/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.remote.sign;

import de.governikus.csc.cryptohost.model.ResourceReferencesDTO;
import de.governikus.csc.signservice.client.SignServiceClient;
import de.governikus.csl.remote.sign.ClientRemoteSignaturePrivateKey;
import de.governikus.csl.remote.sign.exception.RemoteSigningException;
import de.governikus.csl.uom.res.PrivateKeyResource;
import de.governikus.csl.uom.res.PrivateKeyResourceReference;
import de.governikus.csl.uom.res.ResourceReference;
import de.governikus.csl.uom.res.impl.PrivateKeyResourceImpl;
import java.io.IOException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractRemoteSignature {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRemoteSignature.class);
    protected SignServiceClient signServiceClient;

    public PrivateKeyResource getPrivateKeyResource() throws RemoteSigningException {
        PrivateKeyResourceReference privateKeyResourceReference = (PrivateKeyResourceReference)this.getResourceReferences().get(0);
        ClientRemoteSignaturePrivateKey privateKey = new ClientRemoteSignaturePrivateKey(privateKeyResourceReference, this.signServiceClient);
        return new PrivateKeyResourceImpl((PrivateKeyResourceReference)this.getResourceReferences().get(0), (PrivateKey)((Object)privateKey), true, "BC");
    }

    public List<PrivateKeyResource> getPrivateKeyResources() throws RemoteSigningException {
        ArrayList<PrivateKeyResource> privateKeyResources = new ArrayList<PrivateKeyResource>();
        List<ResourceReference> resourceReferences = this.getResourceReferences();
        for (ResourceReference privateKeyResource : resourceReferences) {
            PrivateKeyResourceReference privateKeyResourceReference = (PrivateKeyResourceReference)privateKeyResource;
            ClientRemoteSignaturePrivateKey privateKey = new ClientRemoteSignaturePrivateKey(privateKeyResourceReference, this.signServiceClient);
            privateKeyResources.add((PrivateKeyResource)new PrivateKeyResourceImpl(privateKeyResourceReference, (PrivateKey)((Object)privateKey), true, "BC"));
        }
        return privateKeyResources;
    }

    private List<ResourceReference> getResourceReferences() throws RemoteSigningException {
        ResourceReferencesDTO resourceRefs = null;
        try {
            resourceRefs = this.signServiceClient.getResourceRefs();
        }
        catch (IOException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("error while retrieving resourceRefs from sign service ", (Throwable)e);
            }
            throw RemoteSigningException.createRemoteSigningException(e);
        }
        List resourceReferences = resourceRefs.getResourceReferences();
        if (resourceReferences == null || resourceReferences.isEmpty()) {
            LOG.error("could not get resourceRefs from sign service");
            throw new RemoteSigningException(RemoteSigningException.RemoteSigningFailure.KEY_RESOURCEREFS_NOT_FOUND);
        }
        return resourceReferences;
    }
}

