/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci_view;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Hex;
import de.bos_bremen.ci.QLevel;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.x509.AttributeCertificate;
import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ci.asn1.x509.Extensions;
import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import de.bos_bremen.ci.asn1.x509.IssuerSerial;
import de.bos_bremen.ci.asn1.x509.PolicyInformation;
import de.bos_bremen.ci.asn1.x509.QCStatement;
import de.bos_bremen.ci.asn1.x509.Subject;
import de.bos_bremen.ci.asn1.x509.ext.CertificatePoliciesExtension;
import de.bos_bremen.ci.asn1.x509.ext.QCStatementsExtension;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class CIViewSwing {
    static final Insets left = new Insets(2, 5, 2, 5);
    private static final Insets zero = new Insets(0, 0, 0, 0);
    private static final String DO_NOT_SELECT = "do_not_select";
    protected String subjectCN;
    protected String issuerCN;
    protected String expirationDate;
    protected boolean isAttributeCertificate;
    protected boolean expired;
    protected QLevel level;
    protected boolean commonPKIExtensions;
    protected String baseCertificateSCN;
    protected String baseCertificateSN;
    protected List<Flattable.Pair> pairs;
    private final SwingRun run;
    private final boolean detailes;
    private int a;

    public CIViewSwing(FlatCertificate _cert, boolean _detailes, boolean _short, Date _referenceDate, Locale _locale) {
        this.pairs = this.scanX509Certificate(_cert, _referenceDate, _short, ResourceBundle.getBundle(Flattable.class.getName(), _locale == null ? Locale.getDefault() : _locale));
        this.a = 255;
        this.run = new SwingRun(this);
        this.run._cv = new CScrollView();
        this.detailes = _detailes;
        this.run.res = ResourceBundle.getBundle(Flattable.class.getName(), _locale == null ? Locale.getDefault() : _locale);
    }

    private List<Flattable.Pair> scanX509Certificate(FlatCertificate c, Date _referenceDate, boolean _short, ResourceBundle res) {
        ArrayList<Flattable.Pair> result = new ArrayList();
        result = c.flatten(res, _short);
        this.subjectCN = c.getSubjectCommonName();
        this.issuerCN = c.getIssuer().getDisplayName();
        Date d = c.getNotAfter();
        if (_referenceDate == null) {
            _referenceDate = new Date();
        }
        if (d != null) {
            this.expired = _referenceDate.after(d);
            SimpleDateFormat sdf = new SimpleDateFormat(res.getString(res.containsKey("formatpattern") ? "formatpattern" : "dateformat.pattern.long"));
            this.expirationDate = sdf.format(d);
        } else if (c instanceof Certificate) {
            Certificate cc = (Certificate)c;
            this.expirationDate = Hex.replace((String)res.getString("date.unparsable"), (String)"XXX", (String)cc.getTBSCertificate().getValidity().getNotAfterTime().getValueAsString());
        }
        this.isAttributeCertificate = c instanceof AttributeCertificate;
        if (this.isAttributeCertificate) {
            AttributeCertificate ac = (AttributeCertificate)c;
            Subject subject = ac.getAttributeCertificateInfo().getSubject();
            this.baseCertificateSCN = subject.getDisplayName();
            if (subject instanceof IssuerSerial) {
                IssuerSerial is = (IssuerSerial)subject;
                this.baseCertificateSN = is.getSerialnumber().getValueAsString();
            }
        }
        this.commonPKIExtensions = c.hasCommonPKIrestrictions();
        this.level = QLevel.UNKNOWN;
        OBJECTIDENTIFIER qcComplience = OBJECTIDENTIFIER.valueOf((String)"0.4.0.1862.1.1");
        Extensions exts = c.getExtensions();
        if (exts != null) {
            QCStatementsExtension qcStM = (QCStatementsExtension)c.getExtensions().get("1.3.6.1.5.5.7.1.3");
            if (qcStM != null) {
                List statements = qcStM.getQCStatements();
                for (QCStatement qcs : statements) {
                    if (!qcComplience.equals((Object)qcs.getOID())) continue;
                    this.level = QLevel.QCPPLUS_DE;
                    break;
                }
            }
            qcComplience = OBJECTIDENTIFIER.valueOf((String)"1.3.36.8.1.1");
            CertificatePoliciesExtension cp = (CertificatePoliciesExtension)c.getExtensions().get("2.5.29.32");
            if (cp != null) {
                for (PolicyInformation pi : cp.getPolicyInformations()) {
                    if (!qcComplience.equals((Object)pi.getCertPolicyId())) continue;
                    this.level = QLevel.QCPPLUS_DE_ACCREDITED;
                    break;
                }
            }
        }
        return result;
    }

    public JComponent getView() {
        return this.run._cv;
    }

    public void setTransparenty(boolean _a) {
        this.a = _a ? 224 : 255;
    }

    public Color getTitleColor() {
        return new Color(170, 170, 170, this.a);
    }

    public Color getLabelColor() {
        return new Color(128, 128, 128, this.a);
    }

    public Color getValueColor() {
        return new Color(0, 0, 0, this.a);
    }

    public Color getWarningColor() {
        return new Color(160, 0, 0, this.a);
    }

    public void run() {
        try {
            ImageIcon icon = new ImageIcon(CIViewSwing.class.getResource((this.isAttributeCertificate ? "attribute" : "") + "certificate.png"));
            if (this.a < 255) {
                icon = TransparencyFilter.createDimmedImage(icon, this.a);
            }
            JLabel img = new JLabel(icon);
            img.setDisabledIcon(TransparencyFilter.createDimmedImage(icon, this.a));
            this.run._cv.add((Component)img, new GridBagConstraints(0, this.run.row, 1, 3, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0));
            final JTextArea subject = new JTextArea(this.run.res.getString("subjectdn"));
            subject.setOpaque(false);
            subject.setFont(CView.fontBold);
            subject.setBackground(null);
            subject.setLineWrap(false);
            subject.setWrapStyleWord(true);
            subject.setEditable(false);
            subject.putClientProperty(DO_NOT_SELECT, "");
            subject.setForeground(this.getLabelColor());
            subject.setAlignmentX(0.0f);
            this.run._cv.add((Component)subject, new GridBagConstraints(1, this.run.row, 1, 1, 0.0, 1.0, 12, 0, left, 0, 0));
            JTextArea tc = new JTextArea(this.subjectCN);
            tc.setOpaque(false);
            tc.setFont(CView.fontBold);
            tc.setBackground(null);
            tc.setForeground(this.getValueColor());
            tc.setLineWrap(false);
            tc.setWrapStyleWord(true);
            tc.setEditable(false);
            tc.putClientProperty(DO_NOT_SELECT, "");
            this.run._cv.add((Component)tc, new GridBagConstraints(2, this.run.row, 1, 1, 0.0, 1.0, 18, 2, left, 0, 0));
            ++this.run.row;
            final JTextArea issuer = new JTextArea(this.run.res.getString("issuerdn"));
            issuer.setOpaque(false);
            issuer.setFont(CView.fontBold);
            issuer.setBackground(null);
            issuer.setLineWrap(false);
            issuer.setWrapStyleWord(true);
            issuer.setEditable(false);
            issuer.putClientProperty(DO_NOT_SELECT, "");
            issuer.setForeground(this.getLabelColor());
            issuer.setAlignmentX(0.0f);
            this.run._cv.add((Component)issuer, new GridBagConstraints(1, this.run.row, 1, 1, 0.0, 1.0, 13, 0, left, 0, 0));
            JTextArea tc2 = new JTextArea(this.issuerCN);
            tc2.setOpaque(false);
            tc2.setFont(CView.fontPlain);
            tc2.setBackground(null);
            tc2.setForeground(this.getValueColor());
            tc2.setLineWrap(false);
            tc2.setWrapStyleWord(true);
            tc2.setEditable(false);
            tc2.putClientProperty(DO_NOT_SELECT, "");
            this.run._cv.add((Component)tc2, new GridBagConstraints(2, this.run.row, 1, 1, 0.0, 1.0, 17, 2, left, 0, 0));
            ++this.run.row;
            JTextArea l = new JTextArea(this.run.res.getString("general.validto"));
            l.setOpaque(false);
            l.setFont(CView.fontBold);
            l.setBackground(null);
            l.setLineWrap(false);
            l.setWrapStyleWord(true);
            l.setEditable(false);
            l.putClientProperty(DO_NOT_SELECT, "");
            l.setForeground(this.getLabelColor());
            l.setAlignmentX(0.0f);
            this.run._cv.add((Component)l, new GridBagConstraints(1, this.run.row, 1, 1, 0.0, 1.0, 14, 0, left, 0, 0));
            JTextArea tc3 = new JTextArea(this.expirationDate);
            tc3.setOpaque(false);
            tc3.setFont(CView.fontPlain);
            tc3.setBackground(null);
            tc3.setForeground(this.getValueColor());
            tc3.setLineWrap(false);
            tc3.setWrapStyleWord(true);
            tc3.setEditable(false);
            tc3.putClientProperty(DO_NOT_SELECT, "");
            if (this.expired) {
                tc3.setForeground(new Color(160, 0, 0));
            }
            this.run._cv.add((Component)tc3, new GridBagConstraints(2, this.run.row, 1, 1, 0.0, 1.0, 16, 2, left, 0, 0));
            ++this.run.row;
            if (this.level == QLevel.QCPPLUS_DE || this.level == QLevel.QCPPLUS_DE_ACCREDITED) {
                l = new JTextArea(this.run.res.getString("signature.level"));
                l.setOpaque(false);
                l.setFont(CView.fontBold);
                l.setBackground(null);
                l.setLineWrap(false);
                l.setWrapStyleWord(true);
                l.setEditable(false);
                l.putClientProperty(DO_NOT_SELECT, "");
                l.setForeground(this.getLabelColor());
                l.setAlignmentX(0.0f);
                this.run._cv.add((Component)l, new GridBagConstraints(1, this.run.row, 1, 1, 0.0, 1.0, 14, 0, left, 0, 0));
                tc3 = new JTextArea(this.run.res.getString(this.level.name()));
                tc3.setOpaque(false);
                tc3.setFont(CView.fontPlain);
                tc3.setBackground(null);
                tc3.setForeground(this.getValueColor());
                tc3.setLineWrap(false);
                tc3.setWrapStyleWord(true);
                tc3.setEditable(false);
                tc3.putClientProperty(DO_NOT_SELECT, "");
                this.run._cv.add((Component)tc3, new GridBagConstraints(2, this.run.row, 1, 1, 0.0, 1.0, 16, 2, left, 0, 0));
                ++this.run.row;
            }
            if (this.commonPKIExtensions) {
                tc2 = new JTextArea(this.run.res.getString("has.commonPKIExtensions"));
                tc2.setOpaque(false);
                tc2.setFont(CView.fontPlain);
                tc2.setBackground(null);
                tc2.setForeground(this.getValueColor());
                tc2.setLineWrap(false);
                tc2.setWrapStyleWord(true);
                tc2.setEditable(false);
                tc2.putClientProperty(DO_NOT_SELECT, "");
                this.run._cv.add((Component)tc2, new GridBagConstraints(2, this.run.row, 1, 1, 0.0, 1.0, 16, 2, left, 0, 0));
                ++this.run.row;
            }
            if (this.isAttributeCertificate) {
                l = new JTextArea(this.run.res.getString("baseCertificate.scn"));
                l.setOpaque(false);
                l.setFont(CView.fontBold);
                l.setBackground(null);
                l.setLineWrap(false);
                l.setWrapStyleWord(true);
                l.setEditable(false);
                l.putClientProperty(DO_NOT_SELECT, "");
                l.setForeground(this.getLabelColor());
                l.setAlignmentX(0.0f);
                this.run._cv.add((Component)l, new GridBagConstraints(1, this.run.row, 1, 1, 0.0, 1.0, 14, 0, left, 0, 0));
                String n = this.run.res.getString("baseCertificate.with" + (this.baseCertificateSN != null ? "" : "out") + ".sn");
                n = Hex.replace((String)n, (String)"#", (String)this.baseCertificateSCN);
                if (this.baseCertificateSN != null) {
                    n = Hex.replace((String)n, (String)"#", (String)this.baseCertificateSN);
                }
                JTextArea tc4 = new JTextArea(n);
                tc4.setOpaque(false);
                tc4.setFont(CView.fontPlain);
                tc4.setBackground(null);
                tc4.setForeground(this.getValueColor());
                tc4.setLineWrap(false);
                tc4.setWrapStyleWord(true);
                tc4.setEditable(false);
                tc4.putClientProperty(DO_NOT_SELECT, "");
                this.run._cv.add((Component)tc4, new GridBagConstraints(2, this.run.row, 1, 1, 0.0, 1.0, 16, 2, left, 0, 0));
                ++this.run.row;
            }
            JPanel titleLine = new JPanel(null);
            titleLine.setBorder(new HRBorder(this.getTitleColor()));
            this.run._cv.add((Component)titleLine, new GridBagConstraints(0, this.run.row++, 3, 1, 1.0, 0.0, 13, 2, new Insets(2, 0, 3, 0), 0, 0));
            final JCheckBox details = new JCheckBox(this.run.res.getString("details"));
            details.setName("switch");
            details.setOpaque(false);
            details.setBackground(null);
            details.setForeground(this.getTitleColor());
            details.setFocusPainted(false);
            details.setIcon(UIManager.getIcon("Tree.collapsedIcon"));
            details.setSelectedIcon(UIManager.getIcon("Tree.expandedIcon"));
            details.setPressedIcon(UIManager.getIcon("Tree.collapsedIcon"));
            details.setSelected(this.detailes);
            final CView detailsPanel = this.create(this.run);
            detailsPanel.setVisible(this.detailes);
            if (this.detailes) {
                subject.setLineWrap(true);
                issuer.setLineWrap(true);
                detailsPanel.setVisible(this.detailes);
                details.setPressedIcon(this.detailes ? UIManager.getIcon("Tree.expandedIcon") : UIManager.getIcon("Tree.collapsedIcon"));
            }
            details.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent _e) {
                    subject.setLineWrap(true);
                    issuer.setLineWrap(true);
                    boolean expanded = _e.getStateChange() == 1;
                    detailsPanel.setVisible(expanded);
                    details.setPressedIcon(expanded ? UIManager.getIcon("Tree.expandedIcon") : UIManager.getIcon("Tree.collapsedIcon"));
                }
            });
            this.run._cv.add((Component)details, new GridBagConstraints(0, this.run.row++, 1, 1, 0.0, 1.0, 18, 0, zero, 0, 0));
            this.run._cv.add((Component)detailsPanel, new GridBagConstraints(0, this.run.row++, 3, 1, 1.0, 1.0, 18, 1, zero, 0, 0));
            subject.setLineWrap(false);
            issuer.setLineWrap(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private CView create(SwingRun _run) throws IOException {
        SwingRun tmp = new SwingRun(this);
        tmp._cv = new CScrollView();
        tmp.res = _run.res;
        for (Flattable.Pair pair : this.pairs) {
            tmp.buildRow(pair.label, pair.value);
        }
        JPanel empty = new JPanel();
        empty.setOpaque(false);
        tmp._cv.add((Component)empty, new GridBagConstraints(1, tmp.row++, 1, 1, 1.0, 1.0, 18, 0, left, 0, 0));
        return tmp._cv;
    }

    public static String getComponentVersion() {
        return "CI View";
    }

    public static String getComponentName() {
        return "1.16.11";
    }

    private static final class SwingRun {
        int row;
        CView _cv;
        ResourceBundle res;
        CIViewSwing colors;

        SwingRun(CIViewSwing _colors) {
            this.colors = _colors;
        }

        protected void buildRow(String _label, String _value) {
            if (_label != null && _value == null) {
                JTextArea l = new JTextArea(_label);
                l.setOpaque(false);
                l.setFont(CView.fontBold);
                l.setBackground(null);
                l.setLineWrap(false);
                l.setWrapStyleWord(true);
                l.setEditable(false);
                l.setForeground(this.colors.getTitleColor());
                l.setAlignmentX(1.0f);
                this._cv.add((Component)l, new GridBagConstraints(0, this.row, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, CIViewSwing.left.left, 5, CIViewSwing.left.right), 0, 0));
                JPanel titleLine = new JPanel(null);
                titleLine.setBorder(new HRBorder(this.colors.getTitleColor()));
                this._cv.add((Component)titleLine, new GridBagConstraints(1, this.row, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, CIViewSwing.left.left, 5, CIViewSwing.left.right), 0, 0));
                ++this.row;
                return;
            }
            Insets i = left;
            if (_value != null) {
                JTextArea l = new JTextArea(_label);
                l.setOpaque(false);
                l.setFont(CView.fontBold);
                l.setBackground(null);
                l.setLineWrap(false);
                l.setWrapStyleWord(true);
                l.setEditable(false);
                l.setForeground(this.colors.getLabelColor());
                l.setAlignmentX(0.0f);
                this._cv.add((Component)l, new GridBagConstraints(0, this.row, 1, 1, 0.0, 0.0, 12, 0, i, 0, 0));
                JTextArea tc = new JTextArea(_value);
                tc.setOpaque(false);
                tc.setFont(CView.fontPlain);
                tc.setBackground(null);
                tc.setForeground(this.colors.getValueColor());
                tc.setLineWrap(true);
                tc.setWrapStyleWord(true);
                tc.setEditable(false);
                this._cv.add((Component)tc, new GridBagConstraints(1, this.row, 1, 1, 0.0, 0.0, 18, 1, i, 0, 0));
                ++this.row;
                return;
            }
            JPanel ph = new JPanel();
            ph.setOpaque(false);
            this._cv.add((Component)ph, new GridBagConstraints(0, this.row, 2, 1, 0.0, 0.0, 18, 1, i, 0, 0));
            ++this.row;
        }
    }

    static class CScrollView
    extends CView
    implements Scrollable {
        private static final long serialVersionUID = 1L;
        private static int unitHorizontal = 0;
        private static int unitVertical = 0;

        public CScrollView() {
            if (unitHorizontal == 0) {
                int[] widths;
                FontMetrics fm = this.getFontMetrics(fontPlain);
                for (int i : widths = fm.getWidths()) {
                    unitHorizontal = Math.max(i, unitHorizontal);
                }
                unitVertical = fm.getHeight();
            }
            this.setBorder(new EmptyBorder(15, 15, 15, 15));
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle _visibleRect, int _orientation, int _direction) {
            if (_orientation == 0) {
                return unitHorizontal;
            }
            return unitVertical;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle _visibleRect, int _orientation, int _direction) {
            if (_orientation == 0) {
                return _visibleRect.width;
            }
            return _visibleRect.height;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    static class CView
    extends JComponent {
        private static final long serialVersionUID = 1L;
        protected static Font fontPlain = null;
        protected static Font fontBold = null;

        public CView() {
            this.setLayout(new GridBagLayout());
            if (fontPlain == null) {
                fontPlain = UIManager.getFont("Menu.font");
                fontPlain = fontPlain.deriveFont(11.0f);
                fontBold = fontPlain.deriveFont(1);
            }
            this.setOpaque(false);
        }
    }

    public static class TransparencyFilter
    extends RGBImageFilter {
        private final float o;

        private TransparencyFilter(float _o) {
            this.o = _o / 255.0f;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            int a = rgb >> 24 & 0xFF;
            a = Math.round((float)a * this.o);
            return a << 24 | rgb & 0xFFFFFF;
        }

        public static ImageIcon createDimmedImage(ImageIcon _icon, int _o) {
            return TransparencyFilter.createDimmedImage(_icon.getImage(), _o);
        }

        public static ImageIcon createDimmedImage(Image _icon, int _o) {
            FilteredImageSource prod = new FilteredImageSource(_icon.getSource(), new TransparencyFilter(_o));
            return new ImageIcon(Toolkit.getDefaultToolkit().createImage(prod));
        }
    }

    private static final class HRBorder
    implements Border {
        private final Color c;

        public HRBorder(Color _c) {
            this.c = _c;
        }

        @Override
        public void paintBorder(Component _c, Graphics _g, int _x, int _y, int _width, int _height) {
            _g.setColor(this.c);
            _g.drawLine(_x, _y, _x + _width, _y);
        }

        @Override
        public Insets getBorderInsets(Component _c) {
            return new Insets(1, 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

