/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci_view;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Hex;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

public class CIViewHTML {
    private Writer w;
    private Properties html;
    private FlatCertificate fc;
    private boolean onlyOverview;
    private String fingerprint;
    private ResourceBundle ciRes;
    private String ref;
    private boolean html4;
    private boolean shortDetails;
    private boolean standalone;
    private Locale locale;

    public static void generate(FlatCertificate fc, Writer w, Locale locale, boolean onlyOverview, boolean html4, boolean shortDetails, boolean standalone, String fingerprint, String ref) throws IOException {
        CIViewHTML x = new CIViewHTML(fc, w, locale, onlyOverview, html4, shortDetails, standalone, fingerprint, ref);
        x.generate();
    }

    private CIViewHTML(FlatCertificate _fc, Writer _w, Locale _locale, boolean _onlyOverview, boolean _html4, boolean _shortDetails, boolean _standalone, String _fingerprint, String _ref) {
        this.fc = _fc;
        this.w = _w;
        this.locale = _locale == null ? Locale.getDefault() : _locale;
        this.html = new Properties();
        try {
            Object s = CIViewHTML.class.getName();
            s = "/" + ((String)s).replace('.', '/');
            this.html.load(CIViewHTML.class.getResourceAsStream((String)s + ".properties"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.ciRes = ResourceBundle.getBundle(Flattable.class.getName(), this.locale);
        this.onlyOverview = _onlyOverview;
        this.html4 = _html4;
        this.shortDetails = _shortDetails;
        this.standalone = _standalone;
        this.fingerprint = _fingerprint;
        this.ref = _ref;
    }

    private void generate() throws IOException {
        if (this.standalone) {
            this.writeIntro();
        }
        this.writeCertificateOverview();
        if (this.html4 || !this.onlyOverview) {
            this.writeCertificateDetails();
        }
        this.w.write(this.html.getProperty("paragraph.certificate.extro"));
        if (this.standalone) {
            this.w.write(this.html.getProperty("extro"));
        }
    }

    private void writeIntro() throws IOException {
        this.w.write(this.html.getProperty("doctype" + (this.html4 ? "4" : "3")));
        String s = this.html.getProperty("intro");
        Object cssContent = ".cv_left{vertical-align:top;text-align:right;font-weight:bold;color:#777777;padding:2px;}.cv_left_sub{font-weight:normal;font-size:9px;}.cv_right{vertical-align:top;text-align:left;padding:2px;width:auto;}.cv_rightbold{vertical-align:top;font-weight:bold;white-space:nowrap;text-align:left;padding:2px;width:auto;}.cv_rightexpired{vertical-align:top;white-space:nowrap;text-align:left;color:#772222;padding:2px;width:auto;}div.section{text-align:right;font-weight:bold;color:#aaaaaa;}td.line{color:#cccccc;}div.slidedown{border-color:#cccccc;border-style:solid;border-width:1px;}div.d_viewport{border:none;" + (this.html4 ? "overflow:hidden;height:1px;" : "") + "}div.d_view{border:none;}";
        String css = this.html.getProperty("css");
        css = Hex.replace((String)css, (String)"CSS_CONTENT", (String)cssContent);
        css = Hex.replace((String)css, (String)"MEDIA", (String)"all");
        cssContent = css;
        if (this.html4) {
            cssContent = ((String)cssContent).replaceAll("pt;", "px;");
        }
        s = Hex.replace((String)s, (String)"CSS_STATEMENT", (String)cssContent);
        String jsContent = "";
        if (this.html4) {
            String js = this.html.getProperty("js");
            jsContent = js = Hex.replace((String)js, (String)"JS_CONTENT", (String)"var toggles=new Array();function Toggle(_detailer,_details){this.detailer=document.getElementById(_detailer);this.details=document.getElementById(_details);this.contentHeight=this.details.offsetHeight;this.animating=false;this.currentHeight=0;this.ddirection=1;this.prepare=function(){with(this){ddirection=currentHeight==0?+.05:-.05;animating=true;}};this.step=function(){with(this){if(!animating){return;}currentHeight=Math.round(Math.max(Math.min(contentHeight,currentHeight+contentHeight*ddirection),0));animating=currentHeight!=0&&currentHeight!=contentHeight;detailer.style.height=currentHeight==contentHeight?\"auto\":(currentHeight+\"px\");}}}function toggleDetails(_detailer,_details){var toggle=toggles[_detailer];if(!toggle){toggle=new Toggle(_detailer,_details);toggles[_detailer]=toggle;}toggle.prepare();animate(_detailer);}function animate(_detailer){var toggle=toggles[_detailer];if(!toggle||!toggle.animating){return;}toggle.step();setTimeout(\"animate('\"+_detailer+\"')\",5);}");
        }
        s = Hex.replace((String)s, (String)"JS_STATEMENT", (String)jsContent);
        s = Hex.replace((String)s, (String)"TITLE", (String)CIViewHTML.escapeHTML(this.fc.getSubjectCommonName()));
        this.w.write(s);
    }

    private void writeCertificateOverview() throws IOException {
        String s;
        Flattable.Pair pair;
        this.w.write(this.html.getProperty("paragraph.certificate.intro"));
        this.w.write(this.html.getProperty("paragraph.certificate.overview.intro"));
        List pairs = this.fc.getOverviewPairs(this.ciRes, this.shortDetails);
        Iterator it = pairs.iterator();
        if (it.hasNext()) {
            pair = (Flattable.Pair)it.next();
            s = this.html.getProperty("paragraph.certificate.overview.name");
            s = Hex.replace((String)s, (String)"XXX", (String)CIViewHTML.escapeHTML(pair.label));
            s = Hex.replace((String)s, (String)"XXX", (String)CIViewHTML.escapeHTML(pair.value));
            this.w.write(s);
        }
        if (it.hasNext()) {
            pair = (Flattable.Pair)it.next();
            s = this.html.getProperty("paragraph.certificate.overview.row");
            s = Hex.replace((String)s, (String)"XXX", (String)CIViewHTML.escapeHTML(pair.label));
            s = Hex.replace((String)s, (String)"XXX", (String)CIViewHTML.escapeHTML(pair.value));
            this.w.write(s);
        }
        if (it.hasNext()) {
            pair = (Flattable.Pair)it.next();
            s = this.html.getProperty("paragraph.certificate.overview.date");
            s = Hex.replace((String)s, (String)"XXX", (String)pair.label);
            Date notAfter = this.fc.getNotAfter();
            s = notAfter != null ? Hex.replace((String)s, (String)"XXX", (String)(this.fc.getNotAfter().before(new Date()) ? "expired" : "")) : Hex.replace((String)s, (String)"XXX", (String)"expired");
            s = Hex.replace((String)s, (String)"XXX", (String)CIViewHTML.escapeHTML(pair.value));
            this.w.write(s);
        }
        while (it.hasNext()) {
            pair = (Flattable.Pair)it.next();
            s = this.html.getProperty("paragraph.certificate.overview.row");
            s = Hex.replace((String)s, (String)"XXX", (String)CIViewHTML.escapeHTML(pair.label));
            s = Hex.replace((String)s, (String)"XXX", (String)CIViewHTML.escapeHTML(pair.value));
            this.w.write(s);
        }
        if (this.html4) {
            s = this.html.getProperty("paragraph.certificate.javascript_href");
            s = Hex.replace((String)s, (String)"XXX", (String)("vp_cert_" + this.fingerprint));
            s = Hex.replace((String)s, (String)"XXX", (String)("v_cert_" + this.fingerprint));
            s = Hex.replace((String)this.html.getProperty("paragraph.certificate.hreftag"), (String)"XXX", (String)s);
            s = Hex.replace((String)s, (String)"XXX", (String)CIViewHTML.escapeHTML(this.ciRes.getString("details")));
            s = Hex.replace((String)this.html.getProperty("paragraph.certificate.overview.extro"), (String)"XXX", (String)s);
        } else if (this.onlyOverview) {
            String refKey = this.ref + "_details_";
            s = Hex.replace((String)this.html.getProperty("paragraph.certificate.hreftag"), (String)"XXX", (String)("#" + refKey + this.fingerprint));
            s = Hex.replace((String)s, (String)"XXX", (String)CIViewHTML.escapeHTML(this.ciRes.getString("details")));
            s = Hex.replace((String)this.html.getProperty("paragraph.certificate.overview.extro"), (String)"XXX", (String)s);
        } else {
            s = Hex.replace((String)this.html.getProperty("paragraph.certificate.hreftag2"), (String)"XXX", (String)CIViewHTML.escapeHTML(this.ciRes.getString("details")));
            s = Hex.replace((String)this.html.getProperty("paragraph.certificate.overview.extro"), (String)"XXX", (String)s);
        }
        this.w.write(s);
    }

    private void writeCertificateDetails() throws IOException {
        String s = this.html.getProperty("paragraph.certificate.details.intro");
        s = Hex.replace((String)s, (String)"XXX", (String)("vp_cert_" + this.fingerprint));
        s = Hex.replace((String)s, (String)"XXX", (String)("v_cert_" + this.fingerprint));
        this.w.write(s);
        List result = this.fc.flatten(this.ciRes, this.shortDetails);
        for (Flattable.Pair pair : result) {
            CIViewHTML.buildRow(this.w, this.html, pair.label, pair.value);
        }
        this.w.write(this.html.getProperty("paragraph.certificate.details.extro"));
    }

    public static void buildRow(Writer w, Properties html, String label, String value) throws IOException {
        if (label == null && value == null) {
            w.write(html.getProperty("paragraph.certificate.row.empty"));
            return;
        }
        if (label == null && value != null) {
            String row = html.getProperty("paragraph.certificate.row.value");
            row = Hex.replace((String)row, (String)"XXX", (String)CIViewHTML.escapeHTML(value));
            w.write(row);
            return;
        }
        if (label != null && value == null) {
            String row = html.getProperty("paragraph.certificate.row.title");
            row = Hex.replace((String)row, (String)"XXX", (String)CIViewHTML.escapeHTML(label));
            w.write(row);
            return;
        }
        String row = html.getProperty("paragraph.certificate.row");
        row = Hex.replace((String)row, (String)"XXX", (String)CIViewHTML.escapeHTML(label));
        row = Hex.replace((String)row, (String)"XXX", (String)CIViewHTML.escapeHTML(value));
        w.write(row);
    }

    public static String escapeHTML(String _s) {
        char[] chars;
        if (_s == null) {
            return null;
        }
        _s = _s.replace("&", "&amp;");
        _s = Hex.replaceAll((String)_s, (int)10, (String)"<br>");
        StringBuilder sb = new StringBuilder();
        block4: for (char c : chars = _s.toCharArray()) {
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block4;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static void main(String[] args) throws ParseException, IOException {
        File f = new File("test/testfiles/01e67dc5717fae4feb0752c4385a3d984c2bf8fa.atz");
        FlatCertificate c = FlatCertificate.Factory.generate((Source)new BSource(f));
        File f2 = new File("output.html");
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(f2), "UTF-8");
        CIViewHTML.generate(c, w, Locale.GERMAN, false, false, false, true, "0123456789", "cert");
        ((Writer)w).close();
    }
}

