/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.webservice.client;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.gui.Signer;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.integrated.SignerIntegratedInstance;
import de.bos_bremen.ecard.client.integrated.SignerIntegratedInstanceService;
import de.bos_bremen.ecard.client.integrated.SignerIntergratedInstanceRest;
import de.bos_bremen.ecard.client.model.BooleanTriState;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.PDFSignatureType;
import de.bos_bremen.ecard.client.model.ProcessPolicy;
import de.bos_bremen.ecard.client.model.SignatureType;
import de.bos_bremen.ecard.client.model.TargetFolderType;
import de.bos_bremen.ecard.client.model.error.ErrorHandler;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.model.error.service.ServicesErrorHandler;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.model.licence.ProductFunctions;
import de.bos_bremen.ecard.client.webservice.SignerInstanceServer;
import de.bos_bremen.ecard.client.webservice.client.ServiceMessageHandler;
import de.bos_bremen.ecard.client.webservice.client.SignerInstanceServiceConnector;
import de.bos_bremen.ecard.client.webservice.client.service.ports.Application;
import de.bos_bremen.ecard.client.webservice.client.service.ports.PortUtils;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.xml.ws.WebServiceException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignerInstanceService
implements PropertyChangeListener,
ActionListener,
SignerInstanceServiceConnector {
    private static final Logger LOG = LogManager.getLogger(SignerInstanceService.class);
    private final SystemTray tray = SystemTray.getSystemTray();
    private TrayIcon ti;
    private ServicesErrorHandler serviceErrorHandler;
    private ServiceMessageHandler messageHandler;
    private Signer client;
    private PopupMenu menu;
    private final String licenceXML = "";

    public SignerInstanceService(String ... args) {
        String bundleName = "de.bos_bremen.ecard.client.gui.signer_messages";
        ResourceBundle resourceBundle = ResourceBundle.getBundle(bundleName);
        Messages.addResourceBundle((String)bundleName, (ResourceBundle)resourceBundle);
        String helpPath = null;
        boolean stop = false;
        boolean rest = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-stop")) {
                stop = true;
                continue;
            }
            if (args[i].equals("-rest")) {
                rest = true;
                continue;
            }
            if (!args[i].equals("-helpPath")) continue;
            helpPath = args[++i];
        }
        boolean hideAfterStart = true;
        LicenceTyp enableGeneralIntegratedWS = ProductFunctions.getInstance().enableGeneralIntegratedWS();
        SignerIntegratedInstance signerInstance = null;
        if (enableGeneralIntegratedWS.isEditable()) {
            LOG.debug("enableGeneralIntegratedWS.isEditable() == true");
            URL url = null;
            url = rest ? SignerIntergratedInstanceRest.getUrl() : PortUtils.generateSignerServiceWSDL((Application)Application.GOVERNIKUS_INTEGRATED_SIGNER, (boolean)false);
            boolean started = this.checkSignerInstanceConnection(url);
            if (started) {
                LOG.info("\nIntegrated ist schon gestartet und wird connected");
                signerInstance = rest ? new SignerIntergratedInstanceRest() : SignerInstanceService.getSignerIntegratedInstance();
            }
        } else {
            LOG.debug("enableGeneralIntegratedWS.isEditable() == false");
        }
        if (stop) {
            if (signerInstance != null) {
                try {
                    if (signerInstance instanceof SignerIntegratedInstance) {
                        SignerIntegratedInstance signerIntegratedInstance = signerInstance;
                        LOG.info("send killInstance to SignerIntegratedInstance");
                        signerIntegratedInstance.killInstance();
                    }
                }
                catch (Exception signerIntegratedInstance) {
                    // empty catch block
                }
            }
            return;
        }
        if (signerInstance != null) {
            return;
        }
        SignerInstanceServer signerInstanceServer = new SignerInstanceServer(rest);
        this.client = new Signer(hideAfterStart, helpPath);
        signerInstanceServer.setSignerInstance(this.client);
        this.messageHandler = new ServiceMessageHandler();
        this.serviceErrorHandler = new ServicesErrorHandler(this, this.messageHandler, null);
        Document.getInstance().setErrorHandler(null);
        Document.getInstance().setErrorHandler((ErrorHandler)this.serviceErrorHandler);
        this.serviceErrorHandler.setParent(this.client.getSignerFrame());
        try {
            this.init();
        }
        catch (AWTException e) {
            LOG.error((Object)e, (Throwable)e);
        }
        LocaleChanger.getInstance().addObserver((PropertyChangeListener)this);
        if (enableGeneralIntegratedWS.isEditable() || hideAfterStart) {
            this.client.start(false);
        } else {
            this.client.start(true);
        }
    }

    protected URL getServerUrl(boolean rest) {
        if (rest) {
            try {
                String localHost = InetAddress.getLocalHost().getHostAddress();
                int port = 8088;
                String servicePortString = System.getProperty("SERVICEPORT", System.getenv("SERVICEPORT"));
                if (servicePortString != null) {
                    port = Integer.parseInt(servicePortString);
                }
                return new URL("http://" + localHost + ":" + port + "/signer?wsdl");
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
                return null;
            }
        }
        return PortUtils.generateSignerServiceWSDL((Application)Application.GOVERNIKUS_INTEGRATED_SIGNER, (boolean)false);
    }

    private boolean checkSignerInstanceConnection(URL url) {
        LOG.info("URL: {}", (Object)url);
        if (url == null) {
            return false;
        }
        try {
            HttpURLConnection openConnection = (HttpURLConnection)url.openConnection();
            openConnection.setConnectTimeout(1000);
            openConnection.getInputStream();
            return openConnection.getResponseCode() == 200;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void init() throws AWTException {
        this.createMenu();
        ImageIcon i = this.getTrayIcon();
        this.ti = new TrayIcon(i.getImage(), Messages.getString((String)"service.trayicon.label"), this.menu);
        this.ti.setImageAutoSize(true);
        this.ti.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    boolean visible = !SignerInstanceService.this.isGUIVisible();
                    SignerInstanceService.this.setGUIVisible(visible && !SignerInstanceService.this.isIntegratedEdition());
                }
            }
        });
        this.tray.add(this.ti);
        this.ti.setImage(this.getTrayIcon().getImage());
    }

    private void createMenu() {
        this.menu = new PopupMenu("Signer");
        boolean isIntegrated = this.isIntegratedEdition();
        if (isIntegrated) {
            this.menu.add(this.createMenuItem(ActionCommand.IMPORT_CONFIG));
            this.menu.addSeparator();
            this.menu.add(this.createMenuItem(ActionCommand.INFO));
        } else {
            this.menu.add(this.createMenuItem(ActionCommand.CONFIG));
            Menu submenu = new Menu(Messages.getString((String)"service.trayicon.process.label"));
            submenu.add(this.createMenuItem(ActionCommand.SIGN));
            submenu.add(this.createMenuItem(ActionCommand.VERIFY));
            submenu.add(this.createMenuItem(ActionCommand.ENCRYPT));
            submenu.add(this.createMenuItem(ActionCommand.DECRYPT));
            this.menu.add(submenu);
            this.menu.addSeparator();
            this.menu.add(this.createMenuItem(ActionCommand.HELP));
            this.menu.add(this.createMenuItem(ActionCommand.INFO));
        }
        this.menu.addSeparator();
        this.menu.add(this.createMenuItem(ActionCommand.QUIT));
    }

    private boolean isIntegratedEdition() {
        LicenceTyp integratedLT;
        boolean isIntegrated = false;
        if (this.client != null && Document.getInstance() != null && Document.getInstance().getProductFunctions() != null && (integratedLT = Document.getInstance().getProductFunctions().enableGeneralIntegratedWS()).isEditable() && Config.getLicenceName() != null && Config.getLicenceName().equals("Integrated")) {
            isIntegrated = true;
        }
        return isIntegrated;
    }

    private MenuItem createMenuItem(ActionCommand actionCommand) {
        MenuItem menuItem = new MenuItem(Messages.getString((String)("service.trayicon." + actionCommand.toString().toLowerCase() + ".label")));
        menuItem.setActionCommand(actionCommand.toString());
        menuItem.addActionListener(this);
        menuItem.setEnabled(true);
        return menuItem;
    }

    protected String getClassName(Object o) {
        String classString = o.getClass().getName();
        int dotIndex = classString.lastIndexOf(".");
        return classString.substring(dotIndex + 1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)source;
            String s = menuItem.getActionCommand();
            switch (ActionCommand.valueOf(s)) {
                case QUIT: {
                    this.tray.remove(this.ti);
                    System.exit(0);
                    break;
                }
                case CONFIG: {
                    Document.getInstance().getActionFactory().getConfigureAction().actionPerformed(null);
                    break;
                }
                case SIGN: {
                    this.client.sign("USE_DEFAULT", new String[0], TargetFolderType.useDefault, "", SignatureType.useDefault, PDFSignatureType.useDefault, "", BooleanTriState.useDefault, ProcessPolicy.useDefault, "", "");
                    break;
                }
                case VERIFY: {
                    this.client.verify(new String[0], TargetFolderType.useDefault, "", ProcessPolicy.useDefault, "", "");
                    break;
                }
                case ENCRYPT: {
                    this.client.encrypt("USE_DEFAULT", new String[0], TargetFolderType.useDefault, "", BooleanTriState.useDefault, ProcessPolicy.useDefault, "", "");
                    break;
                }
                case DECRYPT: {
                    this.client.decrypt("USE_DEFAULT", new String[0], TargetFolderType.useDefault, "", BooleanTriState.useDefault, ProcessPolicy.useDefault, "", "");
                    break;
                }
                case IMPORT_CONFIG: {
                    switch (this.client.getStatus().getState()) {
                        case none: 
                        case initializing: 
                        case starting: 
                        case working: 
                        case processing: {
                            Document.getInstance().showMessageDialogText((Component)this.client.getSignerFrame(), "Die Einstellungen koennen zur Prozesslaufzeit nicht importiert werden!");
                            break;
                        }
                        case finished: 
                        case cancelled: 
                        case online: {
                            Document.getInstance().getActionFactory().getImportConfigFileAction().actionPerformed(null);
                        }
                    }
                    break;
                }
                case HELP: {
                    Document.getInstance().getActionFactory().getHelpAction().actionPerformed(null);
                    break;
                }
                case INFO: {
                    Document.getInstance().getActionFactory().getInfoAction().actionPerformed(null);
                    break;
                }
            }
        }
    }

    private void refresh() throws AWTException {
        this.tray.remove(this.ti);
        this.menu.removeAll();
        this.init();
    }

    private ImageIcon getTrayIcon() {
        return new ImageIcon(SignerInstanceService.class.getResource("/resources/boreum_24.png"));
    }

    @Override
    public void displayMessage(String title, String message, TrayIcon.MessageType messageType) {
        if (this.ti != null) {
            this.ti.displayMessage(title, message, messageType);
        }
    }

    @Override
    public boolean isGUIVisible() {
        return this.client != null && this.client.getSignerFrame().isVisible();
    }

    @Override
    public void setGUIVisible(boolean visible) {
        if (visible != this.isGUIVisible()) {
            if (visible) {
                this.client.start(true);
            } else {
                this.client.getSignerFrame().setVisible(false);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        try {
            this.refresh();
        }
        catch (AWTException e) {
            LOG.error((Object)e, (Throwable)e);
        }
    }

    public static SignerIntegratedInstance getSignerIntegratedInstance() {
        SignerIntegratedInstance signerInstance;
        block3: {
            signerInstance = null;
            try {
                SignerIntegratedInstanceService service = new SignerIntegratedInstanceService();
                signerInstance = service.getSignerIntegratedInstancePort();
            }
            catch (WebServiceException ex) {
                LOG.debug((Object)ex, (Throwable)ex);
            }
            catch (RuntimeException ex) {
                LOG.debug((Object)ex, (Throwable)ex);
                if (!(ex.getCause() instanceof SignerException)) break block3;
                throw ex;
            }
        }
        return signerInstance;
    }

    static enum ActionCommand {
        CONFIG,
        SIGN,
        QUIT,
        HELP,
        INFO,
        VERIFY,
        ENCRYPT,
        DECRYPT,
        IMPORT_CONFIG,
        EXPORT_CONFIG;

    }
}

