/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.webservice.client;

import de.bos_bremen.ecard.client.gui.Signer;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.webservice.client.ConsoleParams;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignerInstanceClient {
    private static final Logger LOG = LogManager.getLogger(SignerInstanceClient.class);
    private final ConsoleParams consoleParams;

    public SignerInstanceClient(ConsoleParams inpConsoleParams) {
        this.consoleParams = inpConsoleParams;
    }

    private static int run(ConsoleParams consoleParams) {
        LOG.debug("ConsoleParams: {}", (Object)consoleParams);
        SignerInstanceClient instance = null;
        int aResultCode = -1;
        instance = new SignerInstanceClient(consoleParams);
        aResultCode = instance.run();
        if (aResultCode == -1) {
            aResultCode = ErrorCode.OK.getReturnCode();
        }
        LOG.info("ReturnCode: {}", (Object)aResultCode);
        return aResultCode;
    }

    public static int run(String[] args) {
        LOG.info("--- run ...");
        long startTime = System.currentTimeMillis();
        String currentPath = Paths.get("", new String[0]).toAbsolutePath().toString();
        LOG.trace("{}", (Object)currentPath);
        ConsoleParams consoleParams = null;
        int aResultCode = -1;
        try {
            LOG.info("try to create ConsoleParamer {}", Arrays.asList(args));
            consoleParams = new ConsoleParams(args);
            aResultCode = SignerInstanceClient.run(consoleParams);
        }
        catch (SignerException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            aResultCode = ex.getErrorCode().getReturnCode();
        }
        LOG.info("--- run: {} sec seit Boreum start", (Object)((double)(System.currentTimeMillis() - startTime) / 1000.0));
        return aResultCode;
    }

    private int run() {
        LOG.info("Start...");
        long startTime = System.currentTimeMillis();
        if (this.consoleParams.isStop()) {
            LOG.debug("Da keine Instanz zum Beenden vorhanden ist, kann der Signer geschlossen werden.");
            return 0;
        }
        Signer client = new Signer(false, this.consoleParams.getHelpPath());
        client.start(true);
        LOG.info("Start: {} sec seit Boreum start", (Object)((double)(System.currentTimeMillis() - startTime) / 1000.0));
        return -1;
    }

    public void deleteUpdaterPreferences() {
        Preferences prefs = Preferences.userRoot().node("de");
        prefs = prefs.node("governikus");
        LicenceTyp enableGeneralIntegratedWS = Document.getInstance().getProductFunctions().enableGeneralIntegratedWS();
        String property = enableGeneralIntegratedWS.isEditable() ? "boreum_ie" : "boreum";
        prefs = prefs.node(property);
        Preferences pref = prefs.node("dynamic_message");
        try {
            String[] prefKeys = pref.keys();
            if (prefKeys.length > 0) {
                pref.removeNode();
            }
        }
        catch (BackingStoreException e) {
            LOG.error("BackingStoreException: ", (Throwable)e);
        }
    }
}

