/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.webservice.client;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServiceMessageHandler {
    private static final Logger LOG = LogManager.getLogger(ServiceMessageHandler.class);
    private StringBuilder messages = new StringBuilder();
    private StringBuilder console = new StringBuilder();

    public ServiceMessageHandler() {
        ConsoleOutStream out = new ConsoleOutStream(System.out);
        ConsoleOutStream err = new ConsoleOutStream(System.err);
        try {
            System.setOut(new PrintStream((OutputStream)out, true, StandardCharsets.UTF_8.name()));
            System.setErr(new PrintStream((OutputStream)err, true, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("", (Throwable)e);
        }
    }

    public void appendMessage(String append) {
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yy HH:mm");
        this.messages.append(format.format(new Date()) + " : ");
        this.messages.append(append);
    }

    public void clearMessages() {
        this.messages.delete(0, this.messages.length());
    }

    public String getMessages() {
        return this.messages.toString();
    }

    public String getConsole() {
        return this.console.toString();
    }

    class ConsoleOutStream
    extends OutputStream {
        PrintStream printStream;

        public ConsoleOutStream(PrintStream out) {
            this.printStream = out;
        }

        @Override
        public void write(int b) throws IOException {
            ServiceMessageHandler.this.console.append((char)b);
            this.printStream.write(b);
        }
    }
}

