/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.webservice.client;

import de.bos_bremen.ecard.client.control.process.ProcessName;
import de.bos_bremen.ecard.client.control.process.RootProcessName;
import de.bos_bremen.ecard.client.decrypt.control.process.impl.DecryptProcess;
import de.bos_bremen.ecard.client.encrypt.control.process.impl.EncryptProcess;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.sign.control.process.impl.SignProcess;
import de.bos_bremen.ecard.client.verify.control.process.impl.VerifyProcess;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleParams {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsoleParams.class);
    public static final String PARAM_NAME_HIDE = "-hide";
    public static final String PARAM_NAME_STOP = "-stop";
    public static final String PARAM_NAME_REST = "-rest";
    public static final String PARAM_NAME_HELP = "-help";
    public static final String PARAM_NAME_VERSION = "-version";
    private String aArgSource = null;
    private boolean hide = false;
    private boolean stop = false;
    private ProcessName processName = RootProcessName.getInstance();
    private String helpPath;

    public ConsoleParams(String[] args) throws SignerException {
        log.trace("{}", Arrays.asList(args));
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-")) {
                this.aArgSource = args[i];
                continue;
            }
            if (args[i].equals(PARAM_NAME_HIDE)) {
                this.hide = true;
                continue;
            }
            if (args[i].equals(PARAM_NAME_STOP)) {
                this.stop = true;
                continue;
            }
            if (args[i].equals("-helpPath")) {
                this.helpPath = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals(PARAM_NAME_VERSION)) {
                System.out.println("  Versionsnummer : 10.11.1");
                continue;
            }
            if (args[i].equals(PARAM_NAME_HELP)) {
                System.out.println("");
                ErrorCode.printHelp((PrintStream)System.out);
                continue;
            }
            if (args[i].equals("-" + SignProcess.PROCESS_NAME.getName())) {
                this.processName = SignProcess.PROCESS_NAME;
                continue;
            }
            if (args[i].equals("-" + VerifyProcess.PROCESS_NAME.getName())) {
                this.processName = VerifyProcess.PROCESS_NAME;
                continue;
            }
            if (args[i].equals("-" + EncryptProcess.PROCESS_NAME.getName())) {
                this.processName = EncryptProcess.PROCESS_NAME;
                continue;
            }
            if (!args[i].equals("-" + DecryptProcess.PROCESS_NAME.getName())) continue;
            this.processName = DecryptProcess.PROCESS_NAME;
        }
    }

    private String fetchNextParam(String[] args, int i) throws SignerException {
        if (args.length < i + 1 || args[i].startsWith("-")) {
            throw new SignerException(ErrorCode.MISSING_PARAM, args[i - 1], (Throwable)new Exception(args[i - 1]));
        }
        return args[i];
    }

    public List<String> getSource() {
        File sourceFile;
        ArrayList<String> source = new ArrayList<String>();
        if (this.aArgSource != null && (sourceFile = new File(this.aArgSource)).exists()) {
            if (sourceFile.isDirectory()) {
                File[] listFiles = sourceFile.listFiles(pathname -> pathname.exists() && pathname.isFile());
                if (listFiles != null) {
                    if (listFiles.length == 0) {
                        source.add(sourceFile.getAbsolutePath());
                    } else {
                        for (int i = 0; i < listFiles.length; ++i) {
                            source.add(listFiles[i].getAbsolutePath());
                        }
                    }
                }
            } else {
                source.add(this.aArgSource);
            }
        }
        return source;
    }

    public boolean isHide() {
        return this.hide;
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setProcess(ProcessName process) {
        this.processName = process;
    }

    public ProcessName getProcess() {
        return this.processName;
    }

    public String getHelpPath() {
        return this.helpPath;
    }

    public void setHelpPath(String helpPath) {
        this.helpPath = helpPath;
    }
}

