/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.webservice;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import de.bos_bremen.ecard.client.gui.Signer;
import de.bos_bremen.ecard.client.webservice.SignerIntegratedInstance;
import de.bos_bremen.ecard.client.webservice.client.CardReader;
import de.bos_bremen.ecard.client.webservice.client.CardReaderArray;
import de.bos_bremen.ecard.client.webservice.client.Certificate;
import de.bos_bremen.ecard.client.webservice.client.FrameworkState;
import de.bos_bremen.ecard.client.webservice.client.FrameworkStatus;
import de.bos_bremen.ecard.client.webservice.client.Result;
import de.bos_bremen.ecard.client.webservice.dynamic.JsonRequest;
import de.bos_bremen.ecard.client.webservice.dynamic.JsonResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignerIntegratedInstanceRest
extends SignerIntegratedInstance
implements HttpHandler {
    private static final Logger LOG = LogManager.getLogger(SignerIntegratedInstanceRest.class);
    private Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public SignerIntegratedInstanceRest(Signer signer) {
        super(signer);
    }

    @Override
    public void handle(HttpExchange he) throws IOException {
        byte[] rsp;
        String message = null;
        int httpRsp = 200;
        if (he.getRequestMethod().equals("POST")) {
            int c;
            InputStream is = he.getRequestBody();
            byte[] tmp = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((c = is.read(tmp)) > -1) {
                baos.write(tmp, 0, c);
            }
            is.close();
            baos.close();
            message = baos.toString("UTF-8");
            LOG.debug("Request: {}", (Object)message);
            try {
                String response = this.handleRequest(message);
                rsp = response.getBytes(StandardCharsets.UTF_8);
                LOG.debug("Response: {}", (Object)response);
            }
            catch (Exception e) {
                LOG.error("ERROR", (Throwable)e);
                rsp = ("ERROR: " + e).getBytes(StandardCharsets.UTF_8);
                httpRsp = 400;
            }
        } else {
            rsp = "Sorry, I don't speak GET.".getBytes();
        }
        try {
            he.sendResponseHeaders(httpRsp, rsp.length);
            OutputStream os = he.getResponseBody();
            os.write(rsp);
            os.close();
        }
        catch (IOException e) {
            LOG.error("", (Throwable)e);
        }
    }

    FrameworkStatus convert(de.bos_bremen.ecard.client.model.FrameworkStatus fs) {
        FrameworkStatus ret = new FrameworkStatus();
        switch (fs.getState()) {
            case cancelled: {
                ret.setState(FrameworkState.CANCELLED);
                break;
            }
            case finished: {
                ret.setState(FrameworkState.FINISHED);
                break;
            }
            case initializing: {
                ret.setState(FrameworkState.INITIALIZING);
                break;
            }
            case none: {
                ret.setState(FrameworkState.NONE);
                break;
            }
            case online: {
                ret.setState(FrameworkState.ONLINE);
                break;
            }
            case processing: {
                ret.setState(FrameworkState.PROCESSING);
                break;
            }
            case starting: {
                ret.setState(FrameworkState.STARTING);
                break;
            }
            case working: {
                ret.setState(FrameworkState.WORKING);
                break;
            }
        }
        de.bos_bremen.ecard.client.model.Result[] res = fs.getResults();
        for (int i = 0; i < res.length; ++i) {
            ret.getResults().add(this.convert(res[i]));
        }
        return ret;
    }

    Result convert(de.bos_bremen.ecard.client.model.Result res) {
        Result ret = new Result();
        ret.setDetailMessage(res.getDetailMessage());
        ret.setInputFileName(res.getInputFileName());
        ret.setReturnCode(res.getReturnCode());
        String[] resultFiles = res.getResultFiles();
        for (int i = 0; i < resultFiles.length; ++i) {
            ret.getResultFiles().add(resultFiles[i]);
        }
        return ret;
    }

    CardReaderArray convert(List<de.bos_bremen.ecard.client.model.CardReader> cardReaderList) {
        CardReaderArray cra = new CardReaderArray();
        for (de.bos_bremen.ecard.client.model.CardReader cardReader : cardReaderList) {
            CardReader cr = new CardReader();
            cr.setCardID(cardReader.getCardID());
            List certList = cardReader.getCertificates();
            for (de.bos_bremen.ecard.client.model.Certificate cert : certList) {
                Certificate cws = new Certificate();
                cws.setCommonName(cert.getCommonName());
                cws.setEncoded(cert.getEncoded());
                cws.setSerialnumber(cert.getSerialnumber());
                cr.getCertificates().add(cws);
            }
            cra.getItem().add(cr);
        }
        return cra;
    }

    protected String handleRequest(String req) {
        String command = null;
        JsonResponse jrsp = new JsonResponse();
        try {
            JsonRequest jreq = (JsonRequest)this.gson.fromJson(req, JsonRequest.class);
            command = jreq.command;
            LOG.debug("Received command: {}", (Object)command);
            switch (command) {
                case "GetStatus": {
                    jrsp.status = this.convert(this.getStatus());
                    break;
                }
                case "GetVersion": {
                    jrsp.version = this.getVersion();
                    break;
                }
                case "KillInstance": {
                    break;
                }
                case "ReinitCards": {
                    jrsp.reinitCards = this.reinitCards();
                    break;
                }
                case "CheckCard": {
                    jrsp.checkCard = this.checkCard(jreq.serialNo);
                    break;
                }
                case "GetAvailableCardReader": {
                    jrsp.availableCardReader = this.convert(this.getAvailableCardReader());
                    break;
                }
                case "SignRequest": {
                    jrsp.signResponse = this.signRequest(jreq.signRequest);
                    break;
                }
                case "VerifyRequest": {
                    jrsp.verifyResponse = this.verifyRequest(jreq.verifyRequest);
                    break;
                }
                case "EncryptRequest": {
                    jrsp.encryptResponse = this.encryptRequest(jreq.encryptRequest);
                    break;
                }
                case "DecryptRequest": {
                    jrsp.decryprResponse = this.decryptRequest(jreq.decryprRequest);
                    break;
                }
                default: {
                    LOG.error("Received unknown command: {}", (Object)command);
                    jrsp.error = "Received unknown command: " + command;
                    break;
                }
            }
        }
        catch (Exception e) {
            LOG.error("ERROR", (Throwable)e);
            jrsp.error = e.toString();
        }
        return this.gson.toJson((Object)jrsp);
    }
}

