/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.webservice;

import de.bos_bremen.ecard.client.gui.Signer;
import de.bos_bremen.ecard.client.model.ApplicationPolicy;
import de.bos_bremen.ecard.client.model.BooleanTriState;
import de.bos_bremen.ecard.client.model.CardReader;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.FrameworkStatus;
import de.bos_bremen.ecard.client.model.PDFSignatureType;
import de.bos_bremen.ecard.client.model.ProcessPolicy;
import de.bos_bremen.ecard.client.model.SignatureType;
import de.bos_bremen.ecard.client.model.TargetFolderType;
import de.bos_bremen.ecard.client.webservice.SignerFunctionHandler;
import de.bos_bremen.ecard.client.webservice.dynamic.DecryptRequest;
import de.bos_bremen.ecard.client.webservice.dynamic.EncryptRequest;
import de.bos_bremen.ecard.client.webservice.dynamic.SignRequest;
import de.bos_bremen.ecard.client.webservice.dynamic.VerifyRequest;
import java.util.Collections;
import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@WebService(targetNamespace="governikus")
@SOAPBinding(style=SOAPBinding.Style.RPC)
public class SignerIntegratedInstance
implements SignerFunctionHandler {
    private static final Logger LOG = LogManager.getLogger(SignerIntegratedInstance.class);
    protected Signer signerInstance;

    public SignerIntegratedInstance(Signer signer) {
        this.signerInstance = signer;
    }

    @WebMethod
    public FrameworkStatus getStatus() {
        LOG.info("");
        if (this.signerInstance == null) {
            LOG.warn("(Instance is null : FrameworkStatus none ");
            return new FrameworkStatus(FrameworkStatus.FrameworkState.none);
        }
        FrameworkStatus status = this.signerInstance.getStatus();
        LOG.debug("FrameworkStatus {}", (Object)status.getState());
        return status;
    }

    @WebMethod
    public String getVersion() {
        LOG.info("Instance getVersion...");
        if (this.signerInstance == null) {
            LOG.warn("Instance is null");
            return "";
        }
        String version = this.signerInstance.getVersion();
        LOG.info("Instance getVersion: {}", (Object)version);
        return version;
    }

    @WebMethod
    public boolean checkCard(@WebParam(name="serialNumber") String serialNumber) {
        LOG.info("checkCard...");
        if (this.signerInstance == null) {
            LOG.warn("Instance is null: checkCard wird nicht verarbeitet.");
            return false;
        }
        boolean checkCard = this.signerInstance.checkCard(serialNumber);
        LOG.info("checkCard done : serialNumber {} : {}", (Object)serialNumber, (Object)checkCard);
        return checkCard;
    }

    @WebMethod
    public List<CardReader> getAvailableCardReader() {
        LOG.info("get AvailableCardReader...");
        if (this.signerInstance == null) {
            LOG.warn("Instance is null : empty array");
            return Collections.emptyList();
        }
        List<CardReader> availableCardReader = this.signerInstance.getAvailableCardReader();
        if (availableCardReader == null) {
            LOG.warn("AvailableCardReader is null : empty array");
            return Collections.emptyList();
        }
        LOG.info("get AvailableCardReader done");
        return availableCardReader;
    }

    @Override
    @WebMethod
    public boolean sign(@WebParam(name="serialNumber") String serialnumber, @WebParam(name="inputFiles") String[] inputFile, @WebParam(name="targetFolderType") TargetFolderType targetFolderType, @WebParam(name="outputFolder") String outputFolder, @WebParam(name="signatureFormat") SignatureType signatureType, @WebParam(name="pdfSignatureType") PDFSignatureType pdfSignatureType, @WebParam(name="advancedPDFReason") String advancedPDFReason, @WebParam(name="createTimestamp") BooleanTriState createTimestamp, @WebParam(name="processPolicy") ProcessPolicy processPolicy, @WebParam(name="licenceXML") String licenceXML, @WebParam(name="configuration") String configurationXML) {
        LOG.info("start sign");
        if (this.signerInstance == null) {
            LOG.info("Instance is null : SignRequest wird nicht verarbeitet.");
            return false;
        }
        LOG.info("");
        LOG.info("*** IE service received Sign Parameter ***");
        Document.getInstance().setApplicationPolicy(ApplicationPolicy.hideAfterProcess);
        boolean sign = this.signerInstance.sign(serialnumber, inputFile, targetFolderType, outputFolder, signatureType, pdfSignatureType, advancedPDFReason, createTimestamp, processPolicy, licenceXML, configurationXML);
        LOG.debug("SignRequest created? {}", (Object)sign);
        return sign;
    }

    @Override
    @WebMethod
    public boolean verify(@WebParam(name="inputFiles") String[] inputFile, @WebParam(name="targetFolderType") TargetFolderType targetFolderType, @WebParam(name="outputFolder") String outputFolder, @WebParam(name="processPolicy") ProcessPolicy processPolicy, @WebParam(name="licenceXML") String licenceXML, @WebParam(name="configuration") String configurationXML) {
        LOG.info("start verify");
        if (this.signerInstance == null) {
            LOG.info("Instance is null : VerifyRequest wird nicht verarbeitet.");
            return false;
        }
        LOG.info("");
        LOG.info("*** IE service received Validate Parameter ***");
        Document.getInstance().setApplicationPolicy(ApplicationPolicy.hideAfterProcess);
        boolean verify = this.signerInstance.verify(inputFile, targetFolderType, outputFolder, processPolicy, licenceXML, configurationXML);
        LOG.info("VerifyRequest created? {}", (Object)verify);
        return verify;
    }

    @Override
    @WebMethod
    public boolean decrypt(@WebParam(name="serialNumber") String serialnumber, @WebParam(name="inputFiles") String[] inputFiles, @WebParam(name="targetFolderType") TargetFolderType targetFolderType, @WebParam(name="outputFolder") String outputFolder, @WebParam(name="extractZipArchiv") BooleanTriState extractZipArchiv, @WebParam(name="processPolicy") ProcessPolicy processPolicy, @WebParam(name="licenceXML") String licenceXML, @WebParam(name="configuration") String configurationXML) {
        LOG.info("start decrypt");
        if (this.signerInstance == null) {
            LOG.info("Instance is null : DecryptRequest wird nicht verarbeitet.");
            return false;
        }
        LOG.info("");
        LOG.info("*** IE service received Decrypt Parameter ***");
        Document.getInstance().setApplicationPolicy(ApplicationPolicy.hideAfterProcess);
        boolean decrypt = this.signerInstance.decrypt(serialnumber, inputFiles, targetFolderType, outputFolder, extractZipArchiv, processPolicy, licenceXML, configurationXML);
        LOG.info("DecryptRequest created? {}", (Object)decrypt);
        return decrypt;
    }

    @Override
    @WebMethod
    public boolean encrypt(@WebParam(name="serialNumber") String serialnumber, @WebParam(name="inputFiles") String[] inputFile, @WebParam(name="targetFolderType") TargetFolderType targetFolderType, @WebParam(name="outputFolder") String outputFolder, @WebParam(name="createZipArchivBeforeEncrypt") BooleanTriState createZipArchiv, @WebParam(name="processPolicy") ProcessPolicy processPolicy, @WebParam(name="licenceXML") String licenceXML, @WebParam(name="configuration") String configurationXML) {
        LOG.info("start encrypt");
        if (this.signerInstance == null) {
            LOG.info("Instance ist null : EncryptRequest wird nicht verarbeitet.");
            return false;
        }
        LOG.info("");
        LOG.info("*** IE service received Encrypt Parameter ***");
        Document.getInstance().setApplicationPolicy(ApplicationPolicy.hideAfterProcess);
        boolean encrypt = this.signerInstance.encrypt(serialnumber, inputFile, targetFolderType, outputFolder, createZipArchiv, processPolicy, licenceXML, configurationXML);
        LOG.info("EncryptRequest created? {}", (Object)encrypt);
        return encrypt;
    }

    @WebMethod
    public boolean reinitCards() {
        LOG.info("reinitCards ... ");
        if (this.signerInstance == null) {
            LOG.info("Instance ist null, reinitCards wird nicht verarbeitet: false");
            return false;
        }
        boolean reinitCards = this.signerInstance.reinitCards();
        LOG.info("reinitCards : {}", (Object)reinitCards);
        return reinitCards;
    }

    void setSignerInstance(Signer signer) {
        this.signerInstance = signer;
    }

    @Override
    @WebMethod
    public void killInstance() {
        LOG.info("kill Instance...");
        if (this.signerInstance == null) {
            LOG.info("Instance is null)");
            return;
        }
        this.signerInstance.killInstance();
    }

    @Override
    @WebMethod
    public boolean signRequest(@WebParam(name="signRequest") SignRequest signRequest) {
        LOG.info("*******************************************");
        LOG.info("IE service received SignRequest...");
        LOG.debug("\n{}", (Object)signRequest);
        LOG.info("*******************************************");
        if (this.signerInstance == null) {
            LOG.info("Instance ist null, SignRequest wird nicht verarbeitet.");
            return false;
        }
        try {
            Document.getInstance().setApplicationPolicy(ApplicationPolicy.hideAfterProcess);
            LOG.info("SignRequest -> Boreum ...");
            boolean bl = this.signerInstance.signRequest(signRequest);
            return bl;
        }
        finally {
            LOG.info("SignRequest done.");
        }
    }

    @Override
    @WebMethod
    public boolean verifyRequest(@WebParam(name="verifyRequest") VerifyRequest verifyRequest) {
        LOG.info("*******************************************");
        LOG.info("IE service received VerifyRequest...");
        LOG.debug("\n{}", (Object)verifyRequest);
        LOG.info("*******************************************");
        if (this.signerInstance == null) {
            LOG.info("Instance ist null, VerifyRequest wird nicht verarbeitet.");
            return false;
        }
        try {
            Document.getInstance().setApplicationPolicy(ApplicationPolicy.hideAfterProcess);
            LOG.info("VerifyRequest -> Boreum ...");
            boolean bl = this.signerInstance.verifyRequest(verifyRequest);
            return bl;
        }
        finally {
            LOG.info("VerifyRequest done");
        }
    }

    @Override
    @WebMethod
    public boolean encryptRequest(@WebParam(name="encryptRequest") EncryptRequest encryptRequest) {
        LOG.info("*******************************************");
        LOG.info("IE service received EncryptRequest...");
        LOG.debug("\n{}", (Object)encryptRequest);
        LOG.info("*******************************************");
        if (this.signerInstance == null) {
            LOG.info("Instance ist null, EncryptRequest wird nicht verarbeitet.");
            return false;
        }
        try {
            Document.getInstance().setApplicationPolicy(ApplicationPolicy.hideAfterProcess);
            LOG.info("EncryptRequest -> Boreum ...");
            boolean bl = this.signerInstance.encryptRequest(encryptRequest);
            return bl;
        }
        finally {
            LOG.info("EncryptRequest done.");
        }
    }

    @Override
    @WebMethod
    public boolean decryptRequest(@WebParam(name="decryptRequest") DecryptRequest decryptRequest) {
        LOG.info("*******************************************");
        LOG.info("IE service received DecryptRequest...");
        LOG.debug("\n{}", (Object)decryptRequest);
        LOG.info("*******************************************");
        if (this.signerInstance == null) {
            LOG.info("Instance ist null : DecryptRequest wird nicht verarbeitet.");
            return false;
        }
        try {
            Document.getInstance().setApplicationPolicy(ApplicationPolicy.hideAfterProcess);
            LOG.info("DecryptRequest -> Boreum ...");
            boolean bl = this.signerInstance.decryptRequest(decryptRequest);
            return bl;
        }
        finally {
            LOG.info("DecryptRequest done.");
        }
    }
}

