/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.webservice;

import com.sun.net.httpserver.HttpServer;
import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.gui.Signer;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.model.licence.ProductFunctions;
import de.bos_bremen.ecard.client.webservice.CorsHandlerWrapper;
import de.bos_bremen.ecard.client.webservice.SignerIntegratedInstance;
import de.bos_bremen.ecard.client.webservice.SignerIntegratedInstanceRest;
import de.bos_bremen.ecard.client.webservice.client.service.ports.Application;
import de.bos_bremen.ecard.client.webservice.client.service.ports.PortUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.Executors;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngine;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignerInstanceServer {
    private static final Logger LOG = LogManager.getLogger(SignerInstanceServer.class);
    private Signer signer;
    private SignerIntegratedInstance integratedServer;
    private static final int DEFAULT_FIRST_PORT = 8088;
    private static final int DEFAULT_PORTRANGE = 300;

    public SignerInstanceServer(final boolean rest) {
        Thread t = new Thread(){

            @Override
            public void run() {
                LicenceTyp enableGeneralIntegratedWS = ProductFunctions.getInstance().enableGeneralIntegratedWS();
                if (enableGeneralIntegratedWS.isEditable()) {
                    LOG.info("\nIntegratedWS wird als Thread gestartet.");
                    if (rest) {
                        SignerInstanceServer.this.createIntegratedRest();
                    } else {
                        SignerInstanceServer.this.createIntegratedWS();
                    }
                }
            }
        };
        t.start();
    }

    public Signer getSigner() {
        return this.signer;
    }

    private void createIntegratedWS() {
        URL url = PortUtils.generateSignerServiceWSDL((Application)Application.GOVERNIKUS_INTEGRATED_SIGNER, (boolean)true);
        LOG.info("SOAP Service URL: {}", (Object)url);
        Bus bus = BusFactory.newInstance().createBus();
        JaxWsServerFactoryBean jaxWsServerFactoryBean = new JaxWsServerFactoryBean();
        jaxWsServerFactoryBean.setBus(bus);
        jaxWsServerFactoryBean.setServiceClass(SignerIntegratedInstance.class);
        this.integratedServer = new SignerIntegratedInstance(this.signer);
        jaxWsServerFactoryBean.setServiceBean((Object)this.integratedServer);
        jaxWsServerFactoryBean.setAddress(url.toString());
        JettyHTTPServerEngineFactory engineFactory = (JettyHTTPServerEngineFactory)bus.getExtension(JettyHTTPServerEngineFactory.class);
        try {
            JettyHTTPServerEngine jettyHTTPServerEngine = engineFactory.createJettyHTTPServerEngine(url.getPort(), url.getProtocol());
            jettyHTTPServerEngine.setHandlers(List.of(new CorsHandlerWrapper()));
        }
        catch (Exception cause) {
            throw new RuntimeException("SOAP Service konnte nicht gestartet werden", cause);
        }
        Server endPointServer = jaxWsServerFactoryBean.create();
        endPointServer.start();
        LOG.info("SOAP Service mit CORS l\u00e4uft unter: {}", (Object)jaxWsServerFactoryBean.getAddress());
    }

    private void createIntegratedRest() {
        InetSocketAddress isa = null;
        try {
            this.integratedServer = new SignerIntegratedInstanceRest(this.signer);
            isa = new InetSocketAddress("0.0.0.0", this.findFreePort());
            HttpServer hs = HttpServer.create(isa, 0);
            hs.createContext("/rest", (SignerIntegratedInstanceRest)this.integratedServer);
            hs.setExecutor(Executors.newFixedThreadPool(25));
            hs.start();
            LOG.info("REST server started on {}", (Object)isa);
        }
        catch (IOException e) {
            LOG.error("Failed to start REST server.", (Throwable)e);
            this.unsetServiceport();
        }
    }

    int findFreePort() {
        Map<String, String> systemGetEnv = System.getenv();
        int firstPort = 8088;
        try {
            firstPort = Integer.parseInt(System.getProperty("FIRSTPORT", systemGetEnv.get("FIRSTPORT")));
            LOG.info("System env FIRSTPORT= {}", (Object)firstPort);
        }
        catch (NumberFormatException ex) {
            firstPort = 8088;
            LOG.info("System env FIRSTPORT don't found. The default FIRSTPORT is used : FIRSTPORT = {}", (Object)8088);
        }
        int portRange = 300;
        try {
            portRange = Integer.parseInt(System.getProperty("PORTRANGE", systemGetEnv.get("PORTRANGE")));
            LOG.info("System env PORTRANGE= {}", (Object)portRange);
        }
        catch (NumberFormatException ex) {
            portRange = 300;
            LOG.info("System env PORTRANGE don't found, the default PORTRANGE is used : PORTRANGE = {}", (Object)300);
        }
        for (int i = firstPort; i < firstPort + portRange; i += 2) {
            try {
                ServerSocket serverSocket = new ServerSocket(i);
                serverSocket.close();
                LOG.debug("found free port Port {}", (Object)i);
                try {
                    if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                        Runtime.getRuntime().exec("setx SERVICEPORT " + i);
                        LOG.info("Free port {} written to environment variable SERVICEPORT.", (Object)i);
                        Runtime.getRuntime().addShutdownHook(new Thread(){

                            @Override
                            public void run() {
                                System.err.println("\nSHUTDOWN-HOOK\n");
                                SignerInstanceServer.this.unsetServiceport();
                            }
                        });
                    }
                }
                catch (IOException e) {
                    LOG.error("Failed to write SERVICEPORT port {} to env.SERVICEPORT", (Object)i);
                }
                return i;
            }
            catch (IOException exc) {
                LOG.info(exc.getMessage());
                continue;
            }
        }
        return 8088;
    }

    private void unsetServiceport() {
        System.err.println("\nSHUTDOWN-HOOK GO\n");
        try {
            if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                System.err.println("\nSHUTDOWN-HOOK GOIN\n");
                Runtime.getRuntime().exec("setx SERVICEPORT \"\"");
            }
        }
        catch (IOException e1) {
            LOG.error("", (Throwable)e1);
        }
    }

    public void setSignerInstance(Signer client) {
        if (client == null) {
            return;
        }
        this.signer = client;
        if (this.integratedServer != null) {
            this.integratedServer.setSignerInstance(this.signer);
        }
    }

    static {
        String bundleName = "de.bos_bremen.ecard.client.gui.signer_messages";
        ResourceBundle signerResourceBundle = ResourceBundle.getBundle(bundleName);
        Messages.addResourceBundle((String)bundleName, (ResourceBundle)signerResourceBundle);
    }
}

