/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.model.error.service;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.gui.GUIUtils;
import de.bos_bremen.ecard.client.gui.MultiLineTooltips;
import de.bos_bremen.ecard.client.gui.dialog.ErrorDialog;
import de.bos_bremen.ecard.client.gui.dialog.RedundantDialog;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.FrameworkStatus;
import de.bos_bremen.ecard.client.model.error.AbstractErrorHandler;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.ErrorHandler;
import de.bos_bremen.ecard.client.model.error.ErrorObject;
import de.bos_bremen.ecard.client.webservice.client.ServiceMessageHandler;
import de.bos_bremen.ecard.client.webservice.client.SignerInstanceServiceConnector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.TrayIcon;
import java.text.MessageFormat;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class ServicesErrorHandler
extends AbstractErrorHandler
implements ErrorHandler {
    private final SignerInstanceServiceConnector signerInstanceService;
    private Component parent;

    public ServicesErrorHandler(SignerInstanceServiceConnector signerInstanceService, ServiceMessageHandler messageHandler, Component parent) {
        this.signerInstanceService = signerInstanceService;
        this.parent = parent;
    }

    private String convertHTMLTags(String messageText) {
        if (messageText != null) {
            messageText = this.cutHTMLTag(messageText, "html");
            messageText = this.cutHTMLTag(messageText, "b");
            messageText = this.cutHTMLTag(messageText, "i");
            messageText = this.cutHTMLTag(messageText, "body");
            messageText = messageText.replace("<br>", "\n");
            messageText = messageText.replace("&uuml;", "\u00fc");
            messageText = messageText.replace("&Uuml;", "\u00dc");
            messageText = messageText.replace("&auml;", "\u00e4");
            messageText = messageText.replace("&Auml;", "\u00c4");
            messageText = messageText.replace("&ouml;", "\u00f6");
            messageText = messageText.replace("&Ouml;", "\u00d6");
            messageText = messageText.replace("&szlig;", "\u00df");
            messageText = messageText.replace("&nbsp;", " ");
            messageText = messageText.replace("&copy;", "(c)");
            messageText = messageText.replace("&quot;", "\"");
            messageText = messageText.replace("&amp;", "&");
            messageText = messageText.replace("&lt;", "<");
            messageText = messageText.replace("&gt;", ">");
        }
        return messageText;
    }

    private String cutHTMLTag(String messageText, String tagName) {
        messageText = messageText.replace("<" + tagName + ">", "");
        messageText = messageText.replace("</" + tagName + ">", "");
        return messageText;
    }

    public int displayRedundantMessages(Component parent, String key, String title, String message, int numOptions, int type, Icon icon, boolean force, boolean saveConfig) {
        if (!"exit".equals(key) && this.signerInstanceService.isGUIVisible() || force) {
            if (parent == null) {
                parent = this.parent;
            }
            return RedundantDialog.showDialog((Component)parent, (String)key, (String)title, (String)message, (int)numOptions, (int)type, (boolean)force, (boolean)saveConfig);
        }
        return 0;
    }

    public void displayErrorMessages(Component parent, String dialogKey, String errorMessage, String detailMessage) {
        String title = Messages.getString((String)("dialog." + dialogKey + ".title"));
        if (this.signerInstanceService.isGUIVisible()) {
            if (parent == null) {
                parent = this.parent;
            }
            if (this.signerInstanceService.isGUIVisible()) {
                ErrorDialog.showDialog((Component)parent, (String)dialogKey, (String)title, (String)errorMessage, (String)detailMessage);
            } else {
                String messageText = this.convertHTMLTags(errorMessage);
                this.signerInstanceService.displayMessage(title, messageText, TrayIcon.MessageType.ERROR);
            }
        } else {
            String messageText = this.convertHTMLTags(errorMessage);
            this.signerInstanceService.displayMessage(title, messageText, TrayIcon.MessageType.ERROR);
        }
    }

    public void setParent(Component parent) {
        this.parent = parent;
    }

    protected ErrorObject displayAndSendErrorCode(ErrorCode errorCode, String message, boolean showRedundant, Object ... inObjects) {
        String formatedMessage = MessageFormat.format(message, inObjects);
        LOG.trace("\n{}", (Object)formatedMessage);
        if (errorCode.state().equals((Object)ErrorCode.ErrorCodeStatus.exit)) {
            LOG.info("FrameworkState : {} -> cancelled ", (Object)Document.getInstance().getCurrentFrameworkState());
            Document.getInstance().setCurrentFrameworkState(FrameworkStatus.FrameworkState.cancelled);
            this.signerInstanceService.setGUIVisible(false);
        } else {
            TrayIcon.MessageType messageType = TrayIcon.MessageType.NONE;
            String title = "";
            switch (errorCode.state()) {
                case warn: {
                    messageType = TrayIcon.MessageType.WARNING;
                    title = Messages.getString((String)"dialog.optionPane.warning");
                    break;
                }
                case info: {
                    messageType = TrayIcon.MessageType.INFO;
                    title = Messages.getString((String)"dialog.optionPane.information");
                    break;
                }
                case fatal: {
                    messageType = TrayIcon.MessageType.ERROR;
                    title = Messages.getString((String)"dialog.optionPane.error");
                    break;
                }
                default: {
                    messageType = TrayIcon.MessageType.NONE;
                }
            }
            if (errorCode.errorLevel() > 0) {
                if (this.signerInstanceService.isGUIVisible()) {
                    if (ErrorCode.ErrorCodeStatus.warn.equals((Object)errorCode.state()) || ErrorCode.ErrorCodeStatus.fatal.equals((Object)errorCode.state())) {
                        Dimension parentDimension = Document.getInstance().getFrame().getMinimumSize();
                        JOptionPane.getRootFrame().setMinimumSize(GUIUtils.createRelativeToParent((Dimension)parentDimension, (double)0.9, (double)0.3));
                        JOptionPane.getRootFrame().setSize(GUIUtils.createRelativeToParent((Dimension)parentDimension, (double)0.9, (double)0.4));
                        JOptionPane.getRootFrame().setMaximumSize(parentDimension);
                        String messageText = formatedMessage;
                        messageText = MultiLineTooltips.wrapToolTip((String)messageText, (int)80);
                        LOG.trace("\n{}", (Object)messageText);
                        JLabel messageLabel = new JLabel(messageText);
                        messageLabel.setFocusable(true);
                        messageLabel.addFocusListener(ComponentUtils.createFocusListenerFor((JLabel)messageLabel));
                        JOptionPane.showMessageDialog(this.parent, messageLabel, Messages.getString((String)"dialog.error.title"), 0);
                    }
                } else {
                    String messageText = formatedMessage;
                    messageText = this.convertHTMLTags(messageText);
                    this.signerInstanceService.displayMessage(title, messageText, messageType);
                }
            }
        }
        return new ErrorObject(errorCode, formatedMessage, false);
    }
}

