/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.integrated.verify;

import de.bos_bremen.ecard.client.integrated.AbstractIntegratedParams;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.webservice.client.ProcessPolicy;
import de.bos_bremen.ecard.client.webservice.client.TargetFolderType;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class VerifyParams
extends AbstractIntegratedParams {
    private static final Logger LOG = LogManager.getLogger(VerifyParams.class);
    public static final String PARAM_NAME_LOG_FILE = "-LOG_File";
    public static final String PARAM_NAME_SOURCE = "-source";
    public static final String PARAM_NAME_DEST = "-dest";
    public static final String PARAM_TARGET_FOLDER_TYPE = "-targetFolderType";

    public VerifyParams(String[] args) throws SignerException {
        ArrayList<String> aArgSource = new ArrayList<String>();
        String aArgDest = null;
        String aArgLOGFile = null;
        String aArgWSURL = null;
        String aArgLicenceFile = null;
        String aArgProcessPolicy = null;
        String aArgTargetFolderType = null;
        boolean verbose = false;
        int aArgMaxStartSignerRetryCount = 100;
        int aArgMaxGetWebserviceRetryCount = 200;
        String aArgConfigurationFile = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(PARAM_NAME_SOURCE)) {
                aArgSource.add(this.fetchNextParam(args, ++i));
                continue;
            }
            if (args[i].equals("-helpPath")) {
                this.helpPath = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals(PARAM_NAME_DEST)) {
                aArgDest = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals(PARAM_NAME_LOG_FILE)) {
                aArgLOGFile = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals("-webserviceURL")) {
                aArgWSURL = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals("-licenceFile")) {
                aArgLicenceFile = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals("-configuration")) {
                aArgConfigurationFile = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals("-processPolicy")) {
                aArgProcessPolicy = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals(PARAM_TARGET_FOLDER_TYPE)) {
                aArgTargetFolderType = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals("-maxGetWebserviceRetryCount")) {
                aArgMaxGetWebserviceRetryCount = Integer.parseInt(this.fetchNextParam(args, ++i));
                continue;
            }
            if (args[i].equals("-maxStartSignerRetryCount")) {
                aArgMaxStartSignerRetryCount = Integer.parseInt(this.fetchNextParam(args, ++i));
                continue;
            }
            if (args[i].equals("-version")) {
                System.out.println("  Versionsnummer : 10.11.1");
                continue;
            }
            if (args[i].equals("-v")) {
                verbose = true;
                continue;
            }
            if (args[i].equals("-help")) {
                this.printHelpVerifyParam();
                ErrorCode.printHelp((PrintStream)System.out);
                continue;
            }
            throw new SignerException(ErrorCode.ILLEGAL_PARAM, "unknown parameter " + args[i], null);
        }
        this.setParams(aArgSource, aArgDest, aArgLOGFile, aArgWSURL, aArgLicenceFile, aArgProcessPolicy, aArgTargetFolderType, aArgMaxGetWebserviceRetryCount, aArgMaxStartSignerRetryCount, aArgConfigurationFile);
        this.printParameter(verbose);
    }

    private void printHelpVerifyParam() {
        System.out.println("Usage: Validate  [-source [ dirPath | filePath | fileURL] ] [-source [ filePath | fileURL] ]  [-LOG_File exampleValidate.log  [-dest dirPath] [-licenceFile filePath ] [-configuration filePath] [-processPolicy [ firstStep | skipCompletedStep | lastStep | runProcess ] ] [-targetFolderType [ sameAsSourceFolder | oneSpecial ] ] [-maxGetWebserviceRetryCount [ number (default 200) ]  ] [-maxStartSignerRetryCount [ number (default 200)]  ]");
    }

    private void printParameter(boolean verbose) {
        if (verbose) {
            System.out.println(this.toString());
        }
    }

    public VerifyParams(List<String> inSource, String inLogFile) throws SignerException {
        this.setParams(inSource, this.getDest(), inLogFile, "", this.getLicenceXML(), this.getProcessPolicy().toString(), this.getTargetFolderType().toString(), this.getMaxGetWebserviceRetryCount(), this.getMaxStartSignerRetryCount(), this.getConfigurationXML());
    }

    private void setParams(List<String> inSource, String inDest, String inLogFile, String inWSURL, String inLicenceFile, String inProcessPolicy, String inTargetFolderType, int inMaxGetWebserviceRetryCount, int inMaxStartSignerRetryCount, String inConfigurationFile) throws SignerException {
        if (inSource != null && inLogFile != null && !inLogFile.isEmpty()) {
            this.setDest(inDest);
            this.setSourceFiles(inSource);
            if (inWSURL != null && !inWSURL.equals("")) {
                try {
                    this.webServiceURL = new URL(inWSURL);
                }
                catch (MalformedURLException e) {
                    LOG.error((Object)e, (Throwable)e);
                    this.webServiceURL = null;
                }
            }
            if (inProcessPolicy != null) {
                try {
                    this.processPolicy = ProcessPolicy.valueOf(inProcessPolicy);
                }
                catch (Exception ex) {
                    throw new SignerException(ErrorCode.ILLEGAL_PARAM, inProcessPolicy, (Throwable)new Exception("unknown process policy " + inProcessPolicy));
                }
            }
            if (inTargetFolderType != null) {
                try {
                    this.targetFolderType = TargetFolderType.valueOf(inTargetFolderType);
                }
                catch (Exception ex) {
                    throw new SignerException(ErrorCode.ILLEGAL_PARAM, inTargetFolderType, (Throwable)new Exception("unknown target folder type " + inTargetFolderType));
                }
            }
        } else {
            Object param = "";
            if (inSource == null) {
                param = (String)param + " -source";
            }
            if (inDest == null) {
                param = (String)param + " -dest";
            }
            if (inLogFile == null) {
                param = (String)param + " -LOG_File";
            }
            throw new SignerException(ErrorCode.MISSING_PARAM, (String)param, (Throwable)new Exception("missing param: " + (String)param));
        }
        this.dest = inDest;
        this.logFileName = inLogFile;
        this.licenceFileName = inLicenceFile;
        this.loadLicenceXML();
        this.configurationFileName = inConfigurationFile;
        this.loadConfigurationXML();
        this.setMaxGetWebserviceRetryCount(inMaxGetWebserviceRetryCount);
        this.setMaxStartSignerRetryCount(inMaxStartSignerRetryCount);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(PARAM_NAME_SOURCE).append(" = ").append(this.source).append("\n");
        result.append(PARAM_NAME_DEST).append(" = ").append(this.dest).append("\n");
        result.append(PARAM_NAME_LOG_FILE).append(" = ").append(this.logFileName).append("\n");
        result.append("Optional\n");
        result.append("-webserviceURL").append(" = ").append(this.webServiceURL).append("\n");
        result.append("-licenceFile").append(" = ").append(this.licenceFileName).append("\n");
        result.append("-configuration").append(" = ").append(this.configurationFileName).append("\n");
        return result.toString();
    }
}

