/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.integrated.verify;

import de.bos_bremen.ecard.client.integrated.AbstractIntegratedCaller;
import de.bos_bremen.ecard.client.integrated.AbstractIntegratedParams;
import de.bos_bremen.ecard.client.integrated.SignerIntegratedInstance;
import de.bos_bremen.ecard.client.integrated.verify.VerifyParams;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.webservice.client.VerifyRequest;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Verify
extends AbstractIntegratedCaller {
    private static final Logger LOG = LogManager.getLogger(Verify.class);

    public static void main(String[] args) {
        LOG.info("args: {}", Arrays.asList(args));
        System.exit(Verify.run(args));
    }

    public static int runVerify(VerifyParams params) {
        Verify instance = null;
        int aResultCode = -1;
        instance = new Verify();
        aResultCode = instance.run(params);
        if (aResultCode == -1) {
            aResultCode = ErrorCode.OK.getReturnCode();
        }
        return aResultCode;
    }

    public static int run(String[] args) {
        VerifyParams params = null;
        int aResultCode = -1;
        try {
            params = new VerifyParams(args);
            LOG.debug("VerifyParams: {}", (Object)params);
            aResultCode = Verify.runVerify(params);
            LOG.debug("ReturnCode: {}", (Object)aResultCode);
        }
        catch (SignerException ex) {
            LOG.error("", (Throwable)ex);
            aResultCode = ex.getErrorCode().getReturnCode();
            LOG.error("ReturnCode: {}", (Object)aResultCode);
        }
        LOG.info("ReturnCode: {} {} {}", (Object)aResultCode, (Object)ErrorCode.getErrorCodeByID((int)aResultCode), (Object)ErrorCode.getErrorCodeByID((int)aResultCode).getDescription());
        LOG.info("System.exit: {}", (Object)aResultCode);
        return aResultCode;
    }

    @Override
    protected boolean callGovernikusSigner(AbstractIntegratedParams params, SignerIntegratedInstance signerInstance) throws IllegalArgumentException {
        if (!(params instanceof VerifyParams)) {
            throw new IllegalArgumentException("Es muss vom Typ VerifyParams sein");
        }
        VerifyParams verifyParams = (VerifyParams)params;
        VerifyRequest verifyRequest = new VerifyRequest();
        verifyRequest.getInputFiles().addAll(verifyParams.getSource());
        verifyRequest.setTargetFolderType(verifyParams.getTargetFolderType());
        verifyRequest.setOutputFolder(verifyParams.getDest());
        verifyRequest.setProcessPolicy(verifyParams.getProcessPolicy());
        verifyRequest.setLicenceXML(verifyParams.getLicenceXML());
        verifyRequest.setConfigurationXML(verifyParams.getConfigurationXML());
        return signerInstance.verifyRequest(verifyRequest);
    }

    @Override
    protected boolean couldHideAfterProcess() {
        return false;
    }
}

