/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.integrated.sign;

import de.bos_bremen.ecard.client.integrated.AbstractIntegratedParams;
import de.bos_bremen.ecard.client.model.PDFSignatureType;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.webservice.client.BooleanTriState;
import de.bos_bremen.ecard.client.webservice.client.PdfSignatureType;
import de.bos_bremen.ecard.client.webservice.client.ProcessPolicy;
import de.bos_bremen.ecard.client.webservice.client.SignRequest;
import de.bos_bremen.ecard.client.webservice.client.SignatureType;
import de.bos_bremen.ecard.client.webservice.client.TargetFolderType;
import de.bos_bremen.ecard.client.webservice.client.XmlSignatureType;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SignParams
extends AbstractIntegratedParams {
    private static final Logger LOG = LogManager.getLogger(SignParams.class);
    public static final String PARAM_NAME_LOG_FILE = "-LOG_File";
    public static final String PARAM_NAME_SOURCE = "-source";
    public static final String PARAM_NAME_DEST = "-dest";
    public static final String PARAM_TARGET_FOLDER_TYPE = "-targetFolderType";
    public static final String PARAM_PDF_SIGNATURE_TYPE = "-pdfSignatureType";
    public static final String PARAM_ADVANCED_PDF_REASON = "-advancedPdfReason";
    public static final String PARAM_ADVANCED_PDF_LOCATION = "-advancedPdfLocation";
    public static final String PARAM_XML_SIGNATURE_TYPE = "-xmlSignatureType";
    public static final String PARAM_NAME_SIG_FORMAT = "-sigFormat";
    public static final String PARAM_NAME_CREATE_TIMESTAMP = "-createTimestamp";
    public static final String PARAM_NAME_SERIALNUMBER = "-serialnumber";
    private SignatureType sigFormat;
    private PdfSignatureType pdfSignatureType = PdfSignatureType.USE_DEFAULT;
    private String advancedPdfReason = "";
    private String advancedPdfLocation = "";
    private XmlSignatureType xmlSignatureType = XmlSignatureType.USE_DEFAULT;
    private BooleanTriState createTimestamp = BooleanTriState.USE_DEFAULT;
    private String optKeyStore;
    private String certificateSerialNr;

    public SignParams(String[] args) throws SignerException {
        PdfSignatureType aArgPdfSignatureType = PdfSignatureType.PDF_INLINE;
        String aArgAdvancedPdfReason = null;
        String aArgAdvancedPdfLocation = null;
        String aArgXmlSignatureType = XmlSignatureType.NO_XML_INLINE.name();
        BooleanTriState aArgCreateTimestamp = BooleanTriState.USE_DEFAULT;
        ArrayList<String> aArgSource = new ArrayList<String>();
        String aArgDest = null;
        String aArgLOGFile = null;
        String aArgSigFormat = null;
        String aArgProcessPolicy = null;
        String aArgTargetFolderType = null;
        String aArgWSURL = null;
        String aArgSerialNumber = null;
        boolean verbose = false;
        String aArgLicenceFile = null;
        String aArgConfigurationFile = null;
        int aArgMaxStartSignerRetryCount = 100;
        int aArgMaxGetWebserviceRetryCount = 200;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase(PARAM_NAME_SOURCE)) {
                aArgSource.add(this.fetchNextParam(args, ++i));
                continue;
            }
            if (args[i].equalsIgnoreCase("-helpPath")) {
                this.helpPath = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equalsIgnoreCase(PARAM_NAME_DEST)) {
                aArgDest = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equalsIgnoreCase(PARAM_NAME_LOG_FILE)) {
                aArgLOGFile = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equalsIgnoreCase(PARAM_NAME_SIG_FORMAT)) {
                aArgSigFormat = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equalsIgnoreCase("-processPolicy")) {
                aArgProcessPolicy = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equalsIgnoreCase(PARAM_TARGET_FOLDER_TYPE)) {
                aArgTargetFolderType = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equalsIgnoreCase(PARAM_NAME_CREATE_TIMESTAMP)) {
                aArgCreateTimestamp = this.getBooleanTriState(PARAM_NAME_CREATE_TIMESTAMP, this.fetchNextParam(args, ++i));
                continue;
            }
            if (args[i].equalsIgnoreCase(PARAM_PDF_SIGNATURE_TYPE)) {
                String str;
                if ("automaticPdfInline".equalsIgnoreCase(str = this.fetchNextParam(args, ++i)) || "advancedPdfInline".equalsIgnoreCase(str)) {
                    str = PDFSignatureType.pdfInline.name();
                }
                aArgPdfSignatureType = PdfSignatureType.valueOf(str);
                continue;
            }
            if (args[i].equalsIgnoreCase(PARAM_ADVANCED_PDF_REASON)) {
                aArgAdvancedPdfReason = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equalsIgnoreCase(PARAM_ADVANCED_PDF_LOCATION)) {
                aArgAdvancedPdfLocation = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equalsIgnoreCase("-webserviceURL")) {
                aArgWSURL = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equalsIgnoreCase("-licenceFile")) {
                aArgLicenceFile = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equalsIgnoreCase("-configuration")) {
                aArgConfigurationFile = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equalsIgnoreCase(PARAM_NAME_SERIALNUMBER)) {
                aArgSerialNumber = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equalsIgnoreCase("-maxGetWebserviceRetryCount")) {
                aArgMaxGetWebserviceRetryCount = Integer.parseInt(this.fetchNextParam(args, ++i));
                continue;
            }
            if (args[i].equalsIgnoreCase("-maxStartSignerRetryCount")) {
                aArgMaxStartSignerRetryCount = Integer.parseInt(this.fetchNextParam(args, ++i));
                continue;
            }
            if (args[i].equalsIgnoreCase(PARAM_XML_SIGNATURE_TYPE)) {
                aArgXmlSignatureType = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equalsIgnoreCase("-version")) {
                System.out.println("  Versionsnummer : 10.11.1");
                continue;
            }
            if (args[i].equalsIgnoreCase("-v")) {
                verbose = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-help")) {
                System.out.println("Usage: Sign  [-source [ dirPath | filePath | fileURL] ] [-LOG_File exampleSign.log ] [-sigFormat [ envelopedPKCS7 | detachedPKCS7 ]  [-dest [dirPath] ] [-createTimestamp [ yes | no ] ] [-licenceFile [filePath] ] [-configuration [filePath] ] [-processPolicy [ firstStep | skipCompletedStep | lastStep | runProcess ] ] [-pdfSignatureType [ noPdfInline | pdfInline ] ] [-xmlSignatureType [ noXmlInline | xmlInline ] ] [-targetFolderType [ sameAsSourceFolder | oneSpecial ] ] [-advancedPdfReason [ text < 50 letter] ] [-advancedPdfLocation  [ text < 50 letter] ] [-serialnumber  [ number ] ] [-maxGetWebserviceRetryCount [ number (default 200) ]  ] [-maxStartSignerRetryCount [ number (default 200) ]  ]");
                ErrorCode.printHelp((PrintStream)System.out);
                continue;
            }
            throw new SignerException(ErrorCode.ILLEGAL_PARAM, args[i], (Throwable)new Exception(ErrorCode.ILLEGAL_PARAM.name() + " : " + args[i]));
        }
        this.setParams(aArgSource, aArgDest, aArgSigFormat, aArgProcessPolicy, aArgTargetFolderType, aArgCreateTimestamp, aArgLOGFile, aArgPdfSignatureType, aArgAdvancedPdfReason, aArgAdvancedPdfLocation, aArgWSURL, aArgSerialNumber, aArgLicenceFile, aArgMaxGetWebserviceRetryCount, aArgMaxStartSignerRetryCount, aArgConfigurationFile, aArgXmlSignatureType);
        if (verbose) {
            System.out.println(this.toString());
        }
    }

    private BooleanTriState getBooleanTriState(String paramName, String arg) throws SignerException {
        BooleanTriState aBooleanTRieState;
        if (arg != null) {
            try {
                aBooleanTRieState = BooleanTriState.fromValue(arg);
            }
            catch (Exception ex) {
                for (BooleanTriState booleanTriState : BooleanTriState.values()) {
                    if (!booleanTriState.name().equalsIgnoreCase(arg)) continue;
                    return booleanTriState;
                }
                if (Boolean.TRUE.toString().equalsIgnoreCase(arg)) {
                    return BooleanTriState.YES;
                }
                if (Boolean.FALSE.toString().equalsIgnoreCase(arg)) {
                    return BooleanTriState.NO;
                }
                throw new SignerException(ErrorCode.ILLEGAL_PARAM, "unknown parameter " + paramName, (Throwable)new Exception("Illegal parameter: " + paramName));
            }
        } else {
            throw new SignerException(ErrorCode.ILLEGAL_PARAM, "unknown parameter " + paramName, (Throwable)new Exception("Illegal parameter: " + paramName));
        }
        return aBooleanTRieState;
    }

    public SignParams(List<String> inSource, String inDest, String inSigFormat, String inTargetFolderType, String inProcessPolicy, BooleanTriState inCreateTimestamp, String inLogFile, PdfSignatureType inPdfSignatureType, String inAdvancedPdfReason, String inAdvancedPdfLocation, String inWSURL, String inSerialnumber, String inLicenceFile, int inMaxGetWebserviceRetryCount, int inMaxStartSignerRetryCount, String inConfigurationFile, String inXmlSignatureType) throws SignerException {
        this.setParams(inSource, inDest, inSigFormat, inProcessPolicy, inTargetFolderType, inCreateTimestamp, inLogFile, inPdfSignatureType, inAdvancedPdfReason, inAdvancedPdfLocation, inWSURL, inSerialnumber, inLicenceFile, inMaxGetWebserviceRetryCount, inMaxStartSignerRetryCount, inConfigurationFile, inXmlSignatureType);
    }

    public SignParams(List<String> inSource, String inSigFormat, String inLogFile) throws SignerException {
        this.setParams(inSource, this.getDest(), inSigFormat, this.getProcessPolicy().toString(), this.getTargetFolderType().toString(), BooleanTriState.USE_DEFAULT, inLogFile, this.getPDFSignatureType(), this.getAdvancedPdfReason(), this.getAdvancedPdfLocation(), "", this.getCertificateID(), this.getLicenceXML(), this.getMaxGetWebserviceRetryCount(), this.getMaxStartSignerRetryCount(), this.getConfigurationXML(), XmlSignatureType.NO_XML_INLINE.name());
    }

    private void setParams(List<String> inSource, String inDest, String inSigFormat, String inProcessPolicy, String inTargetFolderType, BooleanTriState aArgCreateTimestamp, String inLogFile, PdfSignatureType pdfSignatureType, String inAdvancedPdfReason, String inAdvancedPdfLocation, String inWSURL, String inSerialnumber, String inLicenceFile, int inMaxGetWebserviceRetryCount, int inMaxStartSignerRetryCount, String inConfigurationFile, String inXmlSignatureType) throws SignerException {
        if (inSource != null && inLogFile != null && !inLogFile.isEmpty() && inSigFormat != null) {
            this.setDest(inDest);
            try {
                this.sigFormat = SignatureType.valueOf(inSigFormat);
            }
            catch (Exception ex) {
                throw new SignerException(ErrorCode.UNKNOWN_SIG_TYPE, inSigFormat, (Throwable)new Exception("unknown signature format " + inSigFormat));
            }
            if (inProcessPolicy != null) {
                try {
                    this.processPolicy = ProcessPolicy.valueOf(inProcessPolicy);
                }
                catch (Exception ex) {
                    throw new SignerException(ErrorCode.ILLEGAL_PARAM, inProcessPolicy, (Throwable)new Exception("unknown process policy " + inProcessPolicy));
                }
            }
            if (inTargetFolderType != null) {
                try {
                    this.targetFolderType = TargetFolderType.valueOf(inTargetFolderType);
                }
                catch (Exception ex) {
                    throw new SignerException(ErrorCode.ILLEGAL_PARAM, inTargetFolderType, (Throwable)new Exception("unknown target folder type " + inTargetFolderType));
                }
            }
            if (inWSURL != null && !inWSURL.equals("")) {
                try {
                    this.webServiceURL = new URL(inWSURL);
                }
                catch (MalformedURLException e) {
                    LOG.error((Object)e, (Throwable)e);
                    this.webServiceURL = null;
                }
            }
        } else {
            Object param = "";
            if (inSource == null) {
                param = (String)param + " -source";
            }
            if (inDest == null) {
                param = (String)param + " -dest";
            }
            if (inLogFile == null) {
                param = (String)param + " -LOG_File";
            }
            if (inSigFormat == null) {
                param = (String)param + " -sigFormat";
            }
            throw new SignerException(ErrorCode.MISSING_PARAM, (String)param, (Throwable)new Exception("missing param: " + (String)param));
        }
        this.setSourceFiles(inSource);
        this.createTimestamp = aArgCreateTimestamp;
        this.pdfSignatureType = pdfSignatureType;
        this.advancedPdfReason = inAdvancedPdfReason;
        this.advancedPdfLocation = inAdvancedPdfLocation;
        this.setXMLSignatureType(inXmlSignatureType);
        this.dest = inDest;
        this.logFileName = inLogFile;
        this.certificateSerialNr = inSerialnumber != null ? inSerialnumber : "";
        this.licenceFileName = inLicenceFile;
        this.loadLicenceXML();
        this.configurationFileName = inConfigurationFile;
        this.loadConfigurationXML();
        this.setMaxGetWebserviceRetryCount(inMaxGetWebserviceRetryCount);
        this.setMaxStartSignerRetryCount(inMaxStartSignerRetryCount);
    }

    public PdfSignatureType getPDFSignatureType() {
        return this.pdfSignatureType;
    }

    public String getAdvancedPdfReason() {
        return this.advancedPdfReason != null ? this.advancedPdfReason : "";
    }

    public String getAdvancedPdfLocation() {
        return this.advancedPdfLocation != null ? this.advancedPdfLocation : "";
    }

    public void setPDFSignatureType(PdfSignatureType pdfSignatureType) {
        this.pdfSignatureType = PdfSignatureType.ADVANCED_PDF_INLINE == pdfSignatureType || PdfSignatureType.AUTOMATIC_PDF_INLINE == pdfSignatureType ? PdfSignatureType.PDF_INLINE : pdfSignatureType;
    }

    public void setAdvancedPdfReason(String advancedPdfReason) {
        this.advancedPdfReason = advancedPdfReason;
    }

    public void setAdvancedPdfLocation(String advancedPdfLocation) {
        this.advancedPdfLocation = advancedPdfLocation;
    }

    public void setSerialNumber(String serialNumber) {
        this.certificateSerialNr = serialNumber == null ? "" : serialNumber;
    }

    public XmlSignatureType getXMLSignatureType() {
        return this.xmlSignatureType;
    }

    public void setXMLSignatureType(String xmlSignatureType) throws SignerException {
        for (XmlSignatureType type : XmlSignatureType.values()) {
            if (!type.name().equalsIgnoreCase(xmlSignatureType)) continue;
            this.xmlSignatureType = type;
            return;
        }
        throw new SignerException(ErrorCode.ILLEGAL_PARAM, "unknown parameter " + xmlSignatureType, (Throwable)new Exception("Illegal Param"));
    }

    public SignatureType getSigFormat() {
        return this.sigFormat;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(PARAM_PDF_SIGNATURE_TYPE).append(" = ").append((Object)this.getPDFSignatureType()).append("\n");
        result.append(PARAM_NAME_SOURCE).append(" = ").append(this.source).append("\n");
        result.append(PARAM_NAME_DEST).append(" = ").append(this.dest).append("\n");
        result.append(PARAM_NAME_SIG_FORMAT).append(" = ").append((Object)this.sigFormat).append("\n");
        result.append(PARAM_NAME_LOG_FILE).append(" = ").append(this.logFileName).append("\n");
        result.append("Optional\n");
        result.append(PARAM_NAME_CREATE_TIMESTAMP).append(" = ").append((Object)this.createTimestamp).append("\n");
        result.append(PARAM_NAME_SERIALNUMBER).append(" = ").append(this.certificateSerialNr).append("\n");
        result.append("-webserviceURL").append(" = ").append(this.webServiceURL).append("\n");
        result.append("-licenceFile").append(" = ").append(this.licenceFileName).append("\n");
        result.append(PARAM_ADVANCED_PDF_REASON).append(" = ").append(this.advancedPdfReason).append("\n");
        result.append(PARAM_ADVANCED_PDF_LOCATION).append(" = ").append(this.advancedPdfLocation).append("\n");
        result.append("-configuration").append(" = ").append(this.configurationFileName).append("\n");
        return result.toString();
    }

    public String getCertificateID() {
        if (this.certificateSerialNr != null && !this.certificateSerialNr.isEmpty()) {
            return this.certificateSerialNr;
        }
        if (this.optKeyStore != null && !this.optKeyStore.isEmpty()) {
            return this.optKeyStore;
        }
        return "";
    }

    public BooleanTriState createTimestamp() {
        return this.createTimestamp;
    }

    public void createTimestamp(BooleanTriState inCreateTimestamp) {
        this.createTimestamp = inCreateTimestamp == null ? BooleanTriState.USE_DEFAULT : inCreateTimestamp;
    }

    SignRequest createSignRequest() {
        SignRequest request = new SignRequest();
        request.getInputFiles().addAll(this.getSource());
        request.setTargetFolderType(this.getTargetFolderType());
        request.setOutputFolder(this.getDest());
        request.setSignatureType(this.getSigFormat());
        request.setPdfSignatureType(this.getPDFSignatureType());
        request.setAdvancedPDFReason(this.getAdvancedPdfReason());
        request.setAdvancedPDFLocation(this.getAdvancedPdfLocation());
        request.setCreateTimestamp(this.createTimestamp());
        request.setProcessPolicy(this.getProcessPolicy());
        request.setLicenceXML(this.getLicenceXML());
        request.setConfigurationXML(this.getConfigurationXML());
        return request;
    }
}

