/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.integrated.sign;

import de.bos_bremen.ecard.client.integrated.AbstractIntegratedCaller;
import de.bos_bremen.ecard.client.integrated.AbstractIntegratedParams;
import de.bos_bremen.ecard.client.integrated.SignerIntegratedInstance;
import de.bos_bremen.ecard.client.integrated.sign.SignParams;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.webservice.client.SignRequest;
import java.text.MessageFormat;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Sign
extends AbstractIntegratedCaller {
    private static final Logger LOG = LogManager.getLogger(Sign.class);

    public static void main(String[] args) {
        LOG.info("Parameter : {}", Arrays.asList(args));
        System.exit(Sign.run(args));
    }

    public static int runSigner(SignParams multiParams) {
        LOG.debug("SignParams: \n{}", (Object)multiParams);
        int aResultCode = -1;
        Sign instance = new Sign();
        aResultCode = instance.run(multiParams);
        if (aResultCode == -1) {
            aResultCode = ErrorCode.OK.getReturnCode();
        }
        LOG.info("ReturnCode: {}", (Object)aResultCode);
        return aResultCode;
    }

    public static int run(String[] args) {
        LOG.debug("args: \n{}", Arrays.asList(args));
        SignParams multiParams = null;
        int aResultCode = -1;
        try {
            multiParams = new SignParams(args);
            LOG.info("");
            aResultCode = Sign.runSigner(multiParams);
            LOG.info("ReturnCode: {}", (Object)aResultCode);
        }
        catch (SignerException ex) {
            LOG.error("", (Throwable)ex);
            aResultCode = ex.getErrorCode().getReturnCode();
            LOG.error("ReturnCode: {}", (Object)aResultCode);
        }
        String messageFormatted = MessageFormat.format(ErrorCode.getErrorCodeByID((int)aResultCode).getDescription(), "");
        LOG.info("ReturnCode: {}={}: {}", (Object)aResultCode, (Object)ErrorCode.getErrorCodeByID((int)aResultCode), (Object)messageFormatted);
        LOG.info("System.exit: {}", (Object)aResultCode);
        return aResultCode;
    }

    @Override
    protected boolean callGovernikusSigner(AbstractIntegratedParams params, SignerIntegratedInstance signerInstance) throws IllegalArgumentException {
        LOG.trace("");
        if (!(params instanceof SignParams)) {
            throw new IllegalArgumentException("Falsche Parametertyp: '" + params.getClass() + "'. SignParams' wird erwartet.");
        }
        SignParams signParams = (SignParams)params;
        SignRequest signRequest = new SignRequest();
        signRequest.setSerialnumber(signParams.getCertificateID());
        signRequest.getInputFiles().addAll(signParams.getSource());
        signRequest.setTargetFolderType(signParams.getTargetFolderType());
        signRequest.setOutputFolder(signParams.getDest());
        signRequest.setSignatureType(signParams.getSigFormat());
        signRequest.setPdfSignatureType(signParams.getPDFSignatureType());
        signRequest.setAdvancedPDFReason(signParams.getAdvancedPdfReason());
        signRequest.setAdvancedPDFLocation(signParams.getAdvancedPdfLocation());
        signRequest.setCreateTimestamp(signParams.createTimestamp());
        signRequest.setProcessPolicy(signParams.getProcessPolicy());
        signRequest.setLicenceXML(signParams.getLicenceXML());
        signRequest.setConfigurationXML(signParams.getConfigurationXML());
        signRequest.setXmlSignatureType(signParams.getXMLSignatureType());
        return signerInstance.signRequest(signRequest);
    }

    @Override
    protected boolean couldHideAfterProcess() {
        return true;
    }
}

