/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.integrated.general;

import de.bos_bremen.ecard.client.integrated.AbstractIntegratedParams;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.SignerException;
import java.io.File;
import java.io.PrintStream;
import java.net.MalformedURLException;

public class GetAvailableCardReaderParams
extends AbstractIntegratedParams {
    public static final String PARAM_NAME_DEST = "-dest";
    private File destFile = null;

    public GetAvailableCardReaderParams(String[] args) throws SignerException {
        String aArgWSURL = null;
        String aArgDest = null;
        boolean verbose = false;
        int aArgMaxStartSignerRetryCount = 100;
        int aArgMaxGetWebserviceRetryCount = 200;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-webserviceURL")) {
                aArgWSURL = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals("-maxGetWebserviceRetryCount")) {
                aArgMaxGetWebserviceRetryCount = Integer.parseInt(this.fetchNextParam(args, ++i));
                continue;
            }
            if (args[i].equals("-maxStartSignerRetryCount")) {
                aArgMaxStartSignerRetryCount = Integer.parseInt(this.fetchNextParam(args, ++i));
                continue;
            }
            if (args[i].equals(PARAM_NAME_DEST)) {
                aArgDest = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals("-version")) {
                System.out.println("  Versionsnummer : 10.11.1");
                continue;
            }
            if (args[i].equals("-v")) {
                verbose = true;
                continue;
            }
            if (!args[i].equals("-help")) continue;
            System.out.println("Usage: GetAvailableCardReader [-webserviceURL VALUE] [-dest VALUE] [-maxGetWebserviceRetryCount VALUE] [-maxStartSignerRetryCount VALUE]");
            ErrorCode.printHelp((PrintStream)System.out);
        }
        this.setParams(aArgWSURL, aArgDest, aArgMaxGetWebserviceRetryCount, aArgMaxStartSignerRetryCount);
        if (verbose) {
            System.out.println(this.toString());
        }
    }

    public GetAvailableCardReaderParams(String wsdlURL, String dest, int inMaxGetWebserviceRetryCount, int inMaxStartSignerRetryCount) throws SignerException {
        this.setParams(wsdlURL, dest, inMaxGetWebserviceRetryCount, inMaxStartSignerRetryCount);
    }

    public GetAvailableCardReaderParams(String wsdlURL, String dest) throws SignerException {
        this.setParams(wsdlURL, dest, this.getMaxGetWebserviceRetryCount(), this.getMaxStartSignerRetryCount());
    }

    private void setParams(String wsdlURL, String dest, int inMaxGetWebserviceRetryCount, int inMaxStartSignerRetryCount) throws SignerException {
        try {
            this.setWebServiceURL(wsdlURL);
        }
        catch (MalformedURLException e) {
            throw new SignerException(ErrorCode.UNKNOWN, (Throwable)e);
        }
        this.setDestination(dest);
        this.setMaxGetWebserviceRetryCount(inMaxGetWebserviceRetryCount);
        this.setMaxStartSignerRetryCount(inMaxStartSignerRetryCount);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Optional\n");
        result.append("-webserviceURL").append(" = ").append(this.webServiceURL).append("\n");
        result.append(PARAM_NAME_DEST).append(" = ").append(this.destFile != null ? this.destFile.getAbsolutePath() : "not Set").append("\n");
        result.append("-maxGetWebserviceRetryCount").append(" = ").append(this.getMaxGetWebserviceRetryCount()).append("\n");
        result.append("-maxStartSignerRetryCount").append(" = ").append(this.getMaxStartSignerRetryCount()).append("\n");
        return result.toString();
    }

    private void setDestination(String destDirectory) throws SignerException {
        if (destDirectory == null) {
            return;
        }
        File tempDest = new File(destDirectory);
        if (!tempDest.exists() || !tempDest.isDirectory()) {
            System.err.println(ErrorCode.OUTPUT_DIR_NOT_FOUND.name());
            throw new SignerException(ErrorCode.OUTPUT_DIR_NOT_FOUND, null);
        }
        this.destFile = new File(destDirectory);
    }

    public File getDestination() {
        return this.destFile;
    }
}

