/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.integrated.general;

import de.bos_bremen.ecard.client.integrated.AbstractIntegratedParams;
import de.bos_bremen.ecard.client.integrated.SignerIntegratedInstance;
import de.bos_bremen.ecard.client.integrated.general.AbstractIntegratedGeneralCaller;
import de.bos_bremen.ecard.client.integrated.general.GetAvailableCardReaderParams;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.webservice.client.CardReader;
import de.bos_bremen.ecard.client.webservice.client.CardReaderArray;
import de.bos_bremen.ecard.client.webservice.client.Certificate;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GetAvailableCardReader
extends AbstractIntegratedGeneralCaller {
    private static final Logger LOG = LogManager.getLogger(GetAvailableCardReader.class);

    public static Object run(String[] args) {
        try {
            CardReaderArray cardReaders = (CardReaderArray)GetAvailableCardReader.runSigner(new GetAvailableCardReaderParams(args));
            if (cardReaders != null && cardReaders.getItem() != null && !cardReaders.getItem().isEmpty()) {
                return ErrorCode.OK.getReturnCode();
            }
            return ErrorCode.UNKNOWN.getReturnCode();
        }
        catch (SignerException e) {
            return e.getErrorCode().getReturnCode();
        }
    }

    public static Object runSigner(GetAvailableCardReaderParams params) {
        GetAvailableCardReader instance = new GetAvailableCardReader();
        return instance.run(params);
    }

    public static void main(String[] args) {
        System.exit((Integer)GetAvailableCardReader.run(args));
    }

    @Override
    protected Object callGovernikusSigner(AbstractIntegratedParams params, SignerIntegratedInstance signerInstance) throws IllegalArgumentException {
        CardReaderArray cardReaderArray = signerInstance.getAvailableCardReader();
        if (cardReaderArray != null && cardReaderArray.getItem() != null && !cardReaderArray.getItem().isEmpty()) {
            for (int i = 0; i < cardReaderArray.getItem().size(); ++i) {
                CardReader cardReader = cardReaderArray.getItem().get(i);
                List<Certificate> certificates = cardReader.getCertificates();
                for (int j = 0; j < certificates.size(); ++j) {
                    this.exportCertificate((GetAvailableCardReaderParams)params, certificates.get(j));
                }
            }
        }
        return cardReaderArray;
    }

    private String exportCertificate(GetAvailableCardReaderParams params, Certificate certificate) {
        String string;
        if (params.getDestination() == null || !params.getDestination().exists()) {
            return "Destination is null or not exists";
        }
        File certificateFile = File.createTempFile(certificate.getCommonName() + "_" + certificate.getSerialnumber() + "_", ".crt", params.getDestination());
        OutputStreamWriter outS = new OutputStreamWriter((OutputStream)new FileOutputStream(certificateFile), StandardCharsets.UTF_8);
        try {
            outS.write(certificate.getEncoded());
            outS.flush();
            string = certificateFile.getAbsolutePath();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outS.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.error((Object)e, (Throwable)e);
                return "No Certificate Export";
            }
        }
        outS.close();
        return string;
    }
}

