/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.integrated.general;

import de.bos_bremen.ecard.client.integrated.AbstractIntegratedParams;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.SignerException;
import java.io.PrintStream;
import java.net.MalformedURLException;

public final class CheckCardParams
extends AbstractIntegratedParams {
    public static final String PARAM_NAME_SERIALNUMBER = "-serialnumber";
    private String serialnumber = "";

    public CheckCardParams(String[] args) throws SignerException {
        String aArgWSURL = null;
        String aArgSerialNumber = null;
        boolean verbose = false;
        int aArgMaxStartSignerRetryCount = 100;
        int aArgMaxGetWebserviceRetryCount = 200;
        block18: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "-webserviceURL": {
                    aArgWSURL = this.fetchNextParam(args, ++i);
                    continue block18;
                }
                case "-serialnumber": {
                    aArgSerialNumber = this.fetchNextParam(args, ++i);
                    continue block18;
                }
                case "-maxGetWebserviceRetryCount": {
                    aArgMaxGetWebserviceRetryCount = Integer.parseInt(this.fetchNextParam(args, ++i));
                    continue block18;
                }
                case "-maxStartSignerRetryCount": {
                    aArgMaxStartSignerRetryCount = Integer.parseInt(this.fetchNextParam(args, ++i));
                    continue block18;
                }
                case "-version": {
                    System.out.println("  Versionsnummer : 10.11.1");
                    continue block18;
                }
                case "-v": {
                    verbose = true;
                    continue block18;
                }
                case "-help": {
                    this.printHelpCheckCard();
                    ErrorCode.printHelp((PrintStream)System.out);
                    continue block18;
                }
                default: {
                    System.err.println("Unerwarteter CheckCard Parameter: " + args[i]);
                    this.printHelpCheckCard();
                }
            }
        }
        this.setParams(aArgWSURL, aArgSerialNumber, aArgMaxGetWebserviceRetryCount, aArgMaxStartSignerRetryCount);
        if (verbose) {
            System.out.println(this.toString());
        }
    }

    private void printHelpCheckCard() {
        System.out.println("Usage: CheckCard [-webserviceURL VALUE] [-serialnumber VALUE] [-maxGetWebserviceRetryCount intRetryCount] [-maxStartSignerRetryCount intRetryCount] [-version] [-v]");
    }

    public CheckCardParams(String wsdlURL, String serialnumber) throws SignerException {
        this.setParams(wsdlURL, serialnumber, this.getMaxGetWebserviceRetryCount(), this.getMaxStartSignerRetryCount());
    }

    public CheckCardParams(String wsdlURL, String serialnumber, int inMaxGetWebserviceRetryCount, int inMaxStartSignerRetryCount) throws SignerException {
        this.setParams(wsdlURL, serialnumber, inMaxGetWebserviceRetryCount, inMaxStartSignerRetryCount);
    }

    private void setParams(String inWSURL, String inSerialnumber, int inMaxGetWebserviceRetryCount, int inMaxStartSignerRetryCount) throws SignerException {
        try {
            this.setWebServiceURL(inWSURL);
        }
        catch (MalformedURLException e) {
            throw new SignerException(ErrorCode.UNKNOWN, (Throwable)e);
        }
        this.serialnumber = inSerialnumber != null ? inSerialnumber : "";
        this.setMaxGetWebserviceRetryCount(inMaxGetWebserviceRetryCount);
        this.setMaxStartSignerRetryCount(inMaxStartSignerRetryCount);
    }

    public String getSerialnumber() {
        return this.serialnumber;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Optional\n");
        result.append("-webserviceURL").append(" = ").append(this.webServiceURL).append("\n");
        result.append(PARAM_NAME_SERIALNUMBER).append(" = ").append(this.serialnumber).append("\n");
        result.append("-maxGetWebserviceRetryCount").append(" = ").append(this.getMaxGetWebserviceRetryCount()).append("\n");
        result.append("-maxStartSignerRetryCount").append(" = ").append(this.getMaxStartSignerRetryCount()).append("\n");
        return result.toString();
    }
}

