/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.integrated.general;

import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.SignerException;
import java.net.MalformedURLException;
import java.net.URL;

public class AbstractIntegratedGeneralParams {
    public static final String PARAM_NAME_HELP = "-help";
    public static final String PARAM_NAME_VERSION = "-version";
    public static final String PARAM_NAME_LOG_FILE = "-LOG_File";
    public static final String PARAM_NAME_WS_LOCATION = "-webserviceURL";
    public static final String PARAM_MAX_START_SIGNER_RETRY_COUNT = "-maxStartSignerRetryCount";
    public static final String PARAM_MAX_GET_WEBSERVICE_RETRY_COUNT = "-maxGetWebserviceRetryCount";
    public static final String PARAM_NAME_VERBOSE = "-v";
    protected URL webServiceURL;
    protected int maxStartSignerRetryCount = 100;
    protected int maxGetWebserviceRetryCount = 200;

    public URL getWebServiceURL() {
        return this.webServiceURL;
    }

    protected String fetchNextParam(String[] args, int i) throws SignerException {
        if (args.length < i + 1 || args[i].startsWith("-")) {
            throw new SignerException(ErrorCode.MISSING_PARAM, args[i - 1], (Throwable)new Exception("missing argument for param " + args[i - 1]));
        }
        return args[i];
    }

    public void setWebServiceURL(String inWebServiceURL) throws MalformedURLException {
        if (inWebServiceURL != null && !inWebServiceURL.equals("")) {
            try {
                this.webServiceURL = new URL(inWebServiceURL);
            }
            catch (MalformedURLException e) {
                this.webServiceURL = null;
                throw new MalformedURLException(inWebServiceURL);
            }
        }
    }

    public int getMaxStartSignerRetryCount() {
        return this.maxStartSignerRetryCount;
    }

    public void setMaxStartSignerRetryCount(int maxStartSignerRetryCount) {
        this.maxStartSignerRetryCount = maxStartSignerRetryCount;
    }

    public int getMaxGetWebserviceRetryCount() {
        return this.maxGetWebserviceRetryCount;
    }

    public void setMaxGetWebserviceRetryCount(int maxGetWebserviceRetryCount) {
        this.maxGetWebserviceRetryCount = maxGetWebserviceRetryCount;
    }
}

