/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.integrated.general;

import de.bos_bremen.ecard.client.integrated.AbstractIntegratedParams;
import de.bos_bremen.ecard.client.integrated.SignerIntegratedInstance;
import de.bos_bremen.ecard.client.integrated.SignerIntegratedInstanceService;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.webservice.client.FrameworkState;
import de.bos_bremen.ecard.client.webservice.client.FrameworkStatus;
import de.bos_bremen.ecard.client.webservice.client.service.ports.Application;
import de.bos_bremen.ecard.client.webservice.client.service.ports.PortUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractIntegratedGeneralCaller {
    private static final Logger LOG = LogManager.getLogger(AbstractIntegratedGeneralCaller.class);
    static int threadError = 0;
    URL url = null;

    protected Object run(AbstractIntegratedParams params) {
        LOG.debug("try to get SignerInstance");
        SignerIntegratedInstance signerInstance = null;
        this.waitForIntegratedinstance(params.getMaxGetWebserviceRetryCount());
        signerInstance = this.getSignerInstance(params);
        if (signerInstance == null) {
            LOG.debug("Es wurde keine SignerInstanz gefunden");
            return ErrorCode.CONNECTION_ERROR.getReturnCode();
        }
        int retryCount = 0;
        boolean wait = false;
        retryCount = 0;
        do {
            FrameworkStatus frameworkStatus = signerInstance.getStatus();
            FrameworkState frameworkState = FrameworkState.NONE;
            try {
                frameworkState = frameworkStatus.getState();
            }
            catch (Exception ex) {
                LOG.error("Konnte kein SignerState erzeugen --> Signerstate.none", (Throwable)ex);
                frameworkState = FrameworkState.NONE;
            }
            if (frameworkState.equals((Object)FrameworkState.STARTING) || frameworkState.equals((Object)FrameworkState.NONE)) {
                if (retryCount >= params.getMaxStartSignerRetryCount()) {
                    return ErrorCode.CONNECTION_ERROR.getReturnCode();
                }
                wait = true;
                ++retryCount;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    LOG.error("", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            wait = false;
        } while (wait);
        return this.callGovernikusSigner(params, signerInstance);
    }

    private void waitForIntegratedinstance(int retryCount) {
        if (!this.checkSignerInstanceConnection()) {
            int counter = 0;
            do {
                try {
                    Thread.sleep(500L);
                    ++counter;
                }
                catch (InterruptedException e) {
                    LOG.error("", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            } while (counter < retryCount && !this.checkSignerInstanceConnection());
        }
    }

    protected boolean checkSignerInstanceConnection() {
        return this.checkSignerInstanceConnection(PortUtils.generateSignerServiceWSDL((Application)Application.GOVERNIKUS_INTEGRATED_SIGNER, (boolean)false));
    }

    protected URL getRestUrl() {
        URL restUrl = null;
        try {
            int port = 8088;
            String servicePortString = System.getProperty("SERVICEPORT", System.getenv("SERVICEPORT"));
            if (servicePortString != null) {
                port = Integer.parseInt(servicePortString);
            }
            restUrl = new URL("http://127.0.0.1:" + port + "/rest");
        }
        catch (MalformedURLException e) {
            LOG.error((Object)e);
        }
        return restUrl;
    }

    protected boolean checkSignerInstanceConnection(URL url) {
        boolean urlConnect = false;
        try {
            URLConnection openConnection = url.openConnection();
            openConnection.setConnectTimeout(500);
            openConnection.connect();
            urlConnect = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return urlConnect;
    }

    protected SignerIntegratedInstance getSignerInstance(AbstractIntegratedParams params) {
        SignerIntegratedInstance signerInstance = null;
        signerInstance = params != null && params.getWebServiceURL() != null ? this.getSignerInstance(params.getWebServiceURL()) : this.getSignerInstance();
        return signerInstance;
    }

    protected SignerIntegratedInstance getSignerInstance(URL webServiceURL) {
        SignerIntegratedInstance signerInstance = null;
        try {
            SignerIntegratedInstanceService service = null;
            service = new SignerIntegratedInstanceService(webServiceURL, new QName("governikus", "SignerIntegratedInstanceService"));
            signerInstance = service.getSignerIntegratedInstancePort();
        }
        catch (WebServiceException ex) {
            LOG.debug((Object)ex, (Throwable)ex);
        }
        return signerInstance;
    }

    protected SignerIntegratedInstance getSignerInstance() {
        SignerIntegratedInstance signerInstance = null;
        try {
            SignerIntegratedInstanceService service = null;
            service = new SignerIntegratedInstanceService();
            signerInstance = service.getSignerIntegratedInstancePort();
        }
        catch (WebServiceException ex) {
            LOG.debug((Object)ex, (Throwable)ex);
        }
        return signerInstance;
    }

    protected abstract Object callGovernikusSigner(AbstractIntegratedParams var1, SignerIntegratedInstance var2) throws IllegalArgumentException;
}

