/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.integrated.encrypt;

import de.bos_bremen.ecard.client.integrated.AbstractIntegratedParams;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.webservice.client.BooleanTriState;
import de.bos_bremen.ecard.client.webservice.client.EncryptionType;
import de.bos_bremen.ecard.client.webservice.client.ProcessPolicy;
import de.bos_bremen.ecard.client.webservice.client.TargetFolderType;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class EncryptParams
extends AbstractIntegratedParams {
    private static final Logger LOG = LogManager.getLogger(EncryptParams.class);
    public static final String PARAM_TARGET_FOLDER_TYPE = "-targetFolderType";
    public static final String PARAM_NAME_LOG_FILE = "-LOG_File";
    public static final String PARAM_NAME_SOURCE = "-source";
    public static final String PARAM_NAME_DEST = "-dest";
    public static final String PARAM_NAME_CREATE_ZIP_ARCHIV_BEFORE_ENCRYPT = "-createZipArchivBeforeEncrypt";
    public static final String PARAM_NAME_ENCRYPTION_TYPE = "-encryptionType";
    public static final String PARAM_NAME_SERIALNUMBERS = "-serialnumber";
    private BooleanTriState createZipArchivBeforeEncrypt = BooleanTriState.YES;
    private List<String> serialNumbers;
    private EncryptionType encryptionType = EncryptionType.CERTIFICATE;

    public EncryptParams(String[] args) throws SignerException {
        ArrayList<String> aArgSource = new ArrayList<String>();
        String aArgDest = null;
        String aArgLOGFile = null;
        String aArgWSURL = null;
        String aArgProcessPolicy = null;
        String aArgTargetFolderType = null;
        ArrayList<String> aArgSerialnumbers = new ArrayList<String>();
        BooleanTriState aArgCreateZipArchiv = BooleanTriState.USE_DEFAULT;
        String aArgEncryptionType = this.encryptionType.name();
        boolean verbose = false;
        String aArgLicenceFile = null;
        int aArgMaxStartSignerRetryCount = 100;
        int aArgMaxGetWebserviceRetryCount = 200;
        String aArgConfigurationFile = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(PARAM_NAME_SOURCE)) {
                aArgSource.add(this.fetchNextParam(args, ++i));
                continue;
            }
            if (args[i].equals("-helpPath")) {
                this.helpPath = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals(PARAM_NAME_DEST)) {
                aArgDest = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals(PARAM_NAME_LOG_FILE)) {
                aArgLOGFile = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals(PARAM_NAME_CREATE_ZIP_ARCHIV_BEFORE_ENCRYPT)) {
                aArgCreateZipArchiv = BooleanTriState.valueOf(this.fetchNextParam(args, ++i).toUpperCase());
                continue;
            }
            if (args[i].equals("-webserviceURL")) {
                aArgWSURL = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals("-licenceFile")) {
                aArgLicenceFile = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals("-configuration")) {
                aArgConfigurationFile = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals(PARAM_NAME_SERIALNUMBERS)) {
                aArgSerialnumbers.add(this.fetchNextParam(args, ++i));
                continue;
            }
            if (args[i].equals("-processPolicy")) {
                aArgProcessPolicy = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals(PARAM_TARGET_FOLDER_TYPE)) {
                aArgTargetFolderType = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals("-maxGetWebserviceRetryCount")) {
                aArgMaxGetWebserviceRetryCount = Integer.parseInt(this.fetchNextParam(args, ++i));
                continue;
            }
            if (args[i].equals("-maxStartSignerRetryCount")) {
                aArgMaxStartSignerRetryCount = Integer.parseInt(this.fetchNextParam(args, ++i));
                continue;
            }
            if (args[i].equals(PARAM_NAME_ENCRYPTION_TYPE)) {
                aArgEncryptionType = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals("-version")) {
                System.out.println("  Versionsnummer : 10.11.1");
                continue;
            }
            if (args[i].equals("-v")) {
                verbose = true;
                continue;
            }
            if (args[i].equals("-help")) {
                System.out.println("Usage: Encrypt  [-source [ dirPath | filePath | fileURL] ] [-LOG_File exampleEncrypt.log ]  [-dest dirPath] [-createZipArchivBeforeEncrypt [ yes | no ] ] [-licenceFile filePath ] [-configuration filePath] [-processPolicy [ firstStep | skipCompletedStep | lastStep | runProcess ] ] [-targetFolderType [ sameAsSourceFolder | oneSpecial ] ] [-maxGetWebserviceRetryCount [ number (default 200) ] ] [-maxStartSignerRetryCount [ number (default 200) ] ] [-encryptionType [ certificate | password ] ]");
                ErrorCode.printHelp((PrintStream)System.out);
                continue;
            }
            throw new SignerException(ErrorCode.ILLEGAL_PARAM, "unknown parameter " + args[i], (Throwable)new Exception("Illegal Param : " + args[i]));
        }
        this.setParams(aArgSource, aArgDest, aArgLOGFile, aArgCreateZipArchiv, aArgWSURL, aArgLicenceFile, aArgProcessPolicy, aArgTargetFolderType, aArgMaxGetWebserviceRetryCount, aArgMaxStartSignerRetryCount, aArgConfigurationFile, aArgEncryptionType);
        if (verbose) {
            System.out.println(this.toString());
        }
    }

    public EncryptParams(List<String> inSource, String inLogFile) throws SignerException {
        this.setParams(inSource, this.getDest(), inLogFile, this.isCreateZipArchivBeforeEncrypt(), "", this.getLicenceXML(), this.getProcessPolicy().toString(), this.getTargetFolderType().toString(), this.getMaxGetWebserviceRetryCount(), this.getMaxStartSignerRetryCount(), this.getConfigurationXML(), this.encryptionType.name());
    }

    public EncryptParams(List<String> inSource, String inDest, String inLogFile, BooleanTriState inCreateZipArchiv, String inWSURL, String inLicenceFile, String inTargetFolderType, String inProcessPolicy, int inMaxGetWebserviceRetryCount, int inMaxStartSignerRetryCount, String inConfigurationFile, String inEncryptionType) throws SignerException {
        this.setParams(inSource, inDest, inLogFile, inCreateZipArchiv, inWSURL, inLicenceFile, inProcessPolicy, inTargetFolderType, inMaxGetWebserviceRetryCount, inMaxStartSignerRetryCount, inConfigurationFile, inEncryptionType);
    }

    private void setParams(List<String> inSource, String inDest, String inLogFile, BooleanTriState inCreateZipArchiv, String inWSURL, String inLicenceFile, String inProcessPolicy, String inTargetFolderType, int inMaxGetWebserviceRetryCount, int inMaxStartSignerRetryCount, String inConfigurationFile, String inEncryptionType) throws SignerException {
        if (inSource != null && inLogFile != null && !inLogFile.isEmpty()) {
            this.setDest(inDest);
            this.setSourceFiles(inSource);
            if (inWSURL != null && !inWSURL.equals("")) {
                try {
                    this.webServiceURL = new URL(inWSURL);
                }
                catch (MalformedURLException e) {
                    LOG.error((Object)e, (Throwable)e);
                    this.webServiceURL = null;
                }
            }
            if (inProcessPolicy != null) {
                try {
                    this.processPolicy = ProcessPolicy.valueOf(inProcessPolicy);
                }
                catch (Exception ex) {
                    throw new SignerException(ErrorCode.ILLEGAL_PARAM, inProcessPolicy, (Throwable)new Exception("unknown process policy " + inProcessPolicy));
                }
            }
            if (inTargetFolderType != null) {
                try {
                    this.targetFolderType = TargetFolderType.valueOf(inTargetFolderType);
                }
                catch (Exception ex) {
                    throw new SignerException(ErrorCode.ILLEGAL_PARAM, inTargetFolderType, (Throwable)new Exception("unknown target folder type " + inTargetFolderType));
                }
            }
        } else {
            Object param = "";
            if (inSource == null) {
                param = (String)param + " -source";
            }
            if (inDest == null) {
                param = (String)param + " -dest";
            }
            if (inLogFile == null) {
                param = (String)param + " -LOG_File";
            }
            throw new SignerException(ErrorCode.MISSING_PARAM, (String)param, (Throwable)new Exception("missing param: " + (String)param));
        }
        this.createZipArchivBeforeEncrypt = inCreateZipArchiv;
        this.setEncryptionType(inEncryptionType);
        this.dest = inDest;
        this.logFileName = inLogFile;
        this.licenceFileName = inLicenceFile;
        this.loadLicenceXML();
        this.configurationFileName = inConfigurationFile;
        this.loadConfigurationXML();
        this.setMaxGetWebserviceRetryCount(inMaxGetWebserviceRetryCount);
        this.setMaxStartSignerRetryCount(inMaxStartSignerRetryCount);
    }

    public void setCreateZipArchivBeforeEncrypt(BooleanTriState createZipArchivBeforeEncrypt) {
        this.createZipArchivBeforeEncrypt = createZipArchivBeforeEncrypt;
    }

    public BooleanTriState isCreateZipArchivBeforeEncrypt() {
        return this.createZipArchivBeforeEncrypt;
    }

    public List<String> getSerialNumbers() {
        if (this.serialNumbers == null) {
            this.serialNumbers = new ArrayList<String>();
        }
        return this.serialNumbers;
    }

    public void setSerialNumbers(List<String> serialNumbers) {
        this.serialNumbers = serialNumbers;
    }

    public EncryptionType getEncryptionType() {
        return this.encryptionType;
    }

    public void setEncryptionType(String encryptionType) throws SignerException {
        for (EncryptionType type : EncryptionType.values()) {
            if (!type.name().equalsIgnoreCase(encryptionType)) continue;
            this.encryptionType = type;
            return;
        }
        throw new SignerException(ErrorCode.ILLEGAL_PARAM, "unknown parameter " + encryptionType, (Throwable)new Exception("Illegal Param"));
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(PARAM_NAME_SOURCE).append(" = ").append(this.source).append("\n");
        result.append(PARAM_NAME_DEST).append(" = ").append(this.dest).append("\n");
        result.append(PARAM_NAME_LOG_FILE).append(" = ").append(this.logFileName).append("\n");
        result.append("Optional\n");
        result.append(PARAM_NAME_CREATE_ZIP_ARCHIV_BEFORE_ENCRYPT).append(" = ").append((Object)this.isCreateZipArchivBeforeEncrypt()).append("\n");
        result.append("-webserviceURL").append(" = ").append(this.webServiceURL).append("\n");
        result.append("-licenceFile").append(" = ").append(this.licenceFileName).append("\n");
        result.append("-configuration").append(" = ").append(this.configurationFileName).append("\n");
        result.append(PARAM_NAME_ENCRYPTION_TYPE).append(" = ").append((Object)this.encryptionType).append("\n");
        return result.toString();
    }
}

