/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.integrated.encrypt;

import de.bos_bremen.ecard.client.integrated.AbstractIntegratedCaller;
import de.bos_bremen.ecard.client.integrated.AbstractIntegratedParams;
import de.bos_bremen.ecard.client.integrated.SignerIntegratedInstance;
import de.bos_bremen.ecard.client.integrated.encrypt.EncryptParams;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.webservice.client.EncryptRequest;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Encrypt
extends AbstractIntegratedCaller {
    private static final Logger LOG = LogManager.getLogger(Encrypt.class);

    public static void main(String[] args) {
        LOG.info("args: {}", Arrays.asList(args));
        System.exit(Encrypt.run(args));
    }

    public static int runEncrypt(EncryptParams multiParams) {
        Encrypt instance = null;
        int aResultCode = -1;
        instance = new Encrypt();
        aResultCode = instance.run(multiParams);
        if (aResultCode == -1) {
            aResultCode = ErrorCode.OK.getReturnCode();
        }
        LOG.info("ReturnCode: {}", (Object)aResultCode);
        return aResultCode;
    }

    public static int run(String[] args) {
        EncryptParams multiParams = null;
        int aResultCode = -1;
        try {
            multiParams = new EncryptParams(args);
            LOG.debug("EncryptParams: {}", (Object)multiParams);
            aResultCode = Encrypt.runEncrypt(multiParams);
            LOG.debug("ReturnCode: {}", (Object)aResultCode);
        }
        catch (SignerException ex) {
            LOG.error("", (Throwable)ex);
            aResultCode = ex.getErrorCode().getReturnCode();
            LOG.error("ReturnCode: {}", (Object)aResultCode);
        }
        LOG.info("ReturnCode: {} {} {}", (Object)aResultCode, (Object)ErrorCode.getErrorCodeByID((int)aResultCode), (Object)ErrorCode.getErrorCodeByID((int)aResultCode).getDescription());
        LOG.info("System.exit: {}", (Object)aResultCode);
        return aResultCode;
    }

    @Override
    protected boolean callGovernikusSigner(AbstractIntegratedParams params, SignerIntegratedInstance signerInstance) throws IllegalArgumentException {
        LOG.trace("");
        if (!(params instanceof EncryptParams)) {
            throw new IllegalArgumentException("Es muss vom Typ EncryptParams sein");
        }
        EncryptParams encryptParams = (EncryptParams)params;
        EncryptRequest encryptRequest = new EncryptRequest();
        encryptRequest.getSerialnumber().addAll(encryptParams.getSerialNumbers());
        encryptRequest.getInputFiles().addAll(encryptParams.getSource());
        encryptRequest.setTargetFolderType(encryptParams.getTargetFolderType());
        encryptRequest.setOutputFolder(encryptParams.getDest());
        encryptRequest.setCreateZipArchivBeforeEncrypt(encryptParams.isCreateZipArchivBeforeEncrypt());
        encryptRequest.setProcessPolicy(encryptParams.getProcessPolicy());
        encryptRequest.setLicenceXML(encryptParams.getLicenceXML());
        encryptRequest.setConfigurationXML(encryptParams.getConfigurationXML());
        encryptRequest.setEncryptionType(encryptParams.getEncryptionType());
        return signerInstance.encryptRequest(encryptRequest);
    }

    @Override
    protected boolean couldHideAfterProcess() {
        return true;
    }
}

