/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.integrated.decrypt;

import de.bos_bremen.ecard.client.integrated.AbstractIntegratedParams;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.webservice.client.BooleanTriState;
import de.bos_bremen.ecard.client.webservice.client.DecryptionType;
import de.bos_bremen.ecard.client.webservice.client.ProcessPolicy;
import de.bos_bremen.ecard.client.webservice.client.TargetFolderType;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DecryptParams
extends AbstractIntegratedParams {
    private static final Logger LOG = LogManager.getLogger(DecryptParams.class);
    public static final String PARAM_NAME_LOG_FILE = "-LOG_File";
    public static final String PARAM_NAME_SOURCE = "-source";
    public static final String PARAM_NAME_DEST = "-dest";
    public static final String PARAM_TARGET_FOLDER_TYPE = "-targetFolderType";
    public static final String PARAM_NAME_EXTRACT_ZIP_ARCHIV = "-extractZipArchiv";
    public static final String PARAM_NAME_DECRYPTION_TYPE = "-decryptionType";
    public static final String PARAM_NAME_SERIALNUMBER = "-serialnumber";
    private BooleanTriState extractZipArchiv = BooleanTriState.USE_DEFAULT;
    private String certificateSerialNr;
    private DecryptionType decryptionType = DecryptionType.CERTIFICATE;

    public void setSerialNumber(String certificateSerialNr) {
        this.certificateSerialNr = certificateSerialNr;
    }

    public DecryptParams(String[] args) throws SignerException {
        ArrayList<String> aArgSource = new ArrayList<String>();
        String aArgDest = null;
        String aArgLOGFile = null;
        String aArgWSURL = null;
        String aArgSerialNumber = null;
        String aArgProcessPolicy = null;
        String aArgTargetFolderType = null;
        String aArgDecryptionType = this.decryptionType.name();
        BooleanTriState aArgExtraxctZipArchiv = BooleanTriState.USE_DEFAULT;
        boolean verbose = false;
        String aArgLicenceFile = null;
        int aArgMaxStartSignerRetryCount = 100;
        int aArgMaxGetWebserviceRetryCount = 200;
        String aArgConfigurationFile = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(PARAM_NAME_SOURCE)) {
                aArgSource.add(this.fetchNextParam(args, ++i));
                continue;
            }
            if (args[i].equals("-helpPath")) {
                this.helpPath = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals(PARAM_NAME_DEST)) {
                aArgDest = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals(PARAM_NAME_LOG_FILE)) {
                aArgLOGFile = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals(PARAM_NAME_EXTRACT_ZIP_ARCHIV)) {
                aArgExtraxctZipArchiv = BooleanTriState.valueOf(this.fetchNextParam(args, ++i).toUpperCase());
                continue;
            }
            if (args[i].equals("-webserviceURL")) {
                aArgWSURL = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals("-licenceFile")) {
                aArgLicenceFile = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals("-configuration")) {
                aArgConfigurationFile = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals(PARAM_NAME_SERIALNUMBER)) {
                aArgSerialNumber = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals("-processPolicy")) {
                aArgProcessPolicy = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals(PARAM_TARGET_FOLDER_TYPE)) {
                aArgTargetFolderType = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals("-maxGetWebserviceRetryCount")) {
                aArgMaxGetWebserviceRetryCount = Integer.parseInt(this.fetchNextParam(args, ++i));
                continue;
            }
            if (args[i].equals("-maxStartSignerRetryCount")) {
                aArgMaxStartSignerRetryCount = Integer.parseInt(this.fetchNextParam(args, ++i));
                continue;
            }
            if (args[i].equals(PARAM_NAME_DECRYPTION_TYPE)) {
                aArgDecryptionType = this.fetchNextParam(args, ++i);
                continue;
            }
            if (args[i].equals("-version")) {
                System.out.println("  Versionsnummer : 10.11.1");
                continue;
            }
            if (args[i].equals("-v")) {
                verbose = true;
                continue;
            }
            if (args[i].equals("-help")) {
                System.out.println("Usage: Decrypt  [-source [ dirPath | filePath | fileURL] ] [-LOG_File exampleDecrypt.log ]  [-dest [dirPath] ] [-extractZipArchiv [ yes | no ] ] [-licenceFile filePath ] [-configuration filePath ] [-processPolicy [ firstStep | skipCompletedStep | lastStep | runProcess ] ] [-targetFolderType [ sameAsSourceFolder | oneSpecial ] ] [-maxGetWebserviceRetryCount [ number (default 200) ] ] [-maxStartSignerRetryCount [ number (default 200) ] ] [-decryptionType [ certificate | password ] ]");
                ErrorCode.printHelp((PrintStream)System.out);
                continue;
            }
            throw new SignerException(ErrorCode.ILLEGAL_PARAM, "unknown parameter " + args[i], (Throwable)new Exception("Illegal Param : " + args[i]));
        }
        this.setParams(aArgSource, aArgDest, aArgLOGFile, aArgExtraxctZipArchiv, aArgWSURL, aArgSerialNumber, aArgLicenceFile, aArgProcessPolicy, aArgTargetFolderType, aArgMaxGetWebserviceRetryCount, aArgMaxStartSignerRetryCount, aArgConfigurationFile, aArgDecryptionType);
        if (verbose) {
            System.out.println(this.toString());
        }
    }

    public DecryptParams(List<String> inSource, String inLogFile) throws SignerException {
        this.setParams(inSource, this.getDest(), inLogFile, this.isExtractZipArchiv(), "", "", this.getLicenceXML(), this.getProcessPolicy().toString(), this.getTargetFolderType().toString(), this.getMaxGetWebserviceRetryCount(), this.getMaxStartSignerRetryCount(), this.getConfigurationXML(), DecryptionType.CERTIFICATE.name());
    }

    public DecryptParams(List<String> inSource, String inDest, String inLogFile, BooleanTriState inExtractZipfile, String inWSURL, String inSerialnumber, String inLicenceFile, String inProcessPolicy, String inTargetFolderType, int inMaxGetWebserviceRetryCount, int inMaxStartSignerRetryCount, String inConfigurationFile, String inDecryptionType) throws SignerException {
        this.setParams(inSource, inDest, inLogFile, inExtractZipfile, inWSURL, inSerialnumber, inLicenceFile, inProcessPolicy, inTargetFolderType, inMaxGetWebserviceRetryCount, inMaxStartSignerRetryCount, inConfigurationFile, inDecryptionType);
    }

    private void setParams(List<String> inSource, String inDest, String inLogFile, BooleanTriState inExtractZipfile, String inWSURL, String inSerialnumber, String inLicenceFile, String inProcessPolicy, String inTargetFolderType, int inMaxGetWebserviceRetryCount, int inMaxStartSignerRetryCount, String inConfigurationFile, String inDecryptionType) throws SignerException {
        if (inSource != null && inLogFile != null && !inLogFile.isEmpty()) {
            this.setDest(inDest);
            this.setSourceFiles(inSource);
            if (inWSURL != null && !inWSURL.equals("")) {
                try {
                    this.webServiceURL = new URL(inWSURL);
                }
                catch (MalformedURLException e) {
                    LOG.error((Object)e, (Throwable)e);
                    this.webServiceURL = null;
                }
            }
            if (inProcessPolicy != null) {
                try {
                    this.processPolicy = ProcessPolicy.valueOf(inProcessPolicy);
                }
                catch (Exception ex) {
                    throw new SignerException(ErrorCode.ILLEGAL_PARAM, inProcessPolicy, (Throwable)new Exception("unknown process policy " + inProcessPolicy));
                }
            }
            if (inTargetFolderType != null) {
                try {
                    this.targetFolderType = TargetFolderType.valueOf(inTargetFolderType);
                }
                catch (Exception ex) {
                    throw new SignerException(ErrorCode.ILLEGAL_PARAM, inTargetFolderType, (Throwable)new Exception("unknown target folder type " + inTargetFolderType));
                }
            }
        } else {
            Object param = "";
            if (inSource == null) {
                param = (String)param + " -source";
            }
            if (inDest == null) {
                param = (String)param + " -dest";
            }
            if (inLogFile == null) {
                param = (String)param + " -LOG_File";
            }
            throw new SignerException(ErrorCode.MISSING_PARAM, (String)param, (Throwable)new Exception("missing param: " + (String)param));
        }
        this.extractZipArchiv = inExtractZipfile;
        this.dest = inDest;
        this.logFileName = inLogFile;
        this.certificateSerialNr = inSerialnumber != null ? inSerialnumber : "";
        this.licenceFileName = inLicenceFile;
        this.loadLicenceXML();
        this.configurationFileName = inConfigurationFile;
        this.loadConfigurationXML();
        this.setDecryptionType(inDecryptionType);
        this.setMaxGetWebserviceRetryCount(inMaxGetWebserviceRetryCount);
        this.setMaxStartSignerRetryCount(inMaxStartSignerRetryCount);
    }

    public BooleanTriState isExtractZipArchiv() {
        return this.extractZipArchiv;
    }

    public void setExtractZipArchiv(BooleanTriState extractZipArchiv) {
        this.extractZipArchiv = extractZipArchiv;
    }

    public String getCertificateID() {
        return this.certificateSerialNr != null ? this.certificateSerialNr : "";
    }

    public DecryptionType getDecryptionType() {
        return this.decryptionType;
    }

    public void setDecryptionType(String decryptionType) throws SignerException {
        for (DecryptionType type : DecryptionType.values()) {
            if (!type.name().equalsIgnoreCase(decryptionType)) continue;
            this.decryptionType = type;
            return;
        }
        throw new SignerException(ErrorCode.ILLEGAL_PARAM, "unknown parameter " + decryptionType, (Throwable)new Exception("Illegal Param"));
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(PARAM_NAME_SOURCE).append(" = ").append(this.source).append("\n");
        result.append(PARAM_NAME_LOG_FILE).append(" = ").append(this.logFileName).append("\n");
        result.append("Optional:\n");
        result.append(PARAM_NAME_DEST).append(" = ").append(this.dest).append("\n");
        result.append(PARAM_NAME_EXTRACT_ZIP_ARCHIV).append(" = ").append((Object)this.isExtractZipArchiv()).append("\n");
        result.append("-licenceFile").append(" = ").append(this.licenceFileName).append("\n");
        result.append("-webserviceURL").append(" = ").append(this.webServiceURL).append("\n");
        result.append(PARAM_TARGET_FOLDER_TYPE).append(" = ").append((Object)this.targetFolderType).append("\n");
        result.append("-processPolicy").append(" = ").append((Object)this.processPolicy).append("\n");
        result.append(PARAM_NAME_DECRYPTION_TYPE).append(" = ").append((Object)this.decryptionType).append("\n");
        result.append("-maxGetWebserviceRetryCount").append(" = ").append(this.maxGetWebserviceRetryCount).append("\n");
        result.append("-maxStartSignerRetryCount").append(" = ").append(this.maxStartSignerRetryCount).append("\n");
        result.append("-configuration").append(" = ").append(this.configurationFileName).append("\n");
        return result.toString();
    }
}

