/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.integrated.decrypt;

import de.bos_bremen.ecard.client.integrated.AbstractIntegratedCaller;
import de.bos_bremen.ecard.client.integrated.AbstractIntegratedParams;
import de.bos_bremen.ecard.client.integrated.SignerIntegratedInstance;
import de.bos_bremen.ecard.client.integrated.decrypt.DecryptParams;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.webservice.client.DecryptRequest;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Decrypt
extends AbstractIntegratedCaller {
    private static final Logger LOG = LogManager.getLogger(Decrypt.class);

    public static void main(String[] args) {
        LOG.info("args: {}", Arrays.asList(args));
        System.exit(Decrypt.run(args));
    }

    public static int runDecrypt(DecryptParams multiParams) {
        Decrypt instance = null;
        int aResultCode = -1;
        instance = new Decrypt();
        aResultCode = instance.run(multiParams);
        if (aResultCode == -1) {
            aResultCode = ErrorCode.OK.getReturnCode();
        }
        LOG.info("ReturnCode: {}", (Object)aResultCode);
        return aResultCode;
    }

    public static int run(String[] args) {
        DecryptParams multiParams = null;
        int aResultCode = -1;
        try {
            multiParams = new DecryptParams(args);
            LOG.debug("DecryptParams: {}", (Object)multiParams);
            aResultCode = Decrypt.runDecrypt(multiParams);
            LOG.debug("ReturnCode: {}", (Object)aResultCode);
        }
        catch (SignerException ex) {
            LOG.error("", (Throwable)ex);
            aResultCode = ex.getErrorCode().getReturnCode();
            LOG.error("ReturnCode: {}", (Object)aResultCode);
        }
        LOG.info("ReturnCode: {} {} {}", (Object)aResultCode, (Object)ErrorCode.getErrorCodeByID((int)aResultCode), (Object)ErrorCode.getErrorCodeByID((int)aResultCode).getDescription());
        LOG.info("System.exit: {}", (Object)aResultCode);
        return aResultCode;
    }

    @Override
    protected boolean callGovernikusSigner(AbstractIntegratedParams params, SignerIntegratedInstance signerInstance) throws IllegalArgumentException {
        if (!(params instanceof DecryptParams)) {
            throw new IllegalArgumentException("Es muss vom Typ DecryptParams sein");
        }
        DecryptParams decryptParams = (DecryptParams)params;
        DecryptRequest decryptRequest = new DecryptRequest();
        decryptRequest.setSerialnumber(decryptParams.getCertificateID());
        decryptRequest.getInputFiles().addAll(decryptParams.getSource());
        decryptRequest.setTargetFolderType(decryptParams.getTargetFolderType());
        decryptRequest.setOutputFolder(decryptParams.getDest());
        decryptRequest.setExtractZipArchiv(decryptParams.isExtractZipArchiv());
        decryptRequest.setProcessPolicy(decryptParams.getProcessPolicy());
        decryptRequest.setLicenceXML(decryptParams.getLicenceXML());
        decryptRequest.setConfigurationXML(decryptParams.getConfigurationXML());
        decryptRequest.setDecryptionType(decryptParams.getDecryptionType());
        return signerInstance.decryptRequest(decryptRequest);
    }

    @Override
    protected boolean couldHideAfterProcess() {
        return true;
    }
}

