/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.integrated;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.bos_bremen.ecard.client.integrated.SignerIntegratedInstance;
import de.bos_bremen.ecard.client.model.PDFSignatureType;
import de.bos_bremen.ecard.client.model.ProcessPolicy;
import de.bos_bremen.ecard.client.model.TargetFolderType;
import de.bos_bremen.ecard.client.model.XMLSignatureType;
import de.bos_bremen.ecard.client.webservice.client.BooleanTriState;
import de.bos_bremen.ecard.client.webservice.client.CardReaderArray;
import de.bos_bremen.ecard.client.webservice.client.DecryptRequest;
import de.bos_bremen.ecard.client.webservice.client.DecryptionType;
import de.bos_bremen.ecard.client.webservice.client.EncryptionType;
import de.bos_bremen.ecard.client.webservice.client.FrameworkStatus;
import de.bos_bremen.ecard.client.webservice.client.PdfSignatureType;
import de.bos_bremen.ecard.client.webservice.client.SignatureType;
import de.bos_bremen.ecard.client.webservice.client.XmlSignatureType;
import de.bos_bremen.ecard.client.webservice.dynamic.AbstractRequest;
import de.bos_bremen.ecard.client.webservice.dynamic.DecryptRequest;
import de.bos_bremen.ecard.client.webservice.dynamic.EncryptRequest;
import de.bos_bremen.ecard.client.webservice.dynamic.JsonRequest;
import de.bos_bremen.ecard.client.webservice.dynamic.JsonResponse;
import de.bos_bremen.ecard.client.webservice.dynamic.SignRequest;
import de.bos_bremen.ecard.client.webservice.dynamic.VerifyRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignerIntergratedInstanceRest
implements SignerIntegratedInstance {
    private static final Logger LOG = LogManager.getLogger(SignerIntergratedInstanceRest.class);
    URL url;
    Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public SignerIntergratedInstanceRest() {
        this.url = SignerIntergratedInstanceRest.getUrl();
    }

    public static URL getUrl() {
        int port = 8088;
        String servicePortString = System.getProperty("SERVICEPORT", System.getenv("SERVICEPORT"));
        if (servicePortString != null) {
            port = Integer.parseInt(servicePortString);
        } else if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            Map<String, String> enviroment = System.getenv();
            String clientName = System.getProperty("CLIENTNAME", enviroment.get("CLIENTNAME"));
            String sessionName = System.getProperty("SESSIONNAME", enviroment.get("SESSIONNAME"));
            LOG.info("CLIENTNAME= {}", (Object)clientName);
            LOG.info("SESSIONNAME= {}", (Object)sessionName);
            if (clientName != null && sessionName != null && !"Console".equals(sessionName)) {
                return null;
            }
        }
        try {
            return new URL("http://127.0.0.1:" + port + "/rest");
        }
        catch (MalformedURLException e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Override
    public FrameworkStatus getStatus() {
        return this.callRest((JsonRequest)JsonRequest.GET_STATUS).status;
    }

    @Override
    public void killInstance() {
        this.callRest(JsonRequest.KILL_INSTANCE);
    }

    @Override
    public String getVersion() {
        return this.callRest((JsonRequest)JsonRequest.GET_VERSION).version;
    }

    @Override
    public boolean checkCard(String serialNumber) {
        JsonRequest jr = new JsonRequest("CheckCard");
        jr.serialNo = serialNumber;
        return this.callRest((JsonRequest)jr).checkCard;
    }

    @Override
    public CardReaderArray getAvailableCardReader() {
        return this.callRest((JsonRequest)JsonRequest.GET_AVAILABLE_CARD_READER).availableCardReader;
    }

    @Override
    public boolean reinitCards() {
        return this.callRest((JsonRequest)JsonRequest.REINIT_CARDS).reinitCards;
    }

    @Override
    public boolean verifyRequest(de.bos_bremen.ecard.client.webservice.client.VerifyRequest verifyRequest) {
        VerifyRequest vr = new VerifyRequest();
        vr.setConfigurationXML(verifyRequest.getConfigurationXML());
        vr.setInputFiles(verifyRequest.getInputFiles().toArray(new String[0]));
        vr.setLicenceXML(verifyRequest.getLicenceXML());
        vr.setOutputFolder(verifyRequest.getOutputFolder());
        vr.setProcessPolicy(this.convert(verifyRequest.getProcessPolicy()));
        vr.setTargetFolderType(this.convert(verifyRequest.getTargetFolderType()));
        return this.callRest((AbstractRequest)vr).verifyResponse;
    }

    private de.bos_bremen.ecard.client.model.BooleanTriState convert(BooleanTriState b) {
        switch (b) {
            case YES: {
                return de.bos_bremen.ecard.client.model.BooleanTriState.yes;
            }
            case NO: {
                return de.bos_bremen.ecard.client.model.BooleanTriState.no;
            }
            case USE_DEFAULT: {
                return de.bos_bremen.ecard.client.model.BooleanTriState.useDefault;
            }
        }
        return null;
    }

    private ProcessPolicy convert(de.bos_bremen.ecard.client.webservice.client.ProcessPolicy pp) {
        switch (pp) {
            case FIRST_STEP: {
                return ProcessPolicy.firstStep;
            }
            case RUN_PROCESS: {
                return ProcessPolicy.runProcess;
            }
            case USE_DEFAULT: {
                return ProcessPolicy.useDefault;
            }
            case SKIP_COMPLETED_STEP: {
                return ProcessPolicy.skipCompletedStep;
            }
        }
        return null;
    }

    private TargetFolderType convert(de.bos_bremen.ecard.client.webservice.client.TargetFolderType tft) {
        switch (tft) {
            case ONE_SPECIAL: {
                return TargetFolderType.oneSpecial;
            }
            case SAME_AS_SOURCE_FOLDER: {
                return TargetFolderType.sameAsSourceFolder;
            }
            case USE_DEFAULT: {
                return TargetFolderType.useDefault;
            }
        }
        return null;
    }

    private DecryptRequest.DecryptionType convert(DecryptionType dt) {
        switch (dt) {
            case CERTIFICATE: {
                return DecryptRequest.DecryptionType.certificate;
            }
            case PASSWORD: {
                return DecryptRequest.DecryptionType.password;
            }
        }
        return null;
    }

    private EncryptRequest.EncryptionType convert(EncryptionType et) {
        switch (et) {
            case CERTIFICATE: {
                return EncryptRequest.EncryptionType.certificate;
            }
            case PASSWORD: {
                return EncryptRequest.EncryptionType.password;
            }
        }
        return null;
    }

    private XMLSignatureType convert(XmlSignatureType st) {
        switch (st) {
            case NO_XML_INLINE: {
                return XMLSignatureType.noXmlInline;
            }
            case USE_DEFAULT: {
                return XMLSignatureType.useDefault;
            }
            case XML_INLINE: {
                return XMLSignatureType.xmlInline;
            }
        }
        return null;
    }

    private de.bos_bremen.ecard.client.model.SignatureType convert(SignatureType st) {
        switch (st) {
            case DETACHED_PKCS_7: {
                return de.bos_bremen.ecard.client.model.SignatureType.detachedPKCS7;
            }
            case ENVELOPED_PKCS_7: {
                return de.bos_bremen.ecard.client.model.SignatureType.envelopedPKCS7;
            }
            case OSCI: {
                return de.bos_bremen.ecard.client.model.SignatureType.osci;
            }
            case RAW_XML: {
                return de.bos_bremen.ecard.client.model.SignatureType.detachedPKCS7;
            }
            case USE_DEFAULT: {
                return de.bos_bremen.ecard.client.model.SignatureType.useDefault;
            }
        }
        return null;
    }

    private PDFSignatureType convert(PdfSignatureType st) {
        switch (st) {
            case NO_PDF_INLINE: {
                return PDFSignatureType.noPdfInline;
            }
            case ADVANCED_PDF_INLINE: 
            case AUTOMATIC_PDF_INLINE: 
            case PDF_INLINE: {
                return PDFSignatureType.pdfInline;
            }
            case USE_DEFAULT: {
                return PDFSignatureType.useDefault;
            }
        }
        return null;
    }

    @Override
    public boolean decryptRequest(DecryptRequest decryptRequest) {
        de.bos_bremen.ecard.client.webservice.dynamic.DecryptRequest dr = new de.bos_bremen.ecard.client.webservice.dynamic.DecryptRequest();
        dr.setConfigurationXML(decryptRequest.getConfigurationXML());
        dr.setDecryptionType(this.convert(decryptRequest.getDecryptionType()));
        dr.setExtractZipArchiv(this.convert(decryptRequest.getExtractZipArchiv()));
        dr.setInputFiles(decryptRequest.getInputFiles().toArray(new String[0]));
        dr.setLicenceXML(decryptRequest.getLicenceXML());
        dr.setOutputFolder(decryptRequest.getOutputFolder());
        dr.setProcessPolicy(this.convert(decryptRequest.getProcessPolicy()));
        dr.setTargetFolderType(this.convert(decryptRequest.getTargetFolderType()));
        return this.callRest((AbstractRequest)dr).decryprResponse;
    }

    @Override
    public boolean encryptRequest(de.bos_bremen.ecard.client.webservice.client.EncryptRequest signRequest) {
        EncryptRequest er = new EncryptRequest();
        er.setConfigurationXML(signRequest.getConfigurationXML());
        er.setCreateZipArchivBeforeEncrypt(this.convert(signRequest.getCreateZipArchivBeforeEncrypt()));
        er.setEncryptionType(this.convert(signRequest.getEncryptionType()));
        er.setInputFiles(signRequest.getInputFiles().toArray(new String[0]));
        er.setLicenceXML(signRequest.getLicenceXML());
        er.setOutputFolder(signRequest.getOutputFolder());
        er.setProcessPolicy(this.convert(signRequest.getProcessPolicy()));
        er.setTargetFolderType(this.convert(signRequest.getTargetFolderType()));
        return this.callRest((AbstractRequest)er).encryptResponse;
    }

    @Override
    public boolean signRequest(de.bos_bremen.ecard.client.webservice.client.SignRequest signRequest) {
        SignRequest sr = new SignRequest();
        sr.setAdvancedPDFReason(signRequest.getAdvancedPDFReason());
        sr.setAdvancedPDFLocation(signRequest.getAdvancedPDFLocation());
        sr.setConfigurationXML(signRequest.getConfigurationXML());
        sr.setCreateTimestamp(this.convert(signRequest.getCreateTimestamp()));
        sr.setInputFiles(signRequest.getInputFiles().toArray(new String[0]));
        sr.setLicenceXML(signRequest.getLicenceXML());
        sr.setOutputFolder(signRequest.getOutputFolder());
        sr.setPdfSignatureType(this.convert(signRequest.getPdfSignatureType()));
        sr.setProcessPolicy(this.convert(signRequest.getProcessPolicy()));
        sr.setSignatureType(this.convert(signRequest.getSignatureType()));
        sr.setTargetFolderType(this.convert(signRequest.getTargetFolderType()));
        sr.setXmlSignatureType(this.convert(signRequest.getXmlSignatureType()));
        return this.callRest((AbstractRequest)sr).signResponse;
    }

    protected JsonResponse callRest(AbstractRequest params) {
        return this.callRest(this.gson.toJson((Object)new JsonRequest(params)));
    }

    protected JsonResponse callRest(JsonRequest jr) {
        return this.callRest(this.gson.toJson((Object)jr));
    }

    protected JsonResponse callRest(String params) {
        try {
            int c;
            LOG.debug("REST call to {}", (Object)this.url);
            HttpURLConnection openConnection = (HttpURLConnection)this.url.openConnection();
            openConnection.setConnectTimeout(500);
            openConnection.setDoOutput(true);
            openConnection.connect();
            LOG.debug("Send data: {}", (Object)params);
            OutputStream os = openConnection.getOutputStream();
            os.write(params.getBytes(StandardCharsets.UTF_8));
            os.close();
            InputStream is = null;
            is = openConnection.getResponseCode() != 200 ? openConnection.getErrorStream() : openConnection.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] tmp = new byte[1024];
            while ((c = is.read(tmp)) > -1) {
                baos.write(tmp, 0, c);
            }
            is.close();
            baos.close();
            String rsp = baos.toString(StandardCharsets.UTF_8);
            LOG.debug("Returned data: {}", (Object)rsp);
            if (openConnection.getResponseCode() != 200) {
                throw new IOException("Server returned HTTP error code " + openConnection.getResponseCode() + ", " + rsp);
            }
            JsonResponse ret = (JsonResponse)this.gson.fromJson(rsp, JsonResponse.class);
            if (ret.error != null) {
                throw new IOException("REST server returned error: " + ret.error);
            }
            return ret;
        }
        catch (Exception e) {
            LOG.error("Error calling REST server.", (Throwable)e);
            return null;
        }
    }
}

