/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.integrated;

import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.webservice.client.ProcessPolicy;
import de.bos_bremen.ecard.client.webservice.client.TargetFolderType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class AbstractIntegratedParams {
    public static final String PARAM_NAME_HELP = "-help";
    public static final String PARAM_NAME_VERSION = "-version";
    public static final String PARAM_NAME_LICENCEFILE = "-licenceFile";
    public static final String PARAM_NAME_CONFIGURATIONFILE = "-configuration";
    public static final String PARAM_NAME_WS_LOCATION = "-webserviceURL";
    public static final String PARAM_NAME_PROCESS_POLICY = "-processPolicy";
    public static final String PARAM_MAX_START_SIGNER_RETRY_COUNT = "-maxStartSignerRetryCount";
    public static final String PARAM_MAX_GET_WEBSERVICE_RETRY_COUNT = "-maxGetWebserviceRetryCount";
    public static final String PARAM_NAME_VERBOSE = "-v";
    protected List<String> source;
    protected String dest = "";
    protected String logFileName;
    protected URL webServiceURL;
    protected String licenceXML = "";
    protected String licenceFileName = null;
    protected String configurationXML = "";
    protected String configurationFileName = null;
    protected TargetFolderType targetFolderType;
    protected ProcessPolicy processPolicy;
    protected int maxStartSignerRetryCount = 100;
    protected int maxGetWebserviceRetryCount = 200;
    protected String helpPath = "";

    public List<String> getSource() {
        if (this.source == null) {
            this.source = new ArrayList<String>();
        }
        return this.source;
    }

    public String getDest() {
        if (this.dest == null) {
            this.dest = "";
        }
        return this.dest;
    }

    public void setDest(String inDest) throws SignerException {
        if (inDest != null && !inDest.isEmpty()) {
            this.dest = inDest;
            this.setTargetFolderType(TargetFolderType.ONE_SPECIAL.toString());
        } else {
            try {
                this.setTargetFolderType(TargetFolderType.SAME_AS_SOURCE_FOLDER.toString());
            }
            catch (SignerException signerException) {
                // empty catch block
            }
        }
    }

    public TargetFolderType getTargetFolderType() {
        if (this.targetFolderType == null) {
            this.targetFolderType = TargetFolderType.SAME_AS_SOURCE_FOLDER;
        }
        return this.targetFolderType;
    }

    public void setTargetFolderType(String inTargetFolderType) throws SignerException {
        try {
            if (TargetFolderType.ONE_SPECIAL.toString().equals(inTargetFolderType) && this.getDest().isEmpty()) {
                throw new SignerException(ErrorCode.ILLEGAL_PARAM, inTargetFolderType, (Throwable)new Exception("unknown target folder with target folder type " + inTargetFolderType));
            }
            this.targetFolderType = TargetFolderType.valueOf(inTargetFolderType);
        }
        catch (Exception ex) {
            throw new SignerException(ErrorCode.ILLEGAL_PARAM, inTargetFolderType, (Throwable)new Exception("unknown target folder type " + inTargetFolderType));
        }
    }

    public void setSourceFiles(List<String> inSource) throws SignerException {
        if (inSource == null) {
            throw new SignerException(ErrorCode.ILLEGAL_PARAM, (Throwable)new Exception("unknown source file/s"));
        }
        this.source = inSource;
    }

    public File getLogFile() {
        if (this.logFileName == null) {
            return null;
        }
        File logFile = null;
        logFile = this.dest != null && !"".equals(this.dest) ? new File(this.dest, this.logFileName) : new File(this.logFileName);
        boolean fileCorrupt = false;
        try {
            fileCorrupt = !logFile.exists() && !logFile.createNewFile();
        }
        catch (IOException ex) {
            fileCorrupt = true;
        }
        if (fileCorrupt) {
            if (this.dest != null && !"".equals(this.dest)) {
                File tempPath = new File(this.dest);
                File tempFileName = new File(this.logFileName);
                logFile = new File(tempPath, tempFileName.getName());
            } else {
                File tempFileName = new File(this.logFileName);
                logFile = new File(tempFileName.getName());
            }
        }
        return logFile;
    }

    public URL getWebServiceURL() {
        return this.webServiceURL;
    }

    public ProcessPolicy getProcessPolicy() {
        if (this.processPolicy == null) {
            this.processPolicy = ProcessPolicy.SKIP_COMPLETED_STEP;
        }
        return this.processPolicy;
    }

    protected String fetchNextParam(String[] args, int i) throws SignerException {
        if (args.length < i + 1 || args[i].startsWith("-")) {
            throw new SignerException(ErrorCode.MISSING_PARAM, args[i - 1], (Throwable)new Exception("missing argument for param " + args[i - 1]));
        }
        return args[i];
    }

    protected void loadLicenceXML() {
        if (this.licenceFileName == null || this.licenceFileName.isEmpty()) {
            this.licenceXML = "";
            return;
        }
        File licenceFile = new File(this.licenceFileName);
        if (!licenceFile.exists()) {
            this.licenceXML = "";
            return;
        }
        this.licenceXML = this.loadXmlContentFrom(this.licenceFileName);
    }

    public String getLicenceXML() {
        return this.licenceXML;
    }

    protected void loadConfigurationXML() {
        if (this.configurationFileName == null || this.configurationFileName.isEmpty()) {
            this.configurationXML = "";
            return;
        }
        File configurationFile = new File(this.configurationFileName);
        if (!configurationFile.exists()) {
            this.configurationXML = "";
            return;
        }
        this.configurationXML = this.loadXmlContentFrom(this.configurationFileName);
    }

    public String getConfigurationXML() {
        return this.configurationXML;
    }

    public void setWebServiceURL(String inWebServiceURL) throws MalformedURLException {
        if (inWebServiceURL != null && !inWebServiceURL.equals("")) {
            try {
                this.webServiceURL = new URL(inWebServiceURL);
            }
            catch (MalformedURLException e) {
                this.webServiceURL = null;
                throw new MalformedURLException(inWebServiceURL);
            }
        }
    }

    public void setProcessPolicy(String inProcessPolicy) throws SignerException {
        try {
            this.processPolicy = ProcessPolicy.valueOf(inProcessPolicy);
        }
        catch (Exception ex) {
            throw new SignerException(ErrorCode.ILLEGAL_PARAM, inProcessPolicy, (Throwable)new Exception("unknown process policy " + inProcessPolicy));
        }
    }

    public void setLicenceXML(String pathToLicenseXmlFile) {
        if (pathToLicenseXmlFile == null || pathToLicenseXmlFile.isEmpty()) {
            this.licenceXML = "";
            return;
        }
        if (new File(pathToLicenseXmlFile).exists()) {
            this.licenceFileName = pathToLicenseXmlFile;
        }
        this.licenceXML = this.loadXmlContentFrom(this.licenceFileName);
    }

    public void setConfigurationXML(String pathToConfigurationXmlFile) {
        if (pathToConfigurationXmlFile == null || pathToConfigurationXmlFile.isEmpty()) {
            this.configurationXML = "";
            return;
        }
        if (new File(pathToConfigurationXmlFile).exists()) {
            this.configurationFileName = pathToConfigurationXmlFile;
        }
        this.configurationXML = this.loadXmlContentFrom(this.configurationFileName);
    }

    public int getMaxStartSignerRetryCount() {
        return this.maxStartSignerRetryCount;
    }

    public void setMaxStartSignerRetryCount(int maxStartSignerRetryCount) {
        this.maxStartSignerRetryCount = maxStartSignerRetryCount;
    }

    public int getMaxGetWebserviceRetryCount() {
        return this.maxGetWebserviceRetryCount;
    }

    public void setMaxGetWebserviceRetryCount(int maxGetWebserviceRetryCount) {
        this.maxGetWebserviceRetryCount = maxGetWebserviceRetryCount;
    }

    public String getHelpPath() {
        return this.helpPath;
    }

    public void setHelpPath(String helpPath) {
        this.helpPath = helpPath;
    }

    protected String loadXmlContentFrom(String pathToXmlFile) {
        String xmlContent;
        if (pathToXmlFile == null || pathToXmlFile.isEmpty()) {
            return "";
        }
        File xmlFile = new File(pathToXmlFile);
        if (!xmlFile.exists()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(xmlFile), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            xmlContent = buffer.toString();
        }
        catch (IOException ex) {
            xmlContent = "";
        }
        return xmlContent;
    }
}

