/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.integrated;

import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.integrated.AbstractIntegratedParams;
import de.bos_bremen.ecard.client.integrated.SignerIntegratedInstance;
import de.bos_bremen.ecard.client.integrated.SignerIntegratedInstanceService;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.webservice.client.FrameworkState;
import de.bos_bremen.ecard.client.webservice.client.FrameworkStatus;
import de.bos_bremen.ecard.client.webservice.client.Result;
import de.bos_bremen.ecard.client.webservice.client.service.ports.Application;
import de.bos_bremen.ecard.client.webservice.client.service.ports.PortUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractIntegratedCaller {
    private static final Logger LOG = LogManager.getLogger(AbstractIntegratedCaller.class);
    static int threadError = 0;

    protected int run(AbstractIntegratedParams params) {
        long startTime = System.currentTimeMillis();
        LOG.debug("try to get SignerInstance");
        SignerIntegratedInstance signerInstance = null;
        if (!this.checkSignerInstanceConnection()) {
            int counter = 0;
            do {
                try {
                    Thread.sleep(500L);
                    ++counter;
                }
                catch (InterruptedException e) {
                    LOG.error("", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            } while (counter < params.getMaxGetWebserviceRetryCount() && !this.checkSignerInstanceConnection());
        }
        if ((signerInstance = this.getSignerInstance(params)) == null) {
            LOG.debug("Es wurde keine SignerInstanz gefunden");
            return ErrorCode.CONNECTION_ERROR.getReturnCode();
        }
        LOG.debug("{} ms seit start", (Object)(System.currentTimeMillis() - startTime));
        int retryCount = 0;
        LOG.info("{} ms seit start get a SignerInstance", (Object)(System.currentTimeMillis() - startTime));
        LOG.debug("Set connection Timeout to 5 Sec");
        System.setProperty("sun.net.client.defaultConnectionTimeout", "5000");
        boolean waitUntilStart = false;
        retryCount = 0;
        do {
            LOG.debug("Warten...");
            FrameworkStatus frameworkStatus = signerInstance.getStatus();
            FrameworkState frameworkState = FrameworkState.NONE;
            try {
                frameworkState = frameworkStatus.getState();
            }
            catch (Exception ex) {
                LOG.error("FrameworkState.none");
            }
            if (frameworkState.equals((Object)FrameworkState.WORKING)) {
                if (retryCount >= params.getMaxStartSignerRetryCount()) {
                    return ErrorCode.CONNECTION_ERROR.getReturnCode();
                }
                waitUntilStart = true;
                ++retryCount;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    LOG.error("", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            waitUntilStart = false;
        } while (waitUntilStart);
        int returnCode = 0;
        if (!this.callGovernikusSigner(params, signerInstance)) {
            LOG.debug("ErrorCode.ABORTED");
            returnCode = ErrorCode.ABORTED.getReturnCode();
        } else {
            FrameworkState frameworkState;
            FrameworkStatus frameworkStatus;
            boolean waitProcessing = false;
            do {
                frameworkStatus = signerInstance.getStatus();
                frameworkState = FrameworkState.NONE;
                try {
                    frameworkState = FrameworkState.valueOf(frameworkStatus.getState().toString());
                    LOG.debug((Object)frameworkState);
                }
                catch (Exception ex) {
                    LOG.error("FrameworkState.NONE");
                }
                if (!frameworkState.equals((Object)FrameworkState.ONLINE) && !frameworkState.equals((Object)FrameworkState.CANCELLED)) {
                    waitProcessing = true;
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        LOG.error("", (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                if (frameworkState.equals((Object)FrameworkState.ONLINE) && !frameworkStatus.getResults().isEmpty() && frameworkStatus.getResults().get(0).getReturnCode() == -1) {
                    LOG.debug("FrameworkState.ONLINE");
                    waitProcessing = true;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        LOG.error("", (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                waitProcessing = false;
            } while (waitProcessing);
            returnCode = this.processResults(params.getLogFile(), frameworkStatus);
            LOG.info((Object)returnCode);
            if (!this.couldHideAfterProcess()) {
                boolean waitOnProcessFinish = false;
                do {
                    frameworkStatus = signerInstance.getStatus();
                    frameworkState = FrameworkState.NONE;
                    try {
                        frameworkState = FrameworkState.valueOf(frameworkStatus.getState().toString());
                        LOG.debug((Object)frameworkState);
                    }
                    catch (Exception ex) {
                        LOG.error("FrameworkState.NONE");
                    }
                    if (!frameworkState.equals((Object)FrameworkState.ONLINE) && !frameworkState.equals((Object)FrameworkState.CANCELLED)) {
                        waitOnProcessFinish = true;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            LOG.error("", (Throwable)e);
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                    waitOnProcessFinish = false;
                } while (waitOnProcessFinish);
            }
        }
        LOG.info("ReturnCode: {}", (Object)returnCode);
        return returnCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processResults(File logFile, FrameworkStatus frameworkStatus) {
        int returnCode;
        block9: {
            block8: {
                LOG.debug("Results in Logfile: {}", (Object)logFile);
                returnCode = 0;
                int lastErrorLevel = 0;
                if (frameworkStatus == null || frameworkStatus.getResults() == null) break block8;
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy;HH:mm:ss");
                PrintStream outS = null;
                try {
                    try {
                        outS = new PrintStream((OutputStream)new FileOutputStream(logFile), true, StandardCharsets.UTF_8.name());
                    }
                    catch (IOException ex) {
                        outS = System.err;
                    }
                    for (int i = 0; i < frameworkStatus.getResults().size(); ++i) {
                        Result result = frameworkStatus.getResults().get(i);
                        StringBuilder resultLine = new StringBuilder();
                        resultLine.append(result.getReturnCode()).append(";");
                        resultLine.append(result.getInputFileName()).append(";");
                        resultLine.append(result.getDetailMessage() != null ? result.getDetailMessage() : "").append(";");
                        for (int j = 0; j < result.getResultFiles().size(); ++j) {
                            resultLine.append(result.getResultFiles().get(j));
                            if (j < result.getResultFiles().size() - 1) {
                                resultLine.append(",");
                                continue;
                            }
                            resultLine.append(";");
                        }
                        resultLine.append(simpleDateFormat.format(new Timestamp(System.currentTimeMillis())));
                        outS.println(resultLine.toString());
                        ErrorCode errorCodeByID = ErrorCode.getErrorCodeByID((int)result.getReturnCode());
                        LOG.debug("error code: {}", (Object)errorCodeByID);
                        if (errorCodeByID == null || lastErrorLevel >= errorCodeByID.errorLevel()) continue;
                        returnCode = errorCodeByID.getReturnCode();
                        lastErrorLevel = errorCodeByID.errorLevel();
                    }
                }
                catch (Throwable throwable) {
                    Utils.closeStream(outS);
                    throw throwable;
                }
                Utils.closeStream((Closeable)outS);
                if (FrameworkState.CANCELLED.equals((Object)frameworkStatus.getState())) {
                    returnCode = ErrorCode.ABORTED.getReturnCode();
                }
                break block9;
            }
            LOG.warn("Keine Ergebnisdateien");
        }
        return returnCode;
    }

    protected SignerIntegratedInstance getSignerInstance(AbstractIntegratedParams params) {
        SignerIntegratedInstance signerInstance = null;
        signerInstance = params != null && params.getWebServiceURL() != null ? this.getSignerInstance(params.getWebServiceURL()) : this.getSignerInstance();
        return signerInstance;
    }

    protected SignerIntegratedInstance getSignerInstance(URL webServiceURL) {
        SignerIntegratedInstance signerInstance = null;
        try {
            SignerIntegratedInstanceService service = null;
            service = new SignerIntegratedInstanceService(webServiceURL, new QName("governikus", "SignerIntegratedInstanceService"));
            signerInstance = service.getSignerIntegratedInstancePort();
        }
        catch (WebServiceException ex) {
            LOG.debug((Object)ex, (Throwable)ex);
        }
        return signerInstance;
    }

    protected boolean checkSignerInstanceConnection() {
        return this.checkSignerInstanceConnection(PortUtils.generateSignerServiceWSDL((Application)Application.GOVERNIKUS_INTEGRATED_SIGNER, (boolean)false));
    }

    protected URL getRestUrl() {
        URL url = null;
        try {
            int port = 8088;
            String servicePortString = System.getProperty("SERVICEPORT", System.getenv("SERVICEPORT"));
            if (servicePortString != null) {
                port = Integer.parseInt(servicePortString);
            }
            url = new URL("http://127.0.0.1:" + port + "/rest");
        }
        catch (MalformedURLException e) {
            LOG.error((Object)e);
        }
        return url;
    }

    protected boolean checkSignerInstanceConnection(URL url) {
        boolean urlConnect = false;
        try {
            URLConnection openConnection = url.openConnection();
            openConnection.setConnectTimeout(500);
            openConnection.connect();
            urlConnect = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return urlConnect;
    }

    protected SignerIntegratedInstance getSignerInstance() {
        SignerIntegratedInstance signerInstance = null;
        try {
            SignerIntegratedInstanceService service = null;
            service = new SignerIntegratedInstanceService();
            signerInstance = service.getSignerIntegratedInstancePort();
        }
        catch (WebServiceException ex) {
            LOG.debug((Object)ex, (Throwable)ex);
        }
        return signerInstance;
    }

    protected abstract boolean callGovernikusSigner(AbstractIntegratedParams var1, SignerIntegratedInstance var2) throws IllegalArgumentException;

    protected abstract boolean couldHideAfterProcess();
}

