/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui;

import de.bos_bremen.ecard.client.webservice.client.SignerInstanceClient;
import de.bos_bremen.ecard.client.webservice.client.SignerInstanceService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignerMainStarter {
    private static final Logger LOG = LogManager.getLogger(SignerMainStarter.class);
    private static final String MAIN_CLASS_NORMAL = "-normal";
    private static final String MAIN_CLASS_SERVICE = "-service";
    private static final String DEFAULT_CONNECT_TIMEOUT = "sun.net.client.defaultConnectTimeout";
    private static final String DEFAULT_READ_TIMEOUT = "sun.net.client.defaultReadTimeout";

    public SignerMainStarter() {
        this.loadProviderProperties();
        System.setProperty(DEFAULT_CONNECT_TIMEOUT, System.getProperty(DEFAULT_CONNECT_TIMEOUT, "30000"));
        System.setProperty(DEFAULT_READ_TIMEOUT, System.getProperty(DEFAULT_READ_TIMEOUT, "180000"));
    }

    private void loadProviderProperties() {
        Properties providerProps = this.convertResourceBundleToProperties(ResourceBundle.getBundle("resources/provider"));
        providerProps.list(System.out);
        System.getProperties().putAll((Map<?, ?>)providerProps);
    }

    private Properties convertResourceBundleToProperties(ResourceBundle resource) {
        Properties properties = new Properties();
        Enumeration<String> keys = resource.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            properties.put(key, resource.getString(key));
        }
        return properties;
    }

    public static void main(String[] args) {
        SignerMainStarter starter = new SignerMainStarter();
        SignerMainStarter.createVersionInstallDate();
        starter.run(args);
    }

    private int run(String[] args) {
        switch (this.getMainClass(args)) {
            case SERVICE: {
                new SignerInstanceService(args);
                break;
            }
            default: {
                return SignerInstanceClient.run(args);
            }
        }
        return 0;
    }

    private MainClassEnum getMainClass(String[] args) {
        MainClassEnum mainClass = MainClassEnum.NORMAL;
        String[] stringArray = args;
        int n = stringArray.length;
        block8: for (int i = 0; i < n; ++i) {
            String arg;
            switch (arg = stringArray[i]) {
                case "-service": {
                    mainClass = MainClassEnum.SERVICE;
                    continue block8;
                }
                case "-normal": {
                    mainClass = MainClassEnum.NORMAL;
                    continue block8;
                }
            }
        }
        System.setProperty("SignerMainClass", mainClass.name());
        LOG.trace("main class: {}", (Object)mainClass);
        return mainClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] processParameters(String[] args) {
        Preferences prefs = Preferences.userRoot().node("de");
        prefs = prefs.node("governikus");
        prefs = prefs.node("boreum");
        Preferences pref = prefs.node("dynamic_message");
        ArrayList<String> arguments = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-") && !args[i].equals("-sign") && !args[i].equals("-verify") && !args[i].equals("-encrypt") && !args[i].equals("-decrypt")) continue;
            arguments.add(args[i]);
        }
        long time = System.currentTimeMillis();
        int i = 0;
        Iterator it = arguments.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            try {
                pref.put(time + "_" + i++, arg);
                it.remove();
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
            finally {
                try {
                    prefs.flush();
                }
                catch (BackingStoreException e) {
                    LOG.error((Object)e);
                }
            }
        }
        return args;
    }

    private static void createVersionInstallDate() {
        Preferences licenceNode = Preferences.userRoot().node("de/bos_bremen/governikus_signer");
        if (licenceNode.get("period", null) == null) {
            licenceNode.put("period", Base64.getEncoder().encodeToString(new SimpleDateFormat("dd.MM.yyyy").format(new Date()).getBytes()));
            try {
                licenceNode.flush();
            }
            catch (BackingStoreException e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    public static enum MainClassEnum {
        NORMAL,
        SERVICE;

    }
}

