/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui;

import de.bos_bremen.ecard.client.GUIClientStarter;
import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.control.process.ProcessFactory;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.control.process.ProcessName;
import de.bos_bremen.ecard.client.control.process.RootProcessName;
import de.bos_bremen.ecard.client.decrypt.control.process.impl.DecryptProcess;
import de.bos_bremen.ecard.client.decrypt.gui.DecryptProcessHelper;
import de.bos_bremen.ecard.client.decrypt.model.formular.process.DecryptProcessFormular;
import de.bos_bremen.ecard.client.encrypt.control.process.impl.EncryptProcess;
import de.bos_bremen.ecard.client.encrypt.gui.EncryptProcessHelper;
import de.bos_bremen.ecard.client.encrypt.model.formular.process.EncryptProcessFormular;
import de.bos_bremen.ecard.client.gui.GUIClient;
import de.bos_bremen.ecard.client.gui.GUIUtils;
import de.bos_bremen.ecard.client.model.BooleanTriState;
import de.bos_bremen.ecard.client.model.CardReader;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.FrameworkInstanceHandler;
import de.bos_bremen.ecard.client.model.FrameworkStatus;
import de.bos_bremen.ecard.client.model.PDFSignatureType;
import de.bos_bremen.ecard.client.model.ProcessPolicy;
import de.bos_bremen.ecard.client.model.SignatureType;
import de.bos_bremen.ecard.client.model.TargetFolderType;
import de.bos_bremen.ecard.client.model.formular.process.ProcessFormular;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.sign.control.process.impl.SignProcess;
import de.bos_bremen.ecard.client.sign.gui.SignProcessHelper;
import de.bos_bremen.ecard.client.sign.model.formular.process.SignProcessFormular;
import de.bos_bremen.ecard.client.util.XMLProperties;
import de.bos_bremen.ecard.client.verify.control.process.impl.VerifyProcess;
import de.bos_bremen.ecard.client.verify.gui.VerifyProcessHelper;
import de.bos_bremen.ecard.client.verify.model.formular.process.VerifyProcessFormular;
import de.bos_bremen.ecard.client.webservice.SingleInstanceHandler;
import de.bos_bremen.ecard.client.webservice.dynamic.DecryptRequest;
import de.bos_bremen.ecard.client.webservice.dynamic.EncryptRequest;
import de.bos_bremen.ecard.client.webservice.dynamic.SignRequest;
import de.bos_bremen.ecard.client.webservice.dynamic.VerifyRequest;
import java.awt.Component;
import java.awt.HeadlessException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Signer
implements SingleInstanceHandler,
FrameworkInstanceHandler {
    private static final String CHANGE_PROCESS_MESSAGE = "change.process.message";
    private static final String KEY_CHANGE_PROCESS = "change.process";
    private static final String KEY_ADDFILE = "addfile";
    private final GUIClient signerFrame;
    private static final Logger LOG = LogManager.getLogger(Signer.class);

    public Signer(boolean hideAfterStart, String helpPath) {
        if (helpPath != null) {
            System.setProperty("signer.helppath", helpPath);
        }
        this.signerFrame = new GUIClient();
        Document documentInstance = Document.getInstance();
        documentInstance.setSingleInstanceHandler((FrameworkInstanceHandler)this);
        documentInstance.setFrame((GUIClientStarter)this.signerFrame);
        this.signerFrame.run();
        this.runProjectPreferencesTimer();
    }

    private void runProjectPreferencesTimer() {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                List<String> updaterPreferences;
                boolean readyToWork;
                FrameworkStatus.FrameworkState state = Signer.this.getStatus().getState();
                boolean bl = readyToWork = FrameworkStatus.FrameworkState.online.equals((Object)state) || FrameworkStatus.FrameworkState.cancelled.equals((Object)state);
                if (readyToWork && (updaterPreferences = Signer.this.getUpdaterPreferences()) != null && !updaterPreferences.isEmpty()) {
                    Signer.this.runSignerWithPreferences(updaterPreferences);
                }
            }
        }, 2000L, 2000L);
    }

    private void runSignerWithPreferences(List<String> args) {
        ArrayList<String> argSource = new ArrayList<String>();
        ProcessName processName = RootProcessName.getInstance();
        for (int i = 0; i < args.size(); ++i) {
            if (!args.get(i).startsWith("-")) {
                argSource.add(args.get(i));
                continue;
            }
            if (args.get(i).equals("-stop")) {
                this.killInstance();
                break;
            }
            if (args.get(i).equals("-" + SignProcess.PROCESS_NAME.getName())) {
                processName = SignProcess.PROCESS_NAME;
                continue;
            }
            if (args.get(i).equals("-" + VerifyProcess.PROCESS_NAME.getName())) {
                processName = VerifyProcess.PROCESS_NAME;
                continue;
            }
            if (args.get(i).equals("-" + EncryptProcess.PROCESS_NAME.getName())) {
                processName = EncryptProcess.PROCESS_NAME;
                continue;
            }
            if (!args.get(i).equals("-" + DecryptProcess.PROCESS_NAME.getName())) continue;
            processName = DecryptProcess.PROCESS_NAME;
        }
        String[] sourceFiles = argSource.toArray(new String[argSource.size()]);
        if (processName.equals(SignProcess.PROCESS_NAME)) {
            SignRequest request = new SignRequest();
            request.setInputFiles(sourceFiles);
            this.signRequest(request);
        } else if (processName.equals(VerifyProcess.PROCESS_NAME)) {
            VerifyRequest request = new VerifyRequest();
            request.setInputFiles(sourceFiles);
            this.verifyRequest(request);
        } else if (processName.equals(EncryptProcess.PROCESS_NAME)) {
            EncryptRequest request = new EncryptRequest();
            request.setInputFiles(sourceFiles);
            this.encryptRequest(request);
        } else if (processName.equals(DecryptProcess.PROCESS_NAME)) {
            DecryptRequest request = new DecryptRequest();
            request.setInputFiles(sourceFiles);
            this.decryptRequest(request);
        }
    }

    private List<String> getUpdaterPreferences() {
        Preferences prefs = Preferences.userRoot().node("de");
        prefs = prefs.node("governikus");
        LicenceTyp enableGeneralIntegratedWS = Document.getInstance().getProductFunctions().enableGeneralIntegratedWS();
        String property = enableGeneralIntegratedWS.isEditable() ? "boreum_ie" : "boreum";
        prefs = prefs.node(property);
        Preferences pref = prefs.node("dynamic_message");
        ArrayList<String> arguments = new ArrayList<String>();
        try {
            String[] prefKeys = pref.keys();
            if (prefKeys.length > 0) {
                for (String key : prefKeys) {
                    arguments.add(pref.get(key, ""));
                }
                pref.removeNode();
            }
            if (!arguments.isEmpty()) {
                return arguments;
            }
        }
        catch (BackingStoreException e) {
            LOG.error("BackingStoreException: ", (Throwable)e);
        }
        return null;
    }

    public JFrame getSignerFrame() {
        return this.signerFrame;
    }

    @Override
    public void killInstance() {
        if (Document.getInstance().getCurrentFrameworkState().equals((Object)FrameworkStatus.FrameworkState.processing)) {
            LOG.warn("Instance ist in FrameworkState processing: wird nicht beendet.");
            return;
        }
        LOG.info("Kill Instance: Exit.");
        System.exit(0);
    }

    public boolean checkCard(String cardnumber) {
        while (Document.getInstance().getCurrentFrameworkState().equals((Object)FrameworkStatus.FrameworkState.initializing) || Document.getInstance().getCurrentFrameworkState().equals((Object)FrameworkStatus.FrameworkState.starting)) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LOG.debug((Object)e, (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        if (this.signerFrame != null && this.signerFrame.getClientView() != null) {
            return this.signerFrame.getClientView().checkCard(cardnumber);
        }
        return false;
    }

    public List<CardReader> getAvailableCardReader() {
        while (Document.getInstance().getCurrentFrameworkState().equals((Object)FrameworkStatus.FrameworkState.initializing) || Document.getInstance().getCurrentFrameworkState().equals((Object)FrameworkStatus.FrameworkState.starting)) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LOG.debug((Object)e, (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        if (this.signerFrame != null && this.signerFrame.getClientView() != null) {
            return this.signerFrame.getClientView().getAvailableCardReader();
        }
        return Collections.emptyList();
    }

    private boolean showSigner() {
        if (this.signerFrame == null) {
            return false;
        }
        this.signerFrame.setSplashScreenVisible(false);
        this.signerFrame.setVisible(true);
        this.signerFrame.setAlwaysOnTop(true);
        this.signerFrame.setAlwaysOnTop(false);
        GUIUtils.updateFontSizeFromConfig();
        return true;
    }

    public FrameworkStatus getStatus() {
        if (this.signerFrame != null && this.signerFrame.getClientView() != null) {
            return this.signerFrame.getClientView().getStatus();
        }
        LOG.debug("getStatus: {}", (Object)FrameworkStatus.FrameworkState.none);
        return new FrameworkStatus(FrameworkStatus.FrameworkState.none);
    }

    public String getVersion() {
        LOG.info("");
        if (this.signerFrame == null || this.signerFrame.getClientView() == null) {
            return "";
        }
        String version = this.signerFrame.getClientView().getVersion();
        LOG.info("Version {}", (Object)version);
        return version;
    }

    @Override
    public boolean decrypt(String serialnumber, String[] inputFile, TargetFolderType targetFolderType, String outputFolder, BooleanTriState extractZipArchiv, ProcessPolicy processPolicy, String licenceXML, String configurationXML) {
        DecryptRequest request = new DecryptRequest();
        request.setInputFiles(inputFile != null ? inputFile : new String[]{});
        request.setTargetFolderType(targetFolderType);
        request.setOutputFolder(outputFolder);
        request.setExtractZipArchiv(extractZipArchiv);
        request.setProcessPolicy(processPolicy);
        request.setLicenceXML(licenceXML);
        request.setConfigurationXML(configurationXML);
        return this.decryptRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean decryptRequest(DecryptRequest request) {
        Document documentInstance;
        LOG.info("");
        LOG.info("*** DecryptRequest received ***");
        LOG.trace("Source : {}", Arrays.asList(request.getInputFiles()));
        if (this.signerFrame == null) {
            return false;
        }
        if (this.signerFrame.getClientView() == null) {
            return false;
        }
        boolean fillFormular = false;
        boolean showSigner = false;
        Document document = documentInstance = Document.getInstance();
        synchronized (document) {
            block18: {
                block17: {
                    DecryptProcessFormular decryptProcessFormular;
                    ProcessFormular processesFormular;
                    if (documentInstance.getCurrentFrameworkState().equals((Object)FrameworkStatus.FrameworkState.processing)) {
                        LOG.info("FrameworkState : processing -> Request abgelehnt. Nur bei FrameworkState online oder cancelled wird ein neuer Request verarbeitet.");
                        return fillFormular;
                    }
                    boolean filesExist = false;
                    ProcessI process = documentInstance.getProcessFactory().getProcess(DecryptProcess.PROCESS_NAME);
                    if (process != null && (processesFormular = documentInstance.getProcessFactory().getNewProcessesFormularInstance(process)) instanceof DecryptProcessFormular && (decryptProcessFormular = (DecryptProcessFormular)processesFormular).getSelectedFiles() != null && !decryptProcessFormular.getSelectedFiles().isEmpty()) {
                        filesExist = true;
                    }
                    boolean isVisible = documentInstance.getFrame() != null && documentInstance.getFrame().isVisible();
                    boolean startOtherProzess = false;
                    ProcessName activeProcess = Utils.getActiveProcess();
                    ProcessName decryptProcess = DecryptProcess.PROCESS_NAME;
                    if (isVisible && activeProcess != null && !activeProcess.equals(RootProcessName.getInstance()) && !activeProcess.equals(DecryptProcess.PROCESS_NAME)) {
                        LOG.info("Frage: Wollen Sie den Prozess Entschluesseln starten und den aktuellen Prozess {} beenden?", (Object)activeProcess.getDisplayName());
                        switch (documentInstance.displayRedundantMessages((Component)documentInstance.getFrame(), KEY_CHANGE_PROCESS, MessageFormat.format(Messages.getString((String)CHANGE_PROCESS_MESSAGE), decryptProcess.getDisplayName(), activeProcess.getDisplayName()), 2, 3, false)) {
                            case 0: {
                                startOtherProzess = true;
                                LOG.info("Ausgewaehlt: Ja, {} beenden und {} starten", (Object)activeProcess.getDisplayName(), (Object)decryptProcess.getDisplayName());
                                break;
                            }
                            default: {
                                LOG.info("Ausgewaehlt: {} nicht beenden.", (Object)activeProcess.getDisplayName());
                                return fillFormular;
                            }
                        }
                    }
                    if (!isVisible || activeProcess == null || startOtherProzess || !filesExist || !documentInstance.getCurrentFrameworkState().equals((Object)FrameworkStatus.FrameworkState.working)) break block17;
                    LOG.info("Frage: Sie haben die Moeglichkeit, die ausgewaehlten Datei(en) hinzuzufuegen oder zu ersetzen?");
                    switch (documentInstance.displayRedundantMessages((Component)documentInstance.getFrame(), KEY_ADDFILE, 3, 3, false)) {
                        case 0: {
                            LOG.info("Ausgewaehlt: Dateien hinzufuegen...");
                            fillFormular = new DecryptProcessHelper().fillDecryptFormular(request.getSerialnumber(), request.getInputFiles(), request.getTargetFolderType(), request.getOutputFolder(), request.getExtractZipArchiv(), this.getState(request.getDecryptionType()), false) != null;
                            break block18;
                        }
                        case 1: {
                            LOG.info("Ausgewaehlt: Dateien ersetzen...");
                            fillFormular = new DecryptProcessHelper().fillDecryptFormular(request.getSerialnumber(), request.getInputFiles(), request.getTargetFolderType(), request.getOutputFolder(), request.getExtractZipArchiv(), this.getState(request.getDecryptionType()), true) != null;
                            break block18;
                        }
                        default: {
                            LOG.info("Ausgewaehlt abbrechen: Dateien hinzufuegen bzw. ersetzen.");
                            return fillFormular;
                        }
                    }
                }
                boolean bl = fillFormular = new DecryptProcessHelper().fillDecryptFormular(request.getSerialnumber(), request.getInputFiles(), request.getTargetFolderType(), request.getOutputFolder(), request.getExtractZipArchiv(), this.getState(request.getDecryptionType()), true) != null;
            }
            if (fillFormular) {
                this.setConfiguration(request.getConfigurationXML());
                documentInstance.getProcessFactory().getProcessChoose().showProcess(DecryptProcess.PROCESS_NAME);
                documentInstance.getProductFunctions().loadDynamicLicence(request.getLicenceXML());
                this.signerFrame.setupProcessPolicy(request.getProcessPolicy());
            }
        }
        if (fillFormular) {
            showSigner = this.showSigner();
        }
        LOG.info("Entschluesselung anzeigen : {} : ", (Object)showSigner, (Object)documentInstance.getCurrentFrameworkState());
        return showSigner;
    }

    BooleanTriState getState(DecryptRequest.DecryptionType dt) {
        if (dt == null) {
            return BooleanTriState.useDefault;
        }
        if (dt.name().equals(DecryptRequest.DecryptionType.password.name())) {
            return BooleanTriState.yes;
        }
        return BooleanTriState.no;
    }

    BooleanTriState getState(EncryptRequest.EncryptionType et) {
        if (et == null) {
            return BooleanTriState.useDefault;
        }
        if (et.name().equals(EncryptRequest.EncryptionType.password.name())) {
            return BooleanTriState.yes;
        }
        return BooleanTriState.no;
    }

    @Override
    public boolean encrypt(String serialnumber, String[] inputFile, TargetFolderType targetFolderType, String outputFolder, BooleanTriState createZipArchiv, ProcessPolicy processPolicy, String licenceXML, String configurationXML) {
        EncryptRequest request = new EncryptRequest();
        request.setInputFiles(inputFile != null ? inputFile : new String[]{});
        request.setTargetFolderType(targetFolderType);
        request.setOutputFolder(outputFolder);
        request.setCreateZipArchivBeforeEncrypt(createZipArchiv);
        request.setProcessPolicy(processPolicy);
        request.setLicenceXML(licenceXML);
        request.setConfigurationXML(configurationXML);
        return this.encryptRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean encryptRequest(EncryptRequest request) {
        Document documentInstance;
        LOG.info("");
        LOG.info("*** EncryptRequest received ***");
        LOG.trace("Source : {}", Arrays.asList(request.getInputFiles()));
        if (this.signerFrame == null) {
            return false;
        }
        if (this.signerFrame.getClientView() == null) {
            return false;
        }
        boolean fillFormular = false;
        boolean showSigner = false;
        Document document = documentInstance = Document.getInstance();
        synchronized (document) {
            block18: {
                block17: {
                    EncryptProcessFormular encryptProcessFormular;
                    ProcessFormular processesFormular;
                    if (documentInstance.getCurrentFrameworkState().equals((Object)FrameworkStatus.FrameworkState.processing)) {
                        LOG.info("FrameworkState : processing -> Request abgelehnt. Nur bei FrameworkState online, cancelled, working wird ein neuer Request verarbeitet.");
                        return fillFormular;
                    }
                    boolean filesExist = false;
                    ProcessI process = documentInstance.getProcessFactory().getProcess(EncryptProcess.PROCESS_NAME);
                    if (process != null && (processesFormular = documentInstance.getProcessFactory().getNewProcessesFormularInstance(process)) instanceof EncryptProcessFormular && (encryptProcessFormular = (EncryptProcessFormular)processesFormular).getSelectedFiles() != null && !encryptProcessFormular.getSelectedFiles().isEmpty()) {
                        filesExist = true;
                    }
                    boolean isVisible = documentInstance.getFrame() != null && documentInstance.getFrame().isVisible();
                    boolean startOtherProzess = false;
                    ProcessName activeProcess = Utils.getActiveProcess();
                    ProcessName encryptProcess = EncryptProcess.PROCESS_NAME;
                    if (isVisible && activeProcess != null && !activeProcess.equals(RootProcessName.getInstance()) && !activeProcess.equals(EncryptProcess.PROCESS_NAME)) {
                        LOG.info("Frage: Wollen Sie den Prozess Verschluesseln starten und den aktuellen Prozess {} beenden?", (Object)activeProcess.getDisplayName());
                        switch (documentInstance.displayRedundantMessages((Component)documentInstance.getFrame(), KEY_CHANGE_PROCESS, MessageFormat.format(Messages.getString((String)CHANGE_PROCESS_MESSAGE), encryptProcess.getDisplayName(), activeProcess.getDisplayName()), 2, 3, false)) {
                            case 0: {
                                startOtherProzess = true;
                                LOG.info("Ausgewaehlt: Ja, {} beenden und {} starten", (Object)activeProcess.getDisplayName(), (Object)encryptProcess.getDisplayName());
                                break;
                            }
                            default: {
                                LOG.info("Ausgewaehlt: {} nicht beenden.", (Object)activeProcess.getDisplayName());
                                return fillFormular;
                            }
                        }
                    }
                    if (!isVisible || activeProcess == null || startOtherProzess || !filesExist || !documentInstance.getCurrentFrameworkState().equals((Object)FrameworkStatus.FrameworkState.working)) break block17;
                    LOG.info("Frage: Sie haben die Moeglichkeit, die ausgewaehlten Datei(en) hinzuzufuegen oder zu ersetzen?");
                    switch (documentInstance.displayRedundantMessages((Component)documentInstance.getFrame(), KEY_ADDFILE, 3, 3, false)) {
                        case 0: {
                            LOG.info("Ausgewaehlt: Dateien hinzufuegen...");
                            fillFormular = new EncryptProcessHelper().fillEncryptFormular(request.getSerialnumber(), request.getInputFiles(), request.getTargetFolderType(), request.getOutputFolder(), request.getCreateZipArchivBeforeEncrypt(), this.getState(request.getEncryptionType()), false) != null;
                            break block18;
                        }
                        case 1: {
                            LOG.info("Ausgewaehlt: Dateien ersetzen...");
                            fillFormular = new EncryptProcessHelper().fillEncryptFormular(request.getSerialnumber(), request.getInputFiles(), request.getTargetFolderType(), request.getOutputFolder(), request.getCreateZipArchivBeforeEncrypt(), this.getState(request.getEncryptionType()), true) != null;
                            break block18;
                        }
                        default: {
                            LOG.info("Ausgewaehlt abbrechen: Dateien hinzufuegen bzw. ersetzen.");
                            return fillFormular;
                        }
                    }
                }
                boolean bl = fillFormular = new EncryptProcessHelper().fillEncryptFormular(request.getSerialnumber(), request.getInputFiles(), request.getTargetFolderType(), request.getOutputFolder(), request.getCreateZipArchivBeforeEncrypt(), this.getState(request.getEncryptionType()), true) != null;
            }
            if (fillFormular) {
                this.setConfiguration(request.getConfigurationXML());
                documentInstance.getProcessFactory().getProcessChoose().showProcess(EncryptProcess.PROCESS_NAME);
                documentInstance.getProductFunctions().loadDynamicLicence(request.getLicenceXML());
                this.signerFrame.setupProcessPolicy(request.getProcessPolicy());
            }
        }
        if (fillFormular) {
            showSigner = this.showSigner();
        }
        LOG.info("Verschluesselung anzeigen : {} : ", (Object)showSigner, (Object)documentInstance.getCurrentFrameworkState());
        return showSigner;
    }

    @Override
    public boolean sign(String serialnumber, String[] inputFile, TargetFolderType targetFolderType, String outputFolder, SignatureType signatureType, PDFSignatureType pdfSignatureType, String advancedPDFReason, BooleanTriState createTimestamp, ProcessPolicy processPolicy, String licenceXML, String configurationXML) {
        LOG.info("Boreum received Parameter -> create SignRequest with Parameter...");
        SignRequest request = new SignRequest();
        request.setInputFiles(inputFile != null ? inputFile : new String[]{});
        request.setTargetFolderType(targetFolderType);
        request.setOutputFolder(outputFolder);
        request.setSignatureType(signatureType);
        request.setPdfSignatureType(pdfSignatureType);
        request.setAdvancedPDFReason(advancedPDFReason);
        request.setCreateTimestamp(createTimestamp);
        request.setProcessPolicy(processPolicy);
        request.setLicenceXML(licenceXML);
        request.setConfigurationXML(configurationXML);
        return this.signRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean signRequest(SignRequest signRequest) {
        Document documentInstance;
        LOG.info("");
        LOG.info("*** SignRequest received ***");
        LOG.trace("Source : {}", Arrays.asList(signRequest.getInputFiles()));
        if (this.signerFrame == null) {
            return false;
        }
        if (this.signerFrame.getClientView() == null) {
            return false;
        }
        boolean showSigner = false;
        boolean fillFormular = false;
        Document document = documentInstance = Document.getInstance();
        synchronized (document) {
            block18: {
                block17: {
                    SignProcessFormular signProcessFormular;
                    ProcessFormular processesFormular;
                    if (documentInstance.getCurrentFrameworkState().equals((Object)FrameworkStatus.FrameworkState.processing)) {
                        LOG.info("FrameworkState : processing -> Request abgelehnt. Nur bei FrameworkState online, cancelled oder working wird ein neuer Request bearbeitet.");
                        return fillFormular;
                    }
                    boolean filesExist = false;
                    ProcessI process = documentInstance.getProcessFactory().getProcess(SignProcess.PROCESS_NAME);
                    if (process != null && (processesFormular = documentInstance.getProcessFactory().getNewProcessesFormularInstance(process)) instanceof SignProcessFormular && (signProcessFormular = (SignProcessFormular)processesFormular).getSelectedFiles() != null && !signProcessFormular.getSelectedFiles().isEmpty()) {
                        filesExist = true;
                    }
                    boolean isVisible = documentInstance.getFrame() != null && documentInstance.getFrame().isVisible();
                    boolean startOtherProzess = false;
                    ProcessName activeProcess = Utils.getActiveProcess();
                    ProcessName signProcess = SignProcess.PROCESS_NAME;
                    if (isVisible && activeProcess != null && !activeProcess.equals(RootProcessName.getInstance()) && !activeProcess.equals(SignProcess.PROCESS_NAME)) {
                        LOG.info("Frage: Wollen Sie den Prozess Signieren starten und den aktuellen Prozess {} beenden?", (Object)activeProcess.getDisplayName());
                        switch (documentInstance.displayRedundantMessages((Component)documentInstance.getFrame(), KEY_CHANGE_PROCESS, MessageFormat.format(Messages.getString((String)CHANGE_PROCESS_MESSAGE), signProcess.getDisplayName(), activeProcess.getDisplayName()), 2, 3, false)) {
                            case 0: {
                                startOtherProzess = true;
                                LOG.info("Ausgewaehlt: Ja, {} beenden und {} starten", (Object)activeProcess.getDisplayName(), (Object)signProcess.getDisplayName());
                                break;
                            }
                            default: {
                                LOG.info("Ausgewaehlt: {} nicht beenden.", (Object)activeProcess.getDisplayName());
                                return fillFormular;
                            }
                        }
                    }
                    if (!isVisible || activeProcess == null || startOtherProzess || !filesExist || !documentInstance.getCurrentFrameworkState().equals((Object)FrameworkStatus.FrameworkState.working)) break block17;
                    LOG.info("Frage: Sie haben die Moeglichkeit, die ausgewaehlten Datei(en) hinzuzufuegen oder zu ersetzen?");
                    switch (documentInstance.displayRedundantMessages((Component)documentInstance.getFrame(), KEY_ADDFILE, 3, 3, false)) {
                        case 0: {
                            LOG.info("Ausgewaehlt: Dateien hinzufuegen...");
                            fillFormular = new SignProcessHelper().fillSignFormular(signRequest.getSerialnumber(), signRequest.getInputFiles(), signRequest.getTargetFolderType(), signRequest.getOutputFolder(), signRequest.getSignatureType(), signRequest.getPdfSignatureType(), signRequest.getAdvancedPDFReason(), signRequest.getAdvancedPDFLocation(), signRequest.getXmlSignatureType(), signRequest.getCreateTimestamp(), false) != null;
                            LOG.info("Dateien hinzugefuegt : {}", (Object)fillFormular);
                            break block18;
                        }
                        case 1: {
                            LOG.info("Ausgewaehlt: Dateien ersetzen...");
                            fillFormular = new SignProcessHelper().fillSignFormular(signRequest.getSerialnumber(), signRequest.getInputFiles(), signRequest.getTargetFolderType(), signRequest.getOutputFolder(), signRequest.getSignatureType(), signRequest.getPdfSignatureType(), signRequest.getAdvancedPDFReason(), signRequest.getAdvancedPDFLocation(), signRequest.getXmlSignatureType(), signRequest.getCreateTimestamp(), true) != null;
                            LOG.info("Dateien sind ersetzt : {}", (Object)fillFormular);
                            break block18;
                        }
                        default: {
                            LOG.info("Ausgewaehlt abbrechen: Dateien hinzufuegen bzw. ersetzen.");
                            return fillFormular;
                        }
                    }
                }
                LOG.info("Default : SignFormular ausfuellen...");
                fillFormular = new SignProcessHelper().fillSignFormular(signRequest.getSerialnumber(), signRequest.getInputFiles(), signRequest.getTargetFolderType(), signRequest.getOutputFolder(), signRequest.getSignatureType(), signRequest.getPdfSignatureType(), signRequest.getAdvancedPDFReason(), signRequest.getAdvancedPDFLocation(), signRequest.getXmlSignatureType(), signRequest.getCreateTimestamp(), true) != null;
                LOG.info("SignFormular ausgefuellt: {}", (Object)fillFormular);
            }
            if (fillFormular) {
                LOG.trace("Nutze Parameter Konfiguration ...");
                this.setConfiguration(signRequest.getConfigurationXML());
                LOG.trace("Nutze Parameter Lizenz ...");
                documentInstance.getProductFunctions().loadDynamicLicence(signRequest.getLicenceXML());
                documentInstance.getProcessFactory().getProcessChoose().showProcess(SignProcess.PROCESS_NAME);
                this.signerFrame.setupProcessPolicy(signRequest.getProcessPolicy());
            }
            LOG.debug("SignFormular : {}", (Object)fillFormular);
        }
        if (fillFormular) {
            showSigner = this.showSigner();
        }
        LOG.info("Signieren anzeigen : {} : {}", (Object)showSigner, (Object)documentInstance.getCurrentFrameworkState());
        return showSigner;
    }

    @Override
    public boolean start(boolean setGUIVisible) {
        if (this.signerFrame == null || this.signerFrame.getClientView() == null) {
            return false;
        }
        if (!setGUIVisible) {
            this.signerFrame.setSplashScreenVisible(false);
            GUIUtils.updateFontSizeFromConfig();
            return true;
        }
        this.showSigner();
        return true;
    }

    @Override
    public boolean verify(String[] inputFile, TargetFolderType targetFolderType, String outputFolder, ProcessPolicy processPolicy, String licenceXML, String configurationXML) {
        VerifyRequest request = new VerifyRequest();
        request.setInputFiles(inputFile != null ? inputFile : new String[]{});
        request.setTargetFolderType(targetFolderType);
        request.setOutputFolder(outputFolder);
        request.setProcessPolicy(processPolicy);
        request.setLicenceXML(licenceXML);
        request.setConfigurationXML(configurationXML);
        return this.verifyRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verifyRequest(VerifyRequest request) {
        Document documentInstance;
        LOG.info("");
        LOG.info("*** VerifyRequest received ***");
        LOG.trace("Source : {}", Arrays.asList(request.getInputFiles()));
        if (this.signerFrame == null) {
            return false;
        }
        if (this.signerFrame.getClientView() == null) {
            return false;
        }
        boolean showSigner = false;
        boolean fillFormular = false;
        Document document = documentInstance = Document.getInstance();
        synchronized (document) {
            block21: {
                block22: {
                    ProcessName activeProcess;
                    boolean startOtherProzess;
                    boolean isVisible;
                    boolean filesExist;
                    block20: {
                        VerifyProcessFormular verifyProcessFormular;
                        ProcessFormular processesFormular;
                        if (documentInstance.getCurrentFrameworkState().equals((Object)FrameworkStatus.FrameworkState.processing)) {
                            LOG.info("FrameworkState : processing -> Request abgelehnt. Nur bei FrameworkState online, cancelled oder working wird ein neuer Request verarbeitet.");
                            return fillFormular;
                        }
                        filesExist = false;
                        ProcessI process = documentInstance.getProcessFactory().getProcess(VerifyProcess.PROCESS_NAME);
                        if (process != null && (processesFormular = documentInstance.getProcessFactory().getNewProcessesFormularInstance(process)) instanceof VerifyProcessFormular && (verifyProcessFormular = (VerifyProcessFormular)processesFormular).getSelectedFiles() != null && !verifyProcessFormular.getSelectedFiles().isEmpty()) {
                            filesExist = true;
                        }
                        isVisible = documentInstance.getFrame() != null && documentInstance.getFrame().isVisible();
                        startOtherProzess = false;
                        activeProcess = Utils.getActiveProcess();
                        ProcessName verifyProcess = VerifyProcess.PROCESS_NAME;
                        if (isVisible && activeProcess != null && !activeProcess.equals(RootProcessName.getInstance()) && !activeProcess.equals(VerifyProcess.PROCESS_NAME)) {
                            LOG.info("Frage: Wollen Sie den Prozess Validieren starten und den aktuellen Prozess {} beenden?", (Object)activeProcess.getDisplayName());
                            switch (documentInstance.displayRedundantMessages((Component)documentInstance.getFrame(), KEY_CHANGE_PROCESS, MessageFormat.format(Messages.getString((String)CHANGE_PROCESS_MESSAGE), verifyProcess.getDisplayName(), activeProcess.getDisplayName()), 2, 3, false)) {
                                case 0: {
                                    startOtherProzess = true;
                                    LOG.info("Ausgewaehlt: Ja, {} beenden und {} starten", (Object)activeProcess.getDisplayName(), (Object)verifyProcess.getDisplayName());
                                    break;
                                }
                                default: {
                                    LOG.info("Ausgewaehlt: {} nicht beenden.", (Object)activeProcess.getDisplayName());
                                    return fillFormular;
                                }
                            }
                        }
                        if (!isVisible || activeProcess == null || startOtherProzess || !filesExist || !documentInstance.getCurrentFrameworkState().equals((Object)FrameworkStatus.FrameworkState.working)) break block20;
                        LOG.info("Frage: Sie haben die Moeglichkeit, die ausgewaehlten Datei(en) hinzuzufuegen oder zu ersetzen?");
                        switch (documentInstance.displayRedundantMessages((Component)documentInstance.getFrame(), KEY_ADDFILE, 3, 3, false)) {
                            case 0: {
                                LOG.info("Ausgewaehlt: Dateien hinzufuegen...");
                                fillFormular = VerifyProcessHelper.fillVerifyFormular((String[])request.getInputFiles(), (TargetFolderType)request.getTargetFolderType(), (String)request.getOutputFolder(), (boolean)false) != null;
                                break block21;
                            }
                            case 1: {
                                LOG.info("Ausgewaehlt: Dateien ersetzen...");
                                fillFormular = VerifyProcessHelper.fillVerifyFormular((String[])request.getInputFiles(), (TargetFolderType)request.getTargetFolderType(), (String)request.getOutputFolder(), (boolean)true) != null;
                                break block21;
                            }
                            default: {
                                LOG.info("Ausgewaehlt abbrechen: Dateien hinzufuegen bzw. ersetzen.");
                                return fillFormular;
                            }
                        }
                    }
                    if (!isVisible || activeProcess == null || startOtherProzess || !filesExist || !documentInstance.getCurrentFrameworkState().equals((Object)FrameworkStatus.FrameworkState.finished)) break block22;
                    LOG.info("Es wurden neue Dateien zum Validierungsdienst uebergeben.Moechten Sie diese Dateien uebernehmenund das aktuelle Validierungsergebnis verwerfen?");
                    switch (documentInstance.displayRedundantMessages((Component)documentInstance.getFrame(), "replaceverifyfile", 2, 3, false)) {
                        case 0: {
                            LOG.info("Ausgewaehlt: Dateien uebernehmen und aktuelle Validierungsergebnis verwerfen.");
                            fillFormular = VerifyProcessHelper.fillVerifyFormular((String[])request.getInputFiles(), (TargetFolderType)request.getTargetFolderType(), (String)request.getOutputFolder(), (boolean)true) != null;
                            break block21;
                        }
                        default: {
                            LOG.info("Ausgewaehlt: Dateien nicht uebernehmen.");
                            return fillFormular;
                        }
                    }
                }
                boolean bl = fillFormular = VerifyProcessHelper.fillVerifyFormular((String[])request.getInputFiles(), (TargetFolderType)request.getTargetFolderType(), (String)request.getOutputFolder(), (boolean)true) != null;
            }
            if (fillFormular) {
                this.setConfiguration(request.getConfigurationXML());
                documentInstance.getProcessFactory().getProcessChoose().showProcess(VerifyProcess.PROCESS_NAME);
                documentInstance.getProductFunctions().loadDynamicLicence(request.getLicenceXML());
                this.signerFrame.setupProcessPolicy(request.getProcessPolicy());
            }
        }
        if (fillFormular) {
            showSigner = this.showSigner();
        }
        LOG.info("Validieren anzeigen : {} : {}", (Object)showSigner, (Object)documentInstance.getCurrentFrameworkState());
        return showSigner;
    }

    @Override
    public void hide() {
        if (this.signerFrame != null) {
            ProcessFactory processFactory = Document.getInstance().getProcessFactory();
            XMLProperties properties = processFactory.getProperties();
            Config.getInstance().setProcessProperties(properties);
            Config.getInstance().storeDefault(false);
            processFactory.setProperties(Config.getInstance().getProcessProperties());
            this.signerFrame.setVisible(false);
        }
    }

    public boolean reinitCards() {
        return this.signerFrame.getClientView().reinitCards();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConfiguration(String configurationXML) {
        LOG.info("");
        if (Document.getInstance().getProductFunctions().enableGeneralIntegratedWS().useInProcess()) {
            Config.init((Component)Document.getInstance().getFrame(), (boolean)false);
        }
        ProcessFactory processFactory = Document.getInstance().getProcessFactory();
        processFactory.setProperties(Config.getInstance().getProcessProperties());
        if (configurationXML != null && !configurationXML.isEmpty()) {
            ByteArrayInputStream isConfig = null;
            try {
                isConfig = new ByteArrayInputStream(configurationXML.getBytes(StandardCharsets.UTF_8));
                Config config = Config.getInstance();
                if (config.checkConfigFile((InputStream)isConfig)) {
                    ((InputStream)isConfig).close();
                    isConfig = new ByteArrayInputStream(configurationXML.getBytes(StandardCharsets.UTF_8));
                    config.load((InputStream)isConfig);
                    processFactory.setProperties(config.getProcessProperties());
                    XMLProperties properties = processFactory.getProperties();
                    config.setProcessProperties(properties);
                    config.fireConfigChangedEvent();
                }
            }
            catch (HeadlessException | IOException exception) {
            }
            finally {
                if (isConfig != null) {
                    try {
                        ((InputStream)isConfig).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (Document.getInstance().getProductFunctions().enableGeneralIntegratedWS().useInProcess()) {
            processFactory.setProperties(Config.getInstance().getProcessProperties());
            XMLProperties properties = processFactory.getProperties();
            Config.getInstance().setProcessProperties(properties);
            Config.getInstance().fireConfigChangedEvent();
        }
    }
}

