/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui;

import de.bos_bremen.ecard.client.GUIClientStarter;
import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.gui.dialog.LicenceKeyDialog;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.error.ErrorHandler;
import de.bos_bremen.ecard.client.model.error.SignerErrorHandler;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import java.awt.Component;
import java.awt.Frame;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GUIClient
extends GUIClientStarter {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger(GUIClient.class);

    public void run() {
        LicenceTyp enableGeneralIntegratedWS;
        Document documentInstance = Document.getInstance();
        if (documentInstance == null) {
            LOG.warn("document instance is null");
            return;
        }
        if (documentInstance.getErrorHandler() == null) {
            documentInstance.setErrorHandler((ErrorHandler)new SignerErrorHandler((Component)((Object)this)));
        }
        this.startInvisibleClient(!(enableGeneralIntegratedWS = documentInstance.getProductFunctions().enableGeneralIntegratedWS()).isEditable());
        Boolean usePeriod = Config.getInstance().isUsePeriod();
        Long period = Config.getInstance().getPeriod();
        if (Boolean.TRUE.equals(usePeriod) && period != null && period == -1L) {
            SwingUtilities.invokeLater(() -> {
                LicenceKeyDialog licenceKeyDialog = new LicenceKeyDialog((Frame)Document.getInstance().getFrame());
                licenceKeyDialog.setVisible(true);
            });
        }
    }

    static {
        System.setProperty("javax.net.ssl.trustStoreType", "JKS");
        String bundleName = "de.bos_bremen.ecard.client.gui.signer_messages";
        ResourceBundle signerResourceBundle = ResourceBundle.getBundle(bundleName);
        Messages.addResourceBundle((String)bundleName, (ResourceBundle)signerResourceBundle);
    }
}

