/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.ers.criteria;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.validate.svp.ERSValidationResult;
import de.governikus.csl.validation.ValidationCriterion;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.er.ERS;
import java.util.Set;
import java.util.stream.Collectors;

public class DigestAlgoNameCompareCheck
implements ValidationCriterion<ERS, ERSValidationResult, SignatureValidationContext> {
    public void verify(ERS ers, ERSValidationResult result, SignatureValidationContext context) {
        if (ers.isContainedInAsicE()) {
            if (Boolean.getBoolean("de.governikus.csl.asic.ers.manifest.allow_algo_mismatch")) {
                result.setDigestAlgoNameCompareCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, (MinorResult)null));
                return;
            }
            String mustMatch = ers.getInitTreeDigestAlgoJcaName();
            Set compareNames = ers.getManifestDigestsByAlgoJcaName().keySet().stream().map(ERS.DigestKey::getAlgoName).collect(Collectors.toSet());
            if (mustMatch != null && compareNames != null && compareNames.stream().allMatch(e -> e.equals(mustMatch))) {
                result.setDigestAlgoNameCompareCheck(SVPFactory.createResultOk());
            } else if (mustMatch == null) {
                result.setDigestAlgoNameCompareCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.SIGNED_DATA_NOT_FOUND));
            } else {
                result.setDigestAlgoNameCompareCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.GENERIC, (String[])new String[]{"ers_verify_manifest_hash_algorithm"}));
            }
        } else {
            result.setDigestAlgoNameCompareCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, (MinorResult)null));
        }
    }

    public boolean preconditionsFulfilled(ERS ers, ERSValidationResult result) {
        return true;
    }

    public boolean isApplicable(ERS ers, ERSValidationResult result, SignatureValidationContext context) {
        return true;
    }
}

