/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.ers;

import de.governikus.csl.ers.ERSDataExtractor;
import de.governikus.csl.ers.ERSDocument;
import de.governikus.csl.ers.ERSParser;
import de.governikus.csl.ers.criteria.DigestAlgoNameCompareCheck;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.PluginType;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.utils.DateUtil;
import de.governikus.csl.utils.MagicBytes;
import de.governikus.csl.validate.svp.ERSValidationResult;
import de.governikus.csl.validate.svp.ObjectValidationResult;
import de.governikus.csl.validation.AbstractDocumentPlugin;
import de.governikus.csl.validation.Configuration;
import de.governikus.csl.validation.PluginPriority;
import de.governikus.csl.validation.ValidatePlugin;
import de.governikus.csl.validation.ValidatePluginException;
import de.governikus.csl.validation.ValidationCriterion;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.dataExtractor.DataExtractor;
import de.governikus.csl.validation.er.ERS;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import java.util.ArrayList;
import java.util.List;

@PluginPriority(priority=-6000L)
@PluginType(id=Plugin.PluginID.VALIDATE_ERS, type=ValidatePlugin.class)
public class ERSPlugin
extends AbstractDocumentPlugin<ERSDocument, ERS, ObjectValidationResult, ERSValidationResult, SignatureValidationContext> {
    private static final String[] SUPPORTED_FILE_EXTENSIONS = new String[]{"ers"};

    public ERSPlugin() {
        super(ERS.class, SignatureValidationContext.class);
    }

    public boolean supportsMimeType(String mimetype) {
        return false;
    }

    public String[] getSupportedFileExtensions() {
        return SUPPORTED_FILE_EXTENSIONS;
    }

    public void configure(Configuration config) {
        this.configuration = config;
    }

    public MagicBytes getMagicBytesOfDocumentFormat() {
        return null;
    }

    public String getID() {
        return Plugin.PluginID.VALIDATE_ERS.getID();
    }

    public ERSDocument parseDocument(SignedData doc, TempDataManager tempDataManager) throws ValidatePluginException {
        try {
            ERSParser ersParser = new ERSParser(this.configuration.getAlgorithmManager());
            return ersParser.loadDocument(doc);
        }
        catch (Exception e) {
            throw new ValidatePluginException((ValidatePlugin)this, "Can't parse er document", (Throwable)e);
        }
    }

    protected ObjectValidationResult createResultStructure(ObjectToValidate<?> objectToValidate) {
        ObjectValidationResult ovr = new ObjectValidationResult();
        ovr.setObjectTypeID(Plugin.PluginID.VALIDATE_ERS.getID());
        return ovr;
    }

    protected ERSValidationResult createSignatureValidationResultStructure() {
        ERSValidationResult result = new ERSValidationResult();
        result.setClaimedSigningTime(DateUtil.DATE_FOR_FINAL_REVOCATION_VALUES);
        result.setSignatureAlgorithmExpirationDateVal(DateUtil.DATE_FOR_FINAL_REVOCATION_VALUES);
        result.setSignatureAlgorithmExpirationDateSign(DateUtil.DATE_FOR_FINAL_REVOCATION_VALUES);
        return result;
    }

    public SignatureValidationContext createContext(ERS signature, ValidationPolicyType policy) {
        return new SignatureValidationContext(policy);
    }

    public DataExtractor<? super ERS, ? super ERSValidationResult> getSignatureDataExtractor() {
        return new ERSDataExtractor();
    }

    public static List<ValidationCriterion<? super ERS, ? super ERSValidationResult, ? super SignatureValidationContext>> getAllKnownCustomPlugins() {
        ArrayList<ValidationCriterion<? super ERS, ? super ERSValidationResult, ? super SignatureValidationContext>> result = new ArrayList<ValidationCriterion<? super ERS, ? super ERSValidationResult, ? super SignatureValidationContext>>();
        result.add(new DigestAlgoNameCompareCheck());
        return result;
    }
}

