/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.ers;

import de.bos_bremen.ci.StreamableInputData;
import de.bos_bremen.ci.asn1.ParseException;
import de.governikus.csl.ers.ERSDocument;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.utils.AbstractDocumentParser;
import de.governikus.csl.validation.er.ArchiveTimestamp;
import de.governikus.csl.validation.er.ArchiveTimestampChain;
import de.governikus.csl.validation.er.ERS;
import de.governikus.csl.validation.er.EvidenceRecord;
import de.governikus.csl.validation.er.EvidenceRecordCreator;
import de.governikus.csl.vi.StreamableCSLDocument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ERSParser
extends AbstractDocumentParser<ERSDocument> {
    private static final String META_INF_PREFIX = "META-INF/";
    private EvidenceRecordCreator erCreator;

    public ERSParser(AlgorithmManager algorithmManager) {
        this.erCreator = new EvidenceRecordCreator(algorithmManager);
    }

    public ERSDocument loadDocument(SignedData sda) throws Exception {
        Document signature = sda.getSignature();
        List contents = sda.getContents();
        return this.loadDocument(signature, contents);
    }

    private ERSDocument loadDocument(Document sig, List<? extends Document> contents) throws ParseException {
        EvidenceRecord evidenceRecord = this.erCreator.create((StreamableInputData)new StreamableCSLDocument(sig));
        this.addContents(contents, evidenceRecord);
        ERS ers = new ERS();
        ers.setEvidenceRecord(evidenceRecord);
        ers.setContentNames(new ArrayList(contents.stream().map(Document::getName).collect(Collectors.toList())));
        ERSDocument ersDocument = new ERSDocument();
        ersDocument.setName(sig.getName());
        ersDocument.setSignatures(Collections.singletonList(ers));
        Document manifest = contents.stream().filter(e -> e.getName().startsWith(META_INF_PREFIX)).findFirst().orElse(null);
        if (manifest != null) {
            ersDocument.setIncludedFilesToValidate(Collections.singletonList(manifest));
            ArchiveTimestamp arTst = (ArchiveTimestamp)((ArchiveTimestampChain)evidenceRecord.getArchiveTimeStampSequence().get(0)).getTimestamps().get(0);
            ers.setInitTreeDigestAlgoJcaName(arTst.getDigestAlgorithm().getJCAName());
        }
        return ersDocument;
    }

    private void addContents(List<? extends Document> contents, EvidenceRecord evidenceRecord) {
        ArrayList<Document> expectedSecured = new ArrayList<Document>();
        for (Document document : contents) {
            if (document.getName().startsWith(META_INF_PREFIX)) continue;
            expectedSecured.add(document);
        }
        evidenceRecord.setExpectedSecuredData(expectedSecured);
    }
}

