/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.base.validators.signature.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.eac.EACObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.rosstandart.RosstandartObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.DefaultCMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.SignerInformationVerifierProvider;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.util.Selector;

public final class CMSUtils {
    public static final String DSA = "DSA";
    public static final String ECDSA = "ECDSA";
    public static final String ECGOST3410 = "ECGOST3410";
    public static final String ECGOST3410_2012_256 = "ECGOST3410-2012-256";
    public static final String ECGOST3410_2012_512 = "ECGOST3410-2012-512";
    private static final Map<String, String> encryptionAlgs = new HashMap<String, String>();
    public static final String GOST3410 = "GOST3410";
    public static final String RS_AAND_MGF1 = "RSAandMGF1";
    public static final String RSA = "RSA";

    private static void addEntries(ASN1ObjectIdentifier alias, String encryption) {
        encryptionAlgs.put(alias.getId(), encryption);
    }

    public static ContentVerifier createContentVerifier(X509CertificateHolder x509CertificateHolder, boolean usePublicKeyOnly, AlgorithmIdentifier verifierAlgorithmIdentifier) throws CertificateException, OperatorCreationException {
        try {
            JcaContentVerifierProviderBuilder builder = new JcaContentVerifierProviderBuilder().setProvider("BC");
            ContentVerifier contentVerifier = null;
            if (usePublicKeyOnly) {
                PublicKey publicKey = new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509CertificateHolder).getPublicKey();
                contentVerifier = builder.build(publicKey).get(verifierAlgorithmIdentifier);
            } else {
                contentVerifier = builder.build(x509CertificateHolder).get(verifierAlgorithmIdentifier);
            }
            if (contentVerifier == null) {
                throw new OperatorCreationException("failed to build content verifier");
            }
            return contentVerifier;
        }
        catch (CertificateException e) {
            throw new OperatorCreationException("failed to create content verifier: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new OperatorCreationException("failed to create content verifier with unexpected exception: " + e.getMessage(), (Throwable)e);
        }
    }

    private static DigestCalculatorProvider createFixedDigestCalculatorProvider(final byte[] digestValue) {
        return algorithm -> {
            final DigestCalculator digestCalculator = new BcDigestCalculatorProvider().get(algorithm);
            return new DigestCalculator(){

                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return digestCalculator.getAlgorithmIdentifier();
                }

                public byte[] getDigest() {
                    return digestValue;
                }

                public OutputStream getOutputStream() {
                    return digestCalculator.getOutputStream();
                }
            };
        };
    }

    public static ContentVerifier createFixedDigestContentVerifier(final X509CertificateHolder x509CertificateHolder, final SignerInformation signerInformation, byte[] digestValue, final boolean usePublicKeyOnly, AlgorithmIdentifier verifierAlgorithmIdentifier) throws CertificateException, OperatorCreationException {
        final ContentVerifier contentVerifier = CMSUtils.createContentVerifier(x509CertificateHolder, usePublicKeyOnly, verifierAlgorithmIdentifier);
        return new ContentVerifier(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return contentVerifier.getAlgorithmIdentifier();
            }

            public OutputStream getOutputStream() {
                return contentVerifier.getOutputStream();
            }

            public boolean verify(byte[] expected) {
                try {
                    String jceSignatureName = CMSUtils.getJCESignatureName(signerInformation);
                    Signature verify = Signature.getInstance(jceSignatureName, "BC");
                    X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509CertificateHolder);
                    if (usePublicKeyOnly) {
                        verify.initVerify(cert.getPublicKey());
                    } else {
                        verify.initVerify(cert);
                    }
                    verify.update(signerInformation.getEncodedSignedAttributes());
                    return verify.verify(signerInformation.getSignature());
                }
                catch (IOException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static SignerInformationVerifier createFixedDigestSignerInformationVerifier(CMSSignedData cms, SignerInformation signerInformation, byte[] digestValue, boolean usePublicKey, X509Certificate expectedSignerCertificate) {
        if (cms == null) {
            return null;
        }
        X509CertificateHolder x509CertificateHolder = CMSUtils.getFirstSignerCertificate(cms);
        if (x509CertificateHolder == null) {
            return null;
        }
        try {
            if (expectedSignerCertificate != null && !Arrays.equals(x509CertificateHolder.getEncoded(), expectedSignerCertificate.getEncoded())) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        ContentVerifierProvider verifierProvider = CMSUtils.createFixedDigestVerifierContentProvider(x509CertificateHolder, signerInformation, digestValue, usePublicKey);
        DigestCalculatorProvider digestCalculatorProvider = CMSUtils.createFixedDigestCalculatorProvider(digestValue);
        return new SignerInformationVerifier((CMSSignatureAlgorithmNameGenerator)new DefaultCMSSignatureAlgorithmNameGenerator(), (SignatureAlgorithmIdentifierFinder)new DefaultSignatureAlgorithmIdentifierFinder(), verifierProvider, digestCalculatorProvider);
    }

    public static SignerInformationVerifierProvider createFixedDigestSignerInformationVerifierProvider(CMSSignedData cmsSignedData, byte[] digestValue, boolean usePublicKey, X509Certificate expectedSignerCertificate) {
        return signerId -> {
            SignerInformationVerifier signaturInformationVerifier = CMSUtils.createFixedDigestSignerInformationVerifier(cmsSignedData, CMSUtils.getSignerInformation(cmsSignedData, signerId), digestValue, usePublicKey, expectedSignerCertificate);
            if (signaturInformationVerifier == null) {
                throw new OperatorCreationException("failed to create SignatureInformationVerifier");
            }
            return signaturInformationVerifier;
        };
    }

    public static ContentVerifierProvider createFixedDigestVerifierContentProvider(final X509CertificateHolder x509CertificateHolder, final SignerInformation signerInformation, final byte[] digestValue, final boolean usePublicKeyOnly) {
        if (x509CertificateHolder == null) {
            return null;
        }
        if (signerInformation == null) {
            return null;
        }
        return new ContentVerifierProvider(){

            public ContentVerifier get(AlgorithmIdentifier verifierAlgorithmIdentifier) throws OperatorCreationException {
                try {
                    return CMSUtils.createFixedDigestContentVerifier(x509CertificateHolder, signerInformation, digestValue, usePublicKeyOnly, verifierAlgorithmIdentifier);
                }
                catch (CertificateException e) {
                    throw new OperatorCreationException("failed to create content verifier: " + e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    throw new OperatorCreationException("failed to create content verifier with unexpected exception: " + e.getMessage(), (Throwable)e);
                }
            }

            public X509CertificateHolder getAssociatedCertificate() {
                return x509CertificateHolder;
            }

            public boolean hasAssociatedCertificate() {
                return true;
            }
        };
    }

    public static SignerInformationVerifier createSignerInformationVerifier(CMSSignedData cms, SignerId signerId, boolean usePublicKey, X509Certificate expectedSignerCertificate) {
        if (cms == null) {
            return null;
        }
        X509CertificateHolder x509CertificateHolder = CMSUtils.findCertificate(cms, signerId);
        if (x509CertificateHolder == null) {
            return null;
        }
        try {
            if (expectedSignerCertificate != null && !Arrays.equals(x509CertificateHolder.getEncoded(), expectedSignerCertificate.getEncoded())) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        ContentVerifierProvider verifierProvider = CMSUtils.createVerifierContentProvider(x509CertificateHolder, usePublicKey);
        return new SignerInformationVerifier((CMSSignatureAlgorithmNameGenerator)new DefaultCMSSignatureAlgorithmNameGenerator(), (SignatureAlgorithmIdentifierFinder)new DefaultSignatureAlgorithmIdentifierFinder(), verifierProvider, (DigestCalculatorProvider)new BcDigestCalculatorProvider());
    }

    public static X509CertificateHolder findCertificate(CMSSignedData cms, SignerId signerId) {
        SignerInformation signerInformation;
        X509CertificateHolder x509CertificateHolder = cms == null ? null : ((signerInformation = CMSUtils.findSignerInformation(cms, signerId)) == null ? CMSUtils.getFirstSignerCertificate(cms) : CMSUtils.getSignerCertificate(cms, signerInformation));
        return x509CertificateHolder;
    }

    public static SignerInformation findSignerInformation(CMSSignedData cms, SignerId signerId) {
        Collection signers;
        if (cms == null) {
            return null;
        }
        SignerInformationStore signerInfos = cms.getSignerInfos();
        SignerInformation signerInformation = signerInfos == null || cms.getSignerInfos().size() == 0 ? null : (signerId == null ? (SignerInformation)signerInfos.iterator().next() : ((signers = signerInfos.getSigners(signerId)) == null || signers.isEmpty() ? (SignerInformation)signerInfos.iterator().next() : (SignerInformation)signers.iterator().next()));
        return signerInformation;
    }

    public static SignerInformationVerifierProvider createSignerInformationVerifierProvider(CMSSignedData cmsSignedData, boolean usePublicKey, X509Certificate expectedSignerCertificate) {
        return signerId -> {
            SignerInformationVerifier signaturInformationVerifier = CMSUtils.createSignerInformationVerifier(cmsSignedData, signerId, usePublicKey, expectedSignerCertificate);
            if (signaturInformationVerifier == null) {
                throw new OperatorCreationException("failed to create SignatureInformationVerifier");
            }
            return signaturInformationVerifier;
        };
    }

    public static ContentVerifierProvider createVerifierContentProvider(final X509CertificateHolder x509CertificateHolder, final boolean usePublicKeyOnly) {
        if (x509CertificateHolder == null) {
            return null;
        }
        return new ContentVerifierProvider(){

            public ContentVerifier get(AlgorithmIdentifier verifierAlgorithmIdentifier) throws OperatorCreationException {
                try {
                    return CMSUtils.createContentVerifier(x509CertificateHolder, usePublicKeyOnly, verifierAlgorithmIdentifier);
                }
                catch (CertificateException e) {
                    throw new OperatorCreationException("failed to create content verifier: " + e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    throw new OperatorCreationException("failed to create content verifier with unexpected exception: " + e.getMessage(), (Throwable)e);
                }
            }

            public X509CertificateHolder getAssociatedCertificate() {
                return x509CertificateHolder;
            }

            public boolean hasAssociatedCertificate() {
                return true;
            }
        };
    }

    public static List<X509CertificateHolder> getAllSignerCertificates(CMSSignedData cms) {
        if (cms == null) {
            return Collections.emptyList();
        }
        SignerInformationStore signerInfos = cms.getSignerInfos();
        if (signerInfos == null) {
            return Collections.emptyList();
        }
        Iterator iterator = signerInfos.iterator();
        if (!iterator.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<X509CertificateHolder> result = new ArrayList<X509CertificateHolder>();
        while (iterator.hasNext()) {
            X509CertificateHolder signerCertificate = CMSUtils.getSignerCertificate(cms, (SignerInformation)iterator.next());
            if (signerCertificate == null) continue;
            result.add(signerCertificate);
        }
        return result;
    }

    public static String getEncryptionAlgName(String encryptionAlgOID) {
        String algName = encryptionAlgs.get(encryptionAlgOID);
        if (algName != null) {
            return algName;
        }
        return encryptionAlgOID;
    }

    public static X509CertificateHolder getFirstCertificate(Collection<X509CertificateHolder> certificates) {
        if (certificates == null) {
            return null;
        }
        if (certificates.isEmpty()) {
            return null;
        }
        Iterator<X509CertificateHolder> iterator = certificates.iterator();
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return null;
        }
        try {
            return iterator.next();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static X509CertificateHolder getFirstSignerCertificate(CMSSignedData cms) {
        if (cms == null) {
            return null;
        }
        SignerInformationStore signerInfos = cms.getSignerInfos();
        if (signerInfos == null) {
            return null;
        }
        Iterator iterator = signerInfos.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        SignerInformation signerInformation = (SignerInformation)iterator.next();
        return CMSUtils.getSignerCertificate(cms, signerInformation);
    }

    public static String getJCESignatureName(SignerInformation signerInformation) {
        return new DefaultCMSSignatureAlgorithmNameGenerator().getSignatureName(signerInformation.getDigestAlgorithmID(), CMSUtils.getSignatureAlgorithmIdentifier(signerInformation));
    }

    private static AlgorithmIdentifier getSignatureAlgorithmIdentifier(SignerInformation signerInformation) {
        return new AlgorithmIdentifier(new ASN1ObjectIdentifier(signerInformation.getEncryptionAlgOID()), (ASN1Encodable)ASN1Sequence.getInstance((Object)signerInformation.getEncryptionAlgParams()));
    }

    public static int getSignatureCount(CMSSignedData cms) {
        if (cms == null) {
            return 0;
        }
        SignerInformationStore signerInfos = cms.getSignerInfos();
        if (signerInfos == null) {
            return 0;
        }
        return signerInfos.size();
    }

    public static X509CertificateHolder getSignerCertificate(CMSSignedData cms, SignerInformation signerInformation) {
        if (signerInformation == null) {
            return null;
        }
        Collection signerCertificates = cms.getCertificates().getMatches((Selector)signerInformation.getSID());
        if (signerCertificates.isEmpty()) {
            return null;
        }
        return CMSUtils.getFirstCertificate(signerCertificates);
    }

    public static SignerInformation getSignerInformation(CMSSignedData cmsSignedData, SignerId signerId) {
        return cmsSignedData.getSignerInfos().get(signerId);
    }

    public static boolean isEquivalent(AlgorithmIdentifier algId1, AlgorithmIdentifier algId2) {
        if (algId1 == null || algId2 == null) {
            return false;
        }
        if (!algId1.getAlgorithm().equals((ASN1Primitive)algId2.getAlgorithm())) {
            return false;
        }
        ASN1Encodable params1 = algId1.getParameters();
        ASN1Encodable params2 = algId2.getParameters();
        if (params1 != null) {
            return params1.equals(params2) || params1.equals(DERNull.INSTANCE) && params2 == null;
        }
        return params2 == null || params2.equals(DERNull.INSTANCE);
    }

    public static DigestInfo generateDTBSHash(SignerInformation signerInformation) throws NoSuchAlgorithmException, NoSuchProviderException, IOException {
        if (signerInformation == null) {
            return null;
        }
        MessageDigest messageDigest = MessageDigest.getInstance(signerInformation.getDigestAlgOID(), "BC");
        return new DigestInfo(signerInformation.getDigestAlgorithmID(), messageDigest.digest(signerInformation.getEncodedSignedAttributes()));
    }

    public static boolean isEquivalent(AlgorithmIdentifier algId1, ASN1ObjectIdentifier algObjectIdentifier) {
        if (algId1 == null || algObjectIdentifier == null) {
            return false;
        }
        return CMSUtils.isEquivalent(algId1, new AlgorithmIdentifier(algObjectIdentifier));
    }

    private CMSUtils() {
    }

    static {
        CMSUtils.addEntries(NISTObjectIdentifiers.dsa_with_sha224, DSA);
        CMSUtils.addEntries(NISTObjectIdentifiers.dsa_with_sha256, DSA);
        CMSUtils.addEntries(NISTObjectIdentifiers.dsa_with_sha384, DSA);
        CMSUtils.addEntries(NISTObjectIdentifiers.dsa_with_sha512, DSA);
        CMSUtils.addEntries(NISTObjectIdentifiers.id_dsa_with_sha3_224, DSA);
        CMSUtils.addEntries(NISTObjectIdentifiers.id_dsa_with_sha3_256, DSA);
        CMSUtils.addEntries(NISTObjectIdentifiers.id_dsa_with_sha3_384, DSA);
        CMSUtils.addEntries(NISTObjectIdentifiers.id_dsa_with_sha3_512, DSA);
        CMSUtils.addEntries(OIWObjectIdentifiers.dsaWithSHA1, DSA);
        CMSUtils.addEntries(OIWObjectIdentifiers.md4WithRSA, RSA);
        CMSUtils.addEntries(OIWObjectIdentifiers.md4WithRSAEncryption, RSA);
        CMSUtils.addEntries(OIWObjectIdentifiers.md5WithRSA, RSA);
        CMSUtils.addEntries(OIWObjectIdentifiers.sha1WithRSA, RSA);
        CMSUtils.addEntries(PKCSObjectIdentifiers.md2WithRSAEncryption, RSA);
        CMSUtils.addEntries(PKCSObjectIdentifiers.md4WithRSAEncryption, RSA);
        CMSUtils.addEntries(PKCSObjectIdentifiers.md5WithRSAEncryption, RSA);
        CMSUtils.addEntries(PKCSObjectIdentifiers.sha1WithRSAEncryption, RSA);
        CMSUtils.addEntries(PKCSObjectIdentifiers.sha224WithRSAEncryption, RSA);
        CMSUtils.addEntries(PKCSObjectIdentifiers.sha256WithRSAEncryption, RSA);
        CMSUtils.addEntries(PKCSObjectIdentifiers.sha384WithRSAEncryption, RSA);
        CMSUtils.addEntries(PKCSObjectIdentifiers.sha512WithRSAEncryption, RSA);
        CMSUtils.addEntries(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224, RSA);
        CMSUtils.addEntries(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256, RSA);
        CMSUtils.addEntries(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384, RSA);
        CMSUtils.addEntries(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512, RSA);
        CMSUtils.addEntries(X9ObjectIdentifiers.ecdsa_with_SHA1, ECDSA);
        CMSUtils.addEntries(X9ObjectIdentifiers.ecdsa_with_SHA224, ECDSA);
        CMSUtils.addEntries(X9ObjectIdentifiers.ecdsa_with_SHA256, ECDSA);
        CMSUtils.addEntries(X9ObjectIdentifiers.ecdsa_with_SHA384, ECDSA);
        CMSUtils.addEntries(X9ObjectIdentifiers.ecdsa_with_SHA512, ECDSA);
        CMSUtils.addEntries(NISTObjectIdentifiers.id_ecdsa_with_sha3_224, ECDSA);
        CMSUtils.addEntries(NISTObjectIdentifiers.id_ecdsa_with_sha3_256, ECDSA);
        CMSUtils.addEntries(NISTObjectIdentifiers.id_ecdsa_with_sha3_384, ECDSA);
        CMSUtils.addEntries(NISTObjectIdentifiers.id_ecdsa_with_sha3_512, ECDSA);
        CMSUtils.addEntries(X9ObjectIdentifiers.id_dsa_with_sha1, DSA);
        CMSUtils.addEntries(EACObjectIdentifiers.id_TA_ECDSA_SHA_1, ECDSA);
        CMSUtils.addEntries(EACObjectIdentifiers.id_TA_ECDSA_SHA_224, ECDSA);
        CMSUtils.addEntries(EACObjectIdentifiers.id_TA_ECDSA_SHA_256, ECDSA);
        CMSUtils.addEntries(EACObjectIdentifiers.id_TA_ECDSA_SHA_384, ECDSA);
        CMSUtils.addEntries(EACObjectIdentifiers.id_TA_ECDSA_SHA_512, ECDSA);
        CMSUtils.addEntries(EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_1, RSA);
        CMSUtils.addEntries(EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_256, RSA);
        CMSUtils.addEntries(EACObjectIdentifiers.id_TA_RSA_PSS_SHA_1, RS_AAND_MGF1);
        CMSUtils.addEntries(EACObjectIdentifiers.id_TA_RSA_PSS_SHA_256, RS_AAND_MGF1);
        CMSUtils.addEntries(X9ObjectIdentifiers.id_dsa, DSA);
        CMSUtils.addEntries(PKCSObjectIdentifiers.rsaEncryption, RSA);
        CMSUtils.addEntries(TeleTrusTObjectIdentifiers.teleTrusTRSAsignatureAlgorithm, RSA);
        CMSUtils.addEntries(X509ObjectIdentifiers.id_ea_rsa, RSA);
        CMSUtils.addEntries(PKCSObjectIdentifiers.id_RSASSA_PSS, RS_AAND_MGF1);
        CMSUtils.addEntries(CryptoProObjectIdentifiers.gostR3410_94, GOST3410);
        CMSUtils.addEntries(CryptoProObjectIdentifiers.gostR3410_2001, ECGOST3410);
        CMSUtils.addEntries(new ASN1ObjectIdentifier("1.3.6.1.4.1.5849.1.6.2"), ECGOST3410);
        CMSUtils.addEntries(new ASN1ObjectIdentifier("1.3.6.1.4.1.5849.1.1.5"), GOST3410);
        CMSUtils.addEntries(RosstandartObjectIdentifiers.id_tc26_gost_3410_12_256, ECGOST3410_2012_256);
        CMSUtils.addEntries(RosstandartObjectIdentifiers.id_tc26_gost_3410_12_512, ECGOST3410_2012_512);
        CMSUtils.addEntries(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001, ECGOST3410);
        CMSUtils.addEntries(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94, GOST3410);
        CMSUtils.addEntries(RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_256, ECGOST3410_2012_256);
        CMSUtils.addEntries(RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_512, ECGOST3410_2012_512);
    }
}

