/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.base.validators.signature.cms;

import de.governikus.base.validators.signature.cms.CMSUtils;
import de.governikus.base.validators.signature.core.SignatureValidatorResult;
import de.governikus.base.validators.signature.core.SignatureValidatorUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformationVerifierProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CMSSignatureValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CMSSignatureValidator.class);

    public static SignatureValidatorResult validateCmsSignature(byte[] cms, byte[] data) {
        return CMSSignatureValidator.validateCmsSignature(cms, data, true, null);
    }

    public static SignatureValidatorResult validateCmsSignature(byte[] cms, byte[] data, boolean usePublicKey) {
        return CMSSignatureValidator.validateCmsSignature(cms, data, usePublicKey, null);
    }

    public static SignatureValidatorResult validateCmsSignature(byte[] cms, byte[] data, boolean usePublicKey, X509Certificate expectedSignerCertificate) {
        if (cms == null || cms.length == 0) {
            return SignatureValidatorResult.ERROR;
        }
        return CMSSignatureValidator.validateCmsSignature((InputStream)new ByteArrayInputStream(cms), (InputStream)(data == null || data.length == 0 ? null : new ByteArrayInputStream(data)), usePublicKey, expectedSignerCertificate);
    }

    public static SignatureValidatorResult validateCmsSignature(byte[] cms, byte[] data, X509Certificate expectedSignerCertificate) {
        return CMSSignatureValidator.validateCmsSignature(cms, data, true);
    }

    public static SignatureValidatorResult validateCmsSignature(byte[] cms, InputStream dataStream) {
        return CMSSignatureValidator.validateCmsSignature(cms, dataStream, true, null);
    }

    public static SignatureValidatorResult validateCmsSignature(byte[] cms, InputStream dataStream, boolean usePublicKey) {
        return CMSSignatureValidator.validateCmsSignature(cms, dataStream, usePublicKey, null);
    }

    public static SignatureValidatorResult validateCmsSignature(byte[] cms, InputStream dataStream, boolean usePublicKey, X509Certificate expectedSignerCertificate) {
        if (cms == null || cms.length == 0) {
            return SignatureValidatorResult.ERROR;
        }
        return CMSSignatureValidator.validateCmsSignature((InputStream)new ByteArrayInputStream(cms), dataStream, usePublicKey, expectedSignerCertificate);
    }

    public static SignatureValidatorResult validateCmsSignature(byte[] cms, InputStream dataStream, X509Certificate expectedSignerCertificate) {
        return CMSSignatureValidator.validateCmsSignature(cms, dataStream, true, expectedSignerCertificate);
    }

    public static SignatureValidatorResult validateCmsSignature(CMSSignedData cms) {
        return CMSSignatureValidator.validateCmsSignature(cms, true, null);
    }

    public static SignatureValidatorResult validateCmsSignature(CMSSignedData cms, boolean usePublicKey) {
        return CMSSignatureValidator.validateCmsSignature(cms, usePublicKey, null);
    }

    public static SignatureValidatorResult validateCmsSignature(CMSSignedData cms, boolean usePublicKey, X509Certificate expectedSignerCertificate) {
        SignerInformationVerifierProvider signerInformationVerifierProvider;
        if (cms == null) {
            return SignatureValidatorResult.ERROR;
        }
        try {
            signerInformationVerifierProvider = CMSUtils.createSignerInformationVerifierProvider(cms, usePublicKey, expectedSignerCertificate);
        }
        catch (Exception e) {
            return SignatureValidatorResult.ERROR;
        }
        return CMSSignatureValidator.validateCmsSignatureBase(cms, signerInformationVerifierProvider);
    }

    public static SignatureValidatorResult validateCmsSignature(CMSSignedData cms, X509Certificate expectedSignerCertificate) {
        return CMSSignatureValidator.validateCmsSignature(cms, true, expectedSignerCertificate);
    }

    public static SignatureValidatorResult validateCmsSignature(InputStream cmsStream, byte[] data) {
        return CMSSignatureValidator.validateCmsSignature(cmsStream, data, true, null);
    }

    public static SignatureValidatorResult validateCmsSignature(InputStream cmsStream, byte[] data, boolean usePublicKey) {
        return CMSSignatureValidator.validateCmsSignature(cmsStream, (InputStream)(data == null || data.length == 0 ? null : new ByteArrayInputStream(data)), usePublicKey, null);
    }

    public static SignatureValidatorResult validateCmsSignature(InputStream cmsStream, byte[] data, boolean usePublicKey, X509Certificate expectedSignerCertificate) {
        return CMSSignatureValidator.validateCmsSignature(cmsStream, (InputStream)(data == null || data.length == 0 ? null : new ByteArrayInputStream(data)), usePublicKey, expectedSignerCertificate);
    }

    public static SignatureValidatorResult validateCmsSignature(InputStream cmsStream, byte[] data, X509Certificate expectedSignerCertificate) {
        return CMSSignatureValidator.validateCmsSignature(cmsStream, data, true, expectedSignerCertificate);
    }

    public static SignatureValidatorResult validateCmsSignature(InputStream cmsStream, InputStream dataStream) {
        return CMSSignatureValidator.validateCmsSignature(cmsStream, dataStream, true, null);
    }

    public static SignatureValidatorResult validateCmsSignature(InputStream cmsStream, InputStream dataStream, boolean usePublicKey) {
        return CMSSignatureValidator.validateCmsSignature(cmsStream, dataStream, usePublicKey, null);
    }

    public static SignatureValidatorResult validateCmsSignature(InputStream cmsStream, InputStream dataStream, boolean usePublicKey, X509Certificate expectedSignerCertificate) {
        CMSSignedData cms;
        block24: {
            if (cmsStream == null) {
                return SignatureValidatorResult.ERROR;
            }
            cms = null;
            if (dataStream == null) {
                try (InputStream is = cmsStream;){
                    cms = new CMSSignedData(cmsStream);
                    break block24;
                }
                catch (Exception e) {
                    return SignatureValidatorResult.ERROR;
                }
            }
            try (InputStream is = cmsStream;
                 InputStream dis = dataStream;){
                cms = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(IOUtils.toByteArray((InputStream)dis)), IOUtils.toByteArray((InputStream)is));
            }
            catch (Exception e) {
                return SignatureValidatorResult.ERROR;
            }
        }
        return CMSSignatureValidator.validateCmsSignature(cms, usePublicKey, expectedSignerCertificate);
    }

    public static SignatureValidatorResult validateCmsSignature(InputStream cmsStream, InputStream dataStream, X509Certificate expectedSignerCertificate) {
        return CMSSignatureValidator.validateCmsSignature(cmsStream, dataStream, true, expectedSignerCertificate);
    }

    private static SignatureValidatorResult validateCmsSignatureBase(CMSSignedData cms, SignerInformationVerifierProvider signerInformationVerifierProvider) {
        if (cms == null) {
            return SignatureValidatorResult.ERROR;
        }
        if (signerInformationVerifierProvider == null) {
            return SignatureValidatorResult.ERROR;
        }
        try {
            SignatureValidatorUtils.registerBC();
            return cms.verifySignatures(signerInformationVerifierProvider) ? SignatureValidatorResult.VALID : SignatureValidatorResult.INVALID;
        }
        catch (CMSException e) {
            LOGGER.info(e.getMessage());
            return SignatureValidatorResult.INVALID;
        }
        catch (Exception exception) {
            return SignatureValidatorResult.ERROR;
        }
    }

    public static SignatureValidatorResult validateCmsSignatureDigest(byte[] cms, byte[] digestValue) {
        return CMSSignatureValidator.validateCmsSignatureDigest(cms, digestValue, true, null);
    }

    public static SignatureValidatorResult validateCmsSignatureDigest(byte[] cms, byte[] digestValue, boolean usePublicKey) {
        return CMSSignatureValidator.validateCmsSignatureDigest(cms, digestValue, usePublicKey, null);
    }

    public static SignatureValidatorResult validateCmsSignatureDigest(byte[] cms, byte[] digestValue, boolean usePublicKey, X509Certificate expectedSignerCertificate) {
        SignatureValidatorResult signatureValidatorResult;
        if (cms == null || cms.length == 0) {
            return SignatureValidatorResult.ERROR;
        }
        if (digestValue == null || digestValue.length == 0) {
            return SignatureValidatorResult.ERROR;
        }
        ByteArrayInputStream cmsStream = new ByteArrayInputStream(cms);
        try {
            signatureValidatorResult = CMSSignatureValidator.validateCmsSignatureDigest(cmsStream, digestValue, usePublicKey, expectedSignerCertificate);
        }
        catch (Throwable throwable) {
            try {
                try {
                    cmsStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return SignatureValidatorResult.ERROR;
            }
        }
        cmsStream.close();
        return signatureValidatorResult;
    }

    public static SignatureValidatorResult validateCmsSignatureDigest(byte[] cms, byte[] digestValue, X509Certificate expectedSignerCertificate) {
        return CMSSignatureValidator.validateCmsSignatureDigest(cms, digestValue, true, expectedSignerCertificate);
    }

    public static SignatureValidatorResult validateCmsSignatureDigest(CMSSignedData cms, byte[] digestValue, boolean usePublicKey, X509Certificate expectedSignerCertificate) {
        SignerInformationVerifierProvider signatureInformationVerifierProvider;
        if (cms == null) {
            return SignatureValidatorResult.ERROR;
        }
        if (digestValue == null || digestValue.length == 0) {
            return SignatureValidatorResult.ERROR;
        }
        try {
            signatureInformationVerifierProvider = CMSUtils.createFixedDigestSignerInformationVerifierProvider(cms, digestValue, usePublicKey, expectedSignerCertificate);
        }
        catch (Exception e) {
            return SignatureValidatorResult.ERROR;
        }
        return CMSSignatureValidator.validateCmsSignatureBase(cms, signatureInformationVerifierProvider);
    }

    public static SignatureValidatorResult validateCmsSignatureDigest(InputStream cmsStream, byte[] digestValue) {
        return CMSSignatureValidator.validateCmsSignatureDigest(cmsStream, digestValue, true, null);
    }

    public static SignatureValidatorResult validateCmsSignatureDigest(InputStream cmsStream, byte[] digestValue, boolean usePublicKey) {
        return CMSSignatureValidator.validateCmsSignatureDigest(cmsStream, digestValue, usePublicKey, null);
    }

    public static SignatureValidatorResult validateCmsSignatureDigest(InputStream cmsStream, byte[] digestValue, boolean usePublicKey, X509Certificate expectedSignerCertificate) {
        if (cmsStream == null) {
            return SignatureValidatorResult.ERROR;
        }
        if (digestValue == null || digestValue.length == 0) {
            return SignatureValidatorResult.ERROR;
        }
        CMSSignedData cms = null;
        try (InputStream is = cmsStream;){
            cms = new CMSSignedData(cmsStream);
        }
        catch (Exception e) {
            return SignatureValidatorResult.ERROR;
        }
        return CMSSignatureValidator.validateCmsSignatureDigest(cms, digestValue, usePublicKey, expectedSignerCertificate);
    }

    public static SignatureValidatorResult validateCmsSignatureDigest(InputStream cmsStream, byte[] digestValue, X509Certificate expectedSignerCertificate) {
        return CMSSignatureValidator.validateCmsSignatureDigest(cmsStream, digestValue, true, expectedSignerCertificate);
    }

    private CMSSignatureValidator() {
    }
}

