/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.template;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButtonUtil;
import de.bos_bremen.ecard.client.sign.control.process.impl.SignConfig;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.VisualPDFPanel;
import de.bos_bremen.ecard.client.sign.template.PopupMenu;
import de.bos_bremen.ecard.client.sign.template.SignatureFieldTemplate;
import de.bos_bremen.ecard.client.sign.template.SignatureFieldTemplateDialog;
import de.bos_bremen.ecard.client.sign.template.SignatureFieldTemplateList;
import de.bos_bremen.ecard.client.sign.template.SignatureFieldTemplateListener;
import de.bos_bremen.ecard.client.sign.template.TransparencyFilter;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignatureFieldTemplatePopupMenu
extends PopupMenu
implements SignatureFieldTemplateListener {
    private static final Logger LOG = LogManager.getLogger(SignatureFieldTemplatePopupMenu.class);
    private final SignConfig config;
    private final VisualPDFPanel parent;

    public SignatureFieldTemplatePopupMenu(VisualPDFPanel parent, JComponent invoker, SignConfig config) {
        super(invoker);
        this.parent = parent;
        this.config = config;
    }

    @Override
    public void init() {
        this.pMenu.removeAll();
        List<SignatureFieldTemplate> templates = SignatureFieldTemplateList.getInstance().getTemplates(this);
        for (SignatureFieldTemplate template : templates) {
            LoadAction load = new LoadAction(template);
            JMenuItem menuItem = load.createJMenuItem();
            this.pMenu.add(menuItem);
        }
        if (!templates.isEmpty()) {
            this.pMenu.addSeparator();
        }
        SaveAction save = new SaveAction();
        JMenuItem menuItem = save.createJMenuItem();
        menuItem.addChangeListener(save.createChangeListenerForMenuItem());
        this.pMenu.add(menuItem);
        AdministrateAction administrate = new AdministrateAction();
        menuItem = administrate.createJMenuItem();
        menuItem.addChangeListener(administrate.createChangeListenerForMenuItem());
        this.pMenu.add(menuItem);
    }

    @Override
    public void deleted(SignatureFieldTemplate template) {
        LOG.info("{}", (Object)template);
    }

    @Override
    public void loaded(SignatureFieldTemplate template) {
        if (template == null) {
            return;
        }
        LOG.info("template loaded: {}", (Object)template);
        template.fillSignConfigFromTemplate(this.config);
    }

    @Override
    public void stored(SignatureFieldTemplate template) {
        LOG.info("{}", (Object)template);
    }

    private class LoadAction
    extends AbstractTemplateAction {
        private static final long serialVersionUID = 1L;
        private final transient SignatureFieldTemplate template;

        public LoadAction(SignatureFieldTemplate t) {
            super(ActionKey.LOAD);
            this.template = t;
            String name = this.template.toString();
            name = name.replace(".signpdf_tmpl", "");
            this.putValue("Name", name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.template.load();
                SignatureFieldTemplatePopupMenu.this.parent.load();
            }
            catch (IOException ex) {
                LOG.error("", (Throwable)ex);
                String key = "config.dialog.visualpdf.visualisation.template.error.dialog.load";
                String message = Messages.getString((String)key);
                String templateName = this.template.toString();
                templateName = templateName.replace(".signpdf_tmpl", "");
                message = message.replace("NAME", templateName);
                JLabel messageLabel = (JLabel)ComponentUtils.makeFocusable((JComponent)new JLabel(message));
                key = "config.dialog.visualpdf.visualisation.template.error.dialog.title";
                String title = Messages.getString((String)key);
                JOptionPane.showMessageDialog(SignatureFieldTemplatePopupMenu.this.parent.getView(), messageLabel, title, 0);
            }
        }
    }

    private class SaveAction
    extends AbstractTemplateAction {
        private static final long serialVersionUID = 1L;

        public SaveAction() {
            super(ActionKey.SAVE);
            this.icon = IconButtonUtil.getPropertyIcon((String)this.resourceKey);
            this.rolloverIcon = IconButtonUtil.getRolloverIcon((String)this.resourceKey);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LOG.info("");
            String resourceKey = "config.dialog.visualpdf.visualisation.template.input.dialog.message";
            String message = Messages.getString((String)resourceKey);
            resourceKey = "config.dialog.visualpdf.visualisation.template.input.dialog.title";
            String title = Messages.getString((String)resourceKey);
            Object templateName = JOptionPane.showInputDialog(SignatureFieldTemplatePopupMenu.this.parent.getJFrame(), message, title, 3);
            if (templateName == null || ((String)templateName).isEmpty()) {
                return;
            }
            if (!((String)templateName).endsWith(".signpdf_tmpl")) {
                templateName = (String)templateName + ".signpdf_tmpl";
            }
            templateName = ((String)templateName).replaceAll("/", "_");
            String path = System.getProperty("BoreumConfigFolder", System.getProperty("user.home"));
            File projectDir = new File(path);
            File file = new File(projectDir, (String)templateName);
            if (file.exists()) {
                String key = "config.dialog.visualpdf.visualisation.template.replace.dialog.message";
                message = Messages.getString((String)key);
                message = message.replace("NAME", (CharSequence)templateName);
                key = "config.dialog.visualpdf.visualisation.template.replace.dialog.title";
                title = Messages.getString((String)key);
                int reply = JOptionPane.showConfirmDialog(SignatureFieldTemplatePopupMenu.this.parent.getView(), message, title, 0);
                if (reply != 0) {
                    return;
                }
            }
            SignatureFieldTemplate t = SignatureFieldTemplateList.getInstance().addTemplate(projectDir, (String)templateName);
            t.fillTemplateFromDialog(SignatureFieldTemplatePopupMenu.this.parent);
            try {
                t.store();
            }
            catch (Exception ex) {
                LOG.error("", (Throwable)ex);
                message = Messages.getString((String)"config.dialog.visualpdf.visualisation.template.error.dialog.save");
                message = message.replace("NAME", (CharSequence)templateName);
                JLabel messageLabel = (JLabel)ComponentUtils.makeFocusable((JComponent)new JLabel(message));
                JOptionPane.showMessageDialog(SignatureFieldTemplatePopupMenu.this.parent.getView(), messageLabel, Messages.getString((String)"config.dialog.visualpdf.visualisation.template.error.dialog.title"), 0);
            }
        }
    }

    private class AdministrateAction
    extends AbstractTemplateAction {
        private static final long serialVersionUID = 1L;

        public AdministrateAction() {
            super(ActionKey.ADMIN);
            this.icon = IconButtonUtil.getPropertyIcon((String)this.resourceKey);
            this.rolloverIcon = IconButtonUtil.getRolloverIcon((String)this.resourceKey);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SignatureFieldTemplateDialog dialog = new SignatureFieldTemplateDialog(SignatureFieldTemplatePopupMenu.this.parent.getJFrame());
            dialog.setVisible(true);
        }
    }

    private abstract class AbstractTemplateAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final ActionKey key;
        protected String resourceKey;
        protected ImageIcon icon;
        protected ImageIcon rolloverIcon;

        public AbstractTemplateAction(ActionKey actionKey) {
            this.key = actionKey;
            this.resourceKey = "config.dialog.visualpdf.visualisation.template." + this.key.name().toLowerCase();
            this.putValue("Name", Messages.getString((String)this.resourceKey));
            this.putValue("ShortDescription", Messages.getString((String)(this.resourceKey + ".tooltip")));
            this.putValue("SmallIcon", ComponentUtils.getIcon((String)this.resourceKey));
        }

        public JMenuItem createJMenuItem() {
            JMenuItem result = new JMenuItem(this);
            Icon i = (Icon)this.getValue("SmallIcon");
            if (i instanceof ImageIcon) {
                ImageIcon imageIcon = (ImageIcon)i;
                ImageIcon disabledIcon = TransparencyFilter.createDimmedImage(imageIcon);
                result.setDisabledIcon(disabledIcon);
            }
            return result;
        }

        public ChangeListener createChangeListenerForMenuItem() {
            return new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (AbstractTemplateAction.this.rolloverIcon == null) {
                        return;
                    }
                    Object object = e.getSource();
                    if (object instanceof JMenuItem) {
                        JMenuItem item = (JMenuItem)object;
                        if (item.isArmed()) {
                            item.setIcon(AbstractTemplateAction.this.rolloverIcon);
                        } else {
                            item.setIcon(AbstractTemplateAction.this.icon);
                        }
                    }
                }
            };
        }
    }

    private static enum ActionKey {
        LOAD,
        SAVE,
        ADMIN;

    }
}

