/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.template;

import de.bos_bremen.ecard.client.sign.template.SignatureFieldTemplate;
import de.bos_bremen.ecard.client.sign.template.SignatureFieldTemplateListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignatureFieldTemplateList {
    private static final Logger LOG = LogManager.getLogger(SignatureFieldTemplateList.class);
    private static SignatureFieldTemplateList instance;
    private final List<SignatureFieldTemplate> templates = new ArrayList<SignatureFieldTemplate>();
    private final EventListenerList listeners = new EventListenerList();

    private SignatureFieldTemplateList() {
        this.init();
    }

    public static SignatureFieldTemplateList getInstance() {
        if (instance == null) {
            instance = new SignatureFieldTemplateList();
        }
        return instance;
    }

    public List<SignatureFieldTemplate> getTemplates(SignatureFieldTemplateListener listener) {
        this.addTemplateListener(listener);
        return this.templates;
    }

    public SignatureFieldTemplate addTemplate(File dir, String name) {
        for (SignatureFieldTemplate template : this.templates) {
            if (!template.getName().equals(name)) continue;
            this.fireDeleted(template);
            break;
        }
        SignatureFieldTemplate template = new SignatureFieldTemplate(dir, name);
        this.templates.add(template);
        return template;
    }

    private void addTemplateListener(SignatureFieldTemplateListener listener) {
        this.listeners.add(SignatureFieldTemplateListener.class, listener);
    }

    public void removeTemplateListener(SignatureFieldTemplateListener listener) {
        this.listeners.remove(SignatureFieldTemplateListener.class, listener);
    }

    protected void fireLoaded(SignatureFieldTemplate template) {
        for (SignatureFieldTemplateListener listener : (SignatureFieldTemplateListener[])this.listeners.getListeners(SignatureFieldTemplateListener.class)) {
            listener.loaded(template);
        }
    }

    protected void fireStored(SignatureFieldTemplate template) {
        for (SignatureFieldTemplateListener listener : (SignatureFieldTemplateListener[])this.listeners.getListeners(SignatureFieldTemplateListener.class)) {
            listener.stored(template);
        }
    }

    protected void fireDeleted(SignatureFieldTemplate template) {
        if (!this.templates.contains(template)) {
            return;
        }
        this.templates.remove(template);
        for (SignatureFieldTemplateListener listener : (SignatureFieldTemplateListener[])this.listeners.getListeners(SignatureFieldTemplateListener.class)) {
            listener.deleted(template);
        }
    }

    private void init() {
        String path = System.getProperty("BoreumConfigFolder", System.getProperty("user.home"));
        File file = new File(path);
        if (!file.exists() && !file.mkdirs()) {
            LOG.warn("could not create temp folder: {}", (Object)file.getAbsolutePath());
            return;
        }
        File[] files = file.listFiles(SignatureFieldTemplate.fileFilter);
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            SignatureFieldTemplate template = new SignatureFieldTemplate(file, files[i].getName());
            this.templates.add(template);
        }
    }
}

