/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.template;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.gui.GUIUtils;
import de.bos_bremen.ecard.client.gui.SignerTheme;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButton;
import de.bos_bremen.ecard.client.gui.view.component.filechooser.FileChooserFactory;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.sign.template.SignatureFieldTemplate;
import de.bos_bremen.ecard.client.sign.template.SignatureFieldTemplateList;
import de.bos_bremen.ecard.client.sign.template.SignatureFieldTemplateListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignatureFieldTemplateDialog
extends JDialog
implements SignatureFieldTemplateListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger(SignatureFieldTemplateDialog.class);
    private static String lastSelectedFolder = "last_selected_folder";
    private IconButton buttonOk = null;
    private IconButton buttonCancel = null;
    private JList<SignatureFieldTemplate> list;
    private IconButton buttonDelete;
    private IconButton buttonExport;
    private final JFrame frame;
    private transient ActionListener cancelAction = e -> this.closeDialog();

    public SignatureFieldTemplateDialog(JFrame parent) {
        super((Frame)parent, true);
        this.frame = parent;
        this.setIconImage(Document.getInstance().getFrame().getIconImage());
        this.initComponents();
        boolean enabled = this.list.getSelectedIndex() != -1;
        this.buttonDelete.setEnabled(enabled);
        this.buttonExport.setEnabled(enabled);
        this.pack();
        this.setMinimumSize(GUIUtils.toCurrentDimension((int)350, (int)200));
        this.setResizable(true);
        this.setLocationRelativeTo(this.getParent());
    }

    private void initComponents() {
        JComponent content = (JComponent)this.getContentPane();
        content.setLayout(new BorderLayout(10, 10));
        try {
            this.setTitle(Messages.getString((String)"config.dialog.visualpdf.visualisation.template.admin.dialog.title"));
        }
        catch (Exception ex) {
            LOG.debug(ex.getMessage());
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (SignatureFieldTemplateDialog.this.buttonCancel != null) {
                    SignatureFieldTemplateDialog.this.buttonCancel.doClick(200);
                } else {
                    SignatureFieldTemplateDialog.this.closeDialog();
                }
            }
        });
        JComponent c = this.buildCenterPanel();
        if (c != null) {
            content.add((Component)c, "Center");
        }
        if ((c = this.buildControlPanel()) != null) {
            content.add((Component)c, "South");
        }
        this.pack();
        this.getRootPane().setDefaultButton((JButton)this.buttonOk);
        this.getRootPane().registerKeyboardAction(this.cancelAction, "Cancel Command", KeyStroke.getKeyStroke(27, 0, false), 2);
    }

    protected JComponent buildControlPanel() {
        String resourceKey = "config.dialog.visualpdf.visualisation.template.admin.dialog.button.cancel";
        this.buttonCancel = this.createCancelButton(resourceKey, this.cancelAction, false);
        IconButton[] miscellaneousButtons = this.createMiscellaneousButtons();
        JPanel p = new JPanel(new GridBagLayout());
        p.setBackground(SignerTheme.BOREUM_PETROL_MENU);
        p.setOpaque(true);
        int count = 0;
        int gridx = 0;
        for (IconButton b : miscellaneousButtons) {
            p.add((Component)b, new GridBagConstraints(gridx, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, gridx == 0 ? 10 : 5, 10, gridx + 1 == count ? 10 : 5), 0, 0));
            ++gridx;
        }
        if (this.buttonOk != null) {
            p.add((Component)this.buttonOk, new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, this.buttonCancel != null ? 13 : 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        }
        if (this.buttonCancel != null) {
            p.add((Component)this.buttonCancel, new GridBagConstraints(gridx, 0, 1, 1, 1.0, 0.0, this.buttonOk != null ? 17 : 10, 0, new Insets(10, 60, 10, 10), 0, 0));
        }
        return p;
    }

    protected JComponent buildCenterPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setBorder(new EmptyBorder(5, 15, 5, 5));
        DefaultListModel<SignatureFieldTemplate> model = new DefaultListModel<SignatureFieldTemplate>();
        List<SignatureFieldTemplate> templates = SignatureFieldTemplateList.getInstance().getTemplates(this);
        for (SignatureFieldTemplate template : templates) {
            model.addElement(template);
        }
        this.list = new JList();
        this.list.setModel(model);
        this.list.setCellRenderer(new TemplateListCellRenderer());
        this.list.setSelectionModel(new DefaultListSelectionModel());
        this.list.setSelectionMode(0);
        JScrollPane sp = new JScrollPane(this.list, 22, 31);
        sp.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.list.addListSelectionListener(e -> {
            if (this.buttonDelete == null || this.buttonExport == null) {
                return;
            }
            boolean enabled = this.list.getSelectedIndex() != -1;
            this.buttonDelete.setEnabled(enabled);
            this.buttonExport.setEnabled(enabled);
            SignatureFieldTemplate t = this.list.getSelectedValue();
            if (t == null) {
                return;
            }
        });
        this.list.setSelectedIndex(0);
        result.add((Component)sp, "Center");
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        result.add((Component)p, "South");
        return result;
    }

    private IconButton[] createMiscellaneousButtons() {
        this.buttonDelete = new IconButton("config.dialog.visualpdf.visualisation.template.delete");
        this.buttonDelete.addActionListener((ActionListener)new DeleteAction());
        InputMap inputMap = this.buttonDelete.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "deleteAction");
        inputMap = this.buttonDelete.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "deleteAction");
        ActionMap actionMap = this.buttonDelete.getActionMap();
        actionMap.put("deleteAction", new DeleteAction());
        IconButton buttonImport = new IconButton("config.dialog.visualpdf.visualisation.template.import");
        buttonImport.addActionListener((ActionListener)new ImportAction());
        inputMap = buttonImport.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "importAction");
        actionMap = buttonImport.getActionMap();
        actionMap.put("importAction", new ImportAction());
        this.buttonExport = new IconButton("config.dialog.visualpdf.visualisation.template.export");
        this.buttonExport.addActionListener((ActionListener)new ExportAction());
        inputMap = this.buttonExport.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "exportAction");
        actionMap = this.buttonExport.getActionMap();
        actionMap.put("exportAction", new ExportAction());
        return new IconButton[]{buttonImport, this.buttonExport, this.buttonDelete};
    }

    private String getLastSelectedFolder() {
        String result = this.getPreferences().get(lastSelectedFolder, null);
        if (result != null) {
            return result;
        }
        return System.getProperty("user.home");
    }

    private void storeSelecedFolder(String folder) {
        this.getPreferences().put(lastSelectedFolder, folder);
    }

    private Preferences getPreferences() {
        Preferences prefs = Preferences.userRoot().node("de");
        prefs = prefs.node("governikus");
        prefs = prefs.node("boreum");
        prefs = prefs.node("template");
        return prefs;
    }

    private IconButton createCancelButton(String key, ActionListener action, boolean defaultCapable) {
        this.buttonCancel = new IconButton(key);
        this.buttonCancel.addActionListener(action);
        InputMap inputMap = this.buttonCancel.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancelAction");
        inputMap = this.buttonCancel.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "cancelAction");
        ActionMap actionMap = this.buttonCancel.getActionMap();
        actionMap.put("cancelAction", new CancelAction());
        this.buttonCancel.setDefaultCapable(defaultCapable);
        return this.buttonCancel;
    }

    private void closeDialog() {
        if (!this.getRootPane().isEnabled()) {
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void loaded(SignatureFieldTemplate template) {
        LOG.info("");
    }

    @Override
    public void stored(SignatureFieldTemplate template) {
        LOG.info("");
    }

    @Override
    public void deleted(SignatureFieldTemplate template) {
        LOG.info("");
    }

    public static class TemplateListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof SignatureFieldTemplate) {
                SignatureFieldTemplate template = (SignatureFieldTemplate)value;
                String result = template.toString();
                int endIndex = result.indexOf(".signpdf_tmpl");
                if (endIndex != -1) {
                    result = result.substring(0, endIndex);
                }
                this.setText("<html>" + result + "</html>");
            }
            return this;
        }
    }

    private class DeleteAction
    extends AbstractAction
    implements ActionListener {
        private static final long serialVersionUID = 1L;

        private DeleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int index = SignatureFieldTemplateDialog.this.list.getSelectedIndex();
            if (index == -1) {
                return;
            }
            SignatureFieldTemplate template = SignatureFieldTemplateDialog.this.list.getSelectedValue();
            String templateName = template.toString();
            String message = Messages.getString((String)"config.dialog.visualpdf.visualisation.template.delete.dialog.message");
            message = message.replace("NAME", templateName);
            JLabel messageLabel = new JLabel(message);
            messageLabel.setFocusable(true);
            messageLabel.addFocusListener(ComponentUtils.createFocusListenerFor((JLabel)messageLabel));
            String title = Messages.getString((String)"config.dialog.visualpdf.visualisation.template.question.dialog.title");
            int reply = JOptionPane.showConfirmDialog(SignatureFieldTemplateDialog.this.frame, messageLabel, title, 0);
            if (reply != 0) {
                return;
            }
            template.delete();
            ListModel<SignatureFieldTemplate> model = SignatureFieldTemplateDialog.this.list.getModel();
            ((DefaultListModel)model).remove(index);
        }
    }

    private class ImportAction
    extends AbstractAction
    implements ActionListener {
        private static final long serialVersionUID = 1L;

        private ImportAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            boolean success;
            LOG.info("import");
            File file = this.getImportFile();
            if (file == null) {
                return;
            }
            String path = System.getProperty("BoreumConfigFolder", System.getProperty("user.home"));
            File projectBox = new File(path);
            File target = new File(projectBox, file.getName());
            boolean exists = target.exists();
            if (exists) {
                String title;
                String message = Messages.getString((String)"config.dialog.visualpdf.visualisation.template.replace.dialog.message");
                int reply = JOptionPane.showConfirmDialog(SignatureFieldTemplateDialog.this.frame, message = message.replace("NAME", target.getName()), title = Messages.getString((String)"config.dialog.visualpdf.visualisation.template.error.dialog.title"), 0);
                if (reply != 0) {
                    return;
                }
            }
            if (!(success = Utils.copyFile((File)file, (File)target, (boolean)true))) {
                String message = Messages.getString((String)"config.dialog.visualpdf.visualisation.template.error.dialog.import");
                String templateName = file.getName();
                templateName = templateName.replace(".signpdf_tmpl", "");
                message = message.replace("NAME", templateName);
                JLabel messageLabel = (JLabel)ComponentUtils.makeFocusable((JComponent)new JLabel(message));
                String title = Messages.getString((String)"config.dialog.visualpdf.visualisation.template.error.dialog.title");
                JOptionPane.showMessageDialog(SignatureFieldTemplateDialog.this.frame, messageLabel, title, 0);
                return;
            }
            SignatureFieldTemplate t = SignatureFieldTemplateList.getInstance().addTemplate(projectBox, file.getName());
            try {
                t.load();
            }
            catch (IOException ex) {
                LOG.error("", (Throwable)ex);
                String message = Messages.getString((String)"config.dialog.visualpdf.visualisation.template.error.dialog.import");
                String templateName = file.getName();
                templateName = templateName.replace(".signpdf_tmpl", "");
                message = message.replace("NAME", templateName);
                JLabel messageLabel = (JLabel)ComponentUtils.makeFocusable((JComponent)new JLabel(message));
                String title = Messages.getString((String)"config.dialog.visualpdf.visualisation.template.error.dialog.title");
                JOptionPane.showMessageDialog(SignatureFieldTemplateDialog.this.frame, messageLabel, title, 0);
                t.delete();
                return;
            }
            if (exists) {
                return;
            }
            ListModel<SignatureFieldTemplate> model = SignatureFieldTemplateDialog.this.list.getModel();
            ((DefaultListModel)model).addElement(t);
        }

        private File getImportFile() {
            JFileChooser fileChooser = FileChooserFactory.defaultFileChooser();
            fileChooser.setPreferredSize(GUIUtils.createRelativeToParent((Dimension)Document.getInstance().getFrame().getMinimumSize()));
            fileChooser.setDialogTitle(Messages.getString((String)"config.dialog.visualpdf.visualisation.template.fileChooser.import.title"));
            fileChooser.setFileSelectionMode(0);
            fileChooser.setCurrentDirectory(new File(SignatureFieldTemplateDialog.this.getLastSelectedFolder()));
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setFileFilter(SignatureFieldTemplate.fileFilter);
            int status = fileChooser.showOpenDialog(SignatureFieldTemplateDialog.this.frame);
            if (status != 0) {
                return null;
            }
            File file = fileChooser.getSelectedFile();
            if (file == null) {
                LOG.info("File null");
            } else {
                LOG.info("File : {}", (Object)file.getAbsolutePath());
            }
            if (file == null) {
                return null;
            }
            if (!file.canRead()) {
                LOG.error("FILE_WRITE_PERMISSION_DENIED");
                return null;
            }
            SignatureFieldTemplateDialog.this.storeSelecedFolder(file.getParent());
            return file;
        }
    }

    private class ExportAction
    extends AbstractAction
    implements ActionListener {
        private static final long serialVersionUID = 1L;

        private ExportAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            boolean success;
            LOG.info("export");
            int index = SignatureFieldTemplateDialog.this.list.getSelectedIndex();
            if (index == -1) {
                return;
            }
            File saveFolder = this.getExportFolder();
            if (saveFolder == null) {
                return;
            }
            SignatureFieldTemplate template = SignatureFieldTemplateDialog.this.list.getSelectedValue();
            File file = new File(saveFolder, template.getName());
            if (file.exists()) {
                String title;
                String message = Messages.getString((String)"config.dialog.visualpdf.visualisation.template.replace.dialog.message");
                int reply = JOptionPane.showConfirmDialog(SignatureFieldTemplateDialog.this.frame, message = message.replace("NAME", file.getName()), title = Messages.getString((String)"config.dialog.visualpdf.visualisation.template.error.dialog.title"), 0);
                if (reply != 0) {
                    return;
                }
            }
            if (success = Utils.copyFile((File)template.asFile(), (File)file, (boolean)true)) {
                return;
            }
            String message = Messages.getString((String)"config.dialog.visualpdf.visualisation.template.error.dialog.export");
            String templateName = template.toString();
            templateName = templateName.replace(".signpdf_tmpl", "");
            message = message.replace("NAME", templateName);
            JLabel messageLabel = (JLabel)ComponentUtils.makeFocusable((JComponent)new JLabel(message));
            String title = Messages.getString((String)"config.dialog.visualpdf.visualisation.template.error.dialog.title");
            JOptionPane.showMessageDialog(SignatureFieldTemplateDialog.this.frame, messageLabel, title, 0);
        }

        private File getExportFolder() {
            JFileChooser fileChooser = FileChooserFactory.defaultFileChooser();
            fileChooser.setPreferredSize(GUIUtils.createRelativeToParent((Dimension)Document.getInstance().getFrame().getMinimumSize()));
            fileChooser.setDialogTitle(Messages.getString((String)"config.dialog.visualpdf.visualisation.template.fileChooser.export.title"));
            fileChooser.setFileSelectionMode(1);
            fileChooser.setCurrentDirectory(new File(SignatureFieldTemplateDialog.this.getLastSelectedFolder()));
            fileChooser.setMultiSelectionEnabled(false);
            int status = fileChooser.showSaveDialog(SignatureFieldTemplateDialog.this.frame);
            if (status != 0) {
                return null;
            }
            File folder = fileChooser.getSelectedFile();
            if (folder == null) {
                LOG.info("Directory null");
            } else {
                LOG.info("Directory : {}", (Object)folder.getAbsolutePath());
            }
            if (folder == null) {
                return null;
            }
            if (!folder.exists() && !folder.mkdirs()) {
                LOG.error("FILE_WRITE_PERMISSION_DENIED");
                return null;
            }
            SignatureFieldTemplateDialog.this.storeSelecedFolder(folder.getAbsolutePath());
            return folder;
        }
    }

    private class CancelAction
    extends AbstractAction
    implements ActionListener {
        private static final long serialVersionUID = 1L;

        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SignatureFieldTemplateDialog.this.closeDialog();
        }
    }
}

