/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.template;

import de.bos_bremen.ecard.client.CommonsUrlConnector;
import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.control.step.Step;
import de.bos_bremen.ecard.client.sign.control.process.impl.SignConfig;
import de.bos_bremen.ecard.client.sign.control.step.Sign;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.VisualPDFPanel;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature.PDFVisualisationTypEnum;
import de.bos_bremen.ecard.client.sign.template.SignatureFieldTemplateFileFilter;
import de.bos_bremen.ecard.client.sign.template.SignatureFieldTemplateList;
import de.governikus.csl.pdf.sign.PDFVisualSignatureDetails;
import de.governikus.csl.pdf.sign.TextColor;
import de.governikus.csl.pdf.sign.TextFormatting;
import de.governikus.csl.pdf.sign.VisibleSignatureLayout;
import de.governikus.csl.pdf.sign.impl.PDFVisualSignatureDetailsImpl;
import de.governikus.csl.pdf.sign.impl.visual.FontEnum;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignatureFieldTemplate {
    public static final String SUFFIX = ".signpdf_tmpl";
    private static final Logger LOG = LogManager.getLogger(SignatureFieldTemplate.class);
    private String name;
    private final File dir;
    private final Properties properties;
    static final SignatureFieldTemplateFileFilter fileFilter = new SignatureFieldTemplateFileFilter();
    public static final String IMAGE_RATIO = "imageRatio";
    public static final String PAGE = "page";
    public static final String TEXT_FORMATTING = "textFormatting";
    public static final String SIGNATURE_ISSUER = "signatureIssuer";
    public static final String TEXT_FONT = "textFont";
    public static final String VISIBLE_SIGNATURE_LAYOUT = "visibleSignatureLayout";
    public static final String USE_DYNAMIC_PDF_SIGNATURE = "useDynamicPdfSignature";
    public static final String USE_SIGNATURE_ISSUER = "useSignatureIssuer";
    public static final String POSITION_X = "positionX";
    public static final String POSITION_Y = "positionY";
    public static final String VISUAL_WIDTH = "visualWidth";
    public static final String VISUAL_HEIGHT = "visualHeight";
    public static final String USE_DYNAMICE_TEXTSIZE = "useDynamicTextSize";
    public static final String IMAGE_FILE = "imagefile";
    public static final String USE_DATE = "useDate";
    public static final String DATE_FORMAT = "dateFormat";
    public static final String PDF_COMATIBILITY = "pdfACompatibility";
    public static final String VISUALISATION_TYP = "visualisationTyp";
    public static final String TEXT_SIZE = "textSize";
    public static final String TEXT_COLOR = "textColor";
    public static final String CREATE_SIGNATURE_FIELD = "createSignatureField";

    public SignatureFieldTemplate(File file, String value) {
        this.dir = file;
        if (this.dir != null && !this.dir.exists() && !this.dir.mkdirs()) {
            LOG.debug("could not create folder: {}", (Object)this.dir);
        }
        this.name = value;
        this.properties = new Properties();
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDummy() {
        return this.properties.isEmpty();
    }

    public void load() throws IOException {
        if (this.name == null || this.dir == null) {
            return;
        }
        File file = new File(this.dir, this.name);
        try (FileInputStream is = new FileInputStream(file);){
            this.properties.load(is);
            SignatureFieldTemplateList.getInstance().fireLoaded(this);
        }
    }

    public void store() {
        if (this.name == null) {
            return;
        }
        File file = new File(this.dir, this.name);
        try (FileOutputStream os = new FileOutputStream(file);){
            this.properties.store(os, null);
            SignatureFieldTemplateList.getInstance().fireStored(this);
        }
        catch (IOException ex) {
            LOG.error("", (Throwable)ex);
        }
    }

    public void delete() {
        if (this.name == null) {
            return;
        }
        File file = new File(this.dir, this.name);
        try {
            Files.delete(file.toPath());
            SignatureFieldTemplateList.getInstance().fireDeleted(this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public File asFile() {
        if (this.name == null) {
            return null;
        }
        return new File(this.dir, this.name);
    }

    public void fillTemplateFromDialog(VisualPDFPanel dialog) {
        this.properties.putAll((Map<?, ?>)dialog.getProperties());
    }

    public void fillTemplateFromSignConfig(SignConfig config) {
        if (config == null) {
            return;
        }
        LOG.info("");
        this.properties.setProperty(IMAGE_RATIO, "" + config.getPdfSignatureExtentionImageRatio());
        this.properties.setProperty(PAGE, "" + config.getPdfSignatureExtentionPage());
        this.properties.setProperty(TEXT_FORMATTING, config.getPdfSignatureExtentionTextFormatting().name());
        this.properties.setProperty(SIGNATURE_ISSUER, config.getPdfSignatureExtentionSignatureIssuer());
        this.properties.setProperty(TEXT_FONT, config.getPdfSignatureExtentionFont().name());
        this.properties.setProperty(VISIBLE_SIGNATURE_LAYOUT, config.getPdfSignatureExtentionVisibleSignatureLayout() != null ? config.getPdfSignatureExtentionVisibleSignatureLayout().name() : "ImageLeft");
        this.properties.setProperty(USE_DYNAMIC_PDF_SIGNATURE, "" + config.visibleSignatureField());
        this.properties.setProperty(USE_SIGNATURE_ISSUER, "" + config.useSignatureIssuer());
        this.properties.setProperty(VISUAL_HEIGHT, "" + config.getPdfSignatureExtentionVisualHeight());
        this.properties.setProperty(VISUAL_WIDTH, "" + config.getPdfSignatureExtentionVisualWidth());
        this.properties.setProperty(USE_DYNAMICE_TEXTSIZE, "" + config.useDynamicTextSize());
        this.properties.setProperty(POSITION_Y, "" + config.getPdfSignatureExtentionPositionY());
        this.properties.setProperty(POSITION_X, "" + config.getPdfSignatureExtentionPositionX());
        this.properties.setProperty(USE_DATE, "" + config.useDate());
        this.properties.setProperty(DATE_FORMAT, config.getPdfSignatureExtentionDateFormat());
        this.properties.setProperty(PDF_COMATIBILITY, "" + config.getPdfSignatureExtentionPdfACompatibility());
        this.properties.setProperty(VISUALISATION_TYP, config.getPdfSignatureExtentionVisualisationTyp().name());
        this.properties.setProperty(TEXT_SIZE, "" + config.getPdfSignatureExtentionFontSize());
        this.properties.setProperty(TEXT_COLOR, config.getPdfSignatureExtentionTextColor().name());
        this.properties.setProperty(IMAGE_FILE, config.getPdfSignatureExtentionImageFile());
        this.properties.setProperty(CREATE_SIGNATURE_FIELD, "" + config.createSignatureField());
    }

    public void fillSignConfigFromTemplate(SignConfig config) {
        if (config == null) {
            return;
        }
        LOG.info("");
        String value = this.properties.getProperty(IMAGE_RATIO, "0.25");
        config.setPdfSignatureExtentionImageRatio(Double.valueOf(value));
        value = this.properties.getProperty(PAGE, "1");
        config.setPdfSignatureExtentionPage(Integer.parseInt(value));
        value = this.properties.getProperty(TEXT_FORMATTING, "center");
        config.setPdfSignatureExtentionTextFormatting(TextFormatting.valueOf((String)value));
        value = this.properties.getProperty(SIGNATURE_ISSUER, "");
        config.setPdfSignatureExtentionSignatureIssuer(value);
        value = this.properties.getProperty(TEXT_FONT, "TIMES");
        config.setPdfSignatureExtentionFont(FontEnum.valueOf((String)value));
        value = this.properties.getProperty(VISIBLE_SIGNATURE_LAYOUT, "ImageLeft");
        config.setPdfSignatureExtentionVisibleSignatureLayout(VisibleSignatureLayout.valueOf((String)value));
        value = this.properties.getProperty(USE_DYNAMIC_PDF_SIGNATURE, "true");
        config.setUseDynamicPdfSignatureExtention(Boolean.valueOf(value));
        value = this.properties.getProperty(USE_SIGNATURE_ISSUER, "");
        config.useSignatureIssuer(Boolean.valueOf(value));
        value = this.properties.getProperty(VISUAL_HEIGHT, "3.0");
        config.setPdfSignatureExtentionVisualHeight(Double.valueOf(value));
        value = this.properties.getProperty(VISUAL_WIDTH, "8.0");
        config.setPdfSignatureExtentionVisualWidth(Double.valueOf(value));
        value = this.properties.getProperty(USE_DYNAMICE_TEXTSIZE, "true");
        config.useDynamicTextSize(Boolean.valueOf(value));
        value = this.properties.getProperty(POSITION_Y, "0.2");
        config.setPdfSignatureExtentionPositionY(Double.valueOf(value));
        value = this.properties.getProperty(POSITION_X, "0.5");
        config.setPdfSignatureExtentionPositionX(Double.valueOf(value));
        value = this.properties.getProperty(USE_DATE, "false");
        config.useDate(Boolean.valueOf(value));
        value = this.properties.getProperty(DATE_FORMAT, "dd.MM.yyyy");
        config.setPdfSignatureExtentionDateFormat(value);
        value = this.properties.getProperty(PDF_COMATIBILITY, "true");
        config.setPdfSignatureExtentionPdfACompatibility(Boolean.valueOf(value));
        value = this.properties.getProperty(VISUALISATION_TYP, "TEXT");
        config.setPdfSignatureExtentionVisualisationTyp(PDFVisualisationTypEnum.valueOf(value));
        value = this.properties.getProperty(TEXT_SIZE, "12");
        config.setPdfSignatureExtentionFontSize(Integer.parseInt(value));
        value = this.properties.getProperty(TEXT_COLOR, "Black");
        config.setPdfSignatureExtentionTextColor(TextColor.valueOf((String)value));
        value = this.properties.getProperty(IMAGE_FILE, "");
        config.setPdfSignatureExtentionImageFile(value);
        value = this.properties.getProperty(CREATE_SIGNATURE_FIELD, "false");
        config.setCreateSignatureField(Boolean.valueOf(value));
    }

    public String toString() {
        if (this.name == null) {
            return "";
        }
        return this.name.replace(SUFFIX, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDFVisualSignatureDetails getPDFOptions() {
        LOG.trace("");
        if (PDFVisualisationTypEnum.NONE.name().equals(this.properties.getProperty(VISUALISATION_TYP))) {
            return null;
        }
        PDFVisualSignatureDetailsImpl options = new PDFVisualSignatureDetailsImpl();
        options.setUseSignerCommonName(Boolean.valueOf(this.properties.getProperty(USE_SIGNATURE_ISSUER, "false")));
        options.setNoName(Boolean.valueOf(false));
        options.setSignerName(this.properties.getProperty(SIGNATURE_ISSUER, ""));
        options.setNoDate(Boolean.valueOf(Boolean.valueOf(this.properties.getProperty(USE_DATE, "false")) == false));
        options.setDateFormat(this.properties.getProperty(DATE_FORMAT, "dd.MM.yyyy"));
        if (this.useSignatureField() && this.createSignatureField()) {
            options.setSignatureHeight(Double.valueOf(this.properties.getProperty(VISUAL_HEIGHT, "3.0")));
            options.setSignatureWidth(Double.valueOf(this.properties.getProperty(VISUAL_WIDTH, "8.0")));
            options.setPositionX(Double.valueOf(this.properties.getProperty(POSITION_X, "0.5")));
            options.setPositionY(Double.valueOf(this.properties.getProperty(POSITION_Y, "0.2")));
        }
        options.setImageToTextRatio(Double.valueOf(this.properties.getProperty(IMAGE_RATIO, "0.25")));
        options.setDynamicTextSize(Boolean.valueOf(this.properties.getProperty(USE_DYNAMICE_TEXTSIZE, "true")));
        options.setPage(Integer.valueOf(this.properties.getProperty(PAGE, "0")));
        options.setFontName(this.properties.getProperty(TEXT_FONT, "TIMES"));
        options.setFontSize(Integer.valueOf(this.properties.getProperty(TEXT_SIZE, "12")));
        options.setTextColor(TextColor.valueOf((String)this.properties.getProperty(TEXT_COLOR, "Black")));
        options.setTextFormatting(TextFormatting.valueOf((String)this.properties.getProperty(TEXT_FORMATTING, "center")));
        String str = this.properties.getProperty(VISIBLE_SIGNATURE_LAYOUT);
        if (str == null || str.trim().isEmpty()) {
            str = "ImageLeft";
        }
        options.setSignatureLayout(VisibleSignatureLayout.valueOf((String)str));
        options.setPDFASignatureAppearance(Boolean.valueOf(this.properties.getProperty(PDF_COMATIBILITY, "true")));
        PDFVisualisationTypEnum vtyp = PDFVisualisationTypEnum.valueOf(this.properties.getProperty(VISUALISATION_TYP, "TEXT"));
        options.setNoText(Boolean.valueOf(!vtyp.equals((Object)PDFVisualisationTypEnum.BOTH) && !vtyp.equals((Object)PDFVisualisationTypEnum.TEXT)));
        if (vtyp.equals((Object)PDFVisualisationTypEnum.BOTH) || vtyp.equals((Object)PDFVisualisationTypEnum.IMAGE)) {
            InputStream is = null;
            try {
                String uriString = this.properties.getProperty(IMAGE_FILE);
                if (uriString.startsWith("file")) {
                    uri = new URI(uriString);
                    File file = new File(uri);
                    is = new FileInputStream(file);
                } else if (uriString.startsWith("http")) {
                    uri = new URI(uriString);
                    File tempFile = new File(Step.getTempFolder(), "pdfVisualisation.tmp");
                    CommonsUrlConnector urlConnector = new CommonsUrlConnector(null);
                    try {
                        tempFile = urlConnector.getFile(uri.toURL(), tempFile);
                        tempFile.deleteOnExit();
                        LOG.info("Temp Datei {} wurde erfolgreich von {} erstellt.", (Object)tempFile.getAbsolutePath(), (Object)uri.toString());
                        is = new FileInputStream(tempFile);
                    }
                    catch (Exception ex) {
                        LOG.error("", (Throwable)ex);
                    }
                } else {
                    String resourceString = uriString.substring(uriString.lastIndexOf(33) + 1);
                    is = Sign.class.getResourceAsStream(resourceString);
                }
                byte[] buffer = new byte[16384];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                if (is != null) {
                    int len;
                    while ((len = is.read(buffer)) > 0) {
                        baos.write(buffer, 0, len);
                    }
                    byte[] imageBuffer = baos.toByteArray();
                    options.setImage(imageBuffer);
                }
                Utils.closeStream((Closeable)is);
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
            finally {
                Utils.closeStream(is);
            }
        } else {
            options.setImage(null);
        }
        LOG.info("PDFVisualSignatureOptions-UseSignerCommonName : {}", (Object)options.getUseSignerCommonName());
        LOG.info("PDFVisualSignatureOptions-SignDisplayName : {}", (Object)options.getSignerName());
        return options;
    }

    public boolean useSignatureField() {
        LOG.trace("");
        try {
            LOG.trace("");
            this.properties.store(System.out, "");
        }
        catch (IOException ex) {
            LOG.debug(ex.getMessage());
        }
        return Boolean.valueOf(this.properties.getProperty(USE_DYNAMIC_PDF_SIGNATURE));
    }

    public boolean createSignatureField() {
        return Boolean.valueOf(this.properties.getProperty(CREATE_SIGNATURE_FIELD));
    }
}

