/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.model.formular.process.impl;

import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.control.process.ProcessName;
import de.bos_bremen.ecard.client.control.step.StepFactory;
import de.bos_bremen.ecard.client.model.HashedFile;
import de.bos_bremen.ecard.client.model.KeyUsage;
import de.bos_bremen.ecard.client.model.PDFSignatureType;
import de.bos_bremen.ecard.client.model.ProcessSignedFile;
import de.bos_bremen.ecard.client.model.SignatureType;
import de.bos_bremen.ecard.client.model.SubsequentProcess;
import de.bos_bremen.ecard.client.model.TargetFolderType;
import de.bos_bremen.ecard.client.model.XMLSignatureType;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.model.formular.process.impl.AbstractProcessFormular;
import de.bos_bremen.ecard.client.model.keyprovider.BNotKServiceKey;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProvider;
import de.bos_bremen.ecard.client.sign.model.formular.process.SignProcessFormular;
import de.bos_bremen.ecard.client.sign.template.SignatureFieldTemplate;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;

public class SignFormular
extends AbstractProcessFormular
implements SignProcessFormular {
    private List<ProcessSignedFile> selectedFiles;
    private Boolean createTimestamp;
    private PDFSignatureType pdfSignatureType;
    private XMLSignatureType xmlSignatureType;
    private SignatureType signatureType;
    private EnumMap<StepFactory.StepName, Boolean> skipStep = new EnumMap(StepFactory.StepName.class);
    private List<KeyProvider> keyProviderList = new ArrayList<KeyProvider>();
    private String serialnumber;
    private String targetFolder;
    private String localCopyFolder;
    private TargetFolderType targetFolderType;
    private String pdfSignatureReason;
    private String pdfSignatureLocation;
    private SignatureFieldTemplate selectedPdfTemplate;
    private SubsequentProcess currentSubsequentProcess;

    public SignFormular() {
    }

    public SignFormular(SignFormular formular) {
        super((AbstractProcessFormular)formular);
        this.selectedFiles = formular.selectedFiles != null ? new ArrayList<ProcessSignedFile>(formular.selectedFiles) : null;
        this.createTimestamp = formular.createTimestamp;
        this.pdfSignatureType = formular.pdfSignatureType;
        this.signatureType = formular.signatureType;
        this.skipStep = formular.skipStep != null ? new EnumMap<StepFactory.StepName, Boolean>(formular.skipStep) : new EnumMap(StepFactory.StepName.class);
        this.keyProviderList = formular.keyProviderList != null ? new ArrayList<KeyProvider>(formular.keyProviderList) : new ArrayList();
        this.targetFolder = formular.targetFolder;
        this.localCopyFolder = formular.localCopyFolder;
        this.targetFolderType = formular.targetFolderType;
        this.pdfSignatureReason = formular.pdfSignatureReason;
        this.selectedPdfTemplate = formular.selectedPdfTemplate;
        this.serialnumber = formular.serialnumber;
    }

    public void addSelectedFile(ProcessSignedFile file) {
        if (this.selectedFiles == null) {
            this.selectedFiles = new ArrayList<ProcessSignedFile>();
        }
        this.selectedFiles.add(file);
        this.notifyAllChangeListener(null, file, StepFactory.StepName.selectfiles);
    }

    public List<ProcessSignedFile> getSelectedFiles() {
        return this.selectedFiles;
    }

    public boolean removeSelectedFile(ProcessSignedFile fileToRemove) {
        boolean result;
        if (this.selectedFiles == null) {
            this.selectedFiles = new ArrayList<ProcessSignedFile>();
        }
        if (result = this.selectedFiles.remove(fileToRemove)) {
            this.notifyAllChangeListener(fileToRemove, null, StepFactory.StepName.selectfiles);
        }
        return result;
    }

    public void removeAllFiles() {
        ArrayList<ProcessSignedFile> processSignedFiles = new ArrayList<ProcessSignedFile>();
        if (this.selectedFiles != null) {
            processSignedFiles.addAll(this.selectedFiles);
        } else {
            this.selectedFiles = new ArrayList<ProcessSignedFile>();
        }
        for (ProcessSignedFile psf : processSignedFiles) {
            this.removeSelectedFile(psf);
        }
    }

    public void setSelectedFiles(List<File> files, boolean replaceFiles) {
        if (replaceFiles) {
            this.selectedFiles = new ArrayList<ProcessSignedFile>();
        }
        if (files != null) {
            for (File file : files) {
                ProcessSignedFile processFileSeen = new ProcessSignedFile(file);
                if (this.containSelectedFiles(processFileSeen)) continue;
                this.selectedFiles.add(processFileSeen);
            }
        }
        this.notifyAllChangeListener(null, this.selectedFiles, StepFactory.StepName.selectfiles);
    }

    public boolean containSelectedFiles(ProcessSignedFile file) {
        for (ProcessSignedFile aktFile : this.selectedFiles) {
            File detachedFile;
            HashedFile hashedFile = file.getFile();
            if (hashedFile != null) {
                if (aktFile.getFile() != null && aktFile.getFile().equals((Object)hashedFile)) {
                    return true;
                }
                if (aktFile.getDetachedFile() != null && aktFile.getDetachedFile().equals(hashedFile)) {
                    return true;
                }
            }
            if ((detachedFile = file.getDetachedFile()) == null) continue;
            if (aktFile.getDetachedFile() != null && aktFile.getDetachedFile().equals(detachedFile)) {
                return true;
            }
            if (aktFile.getFile() == null || !aktFile.getFile().equals((Object)detachedFile)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void createTimestamp(boolean createTimestamp) {
        Boolean oldValue = this.createTimestamp;
        this.createTimestamp = createTimestamp;
        this.notifyAllChangeListener(oldValue, this.createTimestamp, StepFactory.StepName.options);
    }

    @Override
    public Boolean createTimestamp() {
        return this.createTimestamp;
    }

    @Override
    public void setPDFSignatureType(PDFSignatureType pdfSignatureType) {
        PDFSignatureType oldValue = this.pdfSignatureType;
        this.pdfSignatureType = pdfSignatureType;
        this.notifyAllChangeListener(oldValue, pdfSignatureType, StepFactory.StepName.options);
    }

    @Override
    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    @Override
    public PDFSignatureType getPDFSignatureType() {
        return this.pdfSignatureType;
    }

    @Override
    public void setXMLSignatureType(XMLSignatureType xmlSignatureType) {
        XMLSignatureType oldValue = this.xmlSignatureType;
        this.xmlSignatureType = xmlSignatureType;
        this.notifyAllChangeListener(oldValue, xmlSignatureType, StepFactory.StepName.options);
    }

    @Override
    public XMLSignatureType getXMLSignatureType() {
        return this.xmlSignatureType;
    }

    @Override
    public XMLSignatureType getDefaultXMLSignatureType() {
        return XMLSignatureType.noXmlInline;
    }

    @Override
    public void setSignatureType(SignatureType type) {
        SignatureType oldValue = this.signatureType;
        this.signatureType = type;
        this.notifyAllChangeListener(oldValue, type, StepFactory.StepName.options);
    }

    public void skipStep(boolean useDefaults, StepFactory.StepName stepName) {
        this.skipStep.put(stepName, useDefaults);
    }

    public Boolean skipStep(StepFactory.StepName stepName) {
        if (this.skipStep.containsKey(stepName)) {
            return this.skipStep.get(stepName);
        }
        return Boolean.FALSE;
    }

    public boolean addKeyProvider(KeyProvider provider, KeyUsage keyUsage) {
        if (keyUsage != KeyUsage.SIGN || provider == null) {
            return false;
        }
        if (this.keyProviderList.contains(provider)) {
            return true;
        }
        boolean result = this.keyProviderList.add(provider);
        if (result) {
            this.notifyAllChangeListener(null, provider, StepFactory.StepName.selectkeys);
        }
        return result;
    }

    public List<KeyProvider> getKeyProvider(KeyUsage keyUsage) {
        if (keyUsage != KeyUsage.SIGN) {
            return Collections.emptyList();
        }
        return new ArrayList<KeyProvider>(this.keyProviderList);
    }

    public boolean removeKeyProvider(KeyProvider provider, KeyUsage keyUsage) {
        LOG.trace("remove KeyProvider = {}", (Object)keyUsage);
        if (keyUsage != KeyUsage.SIGN) {
            return false;
        }
        ProcessName p = Utils.getActiveProcess();
        if ((p == null || "none".equals(p.toString())) && !(provider instanceof BNotKServiceKey)) {
            LOG.info("no active process -> return");
            return false;
        }
        boolean result = this.keyProviderList.remove(provider);
        if (result) {
            this.notifyAllChangeListener(provider, null, StepFactory.StepName.selectkeys);
        }
        return result;
    }

    public boolean setSelectedAlias(KeyProvider provider, String alias, KeyUsage keyUsage) {
        if (keyUsage != KeyUsage.SIGN) {
            return false;
        }
        if (!this.keyProviderList.contains(provider)) {
            return false;
        }
        int indexOf = this.keyProviderList.indexOf(provider);
        provider.setSelectedAlias(alias);
        this.keyProviderList.remove(indexOf);
        this.keyProviderList.add(indexOf, provider);
        this.notifyAllChangeListener(provider, null, StepFactory.StepName.selectkeys);
        return true;
    }

    public String getTargetFolder() {
        return this.targetFolder;
    }

    public TargetFolderType getTargetFolderType() {
        return this.targetFolderType;
    }

    public boolean setTargetFolder(String targetFolder) {
        String oldValue = this.targetFolder;
        this.targetFolder = targetFolder;
        this.notifyAllChangeListener(oldValue, targetFolder, StepFactory.StepName.selecttargetfolder);
        return true;
    }

    public boolean setTargetFolderType(TargetFolderType folderType) {
        this.targetFolderType = folderType;
        return true;
    }

    public void refresh() {
        this.notifyAllChangeListener(true, false, StepFactory.StepName.options);
    }

    @Override
    public boolean getDefaultCreateTimestamp() {
        return false;
    }

    @Override
    public SignatureType getDefaultSignatureType() {
        return SignatureType.detachedPKCS7;
    }

    public void setDefault() {
        this.createTimestamp(this.getDefaultCreateTimestamp());
        this.setPDFSignatureType(this.getDefaultPDFSignatureType());
        this.setSignatureType(this.getDefaultSignatureType());
        this.setTargetFolderType(TargetFolderType.sameAsSourceFolder);
        this.setTargetFolder(null);
        this.setSelectedFiles(new ArrayList<File>(), true);
        EnumMap<StepFactory.StepName, Boolean> oldSkippStep = new EnumMap<StepFactory.StepName, Boolean>(this.skipStep);
        for (StepFactory.StepName key : oldSkippStep.keySet()) {
            if (!Boolean.TRUE.equals(this.skipStep.get(key))) continue;
            this.skipStep.remove(key);
            this.skipStep(false, key);
        }
        ArrayList<KeyProvider> oldKeyProviderList = new ArrayList<KeyProvider>(this.keyProviderList);
        for (KeyProvider provider : oldKeyProviderList) {
            this.removeKeyProvider(provider, KeyUsage.SIGN);
        }
    }

    public void notifyAllChangeListener() {
        this.notifyAllChangeListener(null, Boolean.TRUE, StepFactory.StepName.selectfiles);
    }

    public void setFileAsSeen(ProcessSignedFile file) throws SignerException {
        try {
            file.setSeen(true);
        }
        finally {
            this.notifyAllChangeListener();
        }
    }

    @Override
    public void setPDFSignatureLocation(String location) {
        String oldValue = this.pdfSignatureLocation;
        this.pdfSignatureLocation = location;
        this.notifyAllChangeListener(oldValue, this.pdfSignatureLocation, StepFactory.StepName.options);
    }

    @Override
    public String getPDFSignatureLocation() {
        return this.pdfSignatureLocation;
    }

    @Override
    public String getDefaultPDFSignatureLocation() {
        return "";
    }

    @Override
    public void setPDFSignatureReason(String reason) {
        String oldValue = this.pdfSignatureReason;
        this.pdfSignatureReason = reason;
        this.notifyAllChangeListener(oldValue, this.pdfSignatureReason, StepFactory.StepName.options);
    }

    @Override
    public String getPDFSignatureReason() {
        return this.pdfSignatureReason;
    }

    @Override
    public String getDefaultPDFSignatureReason() {
        return "";
    }

    @Override
    public PDFSignatureType getDefaultPDFSignatureType() {
        return PDFSignatureType.pdfInline;
    }

    public String getLocalCopyFolder() {
        return this.localCopyFolder;
    }

    public void setLocalCopyFolder(String targetFolder) {
        String oldValue = this.localCopyFolder;
        this.localCopyFolder = targetFolder;
        this.notifyAllChangeListener(oldValue, targetFolder, StepFactory.StepName.selecttargetfolder);
    }

    public SubsequentProcess getSubsequentProcess() {
        return this.currentSubsequentProcess;
    }

    public void setSubsequentProcess(SubsequentProcess subsequentProcess) {
        this.currentSubsequentProcess = subsequentProcess;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("\nSignFormular");
        List<ProcessSignedFile> files = this.getSelectedFiles();
        stringBuilder.append("\nSelectedFiles:");
        if (files == null || files.isEmpty()) {
            stringBuilder.append("---");
        } else {
            for (ProcessSignedFile processSignedFile : files) {
                stringBuilder.append(processSignedFile.getFile().getAbsolutePath()).append(";");
            }
        }
        stringBuilder.append("\n");
        stringBuilder.append("seriennumber :").append(this.getSerialnumber()).append("\n");
        stringBuilder.append("TargetFolder:").append(this.getTargetFolder()).append("\n");
        stringBuilder.append("TargetFolderType:").append(this.getTargetFolderType()).append("\n");
        stringBuilder.append("selected PDF Template:").append(this.getSelectedPdfTemplate()).append("\n");
        return stringBuilder.toString();
    }

    @Override
    public void setSelectedPdfTemplate(SignatureFieldTemplate template) {
        this.selectedPdfTemplate = template;
    }

    @Override
    public SignatureFieldTemplate getSelectedPdfTemplate() {
        return this.selectedPdfTemplate;
    }

    public String getSerialnumber() {
        LOG.debug("get serialnumber : '{}'", (Object)this.serialnumber);
        return this.serialnumber;
    }

    public void setSerialnumber(String serialnumber) {
        LOG.debug("set serialnumber : '{}'", (Object)serialnumber);
        this.serialnumber = serialnumber;
    }
}

