/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.gui.step;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.control.step.working.WorkingStep;
import de.bos_bremen.ecard.client.gui.step.WorkingStepView;
import de.bos_bremen.ecard.client.gui.view.component.ValueWithLabelPanel;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.KeyUsage;
import de.bos_bremen.ecard.client.model.PDFSignatureType;
import de.bos_bremen.ecard.client.model.SignatureType;
import de.bos_bremen.ecard.client.model.XMLSignatureType;
import de.bos_bremen.ecard.client.model.keyprovider.CertificateQuality;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProvider;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.model.licence.ProductFunctions;
import de.bos_bremen.ecard.client.sign.model.formular.process.SignProcessFormular;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignView
extends WorkingStepView {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger(SignView.class);
    private static final JPanel centerPanel = new JPanel();
    private ValueWithLabelPanel signatureLevel;
    private ValueWithLabelPanel pdfInlineLabel;
    private ValueWithLabelPanel xmlInlineLabel;
    private ValueWithLabelPanel defaultSignFormatLabel;
    private ValueWithLabelPanel timestampLabel;
    private JPanel summarySignOptionsPanel;
    private LicenceTyp pdfInlineLicenceTyp;
    private LicenceTyp xmlInlineLicenceTyp;
    private LicenceTyp signFormatLicenceTyp;
    private LicenceTyp timestampLicenceTyp;

    public SignView(WorkingStep workingstep) {
        super(workingstep, centerPanel);
    }

    protected void initGUI(JPanel contentPanel) {
        super.initGUI(contentPanel);
        this.setLayout(new BorderLayout());
        this.add(contentPanel, "Center");
        this.summarySignOptionsPanel = new JPanel(new GridBagLayout());
        this.signatureLevel = new ValueWithLabelPanel("view.step.workingstep.sign.level");
        this.pdfInlineLabel = new ValueWithLabelPanel("view.step.workingstep.sign.pades");
        this.xmlInlineLabel = new ValueWithLabelPanel("view.step.workingstep.sign.xades");
        this.defaultSignFormatLabel = new ValueWithLabelPanel("view.step.workingstep.sign.signatureFormat");
        this.timestampLabel = new ValueWithLabelPanel("view.step.workingstep.sign.timestamp");
        this.layoutSummarySignOptionsPanel();
        this.add(this.summarySignOptionsPanel, "South");
        this.setSummarySelectedSignOptions();
    }

    private void layoutSummarySignOptionsPanel() {
        Insets insets = new Insets(3, 3, 3, 3);
        int anchor = 18;
        this.summarySignOptionsPanel.add((Component)this.signatureLevel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, anchor, 1, insets, 0, 0));
        this.summarySignOptionsPanel.add((Component)this.defaultSignFormatLabel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, anchor, 1, insets, 0, 0));
        this.summarySignOptionsPanel.add((Component)this.pdfInlineLabel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, anchor, 1, insets, 0, 0));
        this.summarySignOptionsPanel.add((Component)this.xmlInlineLabel, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, anchor, 1, insets, 0, 0));
        this.summarySignOptionsPanel.add((Component)this.timestampLabel, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, anchor, 1, insets, 0, 0));
    }

    private void readLicenceTypForSignOptions() {
        ProductFunctions productFunctions = Document.getInstance().getProductFunctions();
        this.pdfInlineLicenceTyp = productFunctions.getLicence("process/sign/options/signformat/pdfinline");
        this.xmlInlineLicenceTyp = productFunctions.getLicence("process/sign/options/signformat/xmlinline");
        this.signFormatLicenceTyp = productFunctions.getLicence("process/sign/options/signformat");
        this.timestampLicenceTyp = productFunctions.getLicence("process/sign/options/timestamp");
    }

    private void setVisibilitySignOptionsLabels() {
        this.pdfInlineLabel.setVisible(this.pdfInlineLicenceTyp.isVisible());
        this.xmlInlineLabel.setVisible(this.xmlInlineLicenceTyp.isVisible());
        this.defaultSignFormatLabel.setVisible(this.signFormatLicenceTyp.isVisible());
        this.timestampLabel.setVisible(this.timestampLicenceTyp.isVisible());
    }

    private void setSelectedSignOptionsToSummary() {
        this.readLicenceTypForSignOptions();
        this.setVisibilitySignOptionsLabels();
        SignProcessFormular signFormular = (SignProcessFormular)this.lastStep.getForm();
        PDFSignatureType pdfSignatureType = signFormular.getPDFSignatureType();
        if (pdfSignatureType == null) {
            LOG.warn("isPDFInlineEnable was not set!");
            pdfSignatureType = PDFSignatureType.noPdfInline;
        }
        this.pdfInlineLabel.setValue(Messages.getString((String)("view.step.workingstep.sign.pades." + pdfSignatureType.name())));
        XMLSignatureType xmlSignatureType = signFormular.getXMLSignatureType();
        if (xmlSignatureType == null) {
            LOG.warn("isXMLInlineEnable was not set!");
            xmlSignatureType = XMLSignatureType.noXmlInline;
        }
        this.xmlInlineLabel.setValue(Messages.getString((String)("view.step.workingstep.sign.xades." + xmlSignatureType.name())));
        SignatureType sType = signFormular.getSignatureType();
        String value = sType == SignatureType.detachedPKCS7 ? "detached" : "enveloped";
        this.defaultSignFormatLabel.setValue(Messages.getString((String)("step.options.signaturetyp.cades." + value + ".short")), Messages.getResource((String)("step.options.signaturetyp.cades." + value + ".tooltip")));
        Boolean createTimestamp = signFormular.createTimestamp();
        if (createTimestamp == null) {
            LOG.warn("createTimestamp was not set!");
            createTimestamp = false;
        }
        this.timestampLabel.setValue(Boolean.TRUE.equals(createTimestamp) ? Messages.getString((String)"view.step.workingstep.sign.isEnabled") : Messages.getString((String)"view.step.workingstep.sign.isNotEnabled"));
    }

    public void setActive(boolean active) {
        Component comp;
        LOG.trace("");
        super.setActive(active);
        if (active) {
            LOG.info("\n------------------------- Signieren/'Signieren'... ----------------------------");
            LOG.trace("Set active Sign last step : {}", (Object)this.lastStep.getStepName());
            this.setSummarySelectedSignOptions();
        }
        if (SwingUtilities.getRootPane((Component)((Object)this)) == null && (comp = SwingUtilities.getRoot((Component)((Object)this))) != null) {
            comp.setVisible(false);
            comp.setVisible(true);
        }
        LOG.info("\n------------------------- Signieren/'Signieren' : ausgewaehlt ----------------------");
    }

    private void setSummarySelectedSignOptions() {
        LOG.trace("");
        SignProcessFormular signFormular = (SignProcessFormular)this.lastStep.getForm();
        if (signFormular == null) {
            return;
        }
        this.setSelectedSignOptionsToSummary();
        List keyProviderList = signFormular.getKeyProvider(KeyUsage.SIGN);
        if (keyProviderList.isEmpty()) {
            return;
        }
        KeyProvider keyProvider = (KeyProvider)keyProviderList.get(0);
        CertificateQuality certificateQuality = keyProvider.getCertificateQuality(keyProvider.getSelectedAlias());
        this.signatureLevel.setValue(Messages.getString((String)certificateQuality.toString()));
        this.revalidate();
        this.repaint();
    }

    public void stateChanged(ChangeEvent event) {
        super.stateChanged(event);
        LOG.trace("sign : last step sign");
        this.setSummarySelectedSignOptions();
    }

    public void requestFocus() {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        LOG.trace("sign : last step sign");
        this.removeAll();
        this.stepContentPanel.removeAll();
        this.initGUI(this.stepContentPanel);
        this.revalidate();
    }
}

