/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.gui.step;

import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.AliasSelectionHandler;
import de.bos_bremen.ecard.client.action.SelectedCertificateHandler;
import de.bos_bremen.ecard.client.control.step.KeyProviderStep;
import de.bos_bremen.ecard.client.control.step.SkippableStep;
import de.bos_bremen.ecard.client.control.step.StepChangedListener;
import de.bos_bremen.ecard.client.gui.MultiLineTooltips;
import de.bos_bremen.ecard.client.gui.dialog.AccessibleJLabel;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.DescriptionPanel;
import de.bos_bremen.ecard.client.gui.view.component.JComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.gui.view.component.SkipStepHandler;
import de.bos_bremen.ecard.client.gui.view.component.SkipStepPanel;
import de.bos_bremen.ecard.client.gui.view.component.buttons.AccessibleRadioButton;
import de.bos_bremen.ecard.client.gui.view.component.buttons.CurvedToggleIconButton;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IFDCurvedToggleIconButton;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButton;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.KeyUsage;
import de.bos_bremen.ecard.client.model.keyprovider.AbstractKeyProvider;
import de.bos_bremen.ecard.client.model.keyprovider.AliasListener;
import de.bos_bremen.ecard.client.model.keyprovider.BNotKServiceKey;
import de.bos_bremen.ecard.client.model.keyprovider.CertificateQuality;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProvider;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProviderEntry;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProviderSource;
import de.bos_bremen.ecard.client.model.keyprovider.SignServiceKey;
import de.bos_bremen.ecard.client.model.keyprovider.SoftwareKey;
import de.bos_bremen.ecard.client.model.keyprovider.TerminalKey;
import de.bos_bremen.ecard.client.model.keyprovider.mcard.TerminalListener;
import de.bos_bremen.ecard.client.model.keyprovider.mcard.TerminalModel;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.model.licence.ProductFunctions;
import de.bos_bremen.ecard.client.sign.control.process.impl.SignConfig;
import de.bos_bremen.ecard.client.sign.control.step.SelectKeys;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.file.Path;
import java.security.KeyStoreException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SelectKeysView
extends JPanel
implements StepChangedListener,
SelectedCertificateHandler,
AdjustmentListener,
AliasSelectionHandler,
PropertyChangeListener,
SkipStepHandler,
TerminalListener,
AliasListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger(SelectKeysView.class);
    private final transient SelectKeys step;
    private static final String PROCESS_SIGN_KEY_SOFTWARE = "process/sign/key/software";
    private static final String PROCESS_SIGN_KEY_SIGNSERVICE = "process/sign/key/signservice";
    private static final String PROCESS_SIGN_KEY_BNOTK = "process/sign/key/BNotK";
    private DescriptionPanel descPanel;
    private CertificateQuality requiredQuality;
    protected JPanel ifdPanel;
    protected JPanel ifdBorderPanel;
    private JScrollPane ifdScrollPane;
    private final List<IFDCurvedToggleIconButton> ifdList = new ArrayList<IFDCurvedToggleIconButton>();
    private IFDButtonGroup ifdGroup;
    private AccessibleJLabel aliasLabel;
    protected JPanel aliasPanel;
    protected JPanel aliasBorderPanel;
    private JScrollPane aliasScrollPane;
    private final List<CurvedToggleIconButton> aliasList = new ArrayList<CurvedToggleIconButton>();
    protected JPanel bottomButtonPanel;
    protected IconButton showCertificateButton;
    protected IconButton reloadCardButton;
    private SkipStepPanel skipStep;
    private String serialnumber = "";
    private String serialnumberAlias = "";
    private transient KeyProvider serialnumberKeyProvider = null;
    private Path keyStore = null;
    private SoftwareKey swKey;
    private char[] pinCacheKeyStore;

    public SelectKeysView(SelectKeys stepSelectKeys) {
        LOG.trace("sign : selectkeys");
        this.step = stepSelectKeys;
        this.step.addStateChangeListener(this);
        LocaleChanger.getInstance().addObserver((PropertyChangeListener)this);
        this.initKeyProviderList();
        this.initGui();
        this.layoutGui(false);
        this.updateIfdList();
        this.layoutIfdPanel();
        JComponentUtils.setLookByLicence((JComponent)this, (LicenceTyp)this.step.getLicenceTyp());
    }

    private void initKeyProviderList() {
        LicenceTyp bNotKKeyLicence;
        LOG.trace("sign : selectkeys");
        ProductFunctions productFunctions = Document.getInstance().getProductFunctions();
        LOG.trace("{} : {}", (Object)this.step.getStepName(), (Object)this.step.getStepProperties());
        LicenceTyp softWareKeyLicence = productFunctions.getLicence(this.step.getLicenceTypKey() + "/software");
        if (softWareKeyLicence.useInProcess()) {
            this.swKey = new SoftwareKey((AliasListener)this, (KeyProviderStep)this.step, this.getKeyUsage(), true);
            this.swKey.setUsePinCache(this.step.isUsePinCache());
            this.step.getKeyProviderList().add(this.swKey);
        }
        this.step.getKeyProviderList().add(new TerminalKey((TerminalListener)this, (AliasListener)this, (KeyProviderStep)this.step, this.getKeyUsage()));
        LicenceTyp signserviceKeyLicence = productFunctions.getLicence(this.step.getLicenceTypKey() + "/signservice");
        if (signserviceKeyLicence.useInProcess()) {
            this.step.getKeyProviderList().add(new SignServiceKey((AliasListener)this, (KeyProviderStep)this.step, this.getKeyUsage()));
        }
        if ((bNotKKeyLicence = productFunctions.getLicence(this.step.getLicenceTypKey() + "/BNotK")).useInProcess()) {
            this.step.getKeyProviderList().add(new BNotKServiceKey((AliasListener)this, (KeyProviderStep)this.step, this.getKeyUsage()));
        }
    }

    private void initGui() {
        LOG.trace("sign : selectkeys : gui");
        this.requiredQuality = ((SignConfig)this.step.getParent().getConfig()).getSignatureLevel();
        LOG.trace("sign : selectkeys : {}", (Object)this.requiredQuality);
        this.descPanel = new DescriptionPanel("step.sign.keychooser");
        this.ifdPanel = new JPanel();
        this.ifdBorderPanel = ComponentUtils.setTitledFocusableBorder((JPanel)new JPanel(), (String)Messages.getString((String)"step.sign.keychooser.title1"));
        this.aliasLabel = new AccessibleJLabel(Messages.getString((String)"step.sign.keychooser.2.text"));
        this.aliasPanel = new JPanel();
        this.aliasBorderPanel = ComponentUtils.setTitledFocusableBorder((JPanel)new JPanel(), (String)Messages.getString((String)"step.sign.keychooser.title2"));
        this.bottomButtonPanel = new JPanel();
        this.showCertificateButton = new IconButton();
        this.showCertificateButton.setAction((Action)Document.getInstance().getActionFactory().createShowCertificateAction((SelectedCertificateHandler)this));
        this.reloadCardButton = new IconButton();
        this.reloadCardButton.setAction((Action)Document.getInstance().getActionFactory().createResetCardAction());
        if (!this.step.getLicenceTyp().isVisible()) {
            this.reloadCardButton.setVisible(false);
        } else if (!this.step.getLicenceTyp().isEditable()) {
            this.reloadCardButton.setEnabled(false);
        }
        this.skipStep = new SkipStepPanel((SkipStepHandler)this);
        this.ifdScrollPane = new JScrollPane();
        this.ifdScrollPane.getHorizontalScrollBar().addAdjustmentListener(this);
        this.ifdScrollPane.setBorder(null);
        this.ifdScrollPane.setVerticalScrollBarPolicy(21);
        this.aliasScrollPane = new JScrollPane();
        this.aliasScrollPane.getHorizontalScrollBar().addAdjustmentListener(this);
        this.aliasScrollPane.setBorder(null);
        this.aliasScrollPane.setVerticalScrollBarPolicy(21);
    }

    private JPanel getSignatureLevelPanel() {
        LOG.trace("{}", (Object)this.step.getLicenceTypKey());
        JPanel signatureLevelPanel = new JPanel(new FlowLayout(3, 10, 1));
        signatureLevelPanel = ComponentUtils.setTitledFocusableBorder((JPanel)signatureLevelPanel, (String)Messages.getString((String)"step.sign.keychooser.signaturelevel"));
        String property = "step.sign.keychooser";
        AccessibleRadioButton all = new AccessibleRadioButton(Messages.getString((String)(property + ".signaturelevel.all")));
        String mnemonic = Messages.getResource((String)(property + ".signaturelevel.all.mnemonic"));
        all.setMnemonic(mnemonic.charAt(0));
        all.setSelected(this.requiredQuality == CertificateQuality.indetermined);
        all.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                LOG.info("signature level -all- selected.");
                this.requiredQuality = CertificateQuality.indetermined;
                ((SignConfig)this.step.getParent().getConfig()).setSignatureLevel(this.requiredQuality);
                this.updateGui();
                all.requestFocus();
            }
        });
        AccessibleRadioButton qualified = new AccessibleRadioButton(Messages.getString((String)(property + ".signaturelevel.qualified")));
        qualified.setToolTipText(Messages.getString((String)"step.sign.keychooser.signaturelevel.qualified.tooltip"));
        mnemonic = Messages.getResource((String)(property + ".signaturelevel.qualified.mnemonic"));
        qualified.setMnemonic(mnemonic.charAt(0));
        qualified.setSelected(this.requiredQuality == CertificateQuality.qualified);
        qualified.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                LOG.info("signature level -qualified- selected.");
                this.requiredQuality = CertificateQuality.qualified;
                ((SignConfig)this.step.getParent().getConfig()).setSignatureLevel(this.requiredQuality);
                this.updateGui();
                qualified.requestFocus();
            }
        });
        AccessibleRadioButton advanced = new AccessibleRadioButton(Messages.getString((String)(property + ".signaturelevel.advanced")));
        mnemonic = Messages.getResource((String)(property + ".signaturelevel.advanced.mnemonic"));
        advanced.setMnemonic(mnemonic.charAt(0));
        advanced.setSelected(this.requiredQuality == CertificateQuality.advanced);
        advanced.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                LOG.info("signature level -advanced- selected.");
                this.requiredQuality = CertificateQuality.advanced;
                ((SignConfig)this.step.getParent().getConfig()).setSignatureLevel(this.requiredQuality);
                this.updateGui();
                advanced.requestFocus();
            }
        });
        signatureLevelPanel.add(new JLabel(" "));
        signatureLevelPanel.add((Component)all);
        signatureLevelPanel.add((Component)advanced);
        signatureLevelPanel.add((Component)qualified);
        ButtonGroup signaturelevel = new ButtonGroup();
        signaturelevel.add((AbstractButton)all);
        signaturelevel.add((AbstractButton)advanced);
        signaturelevel.add((AbstractButton)qualified);
        String key = this.step.getLicenceTypKey() + "/signaturelevel";
        LicenceTyp licence = Document.getInstance().getProductFunctions().getLicence(key);
        JComponentUtils.setLookByLicence((JComponent)signatureLevelPanel, (LicenceTyp)licence);
        return signatureLevelPanel;
    }

    private void layoutGui(boolean showAlias) {
        LOG.trace("sign : selectkeys : gui");
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.bottomButtonPanel.removeAll();
        this.bottomButtonPanel.setLayout(new GridBagLayout());
        JPanel north = new JPanel(new BorderLayout());
        north.add((Component)this.descPanel, "North");
        north.add((Component)this.getSignatureLevelPanel(), "Center");
        north.add((Component)this.ifdBorderPanel, "South");
        JPanel center = new JPanel(new BorderLayout());
        if (showAlias) {
            JPanel p = new JPanel(new BorderLayout());
            p.add((Component)this.aliasLabel, "North");
            p.add((Component)this.aliasBorderPanel, "Center");
            center.add((Component)p, "North");
            GridBagConstraints gbcUpdatePanel = new GridBagConstraints();
            gbcUpdatePanel.anchor = 16;
            gbcUpdatePanel.fill = 0;
            gbcUpdatePanel.weightx = 0.0;
            gbcUpdatePanel.weighty = 1.0;
            gbcUpdatePanel.insets = new Insets(0, 5, 0, 5);
            this.bottomButtonPanel.add((Component)this.reloadCardButton, gbcUpdatePanel);
            gbcUpdatePanel.weightx = 1.0;
            this.bottomButtonPanel.add((Component)this.showCertificateButton, gbcUpdatePanel);
        } else {
            GridBagConstraints gbcUpdatePanel = new GridBagConstraints();
            gbcUpdatePanel.weightx = 1.0;
            gbcUpdatePanel.weighty = 1.0;
            gbcUpdatePanel.anchor = 16;
            gbcUpdatePanel.fill = 0;
            gbcUpdatePanel.insets = new Insets(0, 5, 0, 5);
            this.bottomButtonPanel.add((Component)this.reloadCardButton, gbcUpdatePanel);
        }
        this.showCertificateButton.setEnabled(this.step.isStateComplete());
        center.add((Component)this.bottomButtonPanel, "Center");
        this.add((Component)north, "North");
        this.add((Component)center, "Center");
        this.add((Component)this.skipStep, "South");
        this.revalidate();
        this.repaint();
    }

    private void updateAndShowAliasPanel() {
        LOG.trace("sign : selectkeys");
        LOG.trace("Schluesselauswahl aktualisieren: list, panel ...");
        this.updateAliasList();
        this.updateAliasPanel();
        this.layoutGui(true);
        LOG.trace("Schluesselauswahl ist aktualisiert.");
    }

    private void updateIfdList() {
        LOG.trace("sign : selectkeys");
        LOG.trace("Speicherorte-Liste aktualisieren ...");
        this.ifdList.clear();
        this.ifdGroup = new IFDButtonGroup();
        for (AbstractKeyProvider keyProvider : this.step.getKeyProviderList()) {
            LOG.trace("");
            List buttons = keyProvider.getIFDCurvedToggleIconButton();
            if (buttons == null) continue;
            for (IFDCurvedToggleIconButton button : buttons) {
                button.setFocusTraversalKeysEnabled(false);
                button.addKeyListener(this.createKeyAdapterFor(button));
                this.ifdGroup.add((AbstractButton)button);
                LOG.debug("Speicherort des Schluessels : {}", (Object)button.getText());
                this.updateIFDButton(button);
                this.ifdList.add(button);
            }
        }
        LOG.trace("Speicherorte-Liste ist aktualisiert.");
    }

    private void loadKeyStoreFromXMLProperties() {
        LOG.trace("sign : selectkeys : load keystore ...");
        boolean stepUsePinCache = this.step.isUsePinCache();
        this.swKey.setUsePinCache(stepUsePinCache);
        LOG.trace("pinCacheKeyStore : {}", (Object)(this.pinCacheKeyStore == null ? "wird nicht gemerkt" : "wurde gemerkt."));
        this.swKey.setPinCache(this.pinCacheKeyStore);
        this.swKey.setFileToLoad(this.keyStore.toFile());
        this.pinCacheKeyStore = this.swKey.getPinCache();
        LOG.trace("pinCacheKeyStore : {}", (Object)(this.pinCacheKeyStore == null || this.pinCacheKeyStore.length == 0 ? "soll nicht gemerkt werden." : "wurde gemerkt."));
        LOG.debug("Boreum selektiert ein Speicherort 'aus Datei'...");
        String aliasInConfig = this.step.getFromConfigSWAlias();
        if (aliasInConfig != null && !aliasInConfig.trim().isEmpty()) {
            this.step.setSelectedAlias((KeyProvider)this.swKey, aliasInConfig);
            LOG.debug("Boreum selektiert ein alias aus config : {}", (Object)aliasInConfig);
        }
    }

    private JLabel createErrorLabel(String key) {
        String selectedQuality = Messages.getString((String)("step.sign.keychooser.signaturelevel." + this.requiredQuality.name()));
        LOG.debug("selectedQuality : {}", (Object)selectedQuality);
        String errorMessage = MessageFormat.format(Messages.getString((String)key), selectedQuality);
        LOG.warn("errorMessage : {}", (Object)errorMessage);
        JLabel errorLabel = new JLabel(errorMessage);
        if (!errorLabel.getText().isEmpty()) {
            errorLabel.setFocusable(true);
            errorLabel.getAccessibleContext().setAccessibleDescription("Warnung");
            errorLabel.addFocusListener(ComponentUtils.createFocusListenerFor((JLabel)errorLabel));
        }
        return errorLabel;
    }

    private void updateAliasList() {
        LOG.trace("sign : selectkeys");
        LOG.trace("Schluesselliste aktualisieren...");
        this.aliasList.clear();
        List touse = this.step.getKeyProviderToUse();
        if (touse == null || touse.isEmpty()) {
            LOG.debug("KeyProvider getrennt.");
            return;
        }
        LOG.debug("KeyProvider verbunden.");
        KeyProvider keyProvider = this.step.getSelectedKeyProvider();
        if (keyProvider == null) {
            LOG.debug("No selected KeyProvider.");
            return;
        }
        LOG.debug("SelectedKeyProvider : {}", (Object)keyProvider.getIFDName());
        List allAliases = keyProvider.getAllAliases();
        for (String alias : allAliases) {
            if (keyProvider instanceof SoftwareKey && !this.isKeyEntry(keyProvider, alias)) {
                LOG.trace("");
                continue;
            }
            LOG.debug("alias vorhanden : {}", (Object)alias);
            int buttonTextLength = keyProvider.getDisplayName(alias).length();
            int buttonTextWidth = buttonTextLength / 2 < 30 ? 30 : buttonTextLength / 2;
            String buttonLabel = MultiLineTooltips.wrapToolTip((String)(keyProvider.getDisplayName(alias) + "\n" + keyProvider.getUsageName(alias)), (int)buttonTextWidth);
            CertificateQuality aliasQuality = keyProvider.getCertificateQuality(alias);
            if (CertificateQuality.indetermined.equals((Object)this.requiredQuality) || this.requiredQuality.equals((Object)aliasQuality)) {
                this.aliasList.add(new CurvedToggleIconButton("action.alias", buttonLabel, keyProvider.getUsageName(alias), alias));
            }
            if (this.serialnumber == null || this.serialnumber.trim().isEmpty() || !alias.contains(this.serialnumber)) continue;
            this.serialnumberAlias = alias;
            this.serialnumberKeyProvider = keyProvider;
            LOG.info("serialnumber -> in alias gefunden");
            LOG.info("serialnumber param : {}", (Object)this.serialnumber);
            LOG.info("serialnumber alias : {}", (Object)this.serialnumberAlias);
            LOG.debug("serialnumber in card : {}", (Object)this.serialnumberKeyProvider);
        }
        if (this.aliasList.isEmpty()) {
            LOG.warn("F\u00fcr das Signaturniveau -{}- wurde kein passender Alias gefunden, in : {}", (Object)this.requiredQuality, (Object)keyProvider.getIFDName());
            this.removeAllKeyProvidersFromStep();
            this.layoutGui(false);
            this.selectKeyProviderToUseButton();
            return;
        }
        LOG.debug("Alle Alias-Buttons fertigstellen.");
        for (CurvedToggleIconButton button : this.aliasList) {
            String alias = button.getAlias();
            button.setEnabled(true);
            button.setFocusable(true);
            button.setFocusPainted(true);
            button.addActionListener((ActionListener)Document.getInstance().getActionFactory().createAliasSelectionAction((AliasSelectionHandler)this, alias));
        }
    }

    private void layoutIfdPanel() {
        LOG.trace("sign : selectkeys");
        this.updateButtonPanel(this.ifdBorderPanel, this.ifdPanel, this.ifdList, this.ifdScrollPane, "step." + KeyUsage.SIGN.toString().toLowerCase() + ".error.noIfds");
        LOG.debug("Speicherorte-Panel ist aktualisiert.");
    }

    private void updateButtonPanel(JPanel borderPanel, JPanel panel, List<?> buttons, JScrollPane scrollPane, String key) {
        LOG.trace("sign : selectkeys");
        if (borderPanel == null || panel == null || buttons == null || scrollPane == null) {
            throw new IllegalArgumentException("unallowed null value");
        }
        borderPanel.removeAll();
        panel.removeAll();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weighty = 1.0;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.insets = new Insets(5, 5, 5, 0);
        if (buttons.isEmpty()) {
            gbc.weightx = 1.0;
            gbc.insets = new Insets(5, 15, 0, 0);
            panel.add((Component)this.createErrorLabel(key), gbc);
        }
        for (int i = 0; i < buttons.size(); ++i) {
            if (i == 0) {
                gbc.weightx = 0.0;
            }
            if (i == buttons.size() - 1) {
                gbc.weightx = 1.0;
            }
            panel.add((Component)((CurvedToggleIconButton)buttons.get(i)), gbc);
        }
        scrollPane.setViewportView(panel);
        this.adjustScrollPaneSize(scrollPane, scrollPane.getHorizontalScrollBar(), panel);
        borderPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 0, 0, 0);
        borderPanel.add((Component)scrollPane, gbc);
    }

    public void aliasSelected(String alias) {
        LOG.trace("sign : selectkeys");
        if (alias == null) {
            LOG.error("The selected alias was null, it could not be set.");
            return;
        }
        List keyProvidersToUse = this.step.getKeyProviderToUse();
        if (keyProvidersToUse == null || keyProvidersToUse.isEmpty()) {
            LOG.error("An alias was selected without selecting the KeyProvider.");
            this.step.setSelectedKeyProvider(null);
            this.step.setSelectedAlias(null, null);
            this.aliasList.clear();
            this.ifdGroup = new IFDButtonGroup();
            this.updateGui();
            return;
        }
        LOG.debug("Alias was selected : {}", (Object)alias);
        AbstractKeyProvider selectedKeyProvider = null;
        for (KeyProvider keyProvider : keyProvidersToUse) {
            List allAliases = keyProvider.getAllAliases();
            if (allAliases == null || allAliases.isEmpty() || !allAliases.contains(alias)) continue;
            selectedKeyProvider = (AbstractKeyProvider)keyProvider;
        }
        if (selectedKeyProvider != null) {
            this.step.setSelectedKeyProvider(selectedKeyProvider);
            this.step.setSelectedAlias((KeyProvider)selectedKeyProvider, alias);
            LOG.debug("Set Selected KeyProvider : {}", (Object)selectedKeyProvider.getIFDName());
            LOG.debug("Set Selected alias : {}", (Object)alias);
            LOG.debug("is select key complete ? {}", (Object)this.step.isStateComplete());
        }
    }

    private void selectSelectedAlias(KeyProvider keyProvider) {
        LOG.trace("sign : selectkeys : KeyProvider : {}", (Object)keyProvider.getClass().getSimpleName());
        String selectedAlias = keyProvider.getSelectedAlias();
        LOG.trace("Selected Key-Alias : {}", (Object)selectedAlias);
        this.serialnumber = this.checkConfigForCardSerialnumber();
        if (this.serialnumber == null || this.serialnumber.isEmpty()) {
            LOG.warn("sign : selectkeys: Card-serialnumber ist nicht konfiguriert");
        } else {
            this.searchAliasFor(this.serialnumber);
            LOG.debug("serialnumber : -{}-", (Object)this.serialnumber);
        }
        if (selectedAlias == null) {
            if (this.serialnumberAlias != null && !this.serialnumberAlias.trim().isEmpty()) {
                LOG.debug("KeyProvider has no selected alias. Try to get the serialnumber alias ...");
                selectedAlias = this.serialnumberAlias;
                LOG.debug("Set serialnumber alias as selected: {}", (Object)selectedAlias);
            } else {
                LOG.debug("KeyProvider has no selected alias. Try to get the first alias as default ...");
                selectedAlias = keyProvider.getDefaultAlias();
                LOG.debug("Set defaultAlias as selected: {}", (Object)selectedAlias);
            }
            if (selectedAlias != null) {
                this.step.setSelectedAlias(keyProvider, selectedAlias);
                LOG.debug("");
            }
            LOG.debug("step selectkeys complete : {} ", (Object)this.step.isStateComplete());
        }
        String newAlias = null;
        for (CurvedToggleIconButton aliasButton : this.aliasList) {
            newAlias = aliasButton.getAlias();
            if (newAlias == null || !newAlias.equals(selectedAlias)) continue;
            LOG.debug("selecting aliasButton with alias : {}", (Object)selectedAlias);
            aliasButton.setSelected(true);
            boolean complete = this.step.isStateComplete();
            LOG.debug("step selectkeys complete : {} ", (Object)complete);
            if (!complete) continue;
            return;
        }
        if (newAlias == null) {
            return;
        }
        LOG.warn("alias {}{}", (Object)selectedAlias, (Object)" could not be set as selected because it was not found.");
        keyProvider.setSelectedAlias(newAlias);
        this.step.setSelectedAlias(keyProvider, newAlias);
    }

    private void updateAliasPanel() {
        LOG.trace("sign : selectkeys");
        this.updateButtonPanel(this.aliasBorderPanel, this.aliasPanel, this.aliasList, this.aliasScrollPane, "step.sign.error.noAliases");
        List touse = this.step.getKeyProviderToUse();
        if (touse == null || touse.isEmpty()) {
            LOG.debug("KeyProvider getrennt.");
            return;
        }
        LOG.debug("KeyProvider verbunden.");
        KeyProvider selectedKeyProvider = this.step.getSelectedKeyProvider();
        if (selectedKeyProvider == null) {
            LOG.debug("No selected KeyProvider");
            return;
        }
        LOG.debug("SelectedKeyProvider : {}", (Object)selectedKeyProvider.getIFDName());
        this.selectSelectedAlias(selectedKeyProvider);
        this.revalidate();
        this.repaint();
    }

    private void updateIFDButton(IFDCurvedToggleIconButton button) {
        LOG.trace("sign : selectkeys : updateIFDButton ...");
        if (button == null) {
            LOG.warn("IFDCurvedToggleIconButton was null!");
            return;
        }
        if (button.getKeyProviderEntry().getKeyProviderType() == KeyProviderSource.CARD) {
            button.setToolTipText(Messages.getString((String)"selectkeys.ifd.nocard.tooltip"));
        } else if (KeyProviderSource.SOFTWARE.equals((Object)button.getKeyProviderEntry().getKeyProviderType())) {
            button.setToolTipText(this.step.getFromConfigSWProvider());
        }
        button.setVisible(this.isLicenseVisible(button.getKeyProviderEntry()));
        button.setEnabled(this.isLicenseEditable(button.getKeyProviderEntry()));
        LOG.trace("sign : selectkeys : updateIFDButton done.");
    }

    private KeyListener createKeyAdapterFor(final IFDCurvedToggleIconButton button) {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isConsumed()) {
                    return;
                }
                switch (keyEvent.getKeyCode()) {
                    case 9: {
                        if (keyEvent.isShiftDown()) {
                            button.getParent().transferFocusBackward();
                            keyEvent.consume();
                            break;
                        }
                        button.transferFocus();
                        keyEvent.consume();
                        break;
                    }
                    case 39: 
                    case 40: {
                        SelectKeysView.this.ifdGroup.createListFromGroup();
                        IFDCurvedToggleIconButton next = SelectKeysView.this.ifdGroup.getNextFromFocused(button);
                        if (next == null || !next.isVisible() || !next.isEnabled()) {
                            button.transferFocus();
                        } else {
                            next.requestFocus();
                        }
                        keyEvent.consume();
                        break;
                    }
                    case 37: 
                    case 38: {
                        SelectKeysView.this.ifdGroup.createListFromGroup();
                        IFDCurvedToggleIconButton previous = SelectKeysView.this.ifdGroup.getPreviousFromFocused(button);
                        if (previous == null || !previous.isVisible() || !previous.isEnabled()) {
                            button.transferFocusBackward();
                            keyEvent.consume();
                            break;
                        }
                        previous.requestFocus();
                        keyEvent.consume();
                        break;
                    }
                }
            }
        };
    }

    private boolean isLicenseVisible(KeyProviderEntry entry) {
        LOG.trace("sign : selectkeys");
        if (entry == null) {
            return false;
        }
        switch (entry.getKeyProviderType()) {
            case SOFTWARE: {
                return Document.getInstance().getProductFunctions().getLicence(PROCESS_SIGN_KEY_SOFTWARE).isVisible();
            }
            case NET_SIGNER: {
                return Document.getInstance().getProductFunctions().getLicence(PROCESS_SIGN_KEY_SIGNSERVICE).isVisible();
            }
            case BNOTK: {
                return Document.getInstance().getProductFunctions().getLicence(PROCESS_SIGN_KEY_BNOTK).isVisible();
            }
        }
        return true;
    }

    private boolean isLicenseEditable(KeyProviderEntry entry) {
        LOG.trace("sign : selectkeys");
        if (entry == null) {
            return false;
        }
        switch (entry.getKeyProviderType()) {
            case SOFTWARE: {
                LicenceTyp licenceValue = Document.getInstance().getProductFunctions().getLicence(PROCESS_SIGN_KEY_SOFTWARE);
                return licenceValue.isEditable() && !CertificateQuality.qualified.equals((Object)this.requiredQuality);
            }
            case NET_SIGNER: {
                return Document.getInstance().getProductFunctions().getLicence(PROCESS_SIGN_KEY_SIGNSERVICE).isEditable();
            }
            case BNOTK: {
                return Document.getInstance().getProductFunctions().getLicence(PROCESS_SIGN_KEY_BNOTK).isEditable();
            }
        }
        LOG.trace("Licence : CARD = default = editable. Ausser, wenn BNOTK in Einstellungen eingeschaltet.");
        return true;
    }

    protected void removeAllKeyProvidersFromStep() {
        LOG.trace("sign : selectkeys");
        LOG.debug("Removing all KeyProvidersToUse from step...");
        List keyProviderToUse = this.step.getKeyProviderToUse();
        if (keyProviderToUse == null || keyProviderToUse.isEmpty()) {
            LOG.trace("No KeyProviderToUse.");
            return;
        }
        for (KeyProvider keyProvider : keyProviderToUse) {
            this.step.removeKeyProviderToUse(keyProvider);
        }
        LOG.trace("All KeyProvidersToUse were removed from step.");
    }

    public void stateChanged(ChangeEvent event) {
        LOG.trace("sign : selectkeys");
        this.updateGui();
        this.skipStep.stateChanged(null);
    }

    private void updateGui() {
        LOG.trace("sign : selectkeys : update GUI ...");
        for (IFDCurvedToggleIconButton button : this.ifdList) {
            if (button.getKeyProviderEntry().getKeyProviderType() != KeyProviderSource.SOFTWARE) continue;
            button.setEnabled(this.isLicenseEditable(button.getKeyProviderEntry()));
        }
        List touse = this.step.getKeyProviderToUse();
        if (touse == null || touse.isEmpty()) {
            LOG.debug("KeyProvider getrennt.");
            this.aliasList.clear();
            this.layoutGui(false);
            return;
        }
        LOG.debug("KeyProvider verbunden.");
        KeyProvider keyProvider = this.getSelectedKeyProvider();
        if (keyProvider == null) {
            LOG.debug("No selected KeyProvider was found.");
            this.removeAllKeyProvidersFromStep();
            this.aliasList.clear();
            this.layoutGui(false);
        } else {
            LOG.debug("Selected KeyProvider found : {}", (Object)keyProvider.getIFDName());
            this.updateAndShowAliasPanel();
        }
        this.selectKeyProviderToUseButton();
        LOG.trace("... updateGui done.");
    }

    public Certificate getSelectedCertificate() {
        return null;
    }

    public KeyProvider getSelectedKeyProvider() {
        LOG.trace("sign : selectkeys");
        if (this.step.getSelectedKeyProvider() != null) {
            return this.step.getSelectedKeyProvider();
        }
        this.serialnumber = this.checkConfigForCardSerialnumber();
        if (this.serialnumber == null || this.serialnumber.isEmpty()) {
            LOG.warn("sign : selectkeys: Card-serialnumber ist nicht konfiguriert");
        }
        List keyProviderToUse = this.step.getKeyProviderToUse();
        for (KeyProvider keyProvider : keyProviderToUse) {
            LOG.debug("KeyProvider to use found : {}", (Object)keyProvider.getIFDName());
            List allAliases = keyProvider.getAllAliases();
            for (String alias : allAliases) {
                if (!alias.contains(this.serialnumber)) continue;
                LOG.info("Alias mit serialnumber gefunden : {}", (Object)this.serialnumber);
                this.serialnumberAlias = alias;
                this.serialnumberKeyProvider = keyProvider;
                LOG.debug(this.serialnumberKeyProvider.getIFDName());
                return this.serialnumberKeyProvider;
            }
        }
        if (keyProviderToUse == null || keyProviderToUse.isEmpty()) {
            LOG.trace("No keyProviderToUse.");
            return null;
        }
        LOG.debug("No key provider was selected. Use the first of the existing one: {}", (Object)((KeyProvider)keyProviderToUse.get(0)).getIFDName());
        return (KeyProvider)keyProviderToUse.get(0);
    }

    private void selectKeyProviderToUseButton() {
        LOG.trace("sign : selectkeys");
        LOG.trace("Select KeyProvider to use button ... ");
        KeyProvider selectedKeyProvider = this.step.getSelectedKeyProvider();
        if (selectedKeyProvider != null) {
            LOG.trace("Selected KeyProvider : {}", (Object)selectedKeyProvider.getIFDName());
            LOG.trace("Selected Alias ? : {}", (Object)selectedKeyProvider.getSelectedAlias());
            this.ifdGroup.clearSelection();
            for (IFDCurvedToggleIconButton button : this.ifdList) {
                LOG.trace("button : {}", (Object)button.getText());
                if (button.getIfdTag() == null || !button.getIfdTag().equals(selectedKeyProvider.getIFDName())) continue;
                LOG.trace("Selected Speicherort : {}", (Object)button.getIfdTag());
                this.ifdGroup.setSelected(button.getModel(), true);
                button.requestFocus();
                if (!this.step.isStateComplete()) continue;
                LOG.trace("step selectkeys complete : true");
                return;
            }
            LOG.warn("Kein passender Alias f\u00fcr Signaturniveau -{}- in -{}- gefunden.", (Object)this.requiredQuality, (Object)selectedKeyProvider.getIFDName());
        } else {
            LOG.trace("No selected KeyProvider...");
        }
        List keyProviderToUse = this.step.getKeyProviderToUse();
        if (keyProviderToUse == null || keyProviderToUse.isEmpty()) {
            this.ifdGroup.clearSelection();
            this.aliasList.clear();
            switch (this.ifdList.size()) {
                case 1: {
                    IFDCurvedToggleIconButton button;
                    LOG.debug("1 Speicherort : {}", (Object)this.ifdList.get(0).getText());
                    button = this.ifdList.get(0);
                    if (!button.isKeySourceCard() || !button.isEnabled() || !button.isVisible() || !button.isFocusable()) break;
                    this.ifdGroup.setSelected(button.getModel(), true);
                    break;
                }
                case 2: {
                    if (this.requiredQuality == CertificateQuality.qualified) {
                        LOG.debug("2 Speicherorte : Q Leseger\u00e4t : {}", (Object)this.ifdList.get(1).getText());
                        this.ifdGroup.setSelected(this.ifdList.get(1).getModel(), true);
                        break;
                    }
                    LOG.debug("2 Speicherorte. Bitte w\u00e4hlen Sie eins aus.");
                    break;
                }
                default: {
                    LOG.debug("{} Speicherorte. Bitte w\u00e4hlen Sie eins aus.", (Object)this.ifdList.size());
                }
            }
        }
    }

    private void adjustScrollPaneSize(JScrollPane scrollPane, JScrollBar scrollBar, JPanel panel) {
        Dimension preferredPanelSize = panel.getPreferredSize();
        int height = (int)preferredPanelSize.getHeight();
        height = (int)((double)height + scrollBar.getPreferredSize().getHeight());
        scrollPane.setMinimumSize(new Dimension((int)preferredPanelSize.getWidth(), height));
        scrollPane.setPreferredSize(scrollPane.getMinimumSize());
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        JScrollBar scrollBar = (JScrollBar)e.getSource();
        if (scrollBar.equals(this.aliasScrollPane.getHorizontalScrollBar())) {
            this.adjustScrollPaneSize(this.aliasScrollPane, scrollBar, this.aliasPanel);
        } else if (scrollBar.equals(this.ifdScrollPane.getHorizontalScrollBar())) {
            this.adjustScrollPaneSize(this.ifdScrollPane, scrollBar, this.ifdPanel);
        }
    }

    public void aliasWasSelected() {
        LOG.trace("sign : selectkeys : nohing to do");
        LOG.warn("The aliasWasSelected method should not be called in this class as it is not implemented!");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        LOG.trace("sign : selectkeys");
        this.reinitGUI();
    }

    private void reinitGUI() {
        LOG.trace("sign : selectkeys");
        this.initGui();
        this.layoutGui(false);
        this.updateIfdList();
        this.layoutIfdPanel();
        this.updateGui();
        JComponentUtils.setLookByLicence((JComponent)this, (LicenceTyp)this.step.getLicenceTyp());
    }

    public SkippableStep getSkippableStep() {
        return this.step;
    }

    public boolean getSkipStep() {
        return this.step.skipStep();
    }

    public void setSkipStep(boolean skip) {
        LOG.trace("sign : selectkeys : {}", (Object)skip);
        this.step.skipStep(skip);
    }

    public boolean isStepComplete() {
        LOG.trace("sign : selectkeys");
        return this.step.isStateComplete();
    }

    public void setActive(boolean active) {
        LOG.trace("sign : selectkeys : active : {}", (Object)active);
        if (!active) {
            return;
        }
        LOG.info("\n---------------- Signieren/'Schl\u00fcssel w\u00e4hlen' ... ---------------------------");
        if (this.step.isStateComplete() && this.skipStep.isSkipStepEnabled()) {
            return;
        }
        LOG.trace("sign : selectkeys : uncomplete...");
        this.keyStore = this.checkConfigForSWkey();
        if (this.keyStore == null) {
            LOG.info("sign : selectkeys : kein Keystore ist konfiguriert");
        } else if (this.swKey.isAutoload()) {
            LOG.debug("autoload -> loadKeyStoreFromXMLProperties...");
            this.loadKeyStoreFromXMLProperties();
        } else {
            LOG.debug("load KeyStore wurde abgebrochen -> autoload = false");
        }
        if (this.step.isStateComplete() && this.skipStep.isSkipStepEnabled()) {
            return;
        }
        LOG.trace("sign : selectkeys : uncomplete...");
        LOG.info("Suchen Alias f\u00fcr Serialnumber ...");
        this.serialnumber = this.checkConfigForCardSerialnumber();
        if (this.serialnumber != null && !this.serialnumber.trim().isEmpty()) {
            LOG.info("serialnumber parameter : {}", (Object)this.serialnumber);
            this.searchAliasFor(this.serialnumber);
            LOG.debug("selected card  : {}", (Object)this.serialnumberKeyProvider);
            LOG.info("selected card alias : {}", (Object)this.serialnumberAlias);
        } else {
            LOG.trace("serialnumber: kein ist konfiguriert.");
        }
        if (this.step.isStateComplete() && this.skipStep.isSkipStepEnabled()) {
            return;
        }
        LOG.trace("sign : selectkeys : uncomplete...");
        SwingUtilities.invokeLater(() -> {
            LOG.trace("sign : selectkeys");
            if (this.step.isStateComplete() && this.skipStep.isSkipStepEnabled()) {
                LOG.debug("step : selectkeys : complete.");
                return;
            }
            LOG.debug("sign : selectkeys : uncomplete");
            if (this.keyStore == null && this.swKey.isAutoload()) {
                this.keyStore = this.checkConfigForSWkey();
            }
            if (this.serialnumber == null || this.serialnumber.trim().isEmpty()) {
                this.serialnumber = this.checkConfigForCardSerialnumber();
            } else {
                this.searchAliasFor(this.serialnumber);
            }
            if (this.step.isStateComplete() && this.skipStep.isSkipStepEnabled()) {
                LOG.trace("step : selectkeys : complete.");
            } else {
                LOG.trace("sign : selectkeys : uncomplete");
            }
            LOG.debug("Speicherorte = {}", (Object)this.ifdList.size());
            for (IFDCurvedToggleIconButton button : this.ifdList) {
                LOG.debug("Speicherort = {}", (Object)button.getText());
                if (this.keyStore == null && (this.serialnumber == null || this.serialnumber.trim().isEmpty())) {
                    LOG.debug("-Keine- Einstellungen f\u00fcr Schl\u00fcsselauswahl konfiguriert.");
                    if (this.ifdList.size() == 1 && button.isKeySourceSW() && button.isEnabled() && button.isVisible() && button.isFocusable()) {
                        this.ifdGroup.setSelected(button.getModel(), true);
                        break;
                    }
                    if (this.ifdList.size() > 2 || !button.isKeySourceCard() || !button.isEnabled() || !button.isVisible() || !button.isFocusable()) continue;
                    LOG.debug("Boreum selektiert Signaturkarte vor.");
                    this.ifdGroup.setSelected(button.getModel(), true);
                    button.doClick();
                    this.nextUncompleteStep();
                    break;
                }
                if (this.keyStore != null && button.isKeySourceSW() && button.isEnabled() && button.isVisible() && button.isFocusable()) {
                    LOG.debug("-keystore- Boreum selektiert 'Schl\u00fcssel aus Datei' : {}", (Object)this.keyStore);
                    if (!this.swKey.isAutoload()) {
                        LOG.trace("keyStore nicht autoload...");
                        continue;
                    }
                    LOG.trace("keyStore autoload...");
                    this.ifdGroup.setSelected(button.getModel(), true);
                    LOG.debug("selected key provider : {}", (Object)this.step.getSelectedKeyProvider());
                    if (!this.step.isStateComplete()) {
                        LOG.debug("keyStore laden...");
                        boolean stepUsePinCache = this.step.isUsePinCache();
                        this.swKey.setUsePinCache(stepUsePinCache);
                        if (stepUsePinCache) {
                            LOG.trace("pinCacheKeyStore : {}", (Object)(this.pinCacheKeyStore == null ? "wird nicht gemerkt" : "wurde gemerkt."));
                            this.swKey.setPinCache(this.pinCacheKeyStore);
                        }
                        LOG.trace("PIN-Dialog -> updateGUI...");
                        this.swKey.setFileToLoad(this.keyStore.toFile());
                        if (this.swKey.isUsePinCache()) {
                            LOG.trace("Merke PIN vom Dialog...");
                            this.pinCacheKeyStore = this.swKey.getPinCache();
                            LOG.trace("pinCacheKeyStore : {}", (Object)(this.pinCacheKeyStore == null ? "wurde nicht gemerkt" : "wurde gemerkt."));
                        }
                        if (!this.step.isStateComplete()) {
                            LOG.trace("sign : selectkeys : uncomplete");
                        }
                        this.nextUncompleteStep();
                        break;
                    }
                    LOG.debug("complete : Keystore ist geladen.");
                    break;
                }
                if (this.serialnumber != null && !this.serialnumber.trim().isEmpty() && button.isKeySourceCard() && button.isEnabled() && button.isVisible() && button.isFocusable()) {
                    LOG.debug("-serialnumber- Boreum selektiert Card.");
                    this.ifdGroup.setSelected(button.getModel(), true);
                    button.doClick();
                    this.nextUncompleteStep();
                    break;
                }
                if (CertificateQuality.qualified.equals((Object)this.requiredQuality) && button.isKeySourceCard() && button.isEnabled() && button.isVisible() && button.isFocusable()) {
                    LOG.debug("Signaturniveau = Q + Card");
                    this.ifdGroup.setSelected(button.getModel(), true);
                    button.doClick();
                    this.nextUncompleteStep();
                    break;
                }
                LOG.debug("Boreum trifft keine Vorselektion f\u00fcr Kombination: \nSignaturniveau : {} und \nSpeicherort : {}", (Object)this.requiredQuality, (Object)button.getKeyProviderEntry().getKeyProviderType());
            }
            LOG.debug("step selectkeys complete+skip : {}", (Object)(this.step.isStateComplete() && this.skipStep.isSkipStepEnabled() ? 1 : 0));
            LOG.info("\n---------------- Signieren/'Schluessel waehlen' : ausgewaehlt. ---------------------------");
        });
    }

    private void nextUncompleteStep() {
        if (this.step.isStateComplete()) {
            switch (this.step.getProcessPolicy()) {
                case skipCompletedStep: 
                case lastStep: 
                case runProcess: {
                    LOG.trace((Object)this.step.getProcessPolicy());
                    this.step.getParent().nextUncompleteStep();
                    break;
                }
                default: {
                    LOG.trace((Object)this.step.getProcessPolicy());
                }
            }
        }
    }

    public KeyUsage getKeyUsage() {
        LOG.trace("sign : selectkeys : SIGN");
        return KeyUsage.SIGN;
    }

    @Override
    public void requestFocus() {
    }

    public void terminalAdded(TerminalModel terminal) {
        LOG.trace("sign : selectkeys");
        this.reinitGUI();
    }

    public void terminalRemoved(TerminalModel terminal) {
        LOG.trace("sign : selectkeys");
        this.reinitGUI();
    }

    public void selectAlias(AbstractKeyProvider keyProvider) {
        LOG.trace("sign : selectkeys");
        LOG.debug("Set Selected KeyProvider : {}", (Object)keyProvider.getIFDName());
        this.step.setSelectedKeyProvider(keyProvider);
    }

    private void searchAliasFor(String serialnumber) {
        LOG.trace("sign : selectkeys : {}", (Object)serialnumber);
        if (serialnumber == null || serialnumber.trim().isEmpty()) {
            return;
        }
        List keyProvidersToUse = this.step.getKeyProviderToUse();
        if (keyProvidersToUse == null || keyProvidersToUse.isEmpty()) {
            LOG.trace("No keyProvidersToUse.");
            return;
        }
        for (KeyProvider keyProvider : keyProvidersToUse) {
            LOG.debug("KeyProvider to use gefunden {}", (Object)keyProvider.getIFDName());
            List allAliases = keyProvider.getAllAliases();
            for (String alias : allAliases) {
                LOG.debug("Alias : {}", (Object)alias);
                if (!alias.contains(serialnumber)) continue;
                LOG.info("Alias mit serialnumber gefunden : {}", (Object)serialnumber);
                this.serialnumberAlias = alias;
                this.serialnumberKeyProvider = keyProvider;
                LOG.info("... in {}", (Object)this.serialnumberKeyProvider.getIFDName());
                return;
            }
        }
    }

    private boolean isKeyEntry(KeyProvider keyProvider, String alias) {
        LOG.debug("KeyProvider ({})", (Object)keyProvider.getIFDName());
        try {
            if (keyProvider.getKeyStore().isKeyEntry(alias)) {
                return true;
            }
            LOG.error("Alias ({}) ist kein privater Schl\u00fcssel", (Object)alias);
            return false;
        }
        catch (KeyStoreException e) {
            LOG.error("Alias ({}) ist kein privater Schl\u00fcssel", (Object)alias);
            return false;
        }
    }

    private String checkConfigForCardSerialnumber() {
        return this.step.getSerialnumber();
    }

    private Path checkConfigForSWkey() {
        return this.step.getSWkeyStore();
    }

    protected class IFDButtonGroup
    extends ButtonGroup {
        private static final long serialVersionUID = -7499109778321269525L;
        private List<IFDCurvedToggleIconButton> listFromGroup;

        protected IFDButtonGroup() {
        }

        protected void createListFromGroup() {
            this.listFromGroup = new ArrayList<IFDCurvedToggleIconButton>(this.getButtonCount());
            Enumeration<AbstractButton> elements = this.getElements();
            int ifdListIndex = -1;
            while (elements.hasMoreElements()) {
                IFDCurvedToggleIconButton button = (IFDCurvedToggleIconButton)elements.nextElement();
                button.setId(++ifdListIndex);
                this.listFromGroup.add(button);
            }
        }

        protected IFDCurvedToggleIconButton getNextFromFocused(IFDCurvedToggleIconButton focused) {
            if (focused.getId() == this.listFromGroup.size() - 1) {
                return this.listFromGroup.get(0);
            }
            return this.listFromGroup.get(focused.getId() + 1);
        }

        protected IFDCurvedToggleIconButton getPreviousFromFocused(IFDCurvedToggleIconButton focused) {
            if (focused.getId() == 0) {
                return this.listFromGroup.get(this.listFromGroup.size() - 1);
            }
            return this.listFromGroup.get(focused.getId() - 1);
        }
    }
}

