/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.gui.step;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.DropSelectedFileHandler;
import de.bos_bremen.ecard.client.action.RemoveFileHandler;
import de.bos_bremen.ecard.client.action.SelectedFileHandler;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.control.process.ProcessName;
import de.bos_bremen.ecard.client.control.step.StepChangedListener;
import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import de.bos_bremen.ecard.client.gui.view.component.DescriptionPanel;
import de.bos_bremen.ecard.client.gui.view.component.JComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButton;
import de.bos_bremen.ecard.client.gui.view.component.table.FileDropTargetHandler;
import de.bos_bremen.ecard.client.gui.view.component.table.processfile.ProcessFileTableFactory;
import de.bos_bremen.ecard.client.gui.view.component.table.processfile.ProcessFileTableI;
import de.bos_bremen.ecard.client.gui.view.component.table.processfile.ProcessFileTableListenerFactory;
import de.bos_bremen.ecard.client.gui.view.component.table.processfile.ProcessFileTableModelI;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.ProcessSignedFile;
import de.bos_bremen.ecard.client.model.SignatureType;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.sign.control.process.impl.SignProcess;
import de.bos_bremen.ecard.client.sign.control.step.SelectFiles;
import de.bos_bremen.ecard.client.sign.gui.SignProcessHelper;
import de.bos_bremen.ecard.client.sign.model.formular.process.SignProcessFormular;
import de.bos_bremen.ecard.client.sign.model.formular.process.impl.SignFormular;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SelectFilesView
extends JPanel
implements StepChangedListener,
DropSelectedFileHandler,
RemoveFileHandler,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger(SelectFilesView.class);
    private final transient SelectFiles signSelectFilesStep;
    private DescriptionPanel descPanel;
    private transient ProcessFileTableI processFileTable;

    public SelectFilesView(SelectFiles selectFiles) {
        LOG.trace("sign : selectfiles");
        this.signSelectFilesStep = selectFiles;
        this.initGUI();
        this.signSelectFilesStep.addStateChangeListener(this);
        LocaleChanger.getInstance().addObserver((PropertyChangeListener)this);
    }

    private void initGUI() {
        LOG.trace("sign : selectfiles");
        this.setLayout(new BorderLayout());
        this.descPanel = new DescriptionPanel("sign.step.selectfiles");
        this.add((Component)this.descPanel, "North");
        this.processFileTable = ProcessFileTableFactory.createProcessFileTable((ProcessName)this.signSelectFilesStep.getParent().getProcessName());
        ((JTable)this.processFileTable).addMouseListener(ProcessFileTableListenerFactory.createProcessFileTableMouseListener((ProcessI)this.signSelectFilesStep.getParent()));
        ((JTable)this.processFileTable).addKeyListener(ProcessFileTableListenerFactory.createProcessFileTableKeyListener((ProcessI)this.signSelectFilesStep.getParent()));
        ((JTable)this.processFileTable).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                LOG.trace("sign : selectfiles");
                LOG.trace("event {}", (Object)keyEvent);
                if (keyEvent.isConsumed()) {
                    return;
                }
                if (keyEvent.getKeyCode() == 10) {
                    keyEvent.consume();
                }
            }
        });
        final JScrollPane scrollPane = new JScrollPane((JTable)this.processFileTable);
        scrollPane.setBorder((Border)CurvedBorder.createDefault());
        ((JTable)this.processFileTable).addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                scrollPane.setBorder((Border)CurvedBorder.FOCUSED_BORDER);
            }

            @Override
            public void focusLost(FocusEvent e) {
                scrollPane.setBorder((Border)CurvedBorder.DEFAULT_BORDER);
            }
        });
        String mnemonic = Messages.getResource((String)"view.step.sign.selectfiles.list.header.mnemonic");
        if (mnemonic != null) {
            KeyStroke ks = KeyStroke.getKeyStroke("alt " + mnemonic.charAt(0));
            int condition = 2;
            scrollPane.getInputMap(condition).put(ks, "selectTable");
        }
        scrollPane.getActionMap().put("selectTable", new SetFocusOnTableAction());
        this.add((Component)scrollPane, "Center");
        new DropTarget(scrollPane, (DropTargetListener)new FileDropTargetHandler((DropSelectedFileHandler)this));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(2, 1));
        this.add((Component)buttonPanel, "West");
        Document documentInstance = Document.getInstance();
        IconButton selectFilesButtonAdd = new IconButton();
        selectFilesButtonAdd.setAction(documentInstance.getActionFactory().createSelectFile((SelectedFileHandler)this, "action.selectfile", 0, true, true));
        if (documentInstance.getProductFunctions().getLicence(this.signSelectFilesStep.getLicenceTypKey() + "/addfiles").isVisible()) {
            buttonPanel.add((Component)selectFilesButtonAdd);
            selectFilesButtonAdd.getAction().setEnabled(documentInstance.getProductFunctions().getLicence(this.signSelectFilesStep.getLicenceTypKey() + "/addfiles").isEditable());
        }
        IconButton selectFilesButtonRemove = new IconButton();
        selectFilesButtonRemove.setAction(documentInstance.getActionFactory().createRemoveFile((RemoveFileHandler)this, "action.removefile"));
        KeyStroke deleteKeyStroke = KeyStroke.getKeyStroke("DELETE");
        this.getInputMap(1).put(deleteKeyStroke, "deleteAction");
        this.getActionMap().remove("deleteAction");
        this.getActionMap().put("deleteAction", selectFilesButtonRemove.getAction());
        if (documentInstance.getProductFunctions().getLicence(this.signSelectFilesStep.getLicenceTypKey() + "/removefiles").isVisible()) {
            buttonPanel.add((Component)selectFilesButtonRemove);
            selectFilesButtonRemove.getAction().setEnabled(documentInstance.getProductFunctions().getLicence(this.signSelectFilesStep.getLicenceTypKey() + "/removefiles").isEditable());
        }
        if (!documentInstance.getProductFunctions().getLicence(this.signSelectFilesStep.getLicenceTypKey()).useInProcess()) {
            this.signSelectFilesStep.removeAllFiles();
        }
        this.stateChanged(null);
        JComponentUtils.setLookByLicence((JComponent)this, (LicenceTyp)this.signSelectFilesStep.getLicenceTyp());
    }

    public void stateChanged(ChangeEvent event) {
        LOG.trace("");
        ((ProcessFileTableModelI)this.processFileTable.getModel()).setDataVector(this.signSelectFilesStep.getFiles().toArray());
        this.processFileTable.setColumnWidth();
    }

    public File getLastFolder() {
        LOG.trace("");
        String lastUsedFolder = this.signSelectFilesStep.getApplicationProperties().getProperty("last_folder", null);
        File lastFolder = null;
        if (lastUsedFolder != null) {
            lastFolder = new File(lastUsedFolder);
        }
        return lastFolder;
    }

    public void setFileToLoad(File fileToLoad) {
        LOG.trace("");
        if (fileToLoad == null) {
            return;
        }
        if (!fileToLoad.isFile()) {
            LOG.warn("({}) is not a file", (Object)fileToLoad.getName());
            return;
        }
        if (this.fileExists(fileToLoad)) {
            LOG.warn("{} is exists", (Object)fileToLoad.getName());
            return;
        }
        ProcessSignedFile processFile = SelectFilesView.createProcessSignedFile(fileToLoad, (SignFormular)((SignProcess)this.signSelectFilesStep.getParent()).getProcessFormular());
        this.signSelectFilesStep.addFile(processFile);
        this.signSelectFilesStep.setApplicationProperty("last_folder", fileToLoad.getAbsolutePath());
    }

    public void setFilesToLoad(File[] filesToLoad) {
        LOG.trace("");
        if (filesToLoad == null || filesToLoad.length == 0) {
            LOG.trace("File ist null oder leer");
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        for (File file : filesToLoad) {
            try {
                this.setFileToLoad(file);
            }
            catch (OutOfMemoryError e) {
                LOG.error("", (Throwable)e);
                LOG.error("Die Datei '{}' mit einer Gr\u00f6\u00dfe von '{}' konnte nicht hinzugef\u00fcgt werden.", (Object)file.getName(), (Object)FileUtils.byteCountToDisplaySize((long)file.length()));
                LOG.warn("Der Standardparameter -Xmx2048M f\u00fcr die Java Virtual Mashine (JVM) in Ihrem Boreum ist f\u00fcr Ihre Zwecke zu klein.");
                LOG.info("Passen Sie den Parameter -Xmx f\u00fcr die JVM in der INI-Datei an.");
                LOG.info("Z. B. \u00e4ndern Sie -Xmx2048M in -Xmx3G. Siehe dazu die Erste Hilfe in der Dokumentation oder wenden Sie sich an den Support.");
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public LicenceTyp getLicenceTyp() {
        LOG.trace("");
        return Document.getInstance().getProductFunctions().getLicence(this.signSelectFilesStep.getLicenceTypKey() + "/addfiles");
    }

    public static ProcessSignedFile createProcessSignedFile(File file, SignProcessFormular signFormular) {
        ProcessSignedFile psf = new ProcessSignedFile(file);
        File signatureFile = new File(file.getAbsoluteFile() + ".p7s");
        if (signatureFile.exists()) {
            if (!SignProcessHelper.checkCMSDetachedMatch(file, signatureFile)) {
                return psf;
            }
            LOG.trace("Dialog cms.sign.multiple ...");
            if (Document.getInstance().showOptionDialog(null, "cms.sign.multiple", 2, -1) == 0) {
                signFormular.setSignatureType(SignatureType.detachedPKCS7);
                psf = new ProcessSignedFile(signatureFile);
                psf.setDetachedFile(file);
                psf.multipleCmsSignatures = true;
            }
        }
        return psf;
    }

    private boolean fileExists(File file) {
        LOG.trace("exists?");
        String absoluteName = file.getAbsolutePath();
        List<ProcessSignedFile> files = this.signSelectFilesStep.getFiles();
        for (ProcessSignedFile pfs : files) {
            if (!pfs.getFile().getAbsolutePath().equals(absoluteName)) continue;
            LOG.trace("true");
            return true;
        }
        return false;
    }

    public Object[] getFilesToRemove() {
        LOG.trace("");
        int[] selectedRows = this.processFileTable.getSelectedValues();
        Object[] objectsToRemove = new Object[selectedRows.length];
        List<ProcessSignedFile> alleFiles = this.signSelectFilesStep.getFiles();
        for (int i = 0; i < selectedRows.length; ++i) {
            objectsToRemove[i] = alleFiles.get(selectedRows[i]);
        }
        return objectsToRemove;
    }

    public void removeFiles(Object[] files) {
        LOG.debug("removeFiles for {} elemente", (Object)files.length);
        for (Object obj : files) {
            if (!(obj instanceof ProcessSignedFile)) continue;
            ProcessSignedFile processSignedFile = (ProcessSignedFile)obj;
            this.signSelectFilesStep.removeFile(processSignedFile);
            LOG.debug("removeFile : {}", (Object)processSignedFile.getFile().getName());
        }
        this.processFileTable.clearSelection();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        LOG.trace("sign : selectfiles");
        LOG.trace("PropertyChangeEvent : {}", (Object)evt);
        this.removeAll();
        this.initGUI();
        this.revalidate();
    }

    public void setActive(boolean active) {
        LOG.trace("sign : selectfiles : {}", (Object)active);
        LOG.info("\n------------------------- Signieren/Dateiauswahl : ausgew\u00e4hlt ----------------------------");
    }

    public DescriptionPanel getDescPanel() {
        return this.descPanel;
    }

    public static void main(String[] args) {
        LOG.trace("Dialog cms.sign.multiple ...");
        Document.getInstance().showOptionDialog(null, "cms.sign.multiple", 2, -1);
    }

    private class SetFocusOnTableAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent arg0) {
            SelectFilesView.this.processFileTable.requestFocusInWindow();
            ((JTable)SelectFilesView.this.processFileTable).getSelectionModel().setSelectionInterval(0, 0);
        }
    }
}

