/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.gui.step;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.control.process.ProcessName;
import de.bos_bremen.ecard.client.control.step.SkippableStep;
import de.bos_bremen.ecard.client.control.step.StepChangedListener;
import de.bos_bremen.ecard.client.gui.SignerTheme;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.DescriptionPanel;
import de.bos_bremen.ecard.client.gui.view.component.GridBagPanel;
import de.bos_bremen.ecard.client.gui.view.component.JComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.gui.view.component.SkipStepHandler;
import de.bos_bremen.ecard.client.gui.view.component.SkipStepPanel;
import de.bos_bremen.ecard.client.gui.view.component.buttons.AccessibleRadioButton;
import de.bos_bremen.ecard.client.gui.view.component.buttons.LinkButton;
import de.bos_bremen.ecard.client.gui.view.component.label.AccessibleJLabel;
import de.bos_bremen.ecard.client.gui.view.component.textfields.MaximumLengthTextField;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.PDFSignatureType;
import de.bos_bremen.ecard.client.model.SignatureType;
import de.bos_bremen.ecard.client.model.XMLSignatureType;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.model.licence.ProductFunctions;
import de.bos_bremen.ecard.client.sign.control.process.impl.SignConfig;
import de.bos_bremen.ecard.client.sign.control.step.Options;
import de.bos_bremen.ecard.client.sign.template.SignatureFieldTemplate;
import de.bos_bremen.ecard.client.sign.template.SignatureFieldTemplateList;
import de.bos_bremen.ecard.client.sign.template.SignatureFieldTemplateListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OptionsView
extends JPanel
implements StepChangedListener,
ActionListener,
PropertyChangeListener,
SkipStepHandler,
SignatureFieldTemplateListener {
    private static final long serialVersionUID = 7714148398331454936L;
    private static final Logger LOG = LogManager.getLogger(OptionsView.class);
    private final transient Options signOptionsStep;
    private AccessibleRadioButton nonePDFInline;
    private AccessibleRadioButton enablePDFInline;
    private LinkButton visualPDFSignatureOptions;
    private AccessibleRadioButton noneXMLInline;
    private AccessibleRadioButton enableXMLInline;
    private AccessibleRadioButton pkcs7enveloped;
    private AccessibleRadioButton pkcs7detached;
    private SkipStepPanel skipStepPanel;
    private LinkButton timestampProvider;
    private JCheckBox timestampLabel;
    private JLabel locationLabel;
    private JTextField pdfLocation;
    private JLabel reasonLabel;
    private JTextField pdfReason;
    private JLabel templateLabel;
    private JComboBox<SignatureFieldTemplate> templateList;
    private JLabel timestampServerError;
    private Font errorFont;
    private LicenceTyp pkcs7envelopedLicenceType;
    private LicenceTyp pkcs7detachLicenceTyp;
    private LicenceTyp osciLicenceTyp;
    private LicenceTyp pdfInlineLicenceTyp;
    private LicenceTyp xmlInlineLicenceTyp;
    private LicenceTyp extendedPDFLicenceTyp;
    private LicenceTyp extendedResonPDFLicenceTyp;
    private static final String PROCESS_SIGN_OPTIONS = "process/sign/options";

    public OptionsView(Options signOptions) {
        this.signOptionsStep = signOptions;
        this.createComponents();
        this.initGUI();
        this.signOptionsStep.addStateChangeListener(this);
        LocaleChanger.getInstance().addObserver((PropertyChangeListener)this);
    }

    private void createComponents() {
        this.readLicenceTyp();
        this.pkcs7enveloped = new AccessibleRadioButton(Messages.getString((String)"step.options.signaturetyp.cades.enveloped"));
        this.pkcs7detached = new AccessibleRadioButton(Messages.getString((String)"step.options.signaturetyp.cades.detached"));
        this.nonePDFInline = new AccessibleRadioButton(Messages.getString((String)"step.options.signaturetyp.pades.none"));
        this.enablePDFInline = new AccessibleRadioButton(Messages.getString((String)"step.options.signaturetyp.pades.enabled"));
        this.noneXMLInline = new AccessibleRadioButton(Messages.getString((String)"step.options.signaturetyp.xades.none"));
        this.enableXMLInline = new AccessibleRadioButton(Messages.getString((String)"step.options.signaturetyp.xades.enabled"));
        this.visualPDFSignatureOptions = new LinkButton(Messages.getString((String)"step.options.signaturetyp.pades.advanced.optionlink"));
        this.visualPDFSignatureOptions.setMnemonic(Messages.getString((String)"step.options.signaturetyp.pades.advanced.optionlink.mnemonic").charAt(0));
        InputMap inputMap = this.visualPDFSignatureOptions.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(this.visualPDFSignatureOptions.getMnemonic(), 512), "visualPdfConfigure");
        ActionMap actionMap = this.visualPDFSignatureOptions.getActionMap();
        actionMap.put("visualPdfConfigure", new VisualPdfConfigureAction());
        this.visualPDFSignatureOptions.setToolTipText(Messages.getString((String)"step.options.signaturetyp.pades.advanced.optionlink.tooltip"));
        JPanel visualPdfPanel = new JPanel(new FlowLayout(2, 0, 0));
        visualPdfPanel.add((Component)this.visualPDFSignatureOptions);
        this.visualPDFSignatureOptions.setFocusPainted(false);
        this.visualPDFSignatureOptions.setBackground(Color.WHITE);
        this.visualPDFSignatureOptions.addFocusListener(ComponentUtils.createFocusListenerFor((JPanel)visualPdfPanel));
        this.visualPDFSignatureOptions.addMouseListener((MouseListener)ComponentUtils.createMouseAdapterForLink((LinkButton)this.visualPDFSignatureOptions));
        this.visualPDFSignatureOptions.addActionListener((ActionListener)new VisualPdfConfigureAction());
        this.createButtonGroups();
        this.pkcs7enveloped.addActionListener((ActionListener)this);
        this.pkcs7detached.addActionListener((ActionListener)this);
        this.nonePDFInline.addActionListener((ActionListener)this);
        this.enablePDFInline.addActionListener((ActionListener)this);
        this.noneXMLInline.addActionListener((ActionListener)this);
        this.enableXMLInline.addActionListener((ActionListener)this);
        this.timestampLabel = new JCheckBox(Messages.getString((String)"step.options.inserttimestamp.label"));
        this.timestampLabel.addActionListener(this);
        ComponentUtils.layoutCheckbox((JCheckBox)this.timestampLabel);
        this.timestampProvider = new LinkButton(Messages.getString((String)"step.options.inserttimestamp.timestampprovider"));
        this.timestampProvider.setMnemonic(Messages.getString((String)"step.options.methods.verificationprovider.mnemonic").charAt(0));
        inputMap = this.timestampProvider.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(this.timestampProvider.getMnemonic(), 512), "timestampConfigure");
        actionMap = this.timestampProvider.getActionMap();
        actionMap.put("timestampConfigure", new TimestampProviderConfigureAction());
        this.timestampProvider.setToolTipText(Messages.getString((String)"step.options.inserttimestamp.timestampprovider.tooltip"));
        this.timestampProvider.setHorizontalAlignment(4);
        this.timestampProvider.addActionListener((ActionListener)new TimestampProviderConfigureAction());
        JPanel timestampProviderPanel = new JPanel(new FlowLayout(2, 0, 0));
        timestampProviderPanel.add((Component)this.timestampProvider);
        this.timestampProvider.setFocusPainted(false);
        this.timestampProvider.setBackground(Color.WHITE);
        this.timestampProvider.addFocusListener(ComponentUtils.createFocusListenerFor((JPanel)timestampProviderPanel));
        this.timestampProvider.addMouseListener((MouseListener)ComponentUtils.createMouseAdapterForLink((LinkButton)this.timestampProvider));
        this.pdfReason = new MaximumLengthTextField(50);
        this.pdfReason.addActionListener(this);
        this.pdfReason.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                OptionsView.this.pdfReason.setBorder(SignerTheme.TEXTFIELD_FOCUSLESS);
                OptionsView.this.actionPerformed(new ActionEvent(OptionsView.this.pdfReason, 1001, ""));
            }

            @Override
            public void focusGained(FocusEvent e) {
                OptionsView.this.pdfReason.setBorder(SignerTheme.TEXTFIELD_FOCUSED);
            }
        });
        this.reasonLabel = new JLabel(Messages.getString((String)"step.options.signaturetyp.pades.advanced.reason"));
        this.reasonLabel.setLabelFor(this.pdfReason);
        this.pdfLocation = new MaximumLengthTextField(50);
        this.pdfLocation.addActionListener(this);
        this.pdfLocation.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                OptionsView.this.pdfLocation.setBorder(SignerTheme.TEXTFIELD_FOCUSLESS);
                OptionsView.this.actionPerformed(new ActionEvent(OptionsView.this.pdfLocation, 1001, ""));
            }

            @Override
            public void focusGained(FocusEvent e) {
                OptionsView.this.pdfLocation.setBorder(SignerTheme.TEXTFIELD_FOCUSED);
            }
        });
        this.locationLabel = new JLabel(Messages.getString((String)"step.options.signaturetyp.pades.advanced.location"));
        this.locationLabel.setLabelFor(this.pdfLocation);
        this.timestampServerError = new AccessibleJLabel();
        this.errorFont = (Font)UIManager.get("TitledBorder.font");
        this.timestampServerError.setFont(this.errorFont);
        this.timestampServerError.setForeground(SignerTheme.COLOR_RED);
        this.timestampServerError.setText(Messages.getString((String)"step.options.timestampserver.ok"));
        this.templateLabel = new JLabel(Messages.getString((String)"step.options.signaturetyp.pades.advanced.template"));
        this.templateList = new JComboBox();
        this.templateLabel.setLabelFor(this.templateList);
        this.templateList.addItem(new SignatureFieldTemplate(null, Messages.getString((String)"config.dialog.visualpdf.visualisation.template.none")));
        List<SignatureFieldTemplate> templates = SignatureFieldTemplateList.getInstance().getTemplates(this);
        for (SignatureFieldTemplate template : templates) {
            this.templateList.addItem(template);
        }
        this.templateList.addActionListener(e -> {
            JComboBox cb = (JComboBox)e.getSource();
            SignatureFieldTemplate t = (SignatureFieldTemplate)cb.getSelectedItem();
            this.signOptionsStep.setSelectedPdfTemplate(t);
        });
    }

    private void createButtonGroups() {
        ButtonGroup signaturButtonGroup = new ButtonGroup();
        if (this.pkcs7envelopedLicenceType.isVisible()) {
            signaturButtonGroup.add((AbstractButton)this.pkcs7enveloped);
        }
        if (this.pkcs7detachLicenceTyp.isVisible()) {
            signaturButtonGroup.add((AbstractButton)this.pkcs7detached);
        }
        ButtonGroup pdfButtonGroup = new ButtonGroup();
        pdfButtonGroup.add((AbstractButton)this.nonePDFInline);
        if (this.pdfInlineLicenceTyp.isVisible()) {
            pdfButtonGroup.add((AbstractButton)this.enablePDFInline);
        }
        ButtonGroup xmlButtonGroup = new ButtonGroup();
        xmlButtonGroup.add((AbstractButton)this.noneXMLInline);
        if (this.xmlInlineLicenceTyp.isVisible()) {
            xmlButtonGroup.add((AbstractButton)this.enableXMLInline);
        }
    }

    private void readLicenceTyp() {
        this.xmlInlineLicenceTyp = LicenceTyp.enable;
        ProductFunctions productFunctions = Document.getInstance().getProductFunctions();
        this.pdfInlineLicenceTyp = productFunctions.getLicence("process/sign/options/signformat/pdfinline");
        this.extendedPDFLicenceTyp = productFunctions.getLicence("process/sign/options/extended_pdfsignature");
        this.extendedResonPDFLicenceTyp = productFunctions.getLicence("process/sign/options/extended_pdfsignature/reason");
        this.pkcs7envelopedLicenceType = productFunctions.getLicence("process/sign/options/signformat/pkcs7enveloped");
        this.pkcs7detachLicenceTyp = productFunctions.getLicence("process/sign/options/signformat/pkcs7detached");
        this.osciLicenceTyp = productFunctions.getLicence("process/sign/options/signformat/osci");
    }

    protected void initGUI() {
        this.setLayout(new BorderLayout());
        DescriptionPanel descPanel = new DescriptionPanel("sign.step.options");
        JPanel content = this.createContentPanel2();
        this.skipStepPanel = new SkipStepPanel((SkipStepHandler)this);
        this.add((Component)descPanel, "North");
        this.add((Component)content, "Center");
        this.add((Component)this.skipStepPanel, "South");
        this.stateChanged(null);
        JComponentUtils.setLookByLicence((JComponent)this, (LicenceTyp)this.signOptionsStep.getLicenceTyp());
    }

    private JPanel createContentPanel2() {
        JPanel content = new JPanel();
        content.setLayout(new GridBagLayout());
        GridBagPanel signatureTypPanel = new GridBagPanel(new double[]{1.0});
        signatureTypPanel.setBorder((Border)ComponentUtils.createTitledCurvedBorder((String)"step.options.signaturetyp"));
        signatureTypPanel.setFocusable(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 4;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.1;
        gbc.gridy = 0;
        JComponentUtils.setLookByLicence((JComponent)this.createSignatureTypRadioButtonPanel(), (LicenceTyp)LicenceTyp.enable, (JPanel)signatureTypPanel, (GridBagConstraints)gbc);
        if (this.pkcs7envelopedLicenceType.isVisible() || this.pkcs7detachLicenceTyp.isVisible() || this.osciLicenceTyp.isVisible()) {
            gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0);
            JComponentUtils.setLookByLicence((JComponent)signatureTypPanel, (LicenceTyp)Document.getInstance().getProductFunctions().getLicence("process/sign/options/signformat"), (JPanel)content, (GridBagConstraints)gbc);
        }
        this.createPDFSignaturePanel(content);
        this.createXMLSignaturePanel(content);
        this.createInsertTimestampPanel(content);
        return content;
    }

    private void createInsertTimestampPanel(JPanel content) {
        Insets insets0 = new Insets(0, 0, 0, 0);
        Insets insetsLeft = new Insets(0, 10, 0, 0);
        GridBagPanel insertTimestampPanel = new GridBagPanel();
        insertTimestampPanel.setBorder((Border)ComponentUtils.createTitledCurvedBorder((String)"step.options.inserttimestamp"));
        insertTimestampPanel.setFocusable(true);
        insertTimestampPanel.add((Component)this.timestampLabel.getParent(), (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 25, 0, insetsLeft, 0, 0));
        insertTimestampPanel.add((Component)this.timestampProvider.getParent(), (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 26, 2, insets0, 0, 0));
        insertTimestampPanel.add((Component)this.timestampServerError, (Object)new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 23, 2, insetsLeft, 0, 0));
        GridBagConstraints gbc = new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, insets0, 0, 0);
        JComponentUtils.setLookByLicence((JComponent)insertTimestampPanel, (LicenceTyp)Document.getInstance().getProductFunctions().getLicence("process/sign/options/timestamp"), (JPanel)content, (GridBagConstraints)gbc);
    }

    private JPanel createSignatureTypRadioButtonPanel() {
        GridBagPanel signatureTypRadioButtonPanel = new GridBagPanel(new double[]{0.0, 0.0, 1.0, 0.0});
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 4;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 10, 0, 0);
        JComponentUtils.setLookByLicence((JComponent)this.pkcs7enveloped, (LicenceTyp)this.pkcs7envelopedLicenceType, (JPanel)signatureTypRadioButtonPanel, (GridBagConstraints)gbc);
        ++gbc.gridy;
        JComponentUtils.setLookByLicence((JComponent)this.pkcs7detached, (LicenceTyp)this.pkcs7detachLicenceTyp, (JPanel)signatureTypRadioButtonPanel, (GridBagConstraints)gbc);
        signatureTypRadioButtonPanel.setFocusable(false);
        return signatureTypRadioButtonPanel;
    }

    private void createPDFSignaturePanel(JPanel content) {
        GridBagPanel pdfSignaturePanel = new GridBagPanel(new double[]{1.0});
        pdfSignaturePanel.setBorder((Border)ComponentUtils.createTitledCurvedBorderForTitle((String)Messages.getString((String)"step.options.signaturetyp.pades.title")));
        pdfSignaturePanel.setFocusable(true);
        GridBagPanel pdfSignatureTypRadioButtonPanel = new GridBagPanel(new double[]{0.0, 0.0, 0.0, 1.0});
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insetsBottom = new Insets(0, 0, 3, 0);
        Insets insetsLeft = new Insets(0, 10, 0, 0);
        int y = 0;
        JComponentUtils.setLookByLicence((JComponent)this.nonePDFInline, (LicenceTyp)LicenceTyp.enable, (JPanel)pdfSignatureTypRadioButtonPanel, (GridBagConstraints)new GridBagConstraints(0, y, 3, 1, 1.0, 1.0, 18, 0, insetsLeft, 0, 0));
        JComponentUtils.setLookByLicence((JComponent)this.enablePDFInline, (LicenceTyp)this.pdfInlineLicenceTyp, (JPanel)pdfSignatureTypRadioButtonPanel, (GridBagConstraints)new GridBagConstraints(0, ++y, 3, 1, 1.0, 1.0, 18, 0, insetsLeft, 0, 0));
        JComponentUtils.setLookByLicence((JComponent)((JPanel)this.visualPDFSignatureOptions.getParent()), (LicenceTyp)this.extendedPDFLicenceTyp, (JPanel)pdfSignatureTypRadioButtonPanel, (GridBagConstraints)new GridBagConstraints(3, y, 3, 1, 1.0, 1.0, 12, 0, insets, 0, 0));
        JComponentUtils.setLookByLicence((JComponent)new JLabel("   "), (LicenceTyp)this.extendedResonPDFLicenceTyp, (JPanel)pdfSignatureTypRadioButtonPanel, (GridBagConstraints)new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        JComponentUtils.setLookByLicence((JComponent)this.templateLabel, (LicenceTyp)this.extendedResonPDFLicenceTyp, (JPanel)pdfSignatureTypRadioButtonPanel, (GridBagConstraints)new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 15, 5, 10), 0, 0));
        JComponentUtils.setLookByLicence(this.templateList, (LicenceTyp)this.extendedResonPDFLicenceTyp, (JPanel)pdfSignatureTypRadioButtonPanel, (GridBagConstraints)new GridBagConstraints(2, y, 2, 1, 0.0, 0.0, 21, 2, insetsBottom, 0, 0));
        JComponentUtils.setLookByLicence((JComponent)this.reasonLabel, (LicenceTyp)this.extendedResonPDFLicenceTyp, (JPanel)pdfSignatureTypRadioButtonPanel, (GridBagConstraints)new GridBagConstraints(1, ++y, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 15, 0, 10), 0, 0));
        JComponentUtils.setLookByLicence((JComponent)this.pdfReason, (LicenceTyp)this.extendedResonPDFLicenceTyp, (JPanel)pdfSignatureTypRadioButtonPanel, (GridBagConstraints)new GridBagConstraints(2, y, 2, 1, 1.0, 1.0, 21, 2, insetsBottom, 0, 0));
        JComponentUtils.setLookByLicence((JComponent)this.locationLabel, (LicenceTyp)this.extendedResonPDFLicenceTyp, (JPanel)pdfSignatureTypRadioButtonPanel, (GridBagConstraints)new GridBagConstraints(1, ++y, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 15, 0, 10), 0, 0));
        JComponentUtils.setLookByLicence((JComponent)this.pdfLocation, (LicenceTyp)this.extendedResonPDFLicenceTyp, (JPanel)pdfSignatureTypRadioButtonPanel, (GridBagConstraints)new GridBagConstraints(2, y, 2, 1, 1.0, 1.0, 21, 2, insets, 0, 0));
        JComponentUtils.setLookByLicence((JComponent)pdfSignatureTypRadioButtonPanel, (LicenceTyp)LicenceTyp.enable, (JPanel)pdfSignaturePanel, (GridBagConstraints)new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 18, 2, insets, 0, 0));
        if (this.extendedResonPDFLicenceTyp.isVisible() || this.extendedPDFLicenceTyp.isVisible() || this.pdfInlineLicenceTyp.isVisible()) {
            JComponentUtils.setLookByLicence((JComponent)pdfSignaturePanel, (LicenceTyp)LicenceTyp.enable, (JPanel)content, (GridBagConstraints)new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    private void createXMLSignaturePanel(JPanel content) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 4;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.1;
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 0, 0, 0);
        GridBagPanel xmlSignaturePanel = new GridBagPanel(new double[]{0.0, 0.0, 1.0, 0.0});
        xmlSignaturePanel.setBorder((Border)ComponentUtils.createTitledCurvedBorderForTitle((String)Messages.getString((String)"step.options.signaturetyp.xades.title")));
        xmlSignaturePanel.setFocusable(true);
        GridBagPanel xmlSignatureTypRadioButtonPanel = new GridBagPanel(new double[]{0.0, 0.0, 1.0, 0.0});
        JComponentUtils.setLookByLicence((JComponent)this.noneXMLInline, (LicenceTyp)LicenceTyp.enable, (JPanel)xmlSignatureTypRadioButtonPanel, (GridBagConstraints)gbc);
        ++gbc.gridy;
        JComponentUtils.setLookByLicence((JComponent)this.enableXMLInline, (LicenceTyp)this.xmlInlineLicenceTyp, (JPanel)xmlSignatureTypRadioButtonPanel, (GridBagConstraints)gbc);
        gbc.gridy = 0;
        JComponentUtils.setLookByLicence((JComponent)xmlSignatureTypRadioButtonPanel, (LicenceTyp)LicenceTyp.enable, (JPanel)xmlSignaturePanel, (GridBagConstraints)new GridBagConstraints(0, gbc.gridy, 3, 1, 0.0, 0.0, 18, 2, new Insets(0, 10, 0, 0), 0, 0));
        if (this.xmlInlineLicenceTyp.isVisible()) {
            gbc = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0);
            JComponentUtils.setLookByLicence((JComponent)xmlSignaturePanel, (LicenceTyp)LicenceTyp.enable, (JPanel)content, (GridBagConstraints)gbc);
        }
    }

    public void stateChanged(ChangeEvent event) {
        XMLSignatureType xmlSignatureType = this.signOptionsStep.getXMLSignatureType();
        if (XMLSignatureType.xmlInline.equals((Object)xmlSignatureType)) {
            if (this.xmlInlineLicenceTyp.useInProcess()) {
                this.enableXMLInline.setSelected(true);
            } else {
                this.noneXMLInline.setSelected(true);
            }
        } else {
            this.noneXMLInline.setSelected(true);
        }
        PDFSignatureType pdfSignatureType = this.signOptionsStep.getPDFSignatureType();
        if (PDFSignatureType.pdfInline.equals((Object)pdfSignatureType)) {
            if (this.pdfInlineLicenceTyp.useInProcess()) {
                this.enablePDFInline.setSelected(true);
            } else {
                this.nonePDFInline.setSelected(true);
            }
        } else {
            this.nonePDFInline.setSelected(true);
        }
        this.enableVisualPDF();
        boolean isCreateTimeStamp = this.signOptionsStep.createTimestamp();
        this.timestampLabel.setSelected(isCreateTimeStamp);
        this.timestampProvider.setEnabled(isCreateTimeStamp);
        this.timestampProvider.setTransparent(!isCreateTimeStamp);
        if (this.signOptionsStep.getSignatureType() != null) {
            switch (this.signOptionsStep.getSignatureType()) {
                case detachedPKCS7: {
                    this.pkcs7detached.setSelected(true);
                    break;
                }
                default: {
                    this.pkcs7enveloped.setSelected(true);
                    break;
                }
            }
        } else {
            this.pkcs7enveloped.setSelected(true);
        }
        this.setTimestampServerErrorText(isCreateTimeStamp);
        this.skipStepPanel.stateChanged(null);
    }

    private void setTimestampServerErrorText(boolean isCreateTimeStamp) {
        boolean isTimeStampServiceReadyToUse;
        boolean bl = isTimeStampServiceReadyToUse = isCreateTimeStamp && !((SignConfig)this.signOptionsStep.getParent().getConfig()).isTimestampServiceSet();
        if (isTimeStampServiceReadyToUse) {
            this.timestampServerError.setFont(this.errorFont);
            this.timestampServerError.setForeground(SignerTheme.COLOR_RED);
            this.timestampServerError.setText(Messages.getString((String)"step.options.timestampserver.error"));
            this.timestampServerError.setFocusable(true);
        } else {
            this.timestampServerError.setText(Messages.getString((String)"step.options.timestampserver.ok"));
            this.timestampServerError.setFocusable(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.signOptionsStep.setLastSelectedJComponent((JComponent)e.getSource());
        Object source = e.getSource();
        if (source == null) {
            return;
        }
        LOG.debug("sign options source: {}", source.getClass());
        this.signOptionsStep.setSignatureType(this.pkcs7detached.isSelected() ? SignatureType.detachedPKCS7 : SignatureType.envelopedPKCS7);
        this.signOptionsStep.setXMLSignatureType(this.noneXMLInline.isSelected() ? XMLSignatureType.noXmlInline : XMLSignatureType.xmlInline);
        if (this.nonePDFInline.isSelected()) {
            this.signOptionsStep.setPDFSignatureType(PDFSignatureType.noPdfInline);
        } else if (this.enablePDFInline.isSelected()) {
            this.signOptionsStep.setPDFSignatureType(PDFSignatureType.pdfInline);
        }
        if (source.equals(this.nonePDFInline) || source.equals(this.enablePDFInline)) {
            this.enableVisualPDF();
        }
        if (source.equals(this.pdfReason)) {
            this.signOptionsStep.setPDFSignatureReason(this.pdfReason.getText());
        }
        if (source.equals(this.pdfLocation)) {
            this.signOptionsStep.setPDFSignatureLocation(this.pdfLocation.getText());
        }
        if (source.equals(this.timestampLabel)) {
            this.signOptionsStep.createTimestamp(this.timestampLabel.isSelected());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.removeAll();
        this.createComponents();
        this.initGUI();
        this.revalidate();
    }

    public SkippableStep getSkippableStep() {
        return this.signOptionsStep;
    }

    public boolean getSkipStep() {
        return this.signOptionsStep.skipStep();
    }

    public void setSkipStep(boolean skip) {
        this.signOptionsStep.skipStep(skip);
    }

    public boolean isStepComplete() {
        return this.signOptionsStep.isStateComplete();
    }

    public void setActive(boolean active) {
        if (active) {
            LOG.trace("set active sign : options");
            LOG.info("\n------------------------- Signieren/Optionen : ausgew\u00e4hlt ----------------------------");
        } else {
            LOG.debug("set inactive sign : options");
            this.signOptionsStep.setLastSelectedJComponent(null);
        }
    }

    @Override
    public void requestFocus() {
    }

    private void enableVisualPDF() {
        if (!this.extendedPDFLicenceTyp.isVisible() || !this.extendedPDFLicenceTyp.isEditable()) {
            return;
        }
        if (!this.extendedResonPDFLicenceTyp.isVisible() || !this.extendedResonPDFLicenceTyp.isEditable()) {
            return;
        }
        this.pdfReason.setText(this.signOptionsStep.getPDFSignatureReason());
        this.pdfLocation.setText(this.signOptionsStep.getPDFSignatureLocation());
        boolean enabled = this.enablePDFInline.isSelected();
        this.reasonLabel.setEnabled(enabled);
        this.pdfReason.setEditable(enabled);
        this.pdfReason.setEnabled(enabled);
        this.locationLabel.setEnabled(enabled);
        this.pdfLocation.setEditable(enabled);
        this.pdfLocation.setEnabled(enabled);
        this.visualPDFSignatureOptions.setEnabled(enabled);
        this.visualPDFSignatureOptions.setTransparent(!enabled);
        this.templateLabel.setEnabled(enabled);
        this.templateList.setEnabled(enabled);
    }

    @Override
    public void loaded(SignatureFieldTemplate template) {
        LOG.info("loading...");
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.templateList.getModel();
        if (model.getIndexOf(template) == -1) {
            this.templateList.addItem(template);
        }
    }

    @Override
    public void stored(SignatureFieldTemplate template) {
        LOG.info("storing...");
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.templateList.getModel();
        if (model.getIndexOf(template) == -1) {
            this.templateList.addItem(template);
        }
    }

    @Override
    public void deleted(SignatureFieldTemplate template) {
        LOG.info("");
        this.templateList.removeItem(template);
    }

    private class VisualPdfConfigureAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private VisualPdfConfigureAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProcessName pname = OptionsView.this.signOptionsStep.getParent().getProcessName();
            pname.setSubProcessName("visualPDF");
            actionEvent.setSource(pname);
            Document.getInstance().getActionFactory().getConfigureAction().actionPerformed(actionEvent);
        }
    }

    private class TimestampProviderConfigureAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private TimestampProviderConfigureAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProcessName pname = OptionsView.this.signOptionsStep.getParent().getProcessName();
            pname.setSubProcessName("timestampProvider");
            actionEvent.setSource(pname);
            Document.getInstance().getActionFactory().getConfigureAction().actionPerformed(actionEvent);
        }
    }
}

