/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature.positionselector;

import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature.positionselector.PositionSelectorModelInterface;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PositionSelectorModel
implements PositionSelectorModelInterface {
    private static final Logger LOG = LogManager.getLogger(PositionSelectorModel.class);
    protected ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();
    private boolean activated = false;
    private Double positionX = 0.0;
    private Double positionY = 0.0;
    private boolean showGrid = true;
    private int gridColumns = 10;
    private int gridRows = 14;
    private double cursorWidth = 4.0;
    private double cursorHeight = 2.0;

    public PositionSelectorModel() {
    }

    public PositionSelectorModel(Double xPos, Double yPos) {
        this.positionX = xPos;
        this.positionY = yPos;
    }

    public PositionSelectorModel(boolean b) {
        this.activated = b;
    }

    public PositionSelectorModel(Double xPos, Double yPos, boolean b) {
        this.positionX = xPos;
        this.positionY = yPos;
        this.activated = b;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    @Override
    public ChangeListener[] getChangeListner() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    @Override
    public synchronized boolean isActivated() {
        return this.activated;
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    @Override
    public synchronized void setActivated(boolean b) {
        if (b != this.activated) {
            this.activated = b;
            this.fireChange();
        }
    }

    @Override
    public synchronized void setPositionX(Double pos) {
        if (pos != null && !pos.equals(this.positionX)) {
            LOG.trace("X : {}", (Object)pos);
            this.positionX = pos;
            this.fireChange();
        }
    }

    @Override
    public synchronized void setPositionY(Double pos) {
        if (pos != null && !pos.equals(this.positionY)) {
            LOG.trace("Y : {}", (Object)pos);
            this.positionY = pos;
            this.fireChange();
        }
    }

    protected void fireChange() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i > 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public String toString() {
        String modelString = "X:" + this.positionX + " Y:" + this.positionY + " activated:" + this.isActivated();
        return this.getClass().getName() + "[" + modelString + "]";
    }

    @Override
    public synchronized Double getPositionX() {
        return this.positionX;
    }

    @Override
    public synchronized Double getPositionY() {
        return this.positionY;
    }

    @Override
    public synchronized int getGridColumns() {
        return this.gridColumns;
    }

    @Override
    public int getGridRows() {
        return this.gridRows;
    }

    @Override
    public boolean isShowGrid() {
        return this.showGrid;
    }

    @Override
    public synchronized void setGridColumns(int cols) {
        int old = this.getGridColumns();
        if (old == cols) {
            return;
        }
        this.gridColumns = cols;
        this.fireChange();
    }

    @Override
    public void setGridRows(int rows) {
        int old = this.getGridRows();
        if (old == rows) {
            return;
        }
        this.gridRows = rows;
        this.fireChange();
    }

    @Override
    public void setShowGrid(boolean b) {
        boolean old = this.isShowGrid();
        if (old == b) {
            return;
        }
        this.showGrid = b;
        this.fireChange();
    }

    @Override
    public synchronized double getCursorHeightInCentimeter() {
        return this.cursorHeight;
    }

    @Override
    public synchronized void setCursorHeightInCentimeter(double cm) {
        if (this.cursorHeight == cm) {
            return;
        }
        this.cursorHeight = cm;
        this.fireChange();
    }

    @Override
    public synchronized double getCursorWidthInCentimeter() {
        return this.cursorWidth;
    }

    @Override
    public synchronized void setCursorWidthInCentimeter(double cm) {
        if (this.cursorWidth == cm) {
            return;
        }
        this.cursorWidth = cm;
        this.fireChange();
    }
}

