/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature.positionselector;

import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature.positionselector.BasicPositionSelectorUI;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature.positionselector.PositionSelectorModel;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PositionSelector
extends JComponent
implements ChangeListener {
    private static final Logger LOG = LogManager.getLogger(PositionSelector.class);
    private static final long serialVersionUID = 1L;
    private transient PositionSelectorModel model;
    private int definedWidth;
    private int definedHeight;

    public PositionSelector(int width, int height) {
        this.definedWidth = width;
        this.definedHeight = height;
        this.init(new PositionSelectorModel(), width, height);
        this.setFocusable(true);
        this.setShowGrid(true);
    }

    protected void init(PositionSelectorModel m, int width, int height) {
        this.setModel(m);
        this.setMinimumSize(new Dimension(width, height));
        this.setPreferredSize(new Dimension(width, height));
        this.updateUI();
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI(UIManager.getUI(this));
        } else {
            this.setUI(new BasicPositionSelectorUI());
        }
    }

    @Override
    public String getUIClassID() {
        return "PositionSelectorUI";
    }

    public void setModel(PositionSelectorModel m) {
        PositionSelectorModel old = this.model;
        if (old != null) {
            old.removeChangeListener(this);
        }
        this.model = m == null ? new PositionSelectorModel() : m;
        this.model.addChangeListener(this);
        this.firePropertyChange("model", old, this.model);
    }

    public PositionSelectorModel getModel() {
        return this.model;
    }

    public Double getPositionX() {
        return this.model.getPositionX();
    }

    public Double getPositionY() {
        return this.model.getPositionY();
    }

    public void setPositionX(Double pos) {
        Double old = this.getPositionX();
        if (old != null && !old.equals(pos)) {
            this.model.setPositionX(pos);
            LOG.trace("X neu : {}", (Object)pos);
            this.firePropertyChange("positionX", old, pos);
        }
    }

    public void setPositionY(Double pos) {
        Double old = this.getPositionY();
        if (old != null && !old.equals(pos)) {
            this.model.setPositionY(pos);
            LOG.trace("Y neu : {}", (Object)pos);
            this.firePropertyChange("positionY", old, pos);
        }
    }

    public boolean isGridShow() {
        return this.model.isShowGrid();
    }

    public void setShowGrid(boolean b) {
        boolean old = this.isGridShow();
        if (old != b) {
            this.model.setShowGrid(b);
            this.firePropertyChange("showGrid", old, b);
        }
    }

    public int getGridColumns() {
        return this.model.getGridColumns();
    }

    public void setGridColumns(int cols) {
        this.model.setGridColumns(cols);
    }

    public int getGridRows() {
        return this.model.getGridRows();
    }

    public void setGridRows(int rows) {
        this.model.setGridRows(rows);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.repaint();
    }

    public int getDefinedWidth() {
        LOG.trace((Object)this.definedWidth);
        return this.definedWidth;
    }

    public int getDefinedHeight() {
        LOG.trace((Object)this.definedHeight);
        return this.definedHeight;
    }

    public double getCursorHeightInCentimeter() {
        return this.model.getCursorHeightInCentimeter();
    }

    public void setCursorHeightInCentimeter(double cm) {
        double old = this.getCursorHeightInCentimeter();
        if (cm != old) {
            this.model.setCursorHeightInCentimeter(cm);
            this.firePropertyChange("cursorHeight", old, cm);
        }
    }

    public double getCursorWidthInCentimeter() {
        return this.model.getCursorWidthInCentimeter();
    }

    public void setCursorWidthInCentimeter(double cm) {
        double old = this.getCursorWidthInCentimeter();
        if (cm != old) {
            this.model.setCursorWidthInCentimeter(cm);
            this.firePropertyChange("cursorWidth", old, cm);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.repaint();
    }
}

