/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature.positionselector;

import de.bos_bremen.ecard.client.gui.SignerTheme;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature.positionselector.PositionSelector;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature.positionselector.PositionSelectorUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.plaf.ComponentUI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BasicPositionSelectorUI
extends PositionSelectorUI
implements MouseListener,
MouseMotionListener,
PropertyChangeListener {
    private static final Logger LOG = LogManager.getLogger(BasicPositionSelectorUI.class);
    private PositionSelector positionSelector;
    private int actX = 0;
    private int actY = 0;
    private int shapeWidth = 18;
    private int shapeHeight = 10;
    private int offsetX = 0;
    private int offsetY = 0;

    public static ComponentUI createUI() {
        return new BasicPositionSelectorUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.positionSelector = (PositionSelector)c;
        this.positionSelector.addPropertyChangeListener(this);
        this.positionSelector.addMouseListener(this);
        this.positionSelector.addMouseMotionListener(this);
        InputMap inputMap = this.positionSelector.getInputMap(0);
        ActionMap actionMap = this.positionSelector.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(39, 0), "toRight");
        inputMap.put(KeyStroke.getKeyStroke(37, 0), "toLeft");
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "toUp");
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "toDown");
        actionMap.put("toRight", this.toRightAction());
        actionMap.put("toLeft", this.toLeftAction());
        actionMap.put("toUp", this.toUpAction());
        actionMap.put("toDown", this.toDownAction());
    }

    private AbstractAction toDownAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!BasicPositionSelectorUI.this.positionSelector.hasFocus()) {
                    return;
                }
                BasicPositionSelectorUI.this.actY = BasicPositionSelectorUI.this.positionSelector.isGridShow() ? (BasicPositionSelectorUI.this.actY += BasicPositionSelectorUI.this.getShapeHeight()) : ++BasicPositionSelectorUI.this.actY;
                BasicPositionSelectorUI.this.correctCoordinates();
                BasicPositionSelectorUI.this.snap2Grid();
                BasicPositionSelectorUI.this.positionSelector.repaint();
            }
        };
    }

    private AbstractAction toUpAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!BasicPositionSelectorUI.this.positionSelector.hasFocus()) {
                    return;
                }
                BasicPositionSelectorUI.this.actY = BasicPositionSelectorUI.this.positionSelector.isGridShow() ? (BasicPositionSelectorUI.this.actY -= BasicPositionSelectorUI.this.getShapeHeight()) : --BasicPositionSelectorUI.this.actY;
                BasicPositionSelectorUI.this.correctCoordinates();
                BasicPositionSelectorUI.this.snap2Grid();
                BasicPositionSelectorUI.this.positionSelector.repaint();
            }
        };
    }

    private AbstractAction toLeftAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!BasicPositionSelectorUI.this.positionSelector.hasFocus()) {
                    return;
                }
                BasicPositionSelectorUI.this.actX = BasicPositionSelectorUI.this.positionSelector.isGridShow() ? (BasicPositionSelectorUI.this.actX -= BasicPositionSelectorUI.this.getShapeWidth()) : --BasicPositionSelectorUI.this.actX;
                BasicPositionSelectorUI.this.correctCoordinates();
                BasicPositionSelectorUI.this.snap2Grid();
                BasicPositionSelectorUI.this.positionSelector.repaint();
            }
        };
    }

    private AbstractAction toRightAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!BasicPositionSelectorUI.this.positionSelector.hasFocus()) {
                    return;
                }
                BasicPositionSelectorUI.this.actX = BasicPositionSelectorUI.this.positionSelector.isGridShow() ? (BasicPositionSelectorUI.this.actX += BasicPositionSelectorUI.this.getShapeWidth()) : ++BasicPositionSelectorUI.this.actX;
                BasicPositionSelectorUI.this.correctCoordinates();
                BasicPositionSelectorUI.this.snap2Grid();
                BasicPositionSelectorUI.this.positionSelector.repaint();
            }
        };
    }

    @Override
    public void uninstallUI(JComponent c) {
        PositionSelector selector = (PositionSelector)c;
        selector.removeMouseListener(this);
        selector.removeMouseMotionListener(this);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Insets insets = c.getInsets();
        g.translate(insets.left, insets.top);
        g.setColor(c.getBackground());
        g.fillRect(0, 0, this.getCanvasWidth(), this.getCanvasHeight());
        this.drawGrid(g, c);
        this.drawCursor(g, c);
    }

    private int getCanvasWidth() {
        int right = this.positionSelector.getInsets().right;
        int left = this.positionSelector.getInsets().left;
        return this.positionSelector.getWidth() - right - left;
    }

    private int getCanvasHeight() {
        int top = this.positionSelector.getInsets().top;
        int bottom = this.positionSelector.getInsets().bottom;
        return this.positionSelector.getHeight() - top - bottom;
    }

    private void drawCursor(Graphics g, JComponent c) {
        if (c.isEnabled()) {
            g.setColor(SignerTheme.COLOR_RED);
        } else {
            g.setColor(Color.LIGHT_GRAY);
        }
        this.drawCursorShape(g);
    }

    private void drawCursorShape(Graphics g) {
        g.drawRect(this.actX, this.actY, this.getShapeWidth() - 1, this.getShapeHeight() - 1);
    }

    private void drawGrid(Graphics g, JComponent c) {
        PositionSelector ps = (PositionSelector)c;
        if (!ps.isGridShow()) {
            return;
        }
        for (int y = 0; y < ps.getGridRows() + 1; ++y) {
            for (int x = 0; x < ps.getGridColumns() + 1; ++x) {
                this.drawCross(g, ps, x, y);
            }
        }
    }

    private void drawCross(Graphics g, PositionSelector ps, int x, int y) {
        int fieldWidth = this.getCanvasWidth() / ps.getGridColumns();
        int fieldHeight = this.getCanvasHeight() / ps.getGridRows();
        int middleX = x * fieldWidth;
        int middleY = y * fieldHeight;
        if (ps.isEnabled()) {
            g.setColor(ps.getForeground());
        } else {
            g.setColor(Color.LIGHT_GRAY);
        }
        g.drawLine(middleX, middleY - 2, middleX, middleY + 2);
        g.drawLine(middleX - 2, middleY, middleX + 2, middleY);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.positionSelector.isEnabled()) {
            return;
        }
        this.positionSelector.requestFocus();
        this.correctCoordinates(e);
        this.snap2Grid();
        this.setRelativeCoordinates();
        this.positionSelector.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.positionSelector.isEnabled() && this.inShape(e)) {
            this.offsetX = this.actX - e.getX();
            this.offsetY = this.actY - e.getY();
        }
    }

    private boolean inShape(MouseEvent e) {
        int clickX = e.getX();
        int clickY = e.getY();
        return clickX >= this.actX && clickX <= this.actX + this.getShapeWidth() && clickY >= this.actY && clickY <= this.actY + this.getShapeHeight();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.positionSelector.isEnabled()) {
            return;
        }
        this.correctCoordinates(e);
        this.snap2Grid();
        this.setRelativeCoordinates();
        this.positionSelector.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.positionSelector.isEnabled()) {
            return;
        }
        this.correctCoordinates(e);
        this.positionSelector.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private int getShapeWidth() {
        return this.shapeWidth;
    }

    private int getShapeHeight() {
        return this.shapeHeight;
    }

    private void correctCoordinates(MouseEvent e) {
        this.actX = e.getX() + this.offsetX;
        this.actY = e.getY() + this.offsetY;
        this.correctCoordinates();
    }

    private void correctCoordinates() {
        if (this.actX < 0) {
            this.actX = 0;
        }
        if (this.actX > this.getCanvasWidth() - this.shapeWidth) {
            this.actX = this.getCanvasWidth() - this.shapeWidth;
        }
        if (this.actY < 0) {
            this.actY = 0;
        }
        if (this.actY > this.getCanvasHeight() - this.shapeHeight) {
            this.actY = this.getCanvasHeight() - this.shapeHeight;
        }
    }

    private void snap2Grid() {
        LOG.trace("");
        if (!this.positionSelector.isGridShow()) {
            return;
        }
        int fieldWidth = this.getCanvasWidth() / this.positionSelector.getGridColumns();
        int fieldHeight = this.getCanvasHeight() / this.positionSelector.getGridRows();
        LOG.trace("field W:H - {}:{}", (Object)fieldWidth, (Object)fieldHeight);
        int snapX = (this.actX + fieldWidth / 2) / fieldWidth;
        int snapY = (this.actY + fieldHeight / 2) / fieldHeight;
        this.actX = snapX * fieldWidth;
        this.actY = snapY * fieldHeight;
        this.positionSelector.repaint();
        LOG.trace("absolut actX:actY - {}:{}", (Object)this.actX, (Object)this.actY);
    }

    private void setRelativeCoordinates() {
        LOG.trace("relativ");
        int x = this.actX;
        int y = this.getCanvasHeight() - this.actY;
        double pX = (double)x * 100.0 / (double)this.getCanvasWidth() / 100.0;
        double pY = (double)y * 100.0 / (double)this.getCanvasHeight() / 100.0;
        this.positionSelector.setPositionX(pX);
        this.positionSelector.setPositionY(pY);
        LOG.trace("relativ pX:pY - {}:{}", (Object)pX, (Object)pY);
    }

    private void setAbsoluteCoordinates() {
        LOG.trace("absolut");
        try {
            double pX = this.positionSelector.getPositionX();
            int pW = this.positionSelector.getDefinedWidth();
            this.actX = (int)((double)pW * pX);
            LOG.trace("pX => actX : {} => {}", (Object)pX, (Object)this.actX);
        }
        catch (NullPointerException e) {
            LOG.debug(e.getMessage());
        }
        try {
            double pY = this.positionSelector.getPositionY();
            int pH = this.positionSelector.getDefinedHeight();
            this.actY = (int)((double)pH - (double)pH * pY);
            LOG.trace("pY => actY : {} => {}", (Object)pY, (Object)this.actY);
        }
        catch (NullPointerException e) {
            LOG.debug(e.getMessage());
        }
        this.positionSelector.repaint();
        LOG.trace("absolut actX:actY - {}:{}", (Object)this.actX, (Object)this.actY);
    }

    private void resizeCursor() {
        this.shapeWidth = this.centimeter2Pixel(this.positionSelector.getCursorWidthInCentimeter());
        this.shapeHeight = this.centimeter2Pixel(this.positionSelector.getCursorHeightInCentimeter());
        this.positionSelector.repaint();
    }

    private int centimeter2Pixel(double cm) {
        double mm = cm * 10.0;
        return (int)(mm * (double)this.positionSelector.getDefinedHeight() / 297.0);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt == null) {
            return;
        }
        switch (evt.getPropertyName()) {
            case "positionX": 
            case "positionY": {
                this.setAbsoluteCoordinates();
                break;
            }
            case "cursorHeight": 
            case "cursorWidth": {
                this.resizeCursor();
                break;
            }
        }
    }
}

