/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature;

import de.governikus.csl.SignerValidationProcessor;
import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.transport.HttpHeader;
import de.governikus.csl.transport.HttpResponse;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.imageio.ImageIO;
import javax.ws.rs.ServerErrorException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PDFUserImage {
    private static final Logger LOG = LogManager.getLogger(PDFUserImage.class);
    private URI uri;
    private File imageFile = null;
    private Image image = null;

    public boolean exists() {
        if (this.imageFile != null) {
            return this.imageFile.exists();
        }
        if (this.uri != null) {
            return this.image != null;
        }
        return false;
    }

    public File getImageFile() {
        if (!this.exists()) {
            this.imageFile = null;
            this.image = null;
        }
        return this.imageFile;
    }

    public void setImageFile(File file) {
        this.imageFile = file;
        try {
            if (!this.exists()) {
                this.imageFile = null;
                this.image = null;
            } else {
                this.image = ImageIO.read(this.imageFile);
                this.uri = this.imageFile.toURI();
            }
        }
        catch (IOException e) {
            LOG.error("", (Throwable)e);
            this.imageFile = null;
            this.image = null;
        }
    }

    public Image getImage() {
        if (!this.exists()) {
            this.imageFile = null;
            this.image = null;
        }
        return this.image;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        HttpClient httpClient = SignerValidationProcessor.getInstance().getHttpClient();
        try (HttpResponse response = httpClient.get(uri, new HttpHeader[0]);){
            this.uri = uri;
            this.imageFile = null;
            this.image = null;
            this.image = ImageIO.read(response.getContent());
        }
        catch (IOException | ServerErrorException e) {
            LOG.error("", e);
        }
    }
}

