/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.gui.IconScalingUtils;
import java.awt.Image;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PDFStdImage {
    private static final String RESOURCES = "/resources/";
    private static final Logger LOG = LogManager.getLogger(PDFStdImage.class);
    private URI uri;
    private String displayText;
    private Image image;
    private ImageIcon icon = null;
    private ImageIcon rolloverIcon = null;

    public PDFStdImage(String resourceKey) {
        this.displayText = Messages.getResource((String)(resourceKey + ".text"));
        this.image = IconScalingUtils.createMultiResIcon((String)(resourceKey + ".preview.image")).getImage();
        try {
            String imageName = Messages.getResource((String)(resourceKey + ".image"));
            this.uri = new URI(PDFStdImage.class.getResource(RESOURCES + imageName).toString());
        }
        catch (URISyntaxException e) {
            LOG.error((Object)e, (Throwable)e);
            this.uri = null;
        }
        if (this.image != null) {
            this.setIconAndRolloverIcon(resourceKey);
        } else {
            this.icon = null;
        }
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public Image getImage() {
        return this.image;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Icon getRolloverIcon() {
        return this.rolloverIcon;
    }

    private void setIconAndRolloverIcon(String iconKey) {
        this.icon = IconScalingUtils.createMultiResIcon((String)(iconKey + ".icon"));
        this.rolloverIcon = IconScalingUtils.createMultiResIcon((String)(iconKey + ".rollover.icon"));
    }

    public URI getUri() {
        return this.uri;
    }
}

