/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature;

import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CentimeterTextField
extends JFormattedTextField {
    private static final long serialVersionUID = 4381141485651380805L;
    private static final Logger LOG = LogManager.getLogger(CentimeterTextField.class);
    private static DecimalFormat decimalFormat = new DecimalFormat("#.0");
    private Double minValue;
    private Double maxValue;

    public CentimeterTextField(Double minValue, Double maxValue) {
        super(decimalFormat);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.setInputVerifier(new RangeVerifier());
    }

    public double getCM() {
        double erg;
        try {
            erg = decimalFormat.parse(this.getText()).doubleValue();
        }
        catch (ParseException e) {
            erg = 0.0;
        }
        return erg;
    }

    public void setCM(double cm) {
        String erg = "";
        try {
            erg = decimalFormat.format(cm);
        }
        catch (Exception e) {
            LOG.debug(e.getMessage());
        }
        this.setText(erg);
    }

    @Override
    public boolean isEditValid() {
        return this.getInputVerifier().verify(this);
    }

    private class RangeVerifier
    extends InputVerifier {
        private RangeVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            Double dValue = 1.0;
            boolean erg = true;
            JFormattedTextField tf = (JFormattedTextField)input;
            String text = tf.getText();
            try {
                Number value = decimalFormat.parse(text);
                dValue = value.doubleValue();
                if (dValue < CentimeterTextField.this.minValue) {
                    erg = false;
                }
                if (dValue > CentimeterTextField.this.maxValue) {
                    erg = false;
                }
            }
            catch (ParseException e) {
                LOG.error(e.getMessage());
                erg = false;
            }
            if (!erg) {
                tf.setBackground(UIManager.getColor("TextField.error.background"));
                tf.setForeground(UIManager.getColor("TextField.error.foreground"));
            } else {
                tf.setBackground(new JTextField().getBackground());
                tf.setForeground(new JTextField().getForeground());
            }
            return erg;
        }
    }
}

